/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import org.hyperimage.client.gui.ObjectContentCell;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;

public class ObjectContentsCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = -7813916969496340115L;
    private HashMap<HiObjectContent, ObjectContentCell> cellCache = new HashMap();
    private String defLang;
    private HiObject object = null;
    private static LineBorder standardBorder;
    private static LineBorder defContentBorder;

    static {
        defContentBorder = new LineBorder(Color.darkGray, 2);
    }

    public ObjectContentsCellRenderer(HiObject object, String defLang) {
        this.defLang = defLang;
        this.object = object;
        this.setLayout(new FlowLayout());
        this.setBackground(Color.LIGHT_GRAY);
    }

    public ObjectContentCell getCellForContent(HiObjectContent content) {
        ObjectContentCell cell = this.cellCache.get(content);
        if (cell == null) {
            cell = new ObjectContentCell(content, this.defLang);
            this.cellCache.put(content, cell);
        }
        return cell;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ObjectContentCell cell = this.cellCache.get((HiObjectContent)list.getModel().getElementAt(index));
        if (cell == null) {
            cell = new ObjectContentCell((HiObjectContent)list.getModel().getElementAt(index), this.defLang);
            this.cellCache.put((HiObjectContent)list.getModel().getElementAt(index), cell);
        }
        cell.setSelected(isSelected);
        cell.setOpaque(true);
        this.setOpaque(true);
        if (standardBorder == null) {
            standardBorder = new LineBorder(list.getBackground(), 2);
        }
        LineBorder border = standardBorder;
        if (this.object.getDefaultView() == null && index == 0) {
            border = defContentBorder;
        }
        if (this.object.getDefaultView() != null && this.object.getDefaultView().getId() == ((HiObjectContent)value).getId()) {
            border = defContentBorder;
        }
        this.setBorder(border);
        this.removeAll();
        this.add(cell);
        return this;
    }

    public void refresh(HiInscription inscription) {
        this.cellCache.remove(inscription);
        ObjectContentCell cell = new ObjectContentCell(inscription, this.defLang);
        this.cellCache.put(inscription, cell);
    }
}

