/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.hyperimage.client.gui.PolygonEditorControl;
import org.hyperimage.client.model.RelativePolygon;

public class PolygonListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = -820157524560699784L;
    private HashMap<String, Icon> polygonCache;
    private JLabel polygonLabel;
    private static Border regBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
    private static Border selBorder;

    public PolygonListCellRenderer(JList list) {
        selBorder = BorderFactory.createLineBorder(list.getSelectionBackground(), 3);
        this.setSize(55, 55);
        this.setPreferredSize(new Dimension(62, 62));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.polygonLabel = new JLabel();
        this.polygonLabel.setSize(50, 50);
        this.polygonLabel.setPreferredSize(new Dimension(55, 55));
        this.polygonLabel.setOpaque(true);
        this.setBackground(Color.white);
        this.add((Component)this.polygonLabel, "Center");
        this.polygonCache = new HashMap();
    }

    public static Icon renderPolygonIcon(String polygonModel, Color color) {
        int previewIconSize = 48;
        RelativePolygon tempPolygon = new RelativePolygon(polygonModel, previewIconSize, previewIconSize);
        tempPolygon.clipTo(previewIconSize, previewIconSize);
        BufferedImage colorImage = new BufferedImage(previewIconSize, previewIconSize, 1);
        Graphics2D g2d = colorImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.white);
        g2d.fill3DRect(0, 0, previewIconSize, previewIconSize, true);
        g2d.setColor(color);
        g2d.fill(tempPolygon.getPolygonPath());
        g2d.setStroke(PolygonEditorControl.selectStrokeSolid);
        g2d.setColor(color.darker());
        g2d.draw(tempPolygon.getPolygonPath());
        return new ImageIcon(colorImage);
    }

    public void clearCache() {
        this.polygonCache.clear();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Icon icon = this.polygonCache.get((String)value);
        if (icon == null) {
            icon = PolygonListCellRenderer.renderPolygonIcon((String)value, Color.gray);
            this.polygonCache.put((String)value, icon);
        }
        this.polygonLabel.setIcon(icon);
        if (isSelected) {
            this.polygonLabel.setBorder(selBorder);
        } else {
            this.polygonLabel.setBorder(regBorder);
        }
        return this;
    }
}

