/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiProject;

public class ProjectListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 3829240390573554917L;
    JLabel projectLabel = new JLabel();

    public ProjectListCellRenderer() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.projectLabel, "Center");
        this.setBorder(new EmptyBorder(0, 5, 0, 5));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        HiProject project;
        String title;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.projectLabel.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.projectLabel.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setOpaque(true);
        if (!list.isEnabled()) {
            this.projectLabel.setForeground(Color.gray);
        }
        if ((title = MetadataHelper.findValue(project = (HiProject)value, project.getDefaultLanguage().getLanguageId())) == null) {
            title = "Unbenanntes Project (P" + project.getId() + ")";
        } else if (title.length() == 0) {
            title = "Unbenanntes Project (P" + project.getId() + ")";
        }
        this.projectLabel.setText(title);
        return this;
    }
}

