/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import com.sun.media.jai.widget.DisplayJAI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.hyperimage.client.Messages;
import org.hyperimage.client.util.LoadableImage;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiQuickInfo;
import org.jdesktop.layout.GroupLayout;

public class QuickInfoCell
extends JPanel
implements LoadableImage {
    private static final long serialVersionUID = 8068619766383530438L;
    private JPanel infoPanel;
    private JLabel idInfoLabel;
    private JPanel idInfoPanel;
    private DisplayJAI previewPanel;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private HiQuickInfo info;
    private boolean isSelected = false;
    private boolean needsPreview = false;

    public QuickInfoCell(HiQuickInfo info) {
        this.info = info;
        this.initComponents();
        this.initInfoText();
        this.attachPreview();
    }

    void updateLanguage() {
        this.setInfoHeader();
    }

    @Override
    public boolean needsPreview() {
        return this.needsPreview;
    }

    @Override
    public void setPreviewImage(PlanarImage image) {
        if (this.needsPreview) {
            if (image != null) {
                if (image.getWidth() <= 128 && image.getHeight() <= 128) {
                    int x = (128 - image.getWidth()) / 2;
                    int y = (128 - image.getHeight()) / 2;
                    this.previewPanel.removeAll();
                    this.previewPanel.set(image, x, y);
                    this.needsPreview = false;
                }
            } else {
                RenderedOp errorImage = JAI.create("url", this.getClass().getResource("/resources/icons/preview-loaderror.png"));
                this.previewPanel.removeAll();
                this.previewPanel.set(errorImage);
                this.needsPreview = false;
            }
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        if (selected != this.isSelected) {
            this.isSelected = selected;
            if (this.isSelected) {
                this.setBackground(Color.yellow);
            } else {
                this.setBackground(Color.gray);
            }
        }
    }

    public boolean attachPreview() {
        RenderedOp image;
        boolean found = false;
        if (this.info.getContentType() == HiBaseTypes.HI_GROUP) {
            image = JAI.create("url", this.getClass().getResource("/resources/icons/preview-group.png"));
            this.previewPanel.set(image);
            found = true;
        } else if (this.info.getContentType() == HiBaseTypes.HIURL) {
            image = JAI.create("url", this.getClass().getResource("/resources/icons/preview-url.png"));
            this.previewPanel.set(image);
            found = true;
        } else if (this.info.getContentType() == HiBaseTypes.HI_LIGHT_TABLE) {
            image = JAI.create("url", this.getClass().getResource("/resources/icons/preview-lighttable.png"));
            this.previewPanel.set(image);
            found = true;
        } else if (this.info.getContentType() == HiBaseTypes.HI_LAYER) {
            this.needsPreview = true;
        } else if (this.info.getContentType() == HiBaseTypes.HI_VIEW) {
            this.needsPreview = true;
        } else if (this.info.getContentType() == HiBaseTypes.HI_OBJECT && this.info.getPreview() == null) {
            if (this.info.getCount() > 0) {
                this.needsPreview = true;
            } else {
                image = JAI.create("url", this.getClass().getResource("/resources/icons/preview-noview.png"));
                this.previewPanel.set(image);
                found = true;
            }
        } else if (this.info.getContentType() == HiBaseTypes.HI_REPOSITORY_ITEM) {
            this.needsPreview = true;
        }
        if (this.needsPreview) {
            image = JAI.create("url", this.getClass().getResource("/resources/icons/preview-loading.png"));
            this.previewPanel.set(image);
        }
        return found;
    }

    private void setInfoHeader() {
        if (this.info.getContentType() == HiBaseTypes.HI_GROUP) {
            if (this.info.getCount() != 1) {
                this.idInfoLabel.setText(String.valueOf(Messages.getString("QuickInfoCell.GROUP")) + " (" + this.info.getCount() + " " + Messages.getString("QuickInfoCell.ELEMENTS") + ")");
            } else {
                this.idInfoLabel.setText(String.valueOf(Messages.getString("QuickInfoCell.GROUP")) + " (" + Messages.getString("QuickInfoCell.ONEELEMENT") + ")");
            }
        } else if (this.info.getContentType() == HiBaseTypes.HI_INSCRIPTION) {
            this.idInfoLabel.setText(Messages.getString("QuickInfoCell.INSCRIPTION"));
        } else if (this.info.getContentType() == HiBaseTypes.HI_LAYER) {
            this.idInfoLabel.setText(Messages.getString("QuickInfoCell.LAYER"));
        } else if (this.info.getContentType() == HiBaseTypes.HI_LIGHT_TABLE) {
            this.idInfoLabel.setText(Messages.getString("QuickInfoCell.LIGHTTABLE"));
        } else if (this.info.getContentType() == HiBaseTypes.HI_OBJECT) {
            if (this.info.getCount() != 1) {
                this.idInfoLabel.setText(String.valueOf(Messages.getString("QuickInfoCell.OBJECT")) + " (" + this.info.getCount() + " " + Messages.getString("QuickInfoCell.VIEWS") + ")");
            } else {
                this.idInfoLabel.setText(String.valueOf(Messages.getString("QuickInfoCell.OBJECT")) + " (" + Messages.getString("QuickInfoCell.ONEVIEW") + ")");
            }
        } else if (this.info.getContentType() == HiBaseTypes.HI_TEXT) {
            this.idInfoLabel.setText(Messages.getString("QuickInfoCell.TEXT"));
        } else if (this.info.getContentType() == HiBaseTypes.HI_VIEW) {
            this.idInfoLabel.setText(Messages.getString("QuickInfoCell.VIEW"));
        } else if (this.info.getContentType() == HiBaseTypes.HIURL) {
            this.idInfoLabel.setText(Messages.getString("QuickInfoCell.EXTERNALURL"));
        }
    }

    private void initInfoText() {
        this.setInfoHeader();
        if (this.info.getContentType() == HiBaseTypes.HI_GROUP) {
            this.idInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-icon.png")));
        } else if (this.info.getContentType() == HiBaseTypes.HI_INSCRIPTION) {
            this.idInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/inscription-icon.png")));
        } else if (this.info.getContentType() == HiBaseTypes.HI_LAYER) {
            this.idInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/layer-icon.png")));
        } else if (this.info.getContentType() == HiBaseTypes.HI_LIGHT_TABLE) {
            this.idInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/lighttable-icon.png")));
        } else if (this.info.getContentType() == HiBaseTypes.HI_OBJECT) {
            this.idInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/object-icon.png")));
        } else if (this.info.getContentType() == HiBaseTypes.HI_TEXT) {
            this.idInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/text-icon.png")));
        } else if (this.info.getContentType() == HiBaseTypes.HI_VIEW) {
            this.idInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/view-icon.png")));
        } else if (this.info.getContentType() == HiBaseTypes.HIURL) {
            this.idInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/url-icon.png")));
        } else if (this.info.getContentType() == HiBaseTypes.HI_REPOSITORY_ITEM) {
            this.idInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/repository-icon.png")));
            this.idInfoLabel.setText(this.info.getPreview());
        }
        String title = null;
        if (this.info.getTitle() != null) {
            if (this.info.getTitle().length() > 0) {
                title = this.info.getTitle();
            } else if (this.info.getContentType() == HiBaseTypes.HI_OBJECT) {
                title = "-";
            }
        }
        if (title != null) {
            this.titleLabel.setText(title);
        }
        if (this.info.getPreview() != null && this.info.getContentType() != HiBaseTypes.HI_REPOSITORY_ITEM) {
            this.previewPanel.setLayout(new BorderLayout());
            JLabel area = new JLabel();
            area.setFont(area.getFont().deriveFont(10.0f));
            area.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.previewPanel.add(area);
            area.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            area.setText(MetadataHelper.richTextToHTML(this.info.getPreview()));
        }
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.idInfoPanel = new JPanel();
        this.idInfoLabel = new JLabel();
        this.previewPanel = new DisplayJAI();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.setBackground(Color.gray);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.infoPanel.setLayout(new BorderLayout());
        this.idInfoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.idInfoPanel.setLayout(new BorderLayout());
        this.idInfoLabel.setFont(this.idInfoLabel.getFont().deriveFont(10.0f));
        this.idInfoLabel.setText("ID: ");
        this.idInfoPanel.add((Component)this.idInfoLabel, "Center");
        this.infoPanel.add((Component)this.idInfoPanel, "North");
        this.titlePanel.setBorder(BorderFactory.createEtchedBorder());
        this.titlePanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(10.0f));
        this.titleLabel.setText("-");
        this.titlePanel.add((Component)this.titleLabel, "Center");
        this.infoPanel.add((Component)this.titlePanel, "South");
        this.previewPanel.setBackground(Color.white);
        this.previewPanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.previewPanel.setPreferredSize(new Dimension(128, 128));
        GroupLayout previewPanelLayout = new GroupLayout(this.previewPanel);
        this.previewPanel.setLayout(previewPanelLayout);
        previewPanelLayout.setHorizontalGroup(previewPanelLayout.createParallelGroup(1).add(0, 126, Short.MAX_VALUE));
        previewPanelLayout.setVerticalGroup(previewPanelLayout.createParallelGroup(1).add(0, 126, Short.MAX_VALUE));
        this.infoPanel.add((Component)this.previewPanel, "Center");
        this.setLayout(new BorderLayout());
        this.infoPanel.setPreferredSize(new Dimension(130, 165));
        this.add(this.infoPanel);
    }
}

