/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.hyperimage.client.Messages;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiQuickInfo;
import org.jdesktop.layout.GroupLayout;

public class QuickInfoListCell
extends JPanel {
    private static final long serialVersionUID = 6255714357570789171L;
    private HiQuickInfo info;
    private JLabel idLabel;
    private JLabel typeLabel;
    private JLabel titleLabel;
    private JLabel countLabel;
    private boolean isSelected = false;

    public QuickInfoListCell(HiQuickInfo info) {
        this.info = info;
        this.initComponents();
        this.initInfoText();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        if (selected != this.isSelected) {
            this.isSelected = selected;
            if (this.isSelected) {
                this.setBackground(Color.yellow);
            } else {
                this.setBackground(Color.gray);
            }
        }
    }

    private void initInfoText() {
        String idText = null;
        String typeText = null;
        if (this.info.getContentType() == HiBaseTypes.HI_GROUP) {
            idText = "G";
            typeText = Messages.getString("QuickInfoCell.GROUP");
        } else if (this.info.getContentType() == HiBaseTypes.HI_INSCRIPTION) {
            idText = "I";
            typeText = Messages.getString("QuickInfoCell.INSCRIPTION");
        }
        if (this.info.getContentType() == HiBaseTypes.HI_LAYER) {
            idText = "L";
            typeText = Messages.getString("QuickInfoCell.LAYER");
        }
        if (this.info.getContentType() == HiBaseTypes.HI_LIGHT_TABLE) {
            idText = "X";
            typeText = Messages.getString("QuickInfoCell.LIGHTTABLE");
        }
        if (this.info.getContentType() == HiBaseTypes.HI_OBJECT) {
            idText = "O";
            typeText = Messages.getString("QuickInfoCell.OBJECT");
        }
        if (this.info.getContentType() == HiBaseTypes.HI_TEXT) {
            idText = "T";
            typeText = Messages.getString("QuickInfoCell.TEXT");
        }
        if (this.info.getContentType() == HiBaseTypes.HI_VIEW) {
            idText = "V";
            typeText = Messages.getString("QuickInfoCell.VIEW");
        }
        if (this.info.getContentType() == HiBaseTypes.HIURL) {
            idText = "U";
            typeText = Messages.getString("QuickInfoCell.EXTERNALURL");
        }
        this.idLabel.setText("<html><b>ID: </b>" + idText + this.info.getBaseID() + "</html>");
        this.typeLabel.setText(typeText);
        if (this.info.getTitle().length() > 0) {
            this.titleLabel.setText(this.info.getTitle());
        } else {
            this.titleLabel.setText("-");
        }
        this.countLabel.setText("(" + this.info.getCount() + ")");
    }

    private void initComponents() {
        this.idLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.countLabel = new JLabel();
        this.setBackground(new Color(242, 242, 255));
        this.countLabel.setHorizontalAlignment(11);
        this.countLabel.setText("(32)");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.idLabel).addPreferredGap(1).add(this.typeLabel).addPreferredGap(1).add(this.titleLabel, -1, 277, Short.MAX_VALUE).addPreferredGap(0).add(this.countLabel, -2, 52, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createParallelGroup(3).add(this.idLabel).add(this.typeLabel).add(this.titleLabel).add(this.countLabel)));
    }
}

