/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.hyperimage.client.Messages;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;

public class TagExplorerListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 7602833818020929120L;
    private JLabel cellLabel = new JLabel();
    private String defaultLang;
    private JSeparator separator = new JSeparator();
    private int dropIndex = -1;

    public TagExplorerListCellRenderer(String defaultLang) {
        this.defaultLang = defaultLang;
        this.cellLabel.setFont(this.cellLabel.getFont().deriveFont(12.0f));
        this.setLayout(new BorderLayout());
        this.add((Component)this.cellLabel, "Center");
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        HiGroup tag = (HiGroup)value;
        this.remove(this.separator);
        String id = "G" + tag.getId();
        if (tag.getUUID() != null) {
            id = tag.getUUID();
        }
        HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord((HiBase)tag, this.defaultLang);
        this.cellLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/tag-icon.png")));
        if (record != null) {
            String title = MetadataHelper.findValue("HIBase", "title", record);
            if (title != null && title.length() > 0) {
                this.cellLabel.setText(title);
            } else {
                this.cellLabel.setText(String.valueOf(Messages.getString("TagExplorerListCellRenderer.tag")) + " (" + id.split("-")[4] + ")");
            }
        } else {
            this.cellLabel.setText(String.valueOf(Messages.getString("TagExplorerListCellRenderer.tag")) + " (" + id.split("-")[4] + ")");
        }
        if (isSelected) {
            this.setBackground(list.getBackground());
            this.cellLabel.setBackground(list.getSelectionBackground());
            this.cellLabel.setForeground(list.getSelectionForeground());
        } else {
            this.cellLabel.setBackground(list.getBackground());
            this.cellLabel.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (list.getDropLocation() != null && index == list.getDropLocation().getIndex() && !list.getDropLocation().isInsert()) {
            this.cellLabel.setBackground(Color.green);
            this.cellLabel.setForeground(list.getSelectionForeground());
            if (list.getDropLocation() != null && this.dropIndex != list.getDropLocation().getIndex()) {
                this.dropIndex = list.getDropLocation().getIndex();
                list.repaint();
            }
        }
        if (list.getDropLocation() == null && this.dropIndex >= 0) {
            this.dropIndex = -1;
            list.repaint();
        }
        this.setEnabled(list.isEnabled());
        this.cellLabel.setEnabled(list.isEnabled());
        this.cellLabel.setOpaque(true);
        this.setOpaque(true);
        return this;
    }
}

