/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;

public class TagListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private JLabel cellLabel = new JLabel();
    private ImageIcon tagIcon = new ImageIcon(this.getClass().getResource("/resources/icons/tag-icon.png"));

    public TagListCellRenderer() {
        this.cellLabel.setFont(this.cellLabel.getFont().deriveFont(12.0f));
        this.setLayout(new BorderLayout());
        this.add((Component)this.cellLabel, "Center");
    }

    public static String getTagName(HiGroup tag) {
        String title;
        HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord((HiBase)tag, HIRuntime.getManager().getProject().getDefaultLanguage());
        if (record != null && (title = MetadataHelper.findValue("HIBase", "title", record)).length() > 0) {
            return title;
        }
        return "Tag (" + tag.getUUID().split("-")[4] + ")";
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String tagName = value.toString();
        if (value.getClass() == HiGroup.class) {
            HiGroup tag = (HiGroup)value;
            tagName = TagListCellRenderer.getTagName(tag);
            this.cellLabel.setIcon(this.tagIcon);
        } else {
            this.cellLabel.setIcon(null);
        }
        this.cellLabel.setText(tagName);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.cellLabel.setBackground(list.getSelectionBackground());
            this.cellLabel.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.cellLabel.setBackground(list.getBackground());
            this.cellLabel.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.cellLabel.setEnabled(list.isEnabled());
        this.cellLabel.setOpaque(true);
        this.setOpaque(true);
        return this;
    }
}

