/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;

public class TemplateFieldsListCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel cellLabel = new JLabel();
    private ImageIcon singleLineIcon = new ImageIcon(this.getClass().getResource("/resources/icons/singleLine-icon.png"));
    private ImageIcon multiLineIcon = new ImageIcon(this.getClass().getResource("/resources/icons/multiLine-icon.png"));
    private HiFlexMetadataTemplate template;
    private Locale osLang;

    public TemplateFieldsListCellRenderer(HiFlexMetadataTemplate template, Locale osLang) {
        this.template = template;
        this.osLang = osLang;
        this.cellLabel.setFont(this.cellLabel.getFont().deriveFont(12.0f));
        this.setLayout(new BorderLayout());
        this.add((Component)this.cellLabel, "Center");
    }

    public void setScreenLanguage(Locale osLang) {
        if (osLang == null) {
            return;
        }
        this.osLang = osLang;
    }

    public void setReferenceTemplate(HiFlexMetadataTemplate template) {
        this.template = template;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        HiFlexMetadataSet set = null;
        set = (HiFlexMetadataSet)value;
        String displayName = MetadataHelper.getTemplateKeyDisplayName(this.template, set, MetadataHelper.localeToLangID(this.osLang));
        if (displayName == null || displayName.length() == 0) {
            displayName = "-";
        }
        this.cellLabel.setText("<html>" + displayName + " <i>(" + set.getTagname() + ")</i></html>");
        if (set.isRichText()) {
            this.cellLabel.setIcon(this.multiLineIcon);
        } else {
            this.cellLabel.setIcon(this.singleLineIcon);
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.cellLabel.setBackground(list.getSelectionBackground());
            this.cellLabel.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.cellLabel.setBackground(list.getBackground());
            this.cellLabel.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.cellLabel.setEnabled(list.isEnabled());
        this.cellLabel.setOpaque(true);
        this.setOpaque(true);
        return this;
    }
}

