/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.hyperimage.client.Messages;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;

public class TemplateListCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel cellLabel = new JLabel();
    private ImageIcon lockedIcon = new ImageIcon(this.getClass().getResource("/resources/icons/lock-icon.png"));
    private ImageIcon editIcon = new ImageIcon(this.getClass().getResource("/resources/icons/edit-icon.png"));

    public TemplateListCellRenderer() {
        this.cellLabel.setFont(this.cellLabel.getFont().deriveFont(12.0f));
        this.setLayout(new BorderLayout());
        this.add((Component)this.cellLabel, "Center");
    }

    public static String getTemplateName(HiFlexMetadataTemplate template) {
        if (template.getNamespacePrefix().compareTo("HIInternal") == 0) {
            return Messages.getString("TemplateListCellRenderer.STAMMDATEN");
        }
        if (template.getNamespacePrefix().compareTo("dc") == 0) {
            return Messages.getString("TemplateListCellRenderer.DUBLIN_CORE_LEGACY_SET");
        }
        if (template.getNamespacePrefix().compareTo("cdwalite") == 0) {
            return Messages.getString("TemplateListCellRenderer.CDWA_LITE");
        }
        if (template.getNamespacePrefix().compareTo("vra4") == 0) {
            return Messages.getString("TemplateListCellRenderer.VRA_CORE_4");
        }
        if (template.getNamespacePrefix().compareTo("vra4hdlbg") == 0) {
            return Messages.getString("TemplateListCellRenderer.VRA_CORE_4_HDLBG");
        }
        if (template.getNamespacePrefix().compareTo("HIClassic") == 0) {
            return Messages.getString("TemplateListCellRenderer.HYPERIMAGE_CLASSIC");
        }
        if (template.getNamespacePrefix().equalsIgnoreCase("custom")) {
            return Messages.getString("TemplateListCellRenderer.CUSTOM_TEMPLATE_(BEARBEITBAR)");
        }
        return template.getNamespacePrefix();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        HiFlexMetadataTemplate template = null;
        template = (HiFlexMetadataTemplate)value;
        String templateName = TemplateListCellRenderer.getTemplateName(template);
        this.cellLabel.setText(templateName);
        this.cellLabel.setIcon(this.lockedIcon);
        if (template.getNamespacePrefix().toLowerCase().compareTo("custom") == 0) {
            this.cellLabel.setIcon(this.editIcon);
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.cellLabel.setBackground(list.getSelectionBackground());
            this.cellLabel.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.cellLabel.setBackground(list.getBackground());
            this.cellLabel.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.cellLabel.setEnabled(list.isEnabled());
        this.cellLabel.setOpaque(true);
        this.setOpaque(true);
        return this;
    }
}

