/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiUser;
import org.jdesktop.layout.GroupLayout;

public class AccountSettingsView
extends GUIView
implements DocumentListener {
    private static final long serialVersionUID = -6285928022646976944L;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel emailLabel;
    private JTextField emailTextField;
    private JLabel firstNameLabel;
    private JTextField firstNameTextField;
    private JLabel lastNameLabel;
    private JTextField lastNameTextField;
    private JPasswordField newPasswordField;
    private JLabel newPasswordLabel;
    private JPanel settingsPanel;
    private JButton updateButton;
    private JPanel userDataPanel;
    private JLabel userNameLabel;
    private JTextField userNameTextField;
    private JPanel userPasswordPanel;
    private HiUser user;

    public AccountSettingsView(HiUser user) {
        super(Messages.getString("AccountSettingsView.EDITDATA"));
        this.user = user;
        this.initComponents();
        this.updateLanguage();
        this.setUserMetadata();
        this.setDisplayPanel(this.settingsPanel);
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("AccountSettingsView.EDITDATA"));
        this.userDataPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("AccountSettingsView.ACCOUNTDATA"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue));
        this.firstNameLabel.setText(String.valueOf(Messages.getString("AccountSettingsView.FIRSTNAME")) + ":");
        this.lastNameLabel.setText(String.valueOf(Messages.getString("AccountSettingsView.LASTNAME")) + ":");
        this.emailLabel.setText(String.valueOf(Messages.getString("AccountSettingsView.EMAIL")) + ":");
        this.userNameLabel.setText(String.valueOf(Messages.getString("AccountSettingsView.USERNAME")) + ":");
        this.userPasswordPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("AccountSettingsView.ACCOUNTPASSWORD"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue));
        this.newPasswordLabel.setText(String.valueOf(Messages.getString("AccountSettingsView.NEWPASSWORD")) + ":");
        this.cancelButton.setText(Messages.getString("AccountSettingsView.CANCEL"));
        this.updateButton.setText(Messages.getString("AccountSettingsView.APPLYCHANGES"));
    }

    public JButton getUpdateButton() {
        return this.updateButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void resetPassword() {
        this.newPasswordField.setText("");
        this.updateButton.setEnabled(this.hasMetadataChanges() || this.hasPasswordChanges());
    }

    public String getNewPassword() {
        return new String(this.newPasswordField.getPassword());
    }

    public void syncMetadataChanges() {
        if (this.hasMetadataChanges()) {
            this.user.setFirstName(this.firstNameTextField.getText());
            this.user.setLastName(this.lastNameTextField.getText());
            this.user.setEmail(this.emailTextField.getText());
            this.updateButton.setEnabled(this.hasMetadataChanges() || this.hasPasswordChanges());
        }
    }

    public boolean hasPasswordChanges() {
        return this.newPasswordField.getPassword().length > 5;
    }

    public boolean hasMetadataChanges() {
        boolean hasChanges = false;
        if (this.firstNameTextField.getText().compareTo(this.user.getFirstName()) != 0) {
            hasChanges = true;
        }
        if (this.lastNameTextField.getText().compareTo(this.user.getLastName()) != 0 && this.lastNameTextField.getText().length() > 0) {
            hasChanges = true;
        }
        if (this.emailTextField.getText().compareTo(this.user.getEmail()) != 0) {
            hasChanges = true;
        }
        return hasChanges;
    }

    private void setUserMetadata() {
        this.firstNameTextField.setText(this.user.getFirstName());
        this.lastNameTextField.setText(this.user.getLastName());
        this.emailTextField.setText(this.user.getEmail());
        this.userNameTextField.setText(this.user.getUserName());
    }

    private void initComponents() {
        this.settingsPanel = new JPanel();
        this.userDataPanel = new JPanel();
        this.firstNameLabel = new JLabel();
        this.firstNameTextField = new JTextField();
        this.lastNameLabel = new JLabel();
        this.lastNameTextField = new JTextField();
        this.emailLabel = new JLabel();
        this.emailTextField = new JTextField();
        this.userNameLabel = new JLabel();
        this.userNameTextField = new JTextField();
        this.userPasswordPanel = new JPanel();
        this.newPasswordLabel = new JLabel();
        this.newPasswordField = new JPasswordField();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.updateButton = new JButton();
        this.firstNameLabel.setHorizontalAlignment(4);
        this.firstNameLabel.setLabelFor(this.firstNameTextField);
        this.lastNameLabel.setHorizontalAlignment(4);
        this.lastNameLabel.setLabelFor(this.lastNameTextField);
        this.emailLabel.setHorizontalAlignment(4);
        this.emailLabel.setLabelFor(this.emailTextField);
        this.userNameLabel.setHorizontalAlignment(4);
        this.userNameLabel.setLabelFor(this.userNameTextField);
        this.userNameTextField.setEditable(false);
        this.userNameTextField.setEnabled(false);
        GroupLayout userDataPanelLayout = new GroupLayout(this.userDataPanel);
        this.userDataPanel.setLayout(userDataPanelLayout);
        userDataPanelLayout.setHorizontalGroup(userDataPanelLayout.createParallelGroup(1).add(userDataPanelLayout.createSequentialGroup().addContainerGap().add(userDataPanelLayout.createParallelGroup(1, false).add(this.firstNameLabel, -2, 113, -2).add(this.lastNameLabel, -2, 113, -2).add(this.emailLabel, -1, 113, Short.MAX_VALUE).add(2, this.userNameLabel, -1, 113, Short.MAX_VALUE)).add(10, 10, 10).add(userDataPanelLayout.createParallelGroup(2).add(this.firstNameTextField, -1, 260, Short.MAX_VALUE).add(this.lastNameTextField, -1, 260, Short.MAX_VALUE).add(this.emailTextField, -1, 260, Short.MAX_VALUE).add(1, this.userNameTextField, -1, 260, Short.MAX_VALUE)).addContainerGap()));
        userDataPanelLayout.setVerticalGroup(userDataPanelLayout.createParallelGroup(1).add(userDataPanelLayout.createSequentialGroup().add(userDataPanelLayout.createParallelGroup(3).add(this.firstNameTextField, -2, -1, -2).add(this.firstNameLabel)).addPreferredGap(0).add(userDataPanelLayout.createParallelGroup(3).add(this.lastNameTextField, -2, -1, -2).add(this.lastNameLabel)).addPreferredGap(0).add(userDataPanelLayout.createParallelGroup(3).add(this.emailTextField, -2, -1, -2).add(this.emailLabel)).addPreferredGap(0).add(userDataPanelLayout.createParallelGroup(3).add(this.userNameTextField, -2, -1, -2).add(this.userNameLabel))));
        this.newPasswordLabel.setHorizontalAlignment(4);
        this.newPasswordLabel.setLabelFor(this.newPasswordField);
        GroupLayout userPasswordPanelLayout = new GroupLayout(this.userPasswordPanel);
        this.userPasswordPanel.setLayout(userPasswordPanelLayout);
        userPasswordPanelLayout.setHorizontalGroup(userPasswordPanelLayout.createParallelGroup(1).add(userPasswordPanelLayout.createSequentialGroup().addContainerGap().add(this.newPasswordLabel, -2, 111, -2).addPreferredGap(0).add(this.newPasswordField, -1, 262, Short.MAX_VALUE).addContainerGap()));
        userPasswordPanelLayout.setVerticalGroup(userPasswordPanelLayout.createParallelGroup(1).add(userPasswordPanelLayout.createParallelGroup(3).add(this.newPasswordField, -2, -1, -2).add(this.newPasswordLabel)));
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(1).add(2, buttonPanelLayout.createSequentialGroup().addContainerGap(199, Short.MAX_VALUE).add(this.cancelButton).add(11, 11, 11).add(this.updateButton)));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(1).add(buttonPanelLayout.createSequentialGroup().addContainerGap().add(buttonPanelLayout.createParallelGroup(3).add(this.cancelButton, -2, 29, -2).add(this.updateButton, -2, 29, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(1).add(2, settingsPanelLayout.createSequentialGroup().addContainerGap().add(settingsPanelLayout.createParallelGroup(2).add(1, this.buttonPanel, -1, -1, Short.MAX_VALUE).add(1, this.userDataPanel, -1, -1, Short.MAX_VALUE).add(1, this.userPasswordPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(1).add(settingsPanelLayout.createSequentialGroup().addContainerGap().add(this.userDataPanel, -2, -1, -2).addPreferredGap(0).add(this.userPasswordPanel, -2, -1, -2).addPreferredGap(0).add(this.buttonPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.updateButton.setEnabled(false);
        this.updateButton.setActionCommand("update");
        this.cancelButton.setActionCommand("cancel");
        this.firstNameTextField.getDocument().addDocumentListener(this);
        this.lastNameTextField.getDocument().addDocumentListener(this);
        this.emailTextField.getDocument().addDocumentListener(this);
        this.newPasswordField.getDocument().addDocumentListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateButton.setEnabled(this.hasMetadataChanges() || this.hasPasswordChanges());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateButton.setEnabled(this.hasMetadataChanges() || this.hasPasswordChanges());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateButton.setEnabled(this.hasMetadataChanges() || this.hasPasswordChanges());
    }
}

