/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.HIRichTextFieldControl;
import org.hyperimage.client.gui.HISimpleTextFieldControl;
import org.hyperimage.client.gui.HITemplateSeperatorControl;
import org.hyperimage.client.gui.HITextFieldControl;
import org.hyperimage.client.gui.ResetButton;
import org.hyperimage.client.gui.SaveButton;
import org.hyperimage.client.gui.TagsButton;
import org.hyperimage.client.gui.dialogs.HIBaseTagsEditorDialog;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiKeyValue;
import org.hyperimage.client.ws.HiObject;
import org.jdesktop.layout.GroupLayout;

public class FlexMetadataEditorView
extends GUIView
implements ActionListener {
    private static final long serialVersionUID = -7426122593174332781L;
    private GridBagConstraints gridBagConstraints = new GridBagConstraints();
    private List<HiFlexMetadataTemplate> templates;
    private HiBase base;
    private List<HiFlexMetadataRecord> metadata;
    private String defLang;
    private HashMap<String, HITextFieldControl> modelToView;
    private HashMap<String, Vector<String>> metadataBuffer;
    private Vector<String> languageKeys;
    private int curLangIndex = 0;
    private int defLangIndex = 0;
    private boolean hasChanges = false;
    private JPanel controlPanel;
    private JPanel editorPanel;
    private JLabel idLabel;
    private JComboBox languageComboBox;
    private JLabel languageLabel;
    private JPanel metadataElementsPanel;
    private JPanel metadataPanel;
    private ResetButton resetButton;
    private SaveButton saveButton;
    private TagsButton tagsButton;
    private HashMap<String, HITemplateSeperatorControl> prefixStore = new HashMap();

    public FlexMetadataEditorView(List<HiFlexMetadataTemplate> templates, HiBase base, String defLang) {
        super(Messages.getString("FlexMetadataEditorView.0"), new Color(97, 137, 202));
        this.templates = templates;
        this.base = base;
        this.metadata = MetadataHelper.resolveMetadataRecords(base);
        this.defLang = defLang;
        this.languageKeys = new Vector();
        this.modelToView = new HashMap();
        this.metadataBuffer = new HashMap();
        this.initComponents();
        this.initFields();
        this.buildLanguages();
        this.tagsButton.addActionListener(this);
        this.tagsButton.setCount((int)HIRuntime.getGui().getTagCountForElement(base.getId()));
        this.initBuffer();
        this.setMetadataFields();
        this.setDisplayPanel(this.editorPanel);
    }

    @Override
    public void updateLanguage() {
        this.languageLabel.setText(Messages.getString("FlexMetadataEditorView.17"));
        this.saveButton.setToolTipText(Messages.getString("FlexMetadataEditorView.19"));
        this.resetButton.setToolTipText(Messages.getString("FlexMetadataEditorView.20"));
        this.tagsButton.setToolTipText(Messages.getString("MetadataEditorControl.tagButtonTooltip"));
        this.setTitle(Messages.getString("FlexMetadataEditorView.0"));
        if (this.base instanceof HiObject) {
            this.idLabel.setText(String.valueOf(Messages.getString("HIClientGUI.lastChanged")) + ": " + MetadataHelper.getFuzzyDate(this.base.getTimestamp()));
        }
        this.buildLanguages();
        for (String prefix : this.prefixStore.keySet()) {
            String displayPrefix = this.processDisplayFields(prefix);
            this.prefixStore.get(prefix).updateTitle(displayPrefix);
        }
        for (HiFlexMetadataTemplate template : this.templates) {
            if (template.getNamespacePrefix().compareTo("HIBase") == 0) continue;
            for (HiFlexMetadataSet fmSet : template.getEntries()) {
                HITextFieldControl textControl = this.modelToView.get(String.valueOf(template.getNamespacePrefix()) + "." + fmSet.getTagname());
                if (textControl == null) continue;
                textControl.updateTitle(MetadataHelper.getTemplateKeyDisplayName(template, fmSet.getTagname(), HIRuntime.getGUILanguage().getLanguage()));
            }
        }
    }

    @Override
    public void updateContent() {
        this.resetChanges();
    }

    public void setIdLabel(String id) {
        this.idLabel.setText(String.valueOf(Messages.getString("FlexMetadataEditorView.2")) + " " + id);
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getResetButton() {
        return this.resetButton;
    }

    public void updateMetadataLanguages() {
        this.buildLanguages();
        this.initBuffer();
        this.curLangIndex = this.languageComboBox.getSelectedIndex();
        this.setMetadataFields();
    }

    public void syncChanges() {
        for (String lang : this.languageKeys) {
            HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord(this.metadata, lang);
            Vector<String> values = this.metadataBuffer.get(lang);
            int count = 0;
            if (record == null) continue;
            for (HiKeyValue kvPair : record.getContents()) {
                kvPair.setValue(values.get(count));
                ++count;
            }
        }
        this.hasChanges = false;
    }

    public void resetChanges() {
        this.initBuffer();
        this.setMetadataFields();
        this.hasChanges = false;
    }

    public boolean hasChanges() {
        if (this.metadata == null) {
            return false;
        }
        this.syncToBuffer();
        if (!this.hasChanges && this.entryModified()) {
            this.hasChanges = true;
        }
        return this.hasChanges;
    }

    private boolean entryModified() {
        for (String lang : this.languageKeys) {
            HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord(this.metadata, lang);
            Vector<String> values = this.metadataBuffer.get(lang);
            int count = 0;
            if (record == null) continue;
            for (HiKeyValue kvPair : record.getContents()) {
                if (kvPair.getValue().compareTo(values.get(count)) != 0) {
                    return true;
                }
                ++count;
            }
        }
        return false;
    }

    private void syncToBuffer() {
        if (this.metadata != null) {
            HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(this.curLangIndex));
            Vector<String> values = this.metadataBuffer.get(this.languageKeys.get(this.curLangIndex));
            int count = 0;
            if (record != null) {
                for (HiKeyValue kvPair : record.getContents()) {
                    values.setElementAt(this.modelToView.get(kvPair.getKey()).getText(), count);
                    ++count;
                }
            }
        }
    }

    private void initBuffer() {
        this.metadataBuffer.clear();
        for (String lang : this.languageKeys) {
            HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord(this.metadata, lang);
            Vector<String> values = new Vector<String>();
            if (record == null) continue;
            for (HiKeyValue kvPair : record.getContents()) {
                values.addElement(kvPair.getValue());
            }
            this.metadataBuffer.put(lang, values);
        }
    }

    private void setMetadataFields() {
        if (this.metadata != null) {
            HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(this.curLangIndex));
            int count = 0;
            Vector<String> values = this.metadataBuffer.get(record.getLanguage());
            for (HiKeyValue kvPair : record.getContents()) {
                HITextFieldControl textControl = this.modelToView.get(kvPair.getKey());
                if (values == null || values.get(count) == null) {
                    textControl.setText("");
                } else {
                    textControl.setText(values.get(count));
                }
                ++count;
            }
        }
    }

    private void buildLanguages() {
        this.languageComboBox.removeActionListener(this);
        this.languageKeys.removeAllElements();
        this.languageComboBox.removeAllItems();
        if (this.metadata != null) {
            for (HiFlexMetadataRecord record : this.metadata) {
                this.languageKeys.addElement(record.getLanguage());
                if (record.getLanguage().compareTo(this.defLang) == 0) {
                    this.defLangIndex = this.languageKeys.size() - 1;
                }
                this.languageComboBox.addItem(new Locale(record.getLanguage()).getDisplayLanguage());
            }
            this.languageComboBox.setSelectedIndex(this.defLangIndex);
            this.curLangIndex = this.defLangIndex;
        } else {
            this.languageComboBox.addItem(Messages.getString("FlexMetadataEditorView.4"));
        }
        this.languageComboBox.addActionListener(this);
    }

    private String processDisplayFields(String strPrefix) {
        String strDisplayPrefix = strPrefix;
        if (strPrefix.compareTo("HIInternal") == 0) {
            strDisplayPrefix = Messages.getString("FlexMetadataEditorView.8");
        }
        if (strPrefix.compareTo("dc") == 0) {
            strDisplayPrefix = Messages.getString("FlexMetadataEditorView.10");
        }
        if (strPrefix.compareTo("cdwalite") == 0) {
            strDisplayPrefix = Messages.getString("FlexMetadataEditorView.25");
        }
        if (strPrefix.compareTo("vra4") == 0) {
            strDisplayPrefix = Messages.getString("FlexMetadataEditorView.VRA4");
        }
        if (strPrefix.compareTo("vra4hdlbg") == 0) {
            strDisplayPrefix = Messages.getString("FlexMetadataEditorView.VRA4_Hdlbg");
        }
        if (strPrefix.equalsIgnoreCase("custom")) {
            strDisplayPrefix = Messages.getString("FlexMetadataEditorView.26");
        }
        if (strPrefix.compareTo("HIClassic") == 0) {
            strDisplayPrefix = Messages.getString("FlexMetadataEditorView.12");
        }
        return strDisplayPrefix;
    }

    private void initFields() {
        int mainCount = 0;
        this.prefixStore.clear();
        for (HiFlexMetadataTemplate template : this.templates) {
            Vector<HITextFieldControl> items = new Vector<HITextFieldControl>();
            if (template.getNamespacePrefix().compareTo("HIBase") == 0) continue;
            boolean collapsed = false;
            if (template.getNamespacePrefix().compareTo("HIInternal") == 0) {
                collapsed = true;
            }
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            String prefix = template.getNamespacePrefix();
            prefix = this.processDisplayFields(prefix);
            this.prefixStore.put(template.getNamespacePrefix(), this.addTemplateSeperator(prefix, collapsed, mainCount, this.metadataElementsPanel, panel));
            ++mainCount;
            int count = 0;
            for (HiFlexMetadataSet fmSet : template.getEntries()) {
                HITextFieldControl textControl = fmSet.isRichText() ? this.addMultiLineField(MetadataHelper.getTemplateKeyDisplayName(template, fmSet.getTagname(), HIRuntime.getGUILanguage().getLanguage()), count, panel) : this.addSingleLineField(MetadataHelper.getTemplateKeyDisplayName(template, fmSet.getTagname(), HIRuntime.getGUILanguage().getLanguage()), count, panel);
                this.modelToView.put(String.valueOf(template.getNamespacePrefix()) + "." + fmSet.getTagname(), textControl);
                items.add(textControl);
                ++count;
            }
            this.gridBagConstraints.fill = 1;
            this.gridBagConstraints.gridwidth = 1;
            this.gridBagConstraints.gridheight = 1;
            this.gridBagConstraints.gridx = 0;
            this.gridBagConstraints.gridy = mainCount++;
            this.gridBagConstraints.weightx = 1.0;
            this.gridBagConstraints.weighty = 1.0;
            this.metadataElementsPanel.add((Component)panel, this.gridBagConstraints);
        }
        this.addFiller(mainCount, this.metadataElementsPanel);
        if (this.base instanceof HiObject) {
            this.idLabel.setText(String.valueOf(Messages.getString("HIClientGUI.lastChanged")) + ": " + MetadataHelper.getFuzzyDate(this.base.getTimestamp()));
        }
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.metadataPanel = new JPanel();
        this.languageLabel = new JLabel();
        this.languageComboBox = new JComboBox();
        this.metadataElementsPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.idLabel = new JLabel();
        this.resetButton = new ResetButton();
        this.saveButton = new SaveButton();
        this.tagsButton = new TagsButton();
        JScrollPane metadataElementsScroll = new JScrollPane(this.metadataElementsPanel);
        metadataElementsScroll.setPreferredSize(new Dimension(200, 300));
        this.metadataPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("FlexMetadataEditorView.15"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue));
        GroupLayout metadataPanelLayout = new GroupLayout(this.metadataPanel);
        this.metadataPanel.setLayout(metadataPanelLayout);
        metadataPanelLayout.setHorizontalGroup(metadataPanelLayout.createParallelGroup(1).add(2, metadataPanelLayout.createSequentialGroup().addContainerGap(192, Short.MAX_VALUE).add(this.languageLabel).addPreferredGap(0).add(this.languageComboBox, -2, 187, -2)).add(metadataElementsScroll, -1, -1, Short.MAX_VALUE));
        metadataPanelLayout.setVerticalGroup(metadataPanelLayout.createParallelGroup(1).add(metadataPanelLayout.createSequentialGroup().add(metadataPanelLayout.createParallelGroup(3).add(this.languageComboBox, -2, -1, -2).add(this.languageLabel)).addPreferredGap(0).add(metadataElementsScroll, -1, -1, Short.MAX_VALUE)));
        this.idLabel.setText(Messages.getString("FlexMetadataEditorView.18"));
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(1).add(controlPanelLayout.createSequentialGroup().add(this.resetButton, -2, -1, -2).addPreferredGap(0).add(this.saveButton, -2, -1, -2).addPreferredGap(1).add(this.idLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(this.tagsButton, -2, 90, -2)));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(1).add(controlPanelLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add(controlPanelLayout.createParallelGroup(1).add(2, controlPanelLayout.createParallelGroup(3).add(this.resetButton, -2, -1, -2).add(this.saveButton, -2, -1, -2).add(this.idLabel, -2, 24, -2)).add(2, this.tagsButton, -2, -1, -2)).add(0, 0, 0)));
        GroupLayout editorPanelLayout = new GroupLayout(this.editorPanel);
        this.editorPanel.setLayout(editorPanelLayout);
        editorPanelLayout.setHorizontalGroup(editorPanelLayout.createParallelGroup(1).add(2, editorPanelLayout.createSequentialGroup().addContainerGap().add(editorPanelLayout.createParallelGroup(2).add(1, this.metadataPanel, -1, -1, Short.MAX_VALUE).add(1, this.controlPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        editorPanelLayout.setVerticalGroup(editorPanelLayout.createParallelGroup(1).add(2, editorPanelLayout.createSequentialGroup().addContainerGap().add(this.metadataPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0, 6, 6).add(this.controlPanel, -2, -1, -2).addContainerGap()));
        this.metadataElementsPanel.setLayout(new GridBagLayout());
        this.languageComboBox.addActionListener(this);
        if (System.getProperty("HI.feature.tagsDisabled") != null) {
            this.tagsButton.setVisible(false);
        }
        this.updateLanguage();
    }

    private void addFiller(int index, JPanel panel) {
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.gridheight = 1;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = index;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0E-10;
        panel.add((Component)new JPanel(), this.gridBagConstraints);
    }

    private HITextFieldControl addSingleLineField(String title, int index, JPanel panel) {
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.gridheight = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 0.0;
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = index;
        HISimpleTextFieldControl slPanel = new HISimpleTextFieldControl(title);
        panel.add((Component)slPanel, this.gridBagConstraints);
        return slPanel;
    }

    private HITextFieldControl addMultiLineField(String title, int index, JPanel panel) {
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.gridheight = 1;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = index;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        HIRichTextFieldControl mlPanel = new HIRichTextFieldControl(title);
        panel.add((Component)mlPanel, this.gridBagConstraints);
        return mlPanel;
    }

    private HITemplateSeperatorControl addTemplateSeperator(String title, boolean collapsed, int index, JPanel panel, JPanel itemsPanel) {
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.gridheight = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 0.0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = index;
        HITemplateSeperatorControl control = new HITemplateSeperatorControl(title, itemsPanel, collapsed);
        panel.add((Component)control, this.gridBagConstraints);
        return control;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tagsButton) {
            this.tagsButton.setCount(new HIBaseTagsEditorDialog((Frame)HIRuntime.getGui(), this.base.getId()).chooseTags());
        } else if (this.metadata != null && this.languageKeys.size() > 0) {
            this.hasChanges();
            this.syncToBuffer();
            this.curLangIndex = this.languageComboBox.getSelectedIndex();
            this.setMetadataFields();
        }
    }
}

