/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public abstract class GUIView
extends JPanel {
    private static final long serialVersionUID = -8914666534420252209L;
    protected JMenuBar menuBar;
    protected JMenu menuTitle;

    public GUIView(String title) {
        this.initView(title);
    }

    public GUIView(String title, Color menuColor) {
        this.initView(title);
        this.menuBar.setBackground(menuColor);
        this.menuTitle.setBackground(menuColor);
    }

    public GUIView() {
        this("Component");
    }

    public GUIView(Color menuColor) {
        this("Component", menuColor);
    }

    public void updateContent() {
    }

    protected void initView(String title) {
        this.menuBar = new JMenuBar();
        this.menuTitle = new JMenu(title);
        this.menuBar.add(this.menuTitle);
        this.menuBar.setBackground(new Color(170, 170, 170));
        this.menuTitle.setBackground(this.menuBar.getBackground());
        this.menuTitle.setForeground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.setSize(400, 400);
        this.setPreferredSize(new Dimension(400, 400));
        this.add((Component)this.menuBar, "North");
    }

    public JMenu getMenu() {
        return this.menuTitle;
    }

    public String getTitle() {
        return this.menuTitle.getText();
    }

    public void setTitle(String title) {
        this.menuTitle.setText(title);
    }

    public void updateLanguage() {
    }

    protected void setDisplayPanel(JPanel content) {
        this.add((Component)content, "Center");
        this.setSize(content.getSize());
        this.setPreferredSize(content.getPreferredSize());
    }
}

