/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.hyperimage.client.gui.OptionButton;
import org.hyperimage.client.gui.lists.GroupContentsList;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiQuickInfo;
import org.jdesktop.layout.GroupLayout;

public class GenericContentsView
extends GUIView {
    private static final long serialVersionUID = -7561733761464079441L;
    protected JPanel controlPanel;
    protected JLabel elementCountLabel;
    protected JScrollPane listScrollPane;
    protected JButton listStyleButton;
    protected OptionButton optionsButton;
    protected JPanel contentsPanel;
    protected JProgressBar loadingIndicator;
    protected JPanel contentsInfoPanel;
    protected GroupContentsList contentsList;
    protected JPanel contentsDisplayPanel;
    public ImageIcon iconStyleIcon;
    public ImageIcon listStyleIcon;
    protected List<HiQuickInfo> contents = null;
    protected int elementCount = 0;

    public GenericContentsView(String title) {
        super(title);
        this.initComponents();
        this.setDisplayPanel(this.contentsPanel);
    }

    public void setContents(List<HiQuickInfo> contents) {
        DefaultListModel model = (DefaultListModel)this.contentsList.getModel();
        model.removeAllElements();
        for (HiQuickInfo info : contents) {
            model.addElement(info);
        }
        this.elementCount = model.getSize();
        this.contents = contents;
        this.setLoading(false);
    }

    public List<HiQuickInfo> getContents() {
        return this.contents;
    }

    public void prepareElementLoading() {
        DefaultListModel model = (DefaultListModel)this.contentsList.getModel();
        model.removeAllElements();
        this.elementCount = 0;
        this.setLoading(true);
    }

    public GroupContentsList getContentsList() {
        return this.contentsList;
    }

    public JButton getListStyleButton() {
        return this.listStyleButton;
    }

    protected void setLoading(boolean loading) {
        this.optionsButton.setEnabled(!loading);
        this.loadingIndicator.setVisible(loading);
    }

    protected void initComponents() {
        this.contentsPanel = new JPanel();
        this.contentsDisplayPanel = new JPanel();
        this.listScrollPane = new JScrollPane();
        this.contentsList = new GroupContentsList();
        this.controlPanel = new JPanel();
        this.loadingIndicator = new JProgressBar();
        this.optionsButton = new OptionButton();
        this.contentsInfoPanel = new JPanel();
        this.elementCountLabel = new JLabel();
        this.listStyleButton = new JButton();
        this.loadingIndicator.setIndeterminate(true);
        this.contentsInfoPanel.setLayout(new BorderLayout(10, 0));
        this.contentsInfoPanel.add((Component)this.loadingIndicator, "Center");
        this.listScrollPane.setViewportView(this.contentsList);
        this.controlPanel.setLayout(new BorderLayout(10, 0));
        this.controlPanel.add((Component)this.optionsButton, "West");
        this.elementCountLabel.setText("XX Elemente");
        this.contentsInfoPanel.add((Component)this.elementCountLabel, "West");
        this.controlPanel.add((Component)this.contentsInfoPanel, "Center");
        this.listStyleButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.listStyleButton.setPreferredSize(new Dimension(24, 24));
        this.controlPanel.add((Component)this.listStyleButton, "East");
        GroupLayout searchResultsPanelLayout = new GroupLayout(this.contentsDisplayPanel);
        this.contentsDisplayPanel.setLayout(searchResultsPanelLayout);
        searchResultsPanelLayout.setHorizontalGroup(searchResultsPanelLayout.createParallelGroup(1).add(searchResultsPanelLayout.createSequentialGroup().addContainerGap().add(searchResultsPanelLayout.createParallelGroup(1).add(2, this.controlPanel, -1, 620, Short.MAX_VALUE).add(2, this.listScrollPane, -1, 620, Short.MAX_VALUE)).addContainerGap()));
        searchResultsPanelLayout.setVerticalGroup(searchResultsPanelLayout.createParallelGroup(1).add(2, searchResultsPanelLayout.createSequentialGroup().addContainerGap().add(this.listScrollPane, -1, 213, Short.MAX_VALUE).add(7, 7, 7).add(this.controlPanel, -2, -1, -2).addContainerGap()));
        GroupLayout resultsPanelLayout = new GroupLayout(this.contentsPanel);
        this.contentsPanel.setLayout(resultsPanelLayout);
        resultsPanelLayout.setHorizontalGroup(resultsPanelLayout.createParallelGroup(1).add(this.contentsDisplayPanel, -1, -1, Short.MAX_VALUE));
        resultsPanelLayout.setVerticalGroup(resultsPanelLayout.createParallelGroup(1).add(this.contentsDisplayPanel, -1, -1, Short.MAX_VALUE));
        this.optionsButton.setEnabled(false);
        this.listStyleButton.setEnabled(false);
        this.iconStyleIcon = new ImageIcon(this.getClass().getResource("/resources/icons/group-iconstyle.png"));
        this.listStyleIcon = new ImageIcon(this.getClass().getResource("/resources/icons/group-liststyle.png"));
        this.listStyleButton.setIcon(this.iconStyleIcon);
        this.listStyleButton.setToolTipText("Icon Ansicht - Zur Listendarstellung wechseln");
        this.setLoading(false);
    }
}

