/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.MetadataEditorControl;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiKeyValue;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.jdesktop.layout.GroupLayout;

public class GenericMetadataEditorView
extends GUIView {
    private static final long serialVersionUID = -9211467123067610757L;
    protected JPanel editorPanel;
    protected MetadataEditorControl metadataEditorControl;
    private HiBase base;

    public GenericMetadataEditorView(HiText text, String defLang) {
        super(Messages.getString("GenericMetadataEditorView.0"), new Color(97, 137, 202));
        this.base = text;
        this.metadataEditorControl = new MetadataEditorControl("title", Messages.getString("GenericMetadataEditorView.2"), null, null, "content", Messages.getString("GenericMetadataEditorView.4"));
        this.metadataEditorControl.setHeading(Messages.getString("GenericMetadataEditorView.5"));
        this.metadataEditorControl.setMetadata(text.getMetadata(), defLang);
        System.out.println("Init Editor");
        if (text.getUUID() == null) {
            this.metadataEditorControl.setIdLabel("T" + text.getId());
        } else {
            this.metadataEditorControl.setIdLabel(text.getUUID());
        }
        this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(text.getTimestamp()));
        this.initView();
    }

    public GenericMetadataEditorView(HiInscription inscription, String defLang) {
        super(Messages.getString("GenericMetadataEditorView.7"));
        this.base = inscription;
        this.metadataEditorControl = new MetadataEditorControl(null, null, null, null, "content", Messages.getString("GenericMetadataEditorView.9"));
        this.metadataEditorControl.setHeading(Messages.getString("GenericMetadataEditorView.10"));
        this.metadataEditorControl.setMetadata(inscription.getMetadata(), defLang);
        if (inscription.getUUID() == null) {
            this.metadataEditorControl.setIdLabel("I" + inscription.getId());
        } else {
            this.metadataEditorControl.setIdLabel(inscription.getUUID());
        }
        this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(inscription.getTimestamp()));
        this.initView();
    }

    public GenericMetadataEditorView(Hiurl url, String defLang) {
        super(Messages.getString("GenericMetadataEditorView.12"));
        this.base = url;
        this.metadataEditorControl = new MetadataEditorControl("url", Messages.getString("GenericMetadataEditorView.14"), "title", Messages.getString("GenericMetadataEditorView.16"), "lastaccess", Messages.getString("GenericMetadataEditorView.18"));
        this.metadataEditorControl.setHeading(Messages.getString("GenericMetadataEditorView.19"));
        this.metadataEditorControl.setMultiLanguage(false);
        HiFlexMetadataRecord record = new HiFlexMetadataRecord();
        record.setLanguage(defLang);
        HiKeyValue kvUrl = new HiKeyValue();
        HiKeyValue kvTitle = new HiKeyValue();
        HiKeyValue kvLastAccess = new HiKeyValue();
        kvUrl.setKey("HIBase.url");
        if (url.getUrl() != null) {
            kvUrl.setValue(url.getUrl());
        } else {
            kvUrl.setValue("");
        }
        kvTitle.setKey("HIBase.title");
        if (url.getTitle() != null) {
            kvTitle.setValue(url.getTitle());
        } else {
            kvTitle.setValue("");
        }
        kvLastAccess.setKey("HIBase.lastaccess");
        if (url.getLastAccess() != null) {
            kvLastAccess.setValue(url.getLastAccess());
        } else {
            kvLastAccess.setValue("");
        }
        record.getContents().add(kvUrl);
        record.getContents().add(kvTitle);
        record.getContents().add(kvLastAccess);
        ArrayList<HiFlexMetadataRecord> records = new ArrayList<HiFlexMetadataRecord>();
        records.add(record);
        this.metadataEditorControl.setMetadata(records, defLang);
        if (url.getUUID() == null) {
            this.metadataEditorControl.setIdLabel("U" + url.getId());
        } else {
            this.metadataEditorControl.setIdLabel(url.getUUID());
        }
        this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(url.getTimestamp()));
        this.initView();
    }

    public GenericMetadataEditorView(HiView view, String defLang) {
        super(Messages.getString("GenericMetadataEditorView.27"));
        this.base = view;
        this.metadataEditorControl = new MetadataEditorControl("title", Messages.getString("GenericMetadataEditorView.29"), "source", Messages.getString("GenericMetadataEditorView.31"), "comment", Messages.getString("GenericMetadataEditorView.33"));
        this.metadataEditorControl.setMetadata(view.getMetadata(), defLang);
        if (view.getUUID() == null) {
            this.metadataEditorControl.setIdLabel("V" + view.getId());
        } else {
            this.metadataEditorControl.setIdLabel(view.getUUID());
        }
        this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(view.getTimestamp()));
        this.initView();
    }

    @Override
    public void updateContent() {
        this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(this.base.getTimestamp()));
    }

    @Override
    public void updateLanguage() {
        if (this.base instanceof HiText) {
            this.metadataEditorControl.updateLanguage(Messages.getString("GenericMetadataEditorView.2"), null, Messages.getString("GenericMetadataEditorView.4"));
            this.metadataEditorControl.setHeading(Messages.getString("GenericMetadataEditorView.5"));
            this.setTitle(Messages.getString("GenericMetadataEditorView.0"));
        }
        if (this.base instanceof HiInscription) {
            this.metadataEditorControl.updateLanguage(null, null, Messages.getString("GenericMetadataEditorView.9"));
            this.metadataEditorControl.setHeading(Messages.getString("GenericMetadataEditorView.10"));
            this.setTitle(Messages.getString("GenericMetadataEditorView.7"));
        }
        if (this.base instanceof Hiurl) {
            this.metadataEditorControl.updateLanguage(Messages.getString("GenericMetadataEditorView.14"), Messages.getString("GenericMetadataEditorView.16"), Messages.getString("GenericMetadataEditorView.18"));
            this.metadataEditorControl.setHeading(Messages.getString("GenericMetadataEditorView.19"));
            this.setTitle(Messages.getString("GenericMetadataEditorView.12"));
        }
        if (this.base instanceof HiView) {
            this.metadataEditorControl.updateLanguage(Messages.getString("GenericMetadataEditorView.29"), Messages.getString("GenericMetadataEditorView.31"), Messages.getString("GenericMetadataEditorView.33"));
            this.setTitle(Messages.getString("GenericMetadataEditorView.27"));
        }
        this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(this.base.getTimestamp()));
    }

    private void initView() {
        this.initComponents();
        this.setDisplayPanel(this.editorPanel);
        this.metadataEditorControl.setBaseID(this.base.getId());
        this.metadataEditorControl.setTagCount(HIRuntime.getGui().getTagCountForElement(this.base.getId()));
    }

    public JButton getSaveButton() {
        return this.metadataEditorControl.getSaveButton();
    }

    public JButton getResetButton() {
        return this.metadataEditorControl.getResetButton();
    }

    public void syncChanges() {
        this.metadataEditorControl.syncChanges();
        if (this.base instanceof Hiurl) {
            Hiurl url = (Hiurl)this.base;
            url.setUrl(MetadataHelper.findValue("HIBase", "url", this.metadataEditorControl.getMetadata().get(0)));
            url.setTitle(MetadataHelper.findValue("HIBase", "title", this.metadataEditorControl.getMetadata().get(0)));
            url.setLastAccess(MetadataHelper.findValue("HIBase", "lastaccess", this.metadataEditorControl.getMetadata().get(0)));
        }
    }

    public void resetChanges() {
        this.metadataEditorControl.resetChanges();
    }

    public boolean hasChanges() {
        return this.metadataEditorControl.hasChanges();
    }

    public JPanel getMetadataPanel() {
        return this.metadataEditorControl.getMetadataPanel();
    }

    public void updateMetadata() {
        this.metadataEditorControl.setMetadata(this.base.getMetadata(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.updateContent();
    }

    protected void initComponents() {
        this.editorPanel = new JPanel();
        GroupLayout editorPanelLayout = new GroupLayout(this.editorPanel);
        this.editorPanel.setLayout(editorPanelLayout);
        editorPanelLayout.setHorizontalGroup(editorPanelLayout.createParallelGroup(1).add(editorPanelLayout.createSequentialGroup().addContainerGap().add(this.metadataEditorControl, -1, -1, Short.MAX_VALUE).addContainerGap()));
        editorPanelLayout.setVerticalGroup(editorPanelLayout.createParallelGroup(1).add(editorPanelLayout.createSequentialGroup().addContainerGap().add(this.metadataEditorControl, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

