/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.lists.GroupListCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiGroup;
import org.jdesktop.layout.GroupLayout;

public class GroupListView
extends GUIView
implements ListSelectionListener {
    private static final long serialVersionUID = 3913008821465269712L;
    private JButton createGroupButton;
    private JList groupList;
    private DefaultListModel groupListModel;
    private JScrollPane groupListScrollPane;
    private JButton removeGroupButton;
    private JPanel groupListPanel;
    private HiGroup importGroup;
    private HiGroup trashGroup;
    private Vector<HiGroup> groups;
    private JPopupMenu popupMenu;
    private JMenuItem titleItem;
    private JMenuItem createGroupMenuItem;
    private JMenuItem removeGroupMenuItem;

    public GroupListView(HiGroup importGroup, HiGroup trashGroup, String defaultLang) {
        super(new Color(33, 73, 138));
        this.importGroup = importGroup;
        this.trashGroup = trashGroup;
        this.groups = new Vector();
        this.initComponents();
        this.updateLanguage();
        this.groupList.setCellRenderer(new GroupListCellRenderer(importGroup, trashGroup, defaultLang));
        this.groupList.setDragEnabled(true);
        this.groupList.setDropMode(DropMode.ON_OR_INSERT);
        this.groupList.addListSelectionListener(this);
        this.setGroups();
        this.setDisplayPanel(this.groupListPanel);
    }

    @Override
    public void updateContent() {
        this.groupList.repaint();
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("GroupListView.0"));
        this.createGroupButton.setToolTipText(Messages.getString("GroupListView.1"));
        this.removeGroupButton.setToolTipText(Messages.getString("GroupListView.2"));
        this.titleItem.setText(Messages.getString("GroupListView.3"));
        this.createGroupMenuItem.setText(Messages.getString("GroupListView.4"));
        this.removeGroupMenuItem.setText(Messages.getString("GroupListView.5"));
    }

    public void setGroups(List<HiGroup> groups) {
        this.groups.removeAllElements();
        for (HiGroup group : groups) {
            this.groups.addElement(group);
        }
        this.setGroups();
    }

    public void resetAllGroups(HiGroup importGroup, HiGroup trashGroup, List<HiGroup> groups) {
        this.importGroup = importGroup;
        this.trashGroup = trashGroup;
        ((GroupListCellRenderer)this.groupList.getCellRenderer()).resetGroups(importGroup, trashGroup);
        this.setGroups(groups);
        this.groupList.setSelectedIndex(0);
    }

    private void setGroups() {
        ListSelectionListener[] listeners;
        int selectedIndex = -1;
        HiGroup selGroup = null;
        if (this.groupListModel.size() > 0 && (selectedIndex = this.groupList.getSelectedIndex()) >= 0) {
            selGroup = (HiGroup)this.groupListModel.get(selectedIndex);
        }
        ListSelectionListener[] listSelectionListenerArray = listeners = (ListSelectionListener[])this.groupList.getListeners(ListSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ListSelectionListener listener = listSelectionListenerArray[n2];
            this.groupList.removeListSelectionListener(listener);
            ++n2;
        }
        this.groupListModel.removeAllElements();
        this.groupListModel.addElement(this.importGroup);
        for (HiGroup group : this.groups) {
            this.groupListModel.addElement(group);
        }
        if (System.getProperty("HI.feature.trashDisabled") == null) {
            this.groupListModel.addElement(this.trashGroup);
        }
        if (selectedIndex >= 0) {
            int i = 0;
            while (i < this.groupListModel.size()) {
                if (((HiGroup)this.groupListModel.get(i)).getId() == selGroup.getId()) {
                    selectedIndex = i;
                }
                ++i;
            }
        }
        this.groupList.setSelectedIndex(-1);
        listSelectionListenerArray = listeners;
        n = listeners.length;
        int n3 = 0;
        while (n3 < n) {
            ListSelectionListener listener = listSelectionListenerArray[n3];
            this.groupList.addListSelectionListener(listener);
            ++n3;
        }
        if (selectedIndex >= 0 && selectedIndex < this.groupListModel.size()) {
            this.groupList.setSelectedIndex(selectedIndex);
        } else {
            this.groupList.setSelectedIndex(0);
        }
        if (this.groupList.getSelectedIndex() == 0 || this.groupList.getSelectedIndex() == this.groupListModel.size() - 1) {
            this.removeGroupButton.setEnabled(false);
        } else {
            this.removeGroupButton.setEnabled(true);
        }
    }

    public JList getList() {
        return this.groupList;
    }

    private void initComponents() {
        this.groupListPanel = new JPanel();
        this.createGroupButton = new JButton();
        this.removeGroupButton = new JButton();
        this.groupListScrollPane = new JScrollPane();
        this.groupList = new JList();
        this.groupListModel = new DefaultListModel();
        this.groupList.setModel(this.groupListModel);
        this.groupList.setSelectionMode(0);
        this.createGroupButton.setBorder(BorderFactory.createEmptyBorder());
        this.createGroupButton.setPreferredSize(new Dimension(24, 24));
        this.removeGroupButton.setBorder(BorderFactory.createEmptyBorder());
        this.removeGroupButton.setOpaque(true);
        this.removeGroupButton.setPreferredSize(new Dimension(24, 24));
        this.groupListScrollPane.setViewportView(this.groupList);
        GroupLayout groupListPanelLayout = new GroupLayout(this.groupListPanel);
        this.groupListPanel.setLayout(groupListPanelLayout);
        groupListPanelLayout.setHorizontalGroup(groupListPanelLayout.createParallelGroup(1).add(groupListPanelLayout.createSequentialGroup().addContainerGap().add(groupListPanelLayout.createParallelGroup(1).add(groupListPanelLayout.createSequentialGroup().add(this.createGroupButton, -2, -1, -2).addPreferredGap(0).add(this.removeGroupButton, -2, -1, -2)).add(2, this.groupListScrollPane, -1, 166, Short.MAX_VALUE)).addContainerGap()));
        groupListPanelLayout.setVerticalGroup(groupListPanelLayout.createParallelGroup(1).add(2, groupListPanelLayout.createSequentialGroup().addContainerGap().add(this.groupListScrollPane, -1, 229, Short.MAX_VALUE).addPreferredGap(0).add(groupListPanelLayout.createParallelGroup(3).add(this.createGroupButton, -2, -1, -2).add(this.removeGroupButton, -2, -1, -2)).addContainerGap()));
        this.createGroupButton.setActionCommand("create");
        this.createGroupButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add.png")));
        this.createGroupButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-active.png")));
        this.createGroupButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-disabled.png")));
        this.removeGroupButton.setActionCommand("remove");
        this.removeGroupButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove.png")));
        this.removeGroupButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-active.png")));
        this.removeGroupButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-disabled.png")));
        this.popupMenu = new JPopupMenu();
        this.titleItem = new JMenuItem();
        this.titleItem.setEnabled(false);
        this.popupMenu.add(this.titleItem);
        this.popupMenu.add(new JSeparator());
        this.createGroupMenuItem = new JMenuItem();
        this.createGroupMenuItem.setActionCommand("create");
        this.popupMenu.add(this.createGroupMenuItem);
        this.createGroupMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/create-menu.png")));
        this.removeGroupMenuItem = new JMenuItem();
        this.removeGroupMenuItem.setActionCommand("remove");
        this.popupMenu.add(this.removeGroupMenuItem);
    }

    public HiGroup getCurrentGroup() {
        if (this.groupList.getSelectedIndex() == -1) {
            return null;
        }
        if (this.groupList.getSelectedIndex() == 0) {
            return this.importGroup;
        }
        if (this.groupList.getSelectedIndex() == this.groupListModel.size() - 1) {
            return this.trashGroup;
        }
        return (HiGroup)this.groupListModel.get(this.groupList.getSelectedIndex());
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void showPopupMenu(int x, int y) {
        this.popupMenu.show(this, x, y + 10);
    }

    public void attachActionListeners(ActionListener listener) {
        this.createGroupButton.addActionListener(listener);
        this.removeGroupButton.addActionListener(listener);
        this.createGroupMenuItem.addActionListener(listener);
        this.removeGroupMenuItem.addActionListener(listener);
    }

    public HiGroup getGroup(int index) {
        return (HiGroup)this.groupListModel.get(index);
    }

    public HiGroup getGroup(HiGroup refGroup) {
        HiGroup foundGroup = refGroup;
        int i = 0;
        while (i < this.groupListModel.getSize()) {
            if (((HiGroup)this.groupListModel.get(i)).getId() == refGroup.getId()) {
                foundGroup = (HiGroup)this.groupListModel.get(i);
            }
            ++i;
        }
        return foundGroup;
    }

    public void setSelectedGroup(HiGroup group) {
        int i = 0;
        while (i < this.groupListModel.getSize()) {
            if (((HiGroup)this.groupListModel.get(i)).getId() == group.getId()) {
                this.groupList.setSelectedIndex(i);
            }
            ++i;
        }
    }

    public void updateGroup(HiGroup group) {
        int i = 0;
        while (i < this.groupListModel.size()) {
            if (((HiGroup)this.groupListModel.getElementAt(i)).getId() == group.getId()) {
                this.groupListModel.setElementAt(group, i);
            }
            ++i;
        }
        this.updateContent();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.groupList.getSelectedIndex() == 0 || this.groupList.getSelectedIndex() == this.groupListModel.size() - 1) {
            this.removeGroupButton.setEnabled(false);
            this.removeGroupMenuItem.setEnabled(false);
        } else {
            this.removeGroupButton.setEnabled(true);
            this.removeGroupMenuItem.setEnabled(true);
        }
    }
}

