/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.MetadataEditorControl;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;
import org.jdesktop.layout.GroupLayout;

public class GroupPropertyEditorView
extends GUIView
implements ItemListener {
    private static final long serialVersionUID = -2280958055442791286L;
    private HiGroup group = null;
    private JPanel editorPanel;
    private JCheckBox groupVisibleCheckBox;
    private MetadataEditorControl metadataEditorControl;
    private JPanel propertiesPanel;
    private TitledBorder propertiesBorder;
    private boolean propertyChanged = false;

    public GroupPropertyEditorView() {
        super(new Color(33, 73, 138));
        this.initComponents();
        this.updateLanguage();
        this.setDisplayPanel(this.editorPanel);
    }

    @Override
    public void updateContent() {
        if (this.group != null) {
            this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(this.group.getTimestamp()));
        }
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("GroupPropertyEditorView.0"));
        this.propertiesBorder.setTitle(Messages.getString("GroupPropertyEditorView.9"));
        this.propertiesPanel.repaint();
        this.metadataEditorControl.setIdLabel(Messages.getString("GroupPropertyEditorView.1"));
        this.metadataEditorControl.updateLanguage(Messages.getString("GroupPropertyEditorView.6"), null, Messages.getString("GroupPropertyEditorView.8"));
        if (this.group != null) {
            if (this.group.getType() == GroupTypes.HIGROUP_REGULAR) {
                this.metadataEditorControl.setEmptyText(String.valueOf(Messages.getString("GroupPropertyEditorView.2")) + " (G" + this.group.getId() + ")");
            } else {
                this.metadataEditorControl.setEmptyText("");
            }
            if (this.group.getType() == GroupTypes.HIGROUP_IMPORT) {
                this.metadataEditorControl.setIdLabel(Messages.getString("GroupPropertyEditorView.3"));
            } else if (this.group.getType() == GroupTypes.HIGROUP_TRASH) {
                this.metadataEditorControl.setIdLabel(Messages.getString("GroupPropertyEditorView.4"));
            } else if (this.group.getUUID() == null) {
                this.metadataEditorControl.setIdLabel("G" + this.group.getId());
            } else {
                this.metadataEditorControl.setIdLabel(this.group.getUUID());
            }
            this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(this.group.getTimestamp()));
        }
        this.groupVisibleCheckBox.setText(Messages.getString("GroupPropertyEditorView.11"));
    }

    public List<HiFlexMetadataRecord> getMetadata() {
        return this.metadataEditorControl.getMetadata();
    }

    public JButton getSaveButton() {
        return this.metadataEditorControl.getSaveButton();
    }

    public JButton getResetButton() {
        return this.metadataEditorControl.getResetButton();
    }

    public void setGroup(HiGroup group, String defLang) {
        this.group = group;
        if (group != null) {
            this.groupVisibleCheckBox.removeItemListener(this);
            if (group.getType() == GroupTypes.HIGROUP_REGULAR) {
                this.metadataEditorControl.setBaseID(group.getId());
                if (group.getUUID() == null) {
                    this.metadataEditorControl.setIdLabel("G" + group.getId());
                } else {
                    this.metadataEditorControl.setIdLabel(group.getUUID());
                }
                this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(group.getTimestamp()));
                this.groupVisibleCheckBox.setSelected(group.isVisible());
                this.groupVisibleCheckBox.setEnabled(true);
                this.metadataEditorControl.setMetadata(this.group.getMetadata(), defLang);
                if (group.getType() == GroupTypes.HIGROUP_REGULAR) {
                    this.metadataEditorControl.setEmptyText(String.valueOf(Messages.getString("GroupPropertyEditorView.2")) + " (G" + group.getId() + ")");
                } else {
                    this.metadataEditorControl.setEmptyText("");
                }
            } else {
                if (group.getType() == GroupTypes.HIGROUP_IMPORT) {
                    this.metadataEditorControl.setIdLabel(Messages.getString("GroupPropertyEditorView.3"));
                } else {
                    this.metadataEditorControl.setIdLabel(Messages.getString("GroupPropertyEditorView.4"));
                }
                this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(group.getTimestamp()));
                this.groupVisibleCheckBox.setSelected(false);
                this.groupVisibleCheckBox.setEnabled(false);
                this.metadataEditorControl.setMetadata(null, defLang);
            }
            this.propertyChanged = false;
            this.groupVisibleCheckBox.addItemListener(this);
        } else {
            this.metadataEditorControl.setEmptyText("");
        }
    }

    public boolean hasChanges() {
        return this.metadataEditorControl.hasChanges() || this.propertyChanged;
    }

    public boolean hasPropertyChanges() {
        return false;
    }

    public boolean hasMetadataChanges() {
        return this.metadataEditorControl.hasChanges();
    }

    public void syncChanges() {
        this.propertyChanged = false;
        this.metadataEditorControl.syncChanges();
    }

    public void resetChanges() {
        this.propertyChanged = false;
        this.metadataEditorControl.resetChanges();
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.propertiesPanel = new JPanel();
        this.groupVisibleCheckBox = new JCheckBox();
        this.metadataEditorControl = new MetadataEditorControl("title", Messages.getString("GroupPropertyEditorView.6"), null, null, "comment", Messages.getString("GroupPropertyEditorView.8"));
        this.propertiesBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("GroupPropertyEditorView.9"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.propertiesPanel.setBorder(this.propertiesBorder);
        GroupLayout propertiesPanelLayout = new GroupLayout(this.propertiesPanel);
        this.propertiesPanel.setLayout(propertiesPanelLayout);
        propertiesPanelLayout.setHorizontalGroup(propertiesPanelLayout.createParallelGroup(1).add(propertiesPanelLayout.createSequentialGroup().addContainerGap().add(this.groupVisibleCheckBox).addContainerGap(236, Short.MAX_VALUE)));
        propertiesPanelLayout.setVerticalGroup(propertiesPanelLayout.createParallelGroup(1).add(this.groupVisibleCheckBox));
        this.propertiesPanel.setVisible(false);
        GroupLayout editorPanelLayout = new GroupLayout(this.editorPanel);
        this.editorPanel.setLayout(editorPanelLayout);
        editorPanelLayout.setHorizontalGroup(editorPanelLayout.createParallelGroup(1).add(2, editorPanelLayout.createSequentialGroup().addContainerGap().add(editorPanelLayout.createParallelGroup(2).add(1, this.metadataEditorControl, -1, -1, Short.MAX_VALUE).add(1, this.propertiesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        editorPanelLayout.setVerticalGroup(editorPanelLayout.createParallelGroup(1).add(editorPanelLayout.createSequentialGroup().addContainerGap().add(this.propertiesPanel, -2, -1, -2).addPreferredGap(0).add(this.metadataEditorControl, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.groupVisibleCheckBox.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.propertyChanged = this.groupVisibleCheckBox.isSelected() ^ this.group.isVisible();
    }

    public void setTagCount(long count) {
        this.metadataEditorControl.setTagCount(count);
    }
}

