/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.lists.LayerListCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.model.HILayer;
import org.jdesktop.layout.GroupLayout;

public class LayerListView
extends GUIView {
    private static final long serialVersionUID = 4440600497916240667L;
    private JButton createLayerButton;
    private JList layerList;
    private DefaultListModel layerListModel;
    private JScrollPane layerListScroll;
    private JPanel listPanel;
    private JButton removeLayerButton;
    private JMenuItem titleItem;
    private JPopupMenu popupMenu;
    private JMenuItem createLayerMenuItem;
    private JMenuItem removeLayerMenuItem;
    private Vector<HILayer> layers;
    private String defLang;

    public LayerListView(Vector<HILayer> layers, String defLang) {
        super(new Color(145, 185, 250));
        this.layers = layers;
        this.defLang = defLang;
        this.initComponents();
        this.updateLanguage();
        for (HILayer layer : layers) {
            this.layerListModel.addElement(layer);
        }
        if (layers.size() > 0) {
            this.layerList.setSelectedIndex(0);
        }
        this.layerList.setDragEnabled(true);
        this.layerList.setDropMode(DropMode.INSERT);
        this.setDisplayPanel(this.listPanel);
    }

    @Override
    public void updateLanguage() {
        this.setTitle(Messages.getString("LayerListView.0"));
        this.createLayerMenuItem.setText(Messages.getString("LayerListView.1"));
        this.removeLayerMenuItem.setText(Messages.getString("LayerListView.2"));
        this.createLayerButton.setToolTipText(Messages.getString("LayerListView.3"));
        this.removeLayerButton.setToolTipText(Messages.getString("LayerListView.4"));
        this.titleItem.setText(Messages.getString("LayerListView.5"));
    }

    public String getSortOrder() {
        String sortOrder = "";
        for (HILayer layer : this.layers) {
            sortOrder = String.valueOf(sortOrder) + "," + layer.getModel().getId();
        }
        if (sortOrder.length() > 0) {
            sortOrder = sortOrder.substring(1);
        }
        return sortOrder;
    }

    public void updateLayerList() {
        int oldIndex = this.layerList.getSelectedIndex();
        this.layerListModel.removeAllElements();
        for (HILayer layer : this.layers) {
            this.layerListModel.addElement(layer);
        }
        if (this.layers.size() > 0) {
            if (oldIndex < this.layerListModel.size()) {
                this.layerList.setSelectedIndex(oldIndex);
            } else {
                this.layerList.setSelectedIndex(this.layers.size() - 1);
            }
        }
        this.removeLayerButton.setEnabled(this.layers.size() > 0);
        this.removeLayerMenuItem.setEnabled(this.layers.size() > 0);
    }

    public JList getLayerList() {
        return this.layerList;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void showPopupMenu(int x, int y) {
        this.popupMenu.show(this, x, y + 10);
    }

    public void attachActionListeners(ActionListener listener) {
        this.createLayerButton.addActionListener(listener);
        this.removeLayerButton.addActionListener(listener);
        this.createLayerMenuItem.addActionListener(listener);
        this.removeLayerMenuItem.addActionListener(listener);
    }

    private void initComponents() {
        this.listPanel = new JPanel();
        this.layerListScroll = new JScrollPane();
        this.layerList = new JList();
        this.createLayerButton = new JButton();
        this.removeLayerButton = new JButton();
        this.layerListScroll.setViewportView(this.layerList);
        this.createLayerButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add.png")));
        this.createLayerButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-active.png")));
        this.createLayerButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-disabled.png")));
        this.createLayerButton.setPreferredSize(new Dimension(24, 24));
        this.removeLayerButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove.png")));
        this.removeLayerButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-active.png")));
        this.removeLayerButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-disabled.png")));
        this.removeLayerButton.setPreferredSize(new Dimension(24, 24));
        GroupLayout listPanelLayout = new GroupLayout(this.listPanel);
        this.listPanel.setLayout(listPanelLayout);
        listPanelLayout.setHorizontalGroup(listPanelLayout.createParallelGroup(1).add(listPanelLayout.createSequentialGroup().addContainerGap().add(listPanelLayout.createParallelGroup(1).add(this.layerListScroll, -1, 164, Short.MAX_VALUE).add(listPanelLayout.createSequentialGroup().add(this.createLayerButton, -2, -1, -2).addPreferredGap(0).add(this.removeLayerButton, -2, -1, -2))).addContainerGap()));
        listPanelLayout.setVerticalGroup(listPanelLayout.createParallelGroup(1).add(2, listPanelLayout.createSequentialGroup().addContainerGap().add(this.layerListScroll, -1, 195, Short.MAX_VALUE).addPreferredGap(0).add(listPanelLayout.createParallelGroup(3).add(this.createLayerButton, -2, -1, -2).add(this.removeLayerButton, -2, -1, -2)).addContainerGap()));
        this.layerListModel = new DefaultListModel();
        this.layerList.setModel(this.layerListModel);
        this.layerList.setCellRenderer(new LayerListCellRenderer(this.defLang));
        this.layerList.setSelectionMode(0);
        this.createLayerButton.setActionCommand("add");
        this.removeLayerButton.setActionCommand("remove");
        this.removeLayerButton.setEnabled(this.layers.size() > 0);
        this.popupMenu = new JPopupMenu();
        this.titleItem = new JMenuItem();
        this.titleItem.setEnabled(false);
        this.popupMenu.add(this.titleItem);
        this.popupMenu.add(new JSeparator());
        this.createLayerMenuItem = new JMenuItem();
        this.createLayerMenuItem.setActionCommand("add");
        this.popupMenu.add(this.createLayerMenuItem);
        this.createLayerMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/create-menu.png")));
        this.removeLayerMenuItem = new JMenuItem();
        this.removeLayerMenuItem.setEnabled(this.layers.size() > 0);
        this.removeLayerMenuItem.setActionCommand("remove");
        this.popupMenu.add(this.removeLayerMenuItem);
    }
}

