/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.PolygonEditorControl;
import org.hyperimage.client.gui.lists.LayerListCellRenderer;
import org.hyperimage.client.gui.lists.PolygonListCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.jdesktop.layout.GroupLayout;

public class LayerPolygonEditorView
extends GUIView
implements ChangeListener,
MouseListener,
MouseWheelListener,
MouseMotionListener,
ActionListener,
KeyListener {
    private static final long serialVersionUID = -8566390743522453070L;
    public String polygonEditorViewCommand = "";
    private JPanel editorPanel;
    private JLabel zoomSliderLabel;
    private JLabel zoomInfoLabel;
    private JLabel minusLabel;
    private JLabel plusLabel;
    private PolygonEditorControl polygonEditorControl;
    private JScrollPane polygonScroll;
    private JSlider zoomSlider;
    private Vector<HILayer> layers;
    private HILayer userSelectedLayer = null;
    private PlanarImage image;
    private Vector<String> projectPolygons;
    private float scale = 1.0f;
    private float minimumScale = 0.25f;
    private int posX = 0;
    private int posY = 0;
    private int popupX = 0;
    private int popupY = 0;
    private JMenu newPolygonMenu;
    private JMenuItem layerIDMenuItem;
    private JMenuItem switchToPolygonLayerMenuItem;
    private JMenuItem deletePolygonItem;
    private JMenuItem toFreeDesignItem;
    private JCheckBoxMenuItem openPolygonPathItem;
    private JMenuItem copyToClipboardItem;
    private JMenuItem pasteFromClipboardItem;
    private JMenuItem addToLibraryItem;
    private JMenuItem discardLayerPolygonChanges;
    private JMenuItem discardAllPolygonChanges;
    private JMenuItem newLayerItem;
    private JToggleButton isolationModeButton;
    private JPanel toolButtonsPanel;
    private JToggleButton polygonButton;
    private JToggleButton rectangleButton;
    private JToggleButton circleButton;
    private JToggleButton flowingFreeformButton;
    private JToggleButton arrowButton;

    public LayerPolygonEditorView(Vector<HILayer> layers, PlanarImage image, Vector<String> projectPolygons) {
        super(new Color(145, 185, 250));
        this.layers = layers;
        this.image = image;
        this.projectPolygons = projectPolygons;
        this.initComponents();
        this.updateLanguage();
        this.updateMenuOptions();
        this.setDisplayPanel(this.editorPanel);
        int max = Math.max(image.getWidth(), image.getHeight());
        this.minimumScale = 400.0f / (float)max;
        float unit = (2.0f - this.minimumScale) / 100.0f;
        this.zoomSlider.setValue((int)((1.0f - this.minimumScale) / unit));
        this.populatePopupMenu();
        this.zoomSlider.addChangeListener(this);
        this.polygonEditorControl.addMouseWheelListener(this);
        this.polygonEditorControl.addMouseListener(this);
        this.polygonEditorControl.addMouseMotionListener(this);
        this.isolationModeButton.addActionListener(this);
        this.polygonButton.addActionListener(this);
        this.flowingFreeformButton.addActionListener(this);
        this.rectangleButton.addActionListener(this);
        this.circleButton.addActionListener(this);
        this.arrowButton.addActionListener(this);
        this.deletePolygonItem.addActionListener(this);
        this.toFreeDesignItem.addActionListener(this);
        this.openPolygonPathItem.addActionListener(this);
        this.copyToClipboardItem.addActionListener(this);
        this.pasteFromClipboardItem.addActionListener(this);
        this.discardLayerPolygonChanges.addActionListener(this);
        this.discardAllPolygonChanges.addActionListener(this);
        this.addKeyListener(this);
    }

    public void setFocus() {
        this.setFocusable(true);
        this.requestFocus();
        this.requestFocusInWindow();
    }

    @Override
    public void updateLanguage() {
        this.setTitle(Messages.getString("LayerPolygonEditorView.0"));
        this.layerIDMenuItem.setText(String.valueOf(Messages.getString("LayerPolygonEditorView.1")) + ": ");
        this.zoomSliderLabel.setText(Messages.getString("LayerPolygonEditorView.3"));
        this.zoomInfoLabel.setText(String.valueOf((int)(this.scale * 100.0f)) + " %");
        this.newPolygonMenu.setText(Messages.getString("LayerPolygonEditorView.5"));
        this.deletePolygonItem.setText(Messages.getString("LayerPolygonEditorView.6"));
        this.toFreeDesignItem.setText(Messages.getString("LayerPolygonEditorView.7"));
        this.openPolygonPathItem.setText(Messages.getString("LayerPolygonEditorView.8"));
        this.pasteFromClipboardItem.setText(Messages.getString("LayerPolygonEditorView.9"));
        this.addToLibraryItem.setText(Messages.getString("LayerPolygonEditorView.10"));
        this.discardLayerPolygonChanges.setText(Messages.getString("LayerPolygonEditorView.11"));
        this.discardAllPolygonChanges.setText(Messages.getString("LayerPolygonEditorView.12"));
        this.newLayerItem.setText(Messages.getString("LayerPolygonEditorView.13"));
        this.isolationModeButton.setToolTipText(Messages.getString("LayerPolygonEditorView.isolationModeIcon"));
        this.rectangleButton.setToolTipText(Messages.getString("LayerPolygonEditorView.boxIcon"));
        this.circleButton.setToolTipText(Messages.getString("LayerPolygonEditorView.circleIcon"));
        this.arrowButton.setToolTipText(Messages.getString("LayerPolygonEditorView.arrowIcon"));
        this.polygonButton.setToolTipText(Messages.getString("LayerPolygonEditorView.freeformIcon"));
        this.flowingFreeformButton.setToolTipText(Messages.getString("LayerPolygonEditorView.freehandIcon"));
    }

    public int getScaleX() {
        return this.image.getWidth();
    }

    public int getScaleY() {
        return this.image.getHeight();
    }

    public void repaintShapes() {
        this.polygonEditorControl.repaintShapes();
    }

    public void updateScale() {
        this.polygonEditorControl.updateScale();
    }

    public void setUserSelectedLayer(HILayer layer) {
        this.userSelectedLayer = layer;
        if (layer != null) {
            this.polygonEditorControl.setUserSelectedLayer(layer);
        }
    }

    public void addFreeFormPolygon(HILayer layer) {
        if (layer != null) {
            this.polygonEditorControl.addFreeFormPolygon(layer, this.posX, this.posY);
        }
        this.polygonEditorControl.setPlaceFirstAnchorMode(false);
        this.polygonEditorViewCommand = "";
    }

    public void addFreePolygon(HILayer layer) {
        if (layer != null) {
            this.polygonEditorControl.addFreePolygon(layer, this.posX, this.posY);
        }
        this.polygonEditorControl.setPlaceFirstAnchorMode(false);
        this.polygonEditorViewCommand = "";
    }

    public void addRectanglePolygon(HILayer layer) {
        if (layer != null) {
            this.polygonEditorControl.addRectanglePolygon(layer, this.posX, this.posY);
        }
        this.polygonEditorControl.setPlaceFirstAnchorMode(false);
        this.polygonEditorViewCommand = "";
        this.updateToolbarButtons();
    }

    public void addCirclePolygon(HILayer layer) {
        if (layer != null) {
            this.polygonEditorControl.addCirclePolygon(layer, this.posX, this.posY);
        }
        this.polygonEditorControl.setPlaceFirstAnchorMode(false);
        this.polygonEditorViewCommand = "";
        this.updateToolbarButtons();
    }

    public void addArrowPolygon(HILayer layer) {
        this.polygonEditorControl.setPlaceFirstAnchorMode(false);
        if (layer != null) {
            this.polygonEditorControl.addArrowPolygon(layer, this.posX, this.posY);
        }
        this.polygonEditorViewCommand = "";
        this.updateToolbarButtons();
    }

    public void addLibraryPolygon(HILayer layer, String model) {
        if (layer != null) {
            this.polygonEditorControl.addLibraryPolygon(layer, model, this.posX, this.posY);
        }
    }

    public JMenuItem getSwitchToPolygonLayerItem() {
        return this.switchToPolygonLayerMenuItem;
    }

    public HILayer getActiveLayer() {
        HILayer polygonLayer = null;
        for (HILayer layer : this.layers) {
            if (!layer.getRelativePolygons().contains(this.polygonEditorControl.getActivePolygon())) continue;
            polygonLayer = layer;
        }
        return polygonLayer;
    }

    public HILayer getSelectedLayer() {
        return this.polygonEditorControl.getSelectedLayer();
    }

    public RelativePolygon getSelectedPolygon() {
        return this.polygonEditorControl.getSelectedPolygon();
    }

    public void setPlaceFirstAnchorMode(boolean mode) {
        this.polygonEditorControl.setPlaceFirstAnchorMode(mode);
        this.cleanupPolygons();
    }

    public void cleanupPolygons() {
        this.polygonEditorControl.closeAndCleanupPolygons();
        this.polygonEditorControl.repaint();
    }

    public void updateToolbarButtons() {
        this.polygonButton.removeActionListener(this);
        this.flowingFreeformButton.removeActionListener(this);
        this.rectangleButton.removeActionListener(this);
        this.circleButton.removeActionListener(this);
        this.arrowButton.removeActionListener(this);
        this.polygonButton.setSelected(this.polygonEditorViewCommand.startsWith("add_freeform"));
        this.flowingFreeformButton.setSelected(this.polygonEditorViewCommand.equalsIgnoreCase("add_free"));
        this.rectangleButton.setSelected(this.polygonEditorViewCommand.equalsIgnoreCase("add_rectangle"));
        this.circleButton.setSelected(this.polygonEditorViewCommand.equalsIgnoreCase("add_circle"));
        this.arrowButton.setSelected(this.polygonEditorViewCommand.equalsIgnoreCase("add_arrow"));
        this.polygonButton.addActionListener(this);
        this.flowingFreeformButton.addActionListener(this);
        this.rectangleButton.addActionListener(this);
        this.circleButton.addActionListener(this);
        this.arrowButton.addActionListener(this);
    }

    public void regenerateNewPolygonMenu(ActionListener listener) {
        while (this.newPolygonMenu.getActionListeners().length > 0) {
            this.newPolygonMenu.removeActionListener(this.newPolygonMenu.getActionListeners()[0]);
        }
        this.newPolygonMenu.removeAll();
        this.polygonButton.removeActionListener(listener);
        this.flowingFreeformButton.removeActionListener(listener);
        this.rectangleButton.removeActionListener(listener);
        this.circleButton.removeActionListener(listener);
        this.arrowButton.removeActionListener(listener);
        this.polygonButton.addActionListener(listener);
        this.flowingFreeformButton.addActionListener(listener);
        this.rectangleButton.addActionListener(listener);
        this.circleButton.addActionListener(listener);
        this.arrowButton.addActionListener(listener);
        JMenuItem item = new JMenuItem(Messages.getString("LayerPolygonEditorView.19"));
        item.setActionCommand("ADD_FREEFORM");
        item.addActionListener(listener);
        this.newPolygonMenu.add(item);
        item = new JMenuItem(Messages.getString("LayerPolygonEditorView.21"));
        item.setActionCommand("ADD_RECTANGLE");
        item.addActionListener(listener);
        this.newPolygonMenu.add(item);
        item = new JMenuItem(Messages.getString("LayerPolygonEditorView.circle"));
        item.setActionCommand("ADD_CIRCLE");
        item.addActionListener(listener);
        this.newPolygonMenu.add(item);
        item = new JMenuItem(Messages.getString("LayerPolygonEditorView.arrow"));
        item.setActionCommand("ADD_ARROW");
        item.addActionListener(listener);
        this.newPolygonMenu.add(item);
        item = new JMenuItem(Messages.getString("LayerPolygonEditorView.freehand"));
        item.setActionCommand("ADD_FREE");
        item.addActionListener(listener);
        this.newPolygonMenu.add(item);
        this.newPolygonMenu.add(new JSeparator());
        int i = 0;
        while (i < this.projectPolygons.size()) {
            item = new JMenuItem(Integer.toString(i + 1));
            item.setActionCommand("ADD_LIB_" + i);
            item.addActionListener(listener);
            item.setIcon(PolygonListCellRenderer.renderPolygonIcon(this.projectPolygons.get(i), Color.GRAY));
            this.newPolygonMenu.add(item);
            ++i;
        }
        if (this.projectPolygons.size() == 0) {
            item = new JMenuItem(Messages.getString("LayerPolygonEditorView.24"));
            item.setEnabled(false);
            this.newPolygonMenu.add(item);
        }
    }

    public JMenuItem getAddToLibraryItem() {
        return this.addToLibraryItem;
    }

    public JMenuItem getAddLayerItem() {
        return this.newLayerItem;
    }

    public void updateMenuOptions() {
        this.populatePopupMenu();
        this.isolationModeButton.setEnabled(this.layers.size() > 0);
        if (!this.isolationModeButton.isEnabled()) {
            this.isolationModeButton.setSelected(false);
        }
    }

    private void populatePopupMenu() {
        JPopupMenu popupMenu = this.polygonEditorControl.getPopupMenu();
        popupMenu.removeAll();
        if (this.layers.size() > 0) {
            popupMenu.add(this.layerIDMenuItem);
            popupMenu.add(this.switchToPolygonLayerMenuItem);
            popupMenu.add(new JSeparator());
            popupMenu.add(this.newPolygonMenu);
            popupMenu.add(this.toFreeDesignItem);
            popupMenu.add(this.openPolygonPathItem);
            popupMenu.add(new JSeparator());
            popupMenu.add(this.copyToClipboardItem);
            popupMenu.add(this.pasteFromClipboardItem);
            popupMenu.add(new JSeparator());
            popupMenu.add(this.addToLibraryItem);
            popupMenu.add(new JSeparator());
            popupMenu.add(this.discardLayerPolygonChanges);
            popupMenu.add(this.discardAllPolygonChanges);
            popupMenu.add(new JSeparator());
            popupMenu.add(this.deletePolygonItem);
        } else {
            JMenuItem item = new JMenuItem(Messages.getString("LayerPolygonEditorView.25"));
            item.setEnabled(false);
            popupMenu.add(item);
            popupMenu.add(new JSeparator());
            popupMenu.add(this.newLayerItem);
        }
    }

    private void setPopupMenuState() {
        ImageIcon icon = null;
        this.addToLibraryItem.setEnabled(false);
        if (this.layers.size() > 0) {
            this.pasteFromClipboardItem.setEnabled(!HIRuntime.isClipboardEmpty());
            icon = LayerListCellRenderer.renderColorBarIcon(this.userSelectedLayer.getSolidColour());
            this.newPolygonMenu.setIcon(icon);
            if (this.userSelectedLayer != null) {
                String title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)this.userSelectedLayer.getModel(), HIRuntime.getManager().getProject().getDefaultLanguage()));
                if (title == null || title.length() == 0) {
                    title = this.userSelectedLayer.getModel().getUUID() == null ? "L" + this.userSelectedLayer.getModel().getId() : this.userSelectedLayer.getModel().getUUID();
                }
                this.layerIDMenuItem.setText(String.valueOf(Messages.getString("LayerPolygonEditorView.2")) + ": " + title);
            }
            this.switchToPolygonLayerMenuItem.setEnabled(false);
            HILayer selectedLayer = this.getActiveLayer();
            if (selectedLayer == null) {
                this.switchToPolygonLayerMenuItem.setText(Messages.getString("LayerPolygonEditorView.14"));
            } else {
                String layerTitle;
                if (this.userSelectedLayer != null && selectedLayer.getModel().getId() != this.userSelectedLayer.getModel().getId()) {
                    this.switchToPolygonLayerMenuItem.setEnabled(true);
                }
                if ((layerTitle = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)selectedLayer.getModel(), HIRuntime.getManager().getProject().getDefaultLanguage()))) == null || layerTitle.length() == 0) {
                    layerTitle = "L" + selectedLayer.getModel().getId();
                }
                this.switchToPolygonLayerMenuItem.setText(String.valueOf(Messages.getString("LayerPolygonEditorView.18")) + " \"" + layerTitle + "\" " + Messages.getString("LayerPolygonEditorView.23"));
            }
            if (this.polygonEditorControl.getActivePolygon() == null) {
                this.switchToPolygonLayerMenuItem.setEnabled(false);
                this.deletePolygonItem.setEnabled(false);
                this.toFreeDesignItem.setEnabled(false);
                this.toFreeDesignItem.setVisible(false);
                this.openPolygonPathItem.setEnabled(false);
                this.openPolygonPathItem.setVisible(false);
                this.openPolygonPathItem.setSelected(false);
                this.copyToClipboardItem.setEnabled(false);
            } else {
                this.copyToClipboardItem.setEnabled(true);
                this.deletePolygonItem.setEnabled(true);
                if (this.polygonEditorControl.getActivePolygon().getType() == RelativePolygon.HiPolygonTypes.HI_FREEDESIGN || this.polygonEditorControl.getActivePolygon().getType() == RelativePolygon.HiPolygonTypes.HI_FREEHAND) {
                    this.addToLibraryItem.setEnabled(HIRuntime.getGui().checkEditAbility(true));
                    this.openPolygonPathItem.setEnabled(true);
                    this.openPolygonPathItem.setVisible(true);
                    this.toFreeDesignItem.setEnabled(false);
                    this.toFreeDesignItem.setVisible(false);
                } else {
                    this.openPolygonPathItem.setEnabled(false);
                    this.openPolygonPathItem.setVisible(false);
                    this.toFreeDesignItem.setEnabled(true);
                    this.toFreeDesignItem.setVisible(true);
                }
                if (this.polygonEditorControl.getActivePolygon().isClosed()) {
                    this.openPolygonPathItem.setSelected(false);
                } else {
                    this.openPolygonPathItem.setSelected(true);
                }
            }
            this.discardLayerPolygonChanges.setIcon(icon);
        }
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.polygonEditorControl = new PolygonEditorControl(this.image, this.layers);
        this.polygonEditorControl.view = this;
        this.polygonScroll = new JScrollPane(this.polygonEditorControl);
        this.polygonScroll.setPreferredSize(new Dimension(400, 400));
        this.zoomSliderLabel = new JLabel();
        this.zoomSlider = new JSlider();
        this.zoomInfoLabel = new JLabel();
        this.minusLabel = new JLabel();
        this.plusLabel = new JLabel();
        this.zoomSlider.setSnapToTicks(true);
        this.zoomSlider.setPaintTicks(false);
        this.zoomSlider.setPaintLabels(false);
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setMinimum(1);
        this.zoomSlider.setMaximum(100);
        this.isolationModeButton = new JToggleButton();
        this.isolationModeButton.setBorder(BorderFactory.createEmptyBorder());
        this.isolationModeButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/isolationmode-icon.png")));
        this.isolationModeButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/isolationmode-icon-active.png")));
        this.isolationModeButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/isolationmode-icon-disabled.png")));
        this.isolationModeButton.setPreferredSize(new Dimension(24, 24));
        this.toolButtonsPanel = new JPanel();
        this.polygonButton = new JToggleButton();
        this.polygonButton.setBorder(BorderFactory.createEmptyBorder());
        this.polygonButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/layerEditor.png")));
        this.polygonButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/layerEditor-active.png")));
        this.polygonButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/layerEditor-disabled.png")));
        this.polygonButton.setPreferredSize(new Dimension(24, 24));
        this.polygonButton.setActionCommand("ADD_FREEFORM");
        this.flowingFreeformButton = new JToggleButton();
        this.flowingFreeformButton.setBorder(BorderFactory.createEmptyBorder());
        this.flowingFreeformButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/freeform-icon.png")));
        this.flowingFreeformButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/freeform-icon-active.png")));
        this.flowingFreeformButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/freeform-icon-disabled.png")));
        this.flowingFreeformButton.setPreferredSize(new Dimension(24, 24));
        this.flowingFreeformButton.setActionCommand("ADD_FREE");
        this.rectangleButton = new JToggleButton();
        this.rectangleButton.setBorder(BorderFactory.createEmptyBorder());
        this.rectangleButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/box-icon.png")));
        this.rectangleButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/box-icon-active.png")));
        this.rectangleButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/box-icon-disabled.png")));
        this.rectangleButton.setPreferredSize(new Dimension(24, 24));
        this.rectangleButton.setActionCommand("ADD_RECTANGLE");
        this.circleButton = new JToggleButton();
        this.circleButton.setBorder(BorderFactory.createEmptyBorder());
        this.circleButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/circle-icon.png")));
        this.circleButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/circle-icon-active.png")));
        this.circleButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/circle-icon-disabled.png")));
        this.circleButton.setPreferredSize(new Dimension(24, 24));
        this.circleButton.setActionCommand("ADD_CIRCLE");
        this.arrowButton = new JToggleButton();
        this.arrowButton.setBorder(BorderFactory.createEmptyBorder());
        this.arrowButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/arrow-icon.png")));
        this.arrowButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/arrow-icon-active.png")));
        this.arrowButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/arrow-icon-disabled.png")));
        this.arrowButton.setPreferredSize(new Dimension(24, 24));
        this.arrowButton.setActionCommand("ADD_ARROW");
        this.zoomSliderLabel.setLabelFor(this.zoomSlider);
        this.minusLabel.setHorizontalAlignment(0);
        this.minusLabel.setText("-");
        this.minusLabel.setPreferredSize(new Dimension(24, 12));
        this.plusLabel.setHorizontalAlignment(0);
        this.plusLabel.setText("+");
        this.plusLabel.setPreferredSize(new Dimension(24, 12));
        GroupLayout toolButtonsPanelLayout = new GroupLayout(this.toolButtonsPanel);
        this.toolButtonsPanel.setLayout(toolButtonsPanelLayout);
        toolButtonsPanelLayout.setHorizontalGroup(toolButtonsPanelLayout.createParallelGroup(1).add(toolButtonsPanelLayout.createParallelGroup(2, false).add(1, this.zoomSlider, -2, 0, Short.MAX_VALUE).add(1, this.polygonButton, -1, -1, Short.MAX_VALUE).add(1, this.flowingFreeformButton, -1, -1, Short.MAX_VALUE).add(1, this.rectangleButton, -1, -1, Short.MAX_VALUE).add(1, this.circleButton, -1, -1, Short.MAX_VALUE).add(1, this.arrowButton, -1, -1, Short.MAX_VALUE).add(1, this.isolationModeButton, -1, -1, Short.MAX_VALUE)).add(this.minusLabel, -2, -1, -2).add(this.plusLabel, -2, -1, -2));
        toolButtonsPanelLayout.setVerticalGroup(toolButtonsPanelLayout.createParallelGroup(1).add(toolButtonsPanelLayout.createSequentialGroup().add(this.polygonButton, -2, -1, -2).add(2, 2, 2).add(this.flowingFreeformButton, -2, -1, -2).add(2, 2, 2).add(this.rectangleButton, -2, -1, -2).add(2, 2, 2).add(this.circleButton, -2, -1, -2).add(2, 2, 2).add(this.arrowButton, -2, -1, -2).add(12, 12, 12).add(this.isolationModeButton, -2, -1, -2).add(24, 24, 24).add(this.plusLabel, -2, -1, -2).addPreferredGap(0).add(this.zoomSlider, -2, -1, -2).addPreferredGap(0).add(this.minusLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout editorPanelLayout = new GroupLayout(this.editorPanel);
        this.editorPanel.setLayout(editorPanelLayout);
        editorPanelLayout.setHorizontalGroup(editorPanelLayout.createParallelGroup(1).add(editorPanelLayout.createSequentialGroup().addContainerGap().add(this.toolButtonsPanel, -2, -1, -2).addPreferredGap(0).add(editorPanelLayout.createParallelGroup(1).add(editorPanelLayout.createSequentialGroup().add(this.zoomSliderLabel).addPreferredGap(0).add(this.zoomInfoLabel, -2, 39, -2).add(0, 0, Short.MAX_VALUE)).add(this.polygonScroll, -1, 500, Short.MAX_VALUE)).addContainerGap()));
        editorPanelLayout.setVerticalGroup(editorPanelLayout.createParallelGroup(1).add(2, editorPanelLayout.createSequentialGroup().add(20, 20, 20).add(editorPanelLayout.createParallelGroup(1).add(this.polygonScroll, -2, -1, Short.MAX_VALUE).add(this.toolButtonsPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(editorPanelLayout.createParallelGroup(3).add(this.zoomSliderLabel).add(this.zoomInfoLabel)).add(19, 19, 19)));
        this.newPolygonMenu = new JMenu();
        this.deletePolygonItem = new JMenuItem();
        this.toFreeDesignItem = new JMenuItem();
        this.openPolygonPathItem = new JCheckBoxMenuItem();
        this.pasteFromClipboardItem = new JMenuItem();
        this.addToLibraryItem = new JMenuItem();
        this.discardLayerPolygonChanges = new JMenuItem();
        this.discardAllPolygonChanges = new JMenuItem();
        this.newLayerItem = new JMenuItem();
        this.layerIDMenuItem = new JMenuItem();
        this.layerIDMenuItem.setEnabled(false);
        this.switchToPolygonLayerMenuItem = new JMenuItem();
        this.switchToPolygonLayerMenuItem.setActionCommand("SWITCH_TO_ACTIVE_LAYER");
        this.deletePolygonItem.setActionCommand("DELETE_POLYGON");
        this.toFreeDesignItem.setActionCommand("TO_FREE_DESIGN");
        this.openPolygonPathItem.setActionCommand("OPEN_PATH");
        this.copyToClipboardItem = new JMenuItem(Messages.getString("LayerPolygonEditorView.4"));
        this.copyToClipboardItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/copy-menu.png")));
        this.copyToClipboardItem.setActionCommand("COPY_CLIPBOARD");
        this.pasteFromClipboardItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/paste-menu.png")));
        this.pasteFromClipboardItem.setActionCommand("PASTE_CLIPBOARD");
        this.addToLibraryItem.setActionCommand("TO_LIBRARY");
        this.discardLayerPolygonChanges.setActionCommand("DISCARD_LAYER_POLYGON_CHANGES");
        this.discardAllPolygonChanges.setActionCommand("DISCARD_ALL_POLYGON_CHANGES");
        this.newLayerItem.setActionCommand("add");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value;
        float unit;
        float newScale;
        if (e.getSource() == this.zoomSlider && (newScale = (unit = (2.0f - this.minimumScale) / 100.0f) * (float)(value = this.zoomSlider.getValue()) + this.minimumScale) != this.scale) {
            int centerX = this.polygonScroll.getViewport().getViewPosition().x + this.polygonScroll.getViewport().getSize().width / 2;
            int centerY = this.polygonScroll.getViewport().getViewPosition().y + this.polygonScroll.getViewport().getSize().height / 2;
            centerX = (int)((float)this.image.getWidth() * newScale * (float)centerX / ((float)this.image.getWidth() * this.scale));
            centerY = (int)((float)this.image.getHeight() * newScale * (float)centerY / ((float)this.image.getHeight() * this.scale));
            Point viewPoint = new Point(centerX - this.polygonScroll.getViewport().getSize().width / 2, centerY - this.polygonScroll.getViewport().getSize().height / 2);
            this.zoomInfoLabel.setText(String.valueOf((int)(newScale * 100.0f)) + " %");
            this.scale = newScale;
            this.polygonEditorControl.scaleView(this.scale);
            this.polygonScroll.getViewport().setViewPosition(viewPoint);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setFocus();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setFocus();
        int divX = e.getX() - this.posX;
        int divY = e.getY() - this.posY;
        if (this.polygonEditorViewCommand.length() == 0 && this.polygonEditorControl.getActivePolygon() == null && !this.polygonEditorControl.isResizing()) {
            this.polygonScroll.getViewport().setViewPosition(new Point(Math.min(this.polygonEditorControl.getWidth() - this.polygonScroll.getViewport().getWidth(), Math.max(0, this.polygonScroll.getViewport().getViewPosition().x - divX)), Math.min(this.polygonEditorControl.getHeight() - this.polygonScroll.getViewport().getHeight(), Math.max(0, this.polygonScroll.getViewport().getViewPosition().y - divY))));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setFocus();
        this.posX = e.getX();
        this.posY = e.getY();
        if (e.isPopupTrigger()) {
            e.consume();
            this.popupX = e.getX();
            this.popupY = e.getY();
            this.setPopupMenuState();
            this.polygonEditorControl.selectActivePolygon();
            this.polygonEditorControl.getPopupMenu().show(this, this.popupX - this.polygonScroll.getViewport().getViewPosition().x, this.popupY - this.polygonScroll.getViewport().getViewPosition().y + 15);
        } else {
            if (this.polygonEditorViewCommand.equalsIgnoreCase("add_freeform")) {
                this.addFreeFormPolygon(this.userSelectedLayer);
            }
            if (this.polygonEditorViewCommand.equalsIgnoreCase("add_rectangle")) {
                this.addRectanglePolygon(this.userSelectedLayer);
            }
            if (this.polygonEditorViewCommand.equalsIgnoreCase("add_free")) {
                this.addFreePolygon(this.userSelectedLayer);
            }
            if (this.polygonEditorViewCommand.equalsIgnoreCase("add_circle")) {
                this.addCirclePolygon(this.userSelectedLayer);
            }
            if (this.polygonEditorViewCommand.equalsIgnoreCase("add_arrow")) {
                this.addArrowPolygon(this.userSelectedLayer);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setFocus();
        if (!e.isConsumed() && e.isPopupTrigger()) {
            this.popupX = e.getX();
            this.popupY = e.getY();
            this.setPopupMenuState();
            this.polygonEditorControl.selectActivePolygon();
            this.polygonEditorControl.getPopupMenu().show(this, this.popupX - this.polygonScroll.getViewport().getViewPosition().x, this.popupY - this.polygonScroll.getViewport().getViewPosition().y + 15);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() == 0) {
            this.zoomSlider.setValue(Math.min(Math.max(1, this.zoomSlider.getValue() + e.getWheelRotation()), 100));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.isolationModeButton) {
            this.polygonEditorControl.setIsolationMode(this.isolationModeButton.isSelected());
            return;
        }
        if (e.getSource() == this.polygonButton) {
            if (!this.polygonButton.isSelected()) {
                this.polygonEditorViewCommand = "deselect";
                this.setPlaceFirstAnchorMode(false);
                this.updateToolbarButtons();
            } else {
                this.polygonEditorViewCommand = "add_freeform";
                this.setPlaceFirstAnchorMode(true);
                this.updateToolbarButtons();
            }
            return;
        }
        if (e.getSource() == this.flowingFreeformButton) {
            if (!this.flowingFreeformButton.isSelected()) {
                this.polygonEditorViewCommand = "deselect";
                this.setPlaceFirstAnchorMode(false);
                this.updateToolbarButtons();
            } else {
                this.polygonEditorViewCommand = "add_free";
                this.setPlaceFirstAnchorMode(true);
                this.updateToolbarButtons();
            }
            return;
        }
        if (e.getSource() == this.rectangleButton) {
            if (!this.rectangleButton.isSelected()) {
                this.polygonEditorViewCommand = "deselect";
                this.setPlaceFirstAnchorMode(false);
                this.updateToolbarButtons();
            } else {
                this.polygonEditorViewCommand = "add_rectangle";
                this.setPlaceFirstAnchorMode(true);
                this.updateToolbarButtons();
            }
            return;
        }
        if (e.getSource() == this.circleButton) {
            if (!this.circleButton.isSelected()) {
                this.polygonEditorViewCommand = "deselect";
                this.setPlaceFirstAnchorMode(false);
                this.updateToolbarButtons();
            } else {
                this.polygonEditorViewCommand = "add_circle";
                this.setPlaceFirstAnchorMode(true);
                this.updateToolbarButtons();
            }
            return;
        }
        if (e.getSource() == this.arrowButton) {
            if (!this.arrowButton.isSelected()) {
                this.polygonEditorViewCommand = "deselect";
                this.setPlaceFirstAnchorMode(false);
                this.updateToolbarButtons();
            } else {
                this.polygonEditorViewCommand = "add_arrow";
                this.setPlaceFirstAnchorMode(true);
                this.updateToolbarButtons();
            }
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("DELETE_POLYGON")) {
            this.polygonEditorControl.deleteSelectedPolygon();
        }
        if (this.polygonEditorControl.getActivePolygon() != null) {
            if (e.getActionCommand().equalsIgnoreCase("TO_FREE_DESIGN")) {
                this.polygonEditorControl.convertActivePolygonToFreeDesign();
            } else if (e.getActionCommand().equalsIgnoreCase("OPEN_PATH")) {
                this.polygonEditorControl.setActivePolygonOpen(this.openPolygonPathItem.isSelected());
                this.openPolygonPathItem.setSelected(this.openPolygonPathItem.isSelected());
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("DISCARD_LAYER_POLYGON_CHANGES")) {
            if (this.userSelectedLayer != null) {
                this.userSelectedLayer.resetPolygonChanges();
            }
            this.polygonEditorControl.repaintShapes();
        } else if (e.getActionCommand().equalsIgnoreCase("DISCARD_ALL_POLYGON_CHANGES")) {
            for (HILayer layer : this.layers) {
                layer.resetPolygonChanges();
            }
            this.polygonEditorControl.repaintShapes();
        } else if (e.getActionCommand().equalsIgnoreCase("COPY_CLIPBOARD")) {
            HIRuntime.copyToClipboard(this.polygonEditorControl.getSelectedPolygon().getChangedModel());
        } else if (e.getActionCommand().equalsIgnoreCase("PASTE_CLIPBOARD") && this.layers.size() > 0 && !HIRuntime.isClipboardEmpty()) {
            if (this.polygonEditorControl.getActivePolygon() == null) {
                this.polygonEditorControl.addPolygon(this.userSelectedLayer, HIRuntime.pasteFromClipboard(), this.popupX, this.popupY);
            } else {
                HILayer polygonLayer = this.getActiveLayer();
                if (polygonLayer != null) {
                    this.polygonEditorControl.addPolygon(polygonLayer, HIRuntime.pasteFromClipboard(), this.popupX, this.popupY);
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 8) {
            this.polygonEditorControl.deleteSelectedPolygon();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

