/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.components.LayerEditor;
import org.hyperimage.client.gui.MetadataEditorControl;
import org.hyperimage.client.gui.lists.ColorListCellRenderer;
import org.hyperimage.client.gui.lists.GroupContentsCellRenderer;
import org.hyperimage.client.gui.lists.QuickInfoCell;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.gui.views.LayerPolygonEditorView;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.util.MetadataHelper;
import org.jdesktop.layout.GroupLayout;

public class LayerPropertyEditorView
extends GUIView
implements ChangeListener,
PopupMenuListener,
ActionListener,
MouseListener {
    private static final long serialVersionUID = -3949801824506408714L;
    private JComboBox layerColorComboBox;
    private DefaultComboBoxModel layerColorListModel;
    private JPanel layerColorPanel;
    private JTextField layerOpacityField;
    private JLabel layerOpacityLabel;
    private JPanel layerOpacityPanel;
    private JSlider layerOpacitySlider;
    private JPanel layerPanel;
    private JList linkTargetList;
    private JPanel linkTargetPanel;
    private MetadataEditorControl metadataEditorControl;
    private JPanel propertyPanel;
    private JButton addColorToLibButton;
    private JLabel noLinkLabel;
    private TitledBorder linkTargetBorder;
    private TitledBorder layerBorder;
    private TitledBorder layerColorBorder;
    private TitledBorder layerOpacityBorder;
    private static final Border linkBorder = new LineBorder(Color.black, 1);
    private HILayer layer;
    private boolean enabled = true;
    private LayerPolygonEditorView syncView = null;
    private String defLang;
    private Vector<Color> projectColors;
    private Color customColor;
    private HIComponent owner;
    private JPopupMenu popupMenu;
    private JMenuItem linkInfoMenuItem;
    private JMenuItem visitLinkMenuItem;
    private JMenuItem removeLinkMenuItem;
    private JComponent colorUpdateComponent = null;

    public LayerPropertyEditorView(HIComponent owner, Vector<Color> projectColors, String defLang) {
        this(owner, projectColors, defLang, null);
    }

    public LayerPropertyEditorView(HIComponent owner, Vector<Color> projectColors, String defLang, JComponent colorUpdateComponent) {
        super(Messages.getString("LayerPropertyEditorView.0"), new Color(145, 185, 250));
        this.defLang = defLang;
        this.projectColors = projectColors;
        this.customColor = new Color(0, 0, 0, 127);
        this.owner = owner;
        this.colorUpdateComponent = colorUpdateComponent;
        this.initComponents();
        this.setDisplayPanel(this.propertyPanel);
        this.metadataEditorControl.setBaseID(0L);
        this.metadataEditorControl.setTagCount(0L);
        this.linkTargetList.setDragEnabled(true);
        this.linkTargetList.setDropMode(DropMode.ON);
        this.layerOpacitySlider.addChangeListener(this);
        this.layerOpacityField.addActionListener(this);
        this.layerColorComboBox.addPopupMenuListener(this);
        this.linkTargetList.addMouseListener(this);
    }

    @Override
    public void updateLanguage() {
        super.setTitle(Messages.getString("LayerPropertyEditorView.0"));
        this.noLinkLabel.setText("<html><center><b>" + Messages.getString("LayerPropertyEditorView.10") + "</b><br><br>" + Messages.getString("LayerPropertyEditorView.12") + "</center></html>");
        this.addColorToLibButton.setText(Messages.getString("LayerPropertyEditorView.14"));
        this.metadataEditorControl.updateLanguage(Messages.getString("LayerPropertyEditorView.17"), null, Messages.getString("LayerPropertyEditorView.19"));
        this.linkTargetBorder.setTitle(Messages.getString("LayerPropertyEditorView.22"));
        this.layerBorder.setTitle(Messages.getString("LayerPropertyEditorView.20"));
        this.layerColorBorder.setTitle(Messages.getString("LayerPropertyEditorView.23"));
        this.layerOpacityBorder.setTitle(Messages.getString("LayerPropertyEditorView.24"));
        this.visitLinkMenuItem.setText(Messages.getString("LayerPropertyEditorView.27"));
        this.removeLinkMenuItem.setText(Messages.getString("LayerPropertyEditorView.29"));
    }

    public void updateMetadataLanguages() {
        if (this.layer == null) {
            return;
        }
        this.metadataEditorControl.setMetadata(this.layer.getModel().getMetadata(), this.defLang);
    }

    @Override
    public void updateContent() {
        if (this.layer != null && this.layer.getModel() != null) {
            this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(this.layer.getModel().getTimestamp()));
        }
    }

    public void setLayer(HILayer layer) {
        this.layer = layer;
        if (layer == null) {
            this.metadataEditorControl.setEmptyText("");
            this.setEditingEnabled(false);
        } else {
            this.setEditingEnabled(true);
            this.metadataEditorControl.setBaseID(layer.getModel().getId());
            this.metadataEditorControl.setTagCount(HIRuntime.getGui().getTagCountForElement(layer.getModel().getId()));
            this.layerOpacitySlider.setValue(layer.getColour().getAlpha());
            float relOpacity = (float)this.layerOpacitySlider.getValue() / 255.0f;
            this.layerOpacityField.setText(String.valueOf((int)(relOpacity * 100.0f)));
            this.metadataEditorControl.setMetadata(layer.getModel().getMetadata(), this.defLang);
            if (layer.getModel().getUUID() == null) {
                this.metadataEditorControl.setIdLabel("L" + layer.getModel().getId());
            } else {
                this.metadataEditorControl.setIdLabel(layer.getModel().getUUID());
            }
            this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(layer.getModel().getTimestamp()));
            if (layer.getModel().getUUID() == null) {
                this.metadataEditorControl.setEmptyText(String.valueOf(Messages.getString("LayerPropertyEditorView.3")) + " (L" + layer.getModel().getId() + ")");
            } else {
                this.metadataEditorControl.setEmptyText(String.valueOf(Messages.getString("LayerPropertyEditorView.3")) + " (" + layer.getModel().getUUID() + ")");
            }
            int projColorIndex = -1;
            int i = 0;
            while (i < this.projectColors.size()) {
                Color color = this.projectColors.get(i);
                if (color.getRed() == layer.getColour().getRed() && color.getGreen() == layer.getColour().getGreen() && color.getBlue() == layer.getColour().getBlue()) {
                    projColorIndex = i;
                }
                ++i;
            }
            if (HIRuntime.getGui().checkEditAbility(true)) {
                this.addColorToLibButton.setEnabled(projColorIndex < 0);
            } else {
                this.addColorToLibButton.setEnabled(false);
            }
            if (projColorIndex >= 0) {
                this.layerColorComboBox.setSelectedIndex(projColorIndex);
            } else {
                this.layerColorComboBox.setSelectedIndex(this.projectColors.size());
                this.customColor = new Color(layer.getColour().getRed(), layer.getColour().getGreen(), layer.getColour().getBlue());
                this.updateCustomColor();
            }
        }
        this.updateLayerLink();
    }

    public boolean hasMetadataChanges() {
        System.out.println("-->" + this.metadataEditorControl.hasChanges());
        return this.metadataEditorControl.hasChanges();
    }

    public void syncMetadataChanges() {
        this.metadataEditorControl.syncChanges();
    }

    public void resetMetadataChanges() {
        this.metadataEditorControl.resetChanges();
    }

    public void setSyncView(LayerPolygonEditorView polygonEditorView) {
        this.syncView = polygonEditorView;
    }

    public void setLinkTransferHandler(LayerEditor.LinkTransferHandler linkTransferHandler) {
        this.linkTargetList.setTransferHandler(linkTransferHandler);
        this.noLinkLabel.setTransferHandler(linkTransferHandler);
    }

    public void updateLayerLink() {
        DefaultListModel model = (DefaultListModel)this.linkTargetList.getModel();
        model.removeAllElements();
        GroupContentsCellRenderer renderer = (GroupContentsCellRenderer)this.linkTargetList.getCellRenderer();
        renderer.clearCache();
        if (this.layer != null) {
            if (this.layer.getModel().getLinkInfo() != null) {
                model.addElement(this.layer.getModel().getLinkInfo());
                if (this.getLayerLinkPreview() != null) {
                    this.getLayerLinkPreview().setBorder(new EmptyBorder(0, 0, 0, 0));
                }
                this.linkTargetList.setVisible(true);
                this.noLinkLabel.setVisible(false);
            } else {
                this.linkTargetList.setVisible(false);
                this.noLinkLabel.setVisible(true);
            }
        } else {
            this.linkTargetList.setVisible(false);
            this.noLinkLabel.setVisible(true);
        }
        this.linkTargetList.repaint();
    }

    public QuickInfoCell getLayerLinkPreview() {
        if (this.layer.getModel().getLinkInfo() == null) {
            return null;
        }
        GroupContentsCellRenderer renderer = (GroupContentsCellRenderer)this.linkTargetList.getCellRenderer();
        return renderer.getCellForContent(this.layer.getModel().getLinkInfo());
    }

    public JList getLinkTargetList() {
        return this.linkTargetList;
    }

    public JButton getSaveButton() {
        return this.metadataEditorControl.getSaveButton();
    }

    public JButton getResetButton() {
        return this.metadataEditorControl.getResetButton();
    }

    public JButton getAddToLibraryButton() {
        return this.addColorToLibButton;
    }

    public void setPopupMenuListeners(ActionListener listener) {
        this.visitLinkMenuItem.addActionListener(listener);
        this.removeLinkMenuItem.addActionListener(listener);
    }

    public void regenerateProjectColors() {
        this.layerColorListModel.removeAllElements();
        int index = 0;
        boolean indexSet = false;
        for (Color color : this.projectColors) {
            this.layerColorListModel.addElement(color);
            if (this.layer != null && color.getRed() == this.layer.getColour().getRed() && color.getGreen() == this.layer.getColour().getGreen() && color.getBlue() == this.layer.getColour().getBlue()) {
                indexSet = true;
                this.layerColorComboBox.setSelectedIndex(index);
            }
            ++index;
        }
        if (this.layer != null) {
            this.customColor = new Color(this.layer.getColour().getRed(), this.layer.getColour().getGreen(), this.layer.getColour().getBlue(), 127);
        }
        this.layerColorListModel.addElement(this.customColor);
        if (this.layer == null) {
            this.layerColorComboBox.setSelectedIndex(0);
            indexSet = true;
        }
        if (!indexSet) {
            this.layerColorComboBox.setSelectedIndex(this.layerColorListModel.getSize() - 1);
            this.addColorToLibButton.setEnabled(HIRuntime.getGui().checkEditAbility(true));
        } else {
            this.addColorToLibButton.setEnabled(false);
        }
    }

    private void setEditingEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.layerColorComboBox.setEnabled(enabled);
            this.layerOpacityField.setEnabled(enabled);
            this.layerOpacityField.setEditable(enabled);
            this.layerOpacitySlider.setEnabled(enabled);
            this.linkTargetList.setEnabled(enabled);
            if (!enabled) {
                this.metadataEditorControl.setMetadata(null, this.defLang);
                this.metadataEditorControl.setIdLabel("-");
                this.addColorToLibButton.setEnabled(false);
            }
        }
    }

    private void updateCustomColor() {
        this.layerColorComboBox.removePopupMenuListener(this);
        this.layerColorListModel.removeElementAt(this.projectColors.size());
        this.layerColorListModel.addElement(this.customColor);
        this.layerColorComboBox.setSelectedIndex(this.projectColors.size());
        this.layerColorComboBox.addPopupMenuListener(this);
    }

    private void setPopupMenuState() {
        boolean hasLink = false;
        if (this.layer != null && this.layer.getModel().getLinkInfo() != null) {
            hasLink = true;
        }
        if (hasLink) {
            this.linkInfoMenuItem.setText(String.valueOf(Messages.getString("LayerPropertyEditorView.7")) + " " + MetadataHelper.getDisplayableID(this.layer.getModel().getLinkInfo()));
        }
        this.linkInfoMenuItem.setVisible(hasLink);
        this.visitLinkMenuItem.setEnabled(hasLink);
        this.removeLinkMenuItem.setEnabled(hasLink);
    }

    private void initComponents() {
        this.noLinkLabel = new JLabel();
        this.noLinkLabel.setVisible(false);
        this.noLinkLabel.setSize(136, 171);
        this.noLinkLabel.setPreferredSize(new Dimension(134, 169));
        this.noLinkLabel.setBackground(Color.white);
        this.noLinkLabel.setOpaque(true);
        this.noLinkLabel.setBorder(linkBorder);
        this.addColorToLibButton = new JButton();
        this.addColorToLibButton.setActionCommand("colorToLibrary");
        this.propertyPanel = new JPanel();
        this.layerPanel = new JPanel();
        this.linkTargetPanel = new JPanel();
        this.linkTargetList = new JList();
        this.layerColorPanel = new JPanel();
        this.layerColorComboBox = new JComboBox();
        this.layerOpacityPanel = new JPanel();
        this.layerOpacitySlider = new JSlider();
        this.layerOpacityField = new JTextField();
        this.layerOpacityLabel = new JLabel();
        this.metadataEditorControl = new MetadataEditorControl("title", Messages.getString("LayerPropertyEditorView.17"), null, null, "comment", Messages.getString("LayerPropertyEditorView.19"));
        this.layerBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("LayerPropertyEditorView.20"), 0, 0, new Font("Lucida Grande", 0, 13), Color.BLUE);
        this.layerPanel.setBorder(this.layerBorder);
        this.linkTargetBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("LayerPropertyEditorView.22"));
        this.linkTargetPanel.setBorder(this.linkTargetBorder);
        this.linkTargetPanel.add(this.linkTargetList);
        this.linkTargetPanel.add(this.noLinkLabel);
        this.layerColorBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("LayerPropertyEditorView.23"));
        this.layerColorPanel.setBorder(this.layerColorBorder);
        this.layerColorPanel.setLayout(new BorderLayout());
        this.layerColorPanel.add((Component)this.layerColorComboBox, "Center");
        this.layerColorPanel.add((Component)this.addColorToLibButton, "South");
        this.layerOpacityBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("LayerPropertyEditorView.24"));
        this.layerOpacityPanel.setBorder(this.layerOpacityBorder);
        this.layerOpacitySlider.setMinorTickSpacing(1);
        this.layerOpacitySlider.setSnapToTicks(true);
        this.layerOpacitySlider.setPaintLabels(false);
        this.layerOpacitySlider.setPaintTicks(false);
        this.layerOpacityField.setText("100");
        this.layerOpacityLabel.setLabelFor(this.layerOpacityField);
        this.layerOpacityLabel.setText("%");
        GroupLayout layerOpacityPanelLayout = new GroupLayout(this.layerOpacityPanel);
        this.layerOpacityPanel.setLayout(layerOpacityPanelLayout);
        layerOpacityPanelLayout.setHorizontalGroup(layerOpacityPanelLayout.createParallelGroup(1).add(2, layerOpacityPanelLayout.createSequentialGroup().addContainerGap().add(this.layerOpacitySlider, -1, 132, Short.MAX_VALUE).addPreferredGap(0).add(this.layerOpacityField, -2, 48, -2).addPreferredGap(0).add(this.layerOpacityLabel).add(20, 20, 20)));
        layerOpacityPanelLayout.setVerticalGroup(layerOpacityPanelLayout.createParallelGroup(1).add(layerOpacityPanelLayout.createParallelGroup(3).add(this.layerOpacityLabel).add(this.layerOpacityField, -2, -1, -2)).add(this.layerOpacitySlider, -2, -1, -2));
        GroupLayout layerPanelLayout = new GroupLayout(this.layerPanel);
        this.layerPanel.setLayout(layerPanelLayout);
        layerPanelLayout.setHorizontalGroup(layerPanelLayout.createParallelGroup(1).add(layerPanelLayout.createSequentialGroup().addContainerGap().add(this.linkTargetPanel, -2, -1, -2).addPreferredGap(1).add(layerPanelLayout.createParallelGroup(2).add(this.layerColorPanel, -1, 273, Short.MAX_VALUE).add(this.layerOpacityPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layerPanelLayout.setVerticalGroup(layerPanelLayout.createParallelGroup(1).add(layerPanelLayout.createSequentialGroup().add(layerPanelLayout.createParallelGroup(1, false).add(2, layerPanelLayout.createSequentialGroup().add(3, 3, 3).add(this.layerColorPanel, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.layerOpacityPanel, -2, -1, -2)).add(this.linkTargetPanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout propertyPanelLayout = new GroupLayout(this.propertyPanel);
        this.propertyPanel.setLayout(propertyPanelLayout);
        propertyPanelLayout.setHorizontalGroup(propertyPanelLayout.createParallelGroup(1).add(2, propertyPanelLayout.createSequentialGroup().addContainerGap().add(propertyPanelLayout.createParallelGroup(2).add(1, this.metadataEditorControl, -1, -1, Short.MAX_VALUE).add(1, this.layerPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        propertyPanelLayout.setVerticalGroup(propertyPanelLayout.createParallelGroup(1).add(propertyPanelLayout.createSequentialGroup().addContainerGap().add(this.layerPanel, -2, -1, -2).addPreferredGap(0).add(this.metadataEditorControl, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.popupMenu = new JPopupMenu();
        this.linkInfoMenuItem = new JMenuItem();
        this.linkInfoMenuItem.setEnabled(false);
        this.popupMenu.add(this.linkInfoMenuItem);
        this.visitLinkMenuItem = new JMenuItem();
        this.visitLinkMenuItem.setActionCommand("visitLink");
        this.popupMenu.add(this.visitLinkMenuItem);
        this.popupMenu.add(new JSeparator());
        this.removeLinkMenuItem = new JMenuItem();
        this.removeLinkMenuItem.setActionCommand("removeLink");
        this.popupMenu.add(this.removeLinkMenuItem);
        GroupContentsCellRenderer renderer = new GroupContentsCellRenderer();
        renderer.setLayout(new FlowLayout(1, 0, 0));
        this.linkTargetList.setCellRenderer(renderer);
        this.linkTargetList.setModel(new DefaultListModel());
        this.linkTargetList.setPreferredSize(new Dimension(132, 166));
        this.linkTargetList.setBackground(this.linkTargetPanel.getBackground());
        this.linkTargetList.setBorder(linkBorder);
        this.layerOpacitySlider.setMinimum(0);
        this.layerOpacitySlider.setMaximum(255);
        this.layerColorListModel = new DefaultComboBoxModel();
        this.layerColorComboBox.setModel(this.layerColorListModel);
        this.layerColorComboBox.setRenderer(new ColorListCellRenderer(this.projectColors, this.layerColorComboBox));
        for (Color color : this.projectColors) {
            this.layerColorListModel.addElement(color);
        }
        this.layerColorListModel.addElement(this.customColor);
        this.updateLanguage();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.layer.setOpacity(this.layerOpacitySlider.getValue());
        float relOpacity = (float)this.layerOpacitySlider.getValue() / 255.0f;
        this.layerOpacityField.setText(String.valueOf((int)(relOpacity * 100.0f)));
        if (this.syncView != null) {
            this.syncView.repaintShapes();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.layerColorComboBox.getSelectedIndex() == this.projectColors.size()) {
            final LayerPropertyEditorView propView = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Color newColor = JColorChooser.showDialog(propView, Messages.getString("LayerPropertyEditorView.31"), LayerPropertyEditorView.this.customColor);
                    if (newColor != null) {
                        boolean indexSet = false;
                        int index = 0;
                        while (index < LayerPropertyEditorView.this.projectColors.size()) {
                            Color color = (Color)LayerPropertyEditorView.this.projectColors.get(index);
                            if (color.getRed() == newColor.getRed() && color.getGreen() == newColor.getGreen() && color.getBlue() == newColor.getBlue()) {
                                indexSet = true;
                                LayerPropertyEditorView.this.layerColorComboBox.setSelectedIndex(index);
                            }
                            ++index;
                        }
                        if (!indexSet) {
                            LayerPropertyEditorView.this.customColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), 127);
                            LayerPropertyEditorView.this.updateCustomColor();
                            LayerPropertyEditorView.this.layer.setColour(LayerPropertyEditorView.this.customColor);
                            LayerPropertyEditorView.this.addColorToLibButton.setEnabled(HIRuntime.getGui().checkEditAbility(true));
                        }
                        if (LayerPropertyEditorView.this.syncView != null) {
                            LayerPropertyEditorView.this.syncView.repaintShapes();
                        }
                    } else {
                        LayerPropertyEditorView.this.layer.setColour(LayerPropertyEditorView.this.customColor);
                        LayerPropertyEditorView.this.addColorToLibButton.setEnabled(HIRuntime.getGui().checkEditAbility(true));
                        if (LayerPropertyEditorView.this.syncView != null) {
                            LayerPropertyEditorView.this.syncView.repaintShapes();
                        }
                    }
                    if (LayerPropertyEditorView.this.colorUpdateComponent != null) {
                        LayerPropertyEditorView.this.colorUpdateComponent.repaint();
                    }
                }
            });
        } else {
            this.layer.setColour(this.projectColors.get(this.layerColorComboBox.getSelectedIndex()));
            this.addColorToLibButton.setEnabled(false);
            if (this.syncView != null) {
                this.syncView.repaintShapes();
            }
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int opacity = Integer.parseInt(this.layerOpacityField.getText());
            opacity = Math.max(0, opacity);
            opacity = Math.min(100, opacity);
            int layerOpacity = (int)(2.55f * (float)opacity);
            if (layerOpacity > 0 && layerOpacity < 255) {
                ++layerOpacity;
            }
            this.layer.setOpacity(layerOpacity);
            this.layerOpacitySlider.setValue(layerOpacity);
            if (this.syncView != null) {
                this.syncView.repaintShapes();
            }
        }
        catch (NumberFormatException nfe) {
            this.layerOpacityField.setText(Integer.toString(this.layer.getOpacity() * 100 / 255));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1 && !e.isPopupTrigger()) {
            if (this.layer == null) {
                return;
            }
            if (this.layer.getModel().getLinkInfo() != null) {
                HIRuntime.getGui().openContentEditor(this.layer.getModel().getLinkInfo(), this.owner);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && this.layer != null) {
            e.consume();
            this.setPopupMenuState();
            this.popupMenu.show(this.linkTargetPanel, e.getX(), e.getY() + 15);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed() && e.isPopupTrigger() && this.layer != null) {
            this.setPopupMenuState();
            this.popupMenu.show(this.linkTargetPanel, e.getX(), e.getY() + 15);
        }
    }
}

