/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.TagsButton;
import org.hyperimage.client.gui.dialogs.HIBaseTagsEditorDialog;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiLightTable;

public class LightTablePreViewerView
extends GUIView
implements ActionListener {
    private static final long serialVersionUID = -5239949927219184068L;
    private JPanel editorPanel;
    private JLabel infoLabel;
    private JLabel titleLabel;
    private JPanel infoPanel;
    private JButton openPreViewerButton;
    private TagsButton tagsButton;
    private JLabel previewerNoteLabel;
    HiLightTable lightTable;
    String lightTableTitle;

    public LightTablePreViewerView(HiLightTable lightTable) {
        super(Messages.getString("LightTablePreViewerView.editTitle"), new Color(97, 137, 202));
        this.lightTable = lightTable;
        this.initComponents();
        this.setDisplayPanel(this.editorPanel);
        this.tagsButton.setCount((int)HIRuntime.getGui().getTagCountForElement(lightTable.getId()));
        this.tagsButton.addActionListener(this);
        this.infoLabel.setText(String.valueOf(Messages.getString("HIClientGUI.lastChanged")) + ": " + MetadataHelper.getFuzzyDate(lightTable.getTimestamp()));
    }

    @Override
    public void updateContent() {
        this.infoLabel.setText(String.valueOf(Messages.getString("HIClientGUI.lastChanged")) + ": " + MetadataHelper.getFuzzyDate(this.lightTable.getTimestamp()));
    }

    @Override
    public void updateLanguage() {
        super.setTitle(Messages.getString("LightTablePreViewerView.editTitle"));
        this.openPreViewerButton.setText(Messages.getString("LightTablePreViewerView.openPreViewer"));
        this.tagsButton.setToolTipText(Messages.getString("MetadataEditorControl.tagButtonTooltip"));
        this.previewerNoteLabel.setText("<html><b>" + Messages.getString("LightTablePreViewerView.note") + "</b><br>" + Messages.getString("LightTablePreViewerView.info1") + "<br>" + Messages.getString("LightTablePreViewerView.info2") + "<br><ul><li>" + Messages.getString("LightTablePreViewerView.instruction1") + "</li><li>" + Messages.getString("LightTablePreViewerView.instruction2") + "</li><li>" + Messages.getString("LightTablePreViewerView.instruction3") + "</li></ul></html>");
        ((TitledBorder)this.infoPanel.getBorder()).setTitle(Messages.getString("LightTablePreViewerView.info"));
        this.setLightTableTitle(this.lightTable.getTitle());
    }

    public void resetChanges() {
    }

    public boolean hasChanges() {
        return false;
    }

    public void syncChanges() {
    }

    public JButton getPreViewerButton() {
        return this.openPreViewerButton;
    }

    private void setLightTableTitle(String title) {
        if (title.length() > 0) {
            this.titleLabel.setText(String.valueOf(Messages.getString("LightTableXMLView.15")) + ": " + title);
        } else {
            this.titleLabel.setText(String.valueOf(Messages.getString("LightTableXMLView.17")) + ": -");
        }
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.infoPanel = new JPanel();
        this.previewerNoteLabel = new JLabel();
        this.openPreViewerButton = new JButton();
        this.tagsButton = new TagsButton();
        this.openPreViewerButton.setActionCommand("open");
        this.titleLabel.setText(String.valueOf(Messages.getString("LightTableXMLView.31")) + ": ");
        this.infoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("LightTablePreViewerView.info"), 0, 0, null, Color.blue));
        this.previewerNoteLabel.setVerticalAlignment(1);
        GroupLayout infoPanelLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addContainerGap().addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openPreViewerButton, -1, 511, Short.MAX_VALUE).addComponent(this.previewerNoteLabel, -2, 0, Short.MAX_VALUE).addComponent(this.titleLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, infoPanelLayout.createSequentialGroup().addComponent(this.titleLabel).addGap(18, 18, 18).addComponent(this.previewerNoteLabel, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openPreViewerButton, -2, -1, -2).addContainerGap()));
        GroupLayout editorPanelLayout = new GroupLayout(this.editorPanel);
        this.editorPanel.setLayout(editorPanelLayout);
        editorPanelLayout.setHorizontalGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editorPanelLayout.createSequentialGroup().addContainerGap().addGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoPanel, -1, -1, Short.MAX_VALUE).addGroup(editorPanelLayout.createSequentialGroup().addComponent(this.infoLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tagsButton, -2, 98, -2).addGap(4, 4, 4))).addContainerGap()));
        editorPanelLayout.setVerticalGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.infoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.infoLabel).addComponent(this.tagsButton, -2, -1, -2)).addContainerGap()));
        if (System.getProperty("HI.feature.tagsDisabled") != null) {
            this.tagsButton.setVisible(false);
        }
        this.updateLanguage();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.tagsButton.setCount(new HIBaseTagsEditorDialog((Frame)HIRuntime.getGui(), this.lightTable.getId()).chooseTags());
    }
}

