/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.ResetButton;
import org.hyperimage.client.gui.SaveButton;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiLightTable;
import org.jdesktop.layout.GroupLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LightTableXMLView
extends GUIView {
    private static final long serialVersionUID = -5239949927219184068L;
    private JPanel editorPanel;
    private JLabel infoLabel;
    private ResetButton resetButton;
    private SaveButton saveButton;
    private JLabel titleLabel;
    private JScrollPane xmlScroll;
    private JTextArea xmlTextArea;
    boolean isValidLitaXML = false;
    DocumentBuilderFactory factory;
    DocumentBuilder builder;
    Schema litaSchema = null;
    HiLightTable lightTable;
    String lightTableTitle;
    String lightTableXML;

    public LightTableXMLView(HiLightTable lightTable) {
        super(Messages.getString("LightTableXMLView.6"), new Color(97, 137, 202));
        this.lightTable = lightTable;
        this.initComponents();
        this.setDisplayPanel(this.editorPanel);
        this.lightTableTitle = lightTable.getTitle();
        this.lightTableXML = lightTable.getXml();
        this.xmlTextArea.setText(this.lightTableXML);
        this.setLightTableTitle(this.lightTableTitle);
        this.factory = DocumentBuilderFactory.newInstance();
        this.builder = null;
        try {
            this.factory.setNamespaceAware(false);
            this.builder = this.factory.newDocumentBuilder();
            if (this.builder != null) {
                this.builder.setErrorHandler(null);
            }
            this.litaSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.getClass().getResource("/resources/schema/lita.xsd"));
        }
        catch (ParserConfigurationException e) {
            this.builder = null;
            System.out.println("Client Error: could not init light table xml parser\nReason: " + e.getMessage());
        }
        catch (SAXException e) {
            this.litaSchema = null;
            System.out.println("Client Error: could not init light table xml parser schema\nReason: " + e.getMessage());
        }
        this.parseXMLAndUpdateStatus();
    }

    @Override
    public void updateLanguage() {
        this.saveButton.setToolTipText(Messages.getString("LightTableXMLView.34"));
        this.resetButton.setToolTipText(Messages.getString("LightTableXMLView.35"));
        super.setTitle(Messages.getString("LightTableXMLView.6"));
        this.parseXMLAndUpdateStatus();
    }

    public void resetChanges() {
        this.lightTableTitle = this.lightTable.getTitle();
        this.lightTableXML = this.lightTable.getXml();
        this.xmlTextArea.setText(this.lightTableXML);
        this.setLightTableTitle(this.lightTableTitle);
        this.parseXMLAndUpdateStatus();
    }

    public boolean hasChanges() {
        return this.lightTable.getXml().compareTo(this.lightTableXML) != 0;
    }

    public void syncChanges() {
        this.lightTable.setTitle(this.lightTableTitle);
        this.lightTable.setXml(this.lightTableXML);
        super.setTitle(Messages.getString("LightTableXMLView.6"));
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getResetButton() {
        return this.resetButton;
    }

    private void parseXMLAndUpdateStatus() {
        this.isValidLitaXML = false;
        Document doc = null;
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + this.xmlTextArea.getText();
        xml = MetadataHelper.convertToUTF8(xml);
        ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes());
        try {
            if (this.builder != null) {
                this.builder.reset();
                doc = this.builder.parse(input);
                if (this.litaSchema != null) {
                    this.litaSchema.newValidator().validate(new DOMSource(doc), new DOMResult());
                }
                this.isValidLitaXML = true;
            }
        }
        catch (SAXException e) {
            this.isValidLitaXML = false;
        }
        catch (IOException e) {
            this.isValidLitaXML = false;
        }
        if (this.isValidLitaXML) {
            this.lightTableXML = this.xmlTextArea.getText();
            NodeList nodes = doc.getElementsByTagName("lita");
            int i = 0;
            while (i < nodes.getLength()) {
                Element element = (Element)nodes.item(i);
                NodeList title = element.getElementsByTagName("title");
                Element line = (Element)title.item(0);
                String lang = line.getAttribute("xml:lang");
                if (lang != null && lang.compareTo(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()) == 0) {
                    this.lightTableTitle = line.getTextContent();
                }
                ++i;
            }
            this.setLightTableTitle(this.lightTableTitle);
        } else {
            this.setLightTableTitle("-");
        }
        this.updateXMLGUI();
    }

    private void setLightTableTitle(String title) {
        if (title.length() > 0) {
            this.titleLabel.setText(String.valueOf(Messages.getString("LightTableXMLView.15")) + ": " + title);
        } else {
            this.titleLabel.setText(String.valueOf(Messages.getString("LightTableXMLView.17")) + ": -");
        }
    }

    private void updateXMLGUI() {
        this.saveButton.setEnabled(this.isValidLitaXML);
        if (this.isValidLitaXML) {
            this.infoLabel.setText("<html>" + Messages.getString("LightTableXMLView.20") + ": X" + this.lightTable.getId() + " - <font color=\"#009900\">" + Messages.getString("LightTableXMLView.23") + "</font></html>");
            this.xmlTextArea.setForeground(Color.blue);
        } else {
            this.infoLabel.setText("<html>" + Messages.getString("LightTableXMLView.26") + ": X" + this.lightTable.getId() + " - <font color=\"#FF0000\">" + Messages.getString("LightTableXMLView.29") + "</font></html>");
            this.xmlTextArea.setForeground(Color.black);
        }
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.xmlScroll = new JScrollPane();
        this.xmlTextArea = new JTextArea();
        this.titleLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.resetButton = new ResetButton();
        this.saveButton = new SaveButton();
        this.xmlTextArea.setColumns(20);
        this.xmlTextArea.setRows(5);
        this.xmlScroll.setViewportView(this.xmlTextArea);
        this.titleLabel.setText(String.valueOf(Messages.getString("LightTableXMLView.31")) + ": ");
        this.infoLabel.setText("<html>xxx</html>");
        GroupLayout editorPanelLayout = new GroupLayout(this.editorPanel);
        this.editorPanel.setLayout(editorPanelLayout);
        editorPanelLayout.setHorizontalGroup(editorPanelLayout.createParallelGroup(1).add(editorPanelLayout.createSequentialGroup().addContainerGap().add(editorPanelLayout.createParallelGroup(1).add(this.xmlScroll, -1, 360, Short.MAX_VALUE).add(this.titleLabel, -1, 360, Short.MAX_VALUE).add(editorPanelLayout.createSequentialGroup().add(this.resetButton, -2, -1, -2).addPreferredGap(0).add(this.saveButton, -2, -1, -2).addPreferredGap(1).add(this.infoLabel, -1, 295, Short.MAX_VALUE))).addContainerGap()));
        editorPanelLayout.setVerticalGroup(editorPanelLayout.createParallelGroup(1).add(editorPanelLayout.createSequentialGroup().addContainerGap().add(this.titleLabel).addPreferredGap(0).add(this.xmlScroll, -1, 204, Short.MAX_VALUE).add(8, 8, 8).add(editorPanelLayout.createParallelGroup(3).add(this.infoLabel, -2, 21, -2).add(this.resetButton, -2, -1, -2).add(this.saveButton, -2, -1, -2)).addContainerGap()));
        ((AbstractDocument)this.xmlTextArea.getDocument()).setDocumentFilter(new HILightTableXMLDocumentFilter());
        this.updateLanguage();
    }

    class HILightTableXMLDocumentFilter
    extends DocumentFilter {
        HILightTableXMLDocumentFilter() {
        }

        private void trimXML() {
            String xml = LightTableXMLView.this.xmlTextArea.getText();
            if (!xml.startsWith("<lita id=") && xml.indexOf("<lita id=") > 0) {
                xml = LightTableXMLView.this.xmlTextArea.getText().substring(LightTableXMLView.this.xmlTextArea.getText().indexOf("<lita id="));
            }
            if (!LightTableXMLView.this.xmlTextArea.getText().endsWith("</lita>") && LightTableXMLView.this.xmlTextArea.getText().indexOf("</lita>") > 0) {
                xml = xml.substring(0, xml.indexOf("</lita>") + 7);
            }
            if (xml.compareTo(LightTableXMLView.this.xmlTextArea.getText()) != 0) {
                LightTableXMLView.this.xmlTextArea.setText(xml);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(fb, offs, str, a);
            this.trimXML();
            LightTableXMLView.this.parseXMLAndUpdateStatus();
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
            this.trimXML();
            LightTableXMLView.this.parseXMLAndUpdateStatus();
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(fb, offset, length, text, attrs);
            this.trimXML();
            LightTableXMLView.this.parseXMLAndUpdateStatus();
        }
    }
}

