/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import com.sun.media.jai.widget.DisplayJAI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URLConnection;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.InscriptionViewerControl;
import org.hyperimage.client.gui.LayerViewerControl;
import org.hyperimage.client.gui.TagsButton;
import org.hyperimage.client.gui.dialogs.HIBaseTagsEditorDialog;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.gui.views.GenericMetadataEditorView;
import org.hyperimage.client.util.LoadableImage;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiView;
import org.jdesktop.layout.GroupLayout;

public class ObjectContentEditView
extends GUIView
implements LoadableImage,
ActionListener {
    private static final long serialVersionUID = -2851582974143718095L;
    HiObjectContent content = null;
    private JButton editLayersButton;
    private TagsButton tagsButton;
    private JLabel layerCountLabel;
    private JPanel objectContentsPreviewPanel;
    private JPanel previewPanel;
    private JPanel contentsPanel;
    private JTabbedPane contentsTabPane;
    private JPanel controlPanel;
    private JPanel statusPanel;
    private JPanel editPanel;
    private JProgressBar loadingIndicator;
    private PlanarImage noPreview;
    private DisplayJAI viewPanel;
    private InscriptionViewerControl inscriptionViewer;
    private LayerViewerControl layerViewer = null;
    private String defLang;
    private GenericMetadataEditorView metadataEditor;

    public ObjectContentEditView(String defLang) {
        super(new Color(97, 137, 202));
        this.defLang = defLang;
        this.initComponents();
        this.updateLanguage();
        this.tagsButton.addActionListener(this);
        this.setDisplayPanel(this.objectContentsPreviewPanel);
    }

    @Override
    public void updateLanguage() {
        this.layerCountLabel.setText(Messages.getString("ObjectContentEditView.0"));
        this.updateStatusBar();
        if (this.content == null || this.content instanceof HiView) {
            this.setTitle(Messages.getString("ObjectContentEditView.1"));
        } else {
            this.setTitle(Messages.getString("ObjectContentEditView.inscriptiondetails"));
        }
        this.contentsTabPane.addTab(Messages.getString("ObjectContentEditView.2"), this.previewPanel);
        this.contentsTabPane.addTab(Messages.getString("ObjectContentEditView.3"), new JScrollPane(this.editPanel));
        this.editLayersButton.setToolTipText(Messages.getString("ObjectContentEditView.4"));
        this.tagsButton.setToolTipText(Messages.getString("MetadataEditorControl.tagButtonTooltip"));
        if (this.metadataEditor != null) {
            this.metadataEditor.updateLanguage();
        }
        this.layerViewer.updateLanguage();
    }

    @Override
    public void updateContent() {
        this.resetChanges();
        if (this.content instanceof HiView) {
            this.layerViewer.initLayers(((HiView)this.content).getLayers(), ((HiView)this.content).getSortOrder());
            this.previewPanel.repaint();
        }
        this.repaint();
        this.updateStatusBar();
    }

    public void setContentView(HiObjectContent content) {
        this.content = content;
        this.setView();
    }

    public void updateMetadataLanguages() {
        this.metadataEditor.updateMetadata();
    }

    public JPanel getDisplayPanel() {
        return this.previewPanel;
    }

    public LayerViewerControl getLayerViewer() {
        return this.layerViewer;
    }

    public JButton getLayerEditorButton() {
        return this.editLayersButton;
    }

    public boolean hasChanges() {
        if (this.metadataEditor != null) {
            return this.metadataEditor.hasChanges();
        }
        return false;
    }

    public void syncChanges() {
        if (this.metadataEditor != null) {
            this.metadataEditor.syncChanges();
        }
    }

    public void resetChanges() {
        if (this.metadataEditor != null) {
            this.metadataEditor.resetChanges();
            this.editPanel.doLayout();
            this.editPanel.repaint();
        }
    }

    public void updateStatusBar() {
        if (this.content instanceof HiView) {
            String id = "V" + this.content.getId();
            if (this.content.getUUID() != null) {
                id = this.content.getUUID();
            }
            String count = Messages.getString("ObjectContentEditView.6");
            String layerString = Messages.getString("ObjectContentEditView.7");
            if (((HiView)this.content).getLayers().size() == 1) {
                layerString = Messages.getString("ObjectContentEditView.8");
                count = Messages.getString("ObjectContentEditView.9");
            } else if (((HiView)this.content).getLayers().size() > 1) {
                count = Integer.toString(((HiView)this.content).getLayers().size());
            }
            String mimetype = URLConnection.guessContentTypeFromName(((HiView)this.content).getFilename());
            if (mimetype.startsWith("image/")) {
                this.layerCountLabel.setText("<html>" + Messages.getString("ObjectContentEditView.viewLastChanged") + ":&nbsp;" + MetadataHelper.getFuzzyDate(this.content.getTimestamp()) + "<br>" + ((HiView)this.content).getWidth() + "*" + ((HiView)this.content).getHeight() + " px - " + count + " " + layerString + "</html>");
            } else {
                this.layerCountLabel.setText("<html>" + Messages.getString("ObjectContentEditView.viewLastChanged") + ":&nbsp;" + MetadataHelper.getFuzzyDate(this.content.getTimestamp()) + "<br>" + Messages.getString("ObjectContentEditView.18") + " (" + mimetype + ")</html>");
            }
            if (!this.needsPreview()) {
                this.loadingIndicator.setVisible(false);
            }
        } else if (this.content instanceof HiInscription) {
            this.layerCountLabel.setText(String.valueOf(Messages.getString("ObjectContentEditView.inscriptionLastChanged")) + ": " + MetadataHelper.getFuzzyDate(this.content.getTimestamp()));
        }
        if (this.content == null) {
            this.layerCountLabel.setText(Messages.getString("ObjectContentEditView.25"));
        }
    }

    private void setView() {
        if (this.content == null || this.content instanceof HiView) {
            this.setTitle(Messages.getString("ObjectContentEditView.1"));
        } else {
            this.setTitle(Messages.getString("ObjectContentEditView.inscriptiondetails"));
        }
        if (this.content == null) {
            this.setNoPreview();
            return;
        }
        this.previewPanel.removeAll();
        this.tagsButton.setEnabled(true);
        this.tagsButton.setCount((int)HIRuntime.getGui().getTagCountForElement(this.content.getId()));
        if (this.content instanceof HiView) {
            this.loadingIndicator.setVisible(true);
            this.layerCountLabel.setText(Messages.getString("ObjectContentEditView.21"));
            this.editLayersButton.setEnabled(true);
            this.layerViewer.setPreviewLoading();
            this.layerViewer.initLayers(((HiView)this.content).getLayers(), ((HiView)this.content).getSortOrder());
            this.previewPanel.add(this.layerViewer);
            this.metadataEditor = new GenericMetadataEditorView((HiView)this.content, this.defLang);
        } else {
            this.inscriptionViewer.setInscription((HiInscription)this.content);
            this.previewPanel.add(this.inscriptionViewer);
            this.metadataEditor = new GenericMetadataEditorView((HiInscription)this.content, this.defLang);
            this.loadingIndicator.setVisible(false);
            String id = "I" + this.content.getId();
            if (this.content.getUUID() != null) {
                id = this.content.getUUID();
            }
            this.layerCountLabel.setText(String.valueOf(Messages.getString("ObjectContentEditView.inscriptionLastChanged")) + " " + MetadataHelper.getFuzzyDate(this.content.getTimestamp()));
            this.editLayersButton.setEnabled(false);
        }
        this.editPanel.removeAll();
        this.editPanel.add(this.metadataEditor.getMetadataPanel());
        this.editPanel.doLayout();
        this.editPanel.repaint();
        this.previewPanel.doLayout();
        this.previewPanel.repaint();
    }

    private void setNoPreview() {
        this.tagsButton.setEnabled(false);
        this.tagsButton.setCount(0);
        this.editPanel.removeAll();
        this.editPanel.doLayout();
        this.editPanel.repaint();
        this.previewPanel.removeAll();
        this.viewPanel.set(this.noPreview);
        this.previewPanel.add(this.viewPanel);
        this.layerCountLabel.setText(Messages.getString("ObjectContentEditView.25"));
        this.loadingIndicator.setVisible(false);
    }

    private void initComponents() {
        this.objectContentsPreviewPanel = new JPanel();
        this.previewPanel = new JPanel();
        this.editLayersButton = new JButton();
        this.tagsButton = new TagsButton();
        this.layerCountLabel = new JLabel();
        this.contentsPanel = new JPanel();
        this.contentsTabPane = new JTabbedPane();
        this.editPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.loadingIndicator = new JProgressBar();
        GroupLayout contentsPanelLayout = new GroupLayout(this.contentsPanel);
        this.contentsPanel.setLayout(contentsPanelLayout);
        contentsPanelLayout.setHorizontalGroup(contentsPanelLayout.createParallelGroup(1).add(0, 394, Short.MAX_VALUE).add(contentsPanelLayout.createParallelGroup(1).add(2, this.contentsTabPane, -1, 394, Short.MAX_VALUE)));
        contentsPanelLayout.setVerticalGroup(contentsPanelLayout.createParallelGroup(1).add(0, 252, Short.MAX_VALUE).add(contentsPanelLayout.createParallelGroup(1).add(this.contentsTabPane, -1, 252, Short.MAX_VALUE)));
        this.editLayersButton.setActionCommand("editLayers");
        this.editLayersButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.editLayersButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/layerEditor.png")));
        this.editLayersButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/layerEditor-active.png")));
        this.editLayersButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/layerEditor-disabled.png")));
        this.editLayersButton.setPreferredSize(new Dimension(24, 24));
        this.statusPanel.setLayout(new BorderLayout(5, 0));
        this.statusPanel.add((Component)this.layerCountLabel, "Center");
        this.statusPanel.add((Component)this.loadingIndicator, "East");
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(1).add(controlPanelLayout.createSequentialGroup().add(this.editLayersButton, -2, -1, -2).add(12, 12, 12).add(this.statusPanel, -1, 258, Short.MAX_VALUE).addPreferredGap(0).add(this.tagsButton, -2, 90, -2)));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(1).add(2, this.statusPanel, -2, 24, Short.MAX_VALUE).add(2, this.editLayersButton, -1, -1, Short.MAX_VALUE).add(2, this.tagsButton, -2, -1, -2));
        GroupLayout objectContentsPreviewPanelLayout = new GroupLayout(this.objectContentsPreviewPanel);
        this.objectContentsPreviewPanel.setLayout(objectContentsPreviewPanelLayout);
        objectContentsPreviewPanelLayout.setHorizontalGroup(objectContentsPreviewPanelLayout.createParallelGroup(1).add(2, objectContentsPreviewPanelLayout.createSequentialGroup().addContainerGap().add(objectContentsPreviewPanelLayout.createParallelGroup(2).add(1, this.contentsPanel, -1, -1, Short.MAX_VALUE).add(1, this.controlPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        objectContentsPreviewPanelLayout.setVerticalGroup(objectContentsPreviewPanelLayout.createParallelGroup(1).add(2, objectContentsPreviewPanelLayout.createSequentialGroup().addContainerGap().add(this.contentsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(this.controlPanel, -2, -1, -2).addContainerGap()));
        if (System.getProperty("HI.feature.tagsDisabled") != null) {
            this.tagsButton.setVisible(false);
        }
        this.loadingIndicator.setIndeterminate(true);
        this.previewPanel.setLayout(new BorderLayout());
        this.editPanel.setLayout(new BorderLayout());
        this.viewPanel = new DisplayJAI();
        this.noPreview = JAI.create("url", this.getClass().getResource("/resources/hyperimage-nopreview.png"));
        this.inscriptionViewer = new InscriptionViewerControl(this.defLang);
        this.layerViewer = new LayerViewerControl();
        this.setNoPreview();
    }

    @Override
    public boolean needsPreview() {
        return this.layerViewer.needsPreview();
    }

    @Override
    public void setPreviewImage(PlanarImage image) {
        this.layerViewer.setPreviewImage(image);
        this.updateStatusBar();
        this.loadingIndicator.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.content != null) {
            this.tagsButton.setCount(new HIBaseTagsEditorDialog((Frame)HIRuntime.getGui(), this.content.getId()).chooseTags());
        }
    }
}

