/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.OptionButton;
import org.hyperimage.client.gui.lists.ObjectContentsCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;
import org.jdesktop.layout.GroupLayout;

public class ObjectContentsListView
extends GUIView
implements MouseListener {
    private static final long serialVersionUID = 4698307895559211977L;
    private HiObject object;
    private String defaultLang;
    private JScrollPane listScroll;
    private JPanel objectContentsControlPanel;
    private JPanel objectContentsPanel;
    private OptionButton optionsButton;
    private JLabel viewCountLabel;
    private JList objectContentsList;
    private DefaultListModel objectContentsListModel;
    private ObjectContentsCellRenderer objectContentsRenderer;
    private JPopupMenu popupMenu;
    private JCheckBoxMenuItem defaultViewToggleMenuItem;
    private JMenuItem newInscriptionMenuItem;
    private JMenuItem moveViewToTrashMenuItem;

    public ObjectContentsListView(String defaultLang, HiObject object) {
        super(new Color(97, 137, 202));
        this.defaultLang = defaultLang;
        this.object = object;
        this.initComponents();
        this.updateLanguage();
        this.setDisplayPanel(this.objectContentsPanel);
        this.objectContentsList.setDragEnabled(true);
        this.objectContentsList.setDropMode(DropMode.INSERT);
        this.updateViewCount();
        this.populateList();
        this.populatePopupMenu();
        this.sortObjectContent();
        this.objectContentsList.addMouseListener(this);
    }

    @Override
    public void updateLanguage() {
        this.setTitle(Messages.getString("ObjectContentsListView.0"));
        this.viewCountLabel.setText(Messages.getString("ObjectContentsListView.1"));
        this.updateViewCount();
        this.defaultViewToggleMenuItem.setText(Messages.getString("ObjectContentsListView.2"));
        this.newInscriptionMenuItem.setText(Messages.getString("ObjectContentsListView.3"));
        this.moveViewToTrashMenuItem.setText(Messages.getString("ObjectContentsListView.4"));
        this.optionsButton.updateLanguage();
    }

    public JList getContentsList() {
        return this.objectContentsList;
    }

    public void setSelectedIndex(int index) {
        if (this.objectContentsListModel.getSize() <= 0) {
            this.optionsButton.setEnabled(false);
            return;
        }
        this.optionsButton.setEnabled(true);
        if (index < 0 || index >= this.objectContentsListModel.getSize()) {
            return;
        }
        if (this.objectContentsList.getSelectedIndex() != index) {
            this.objectContentsList.setSelectedIndex(index);
        }
    }

    public JButton getOptionsButton() {
        return this.optionsButton;
    }

    public void updateRendering(HiInscription inscription) {
        this.objectContentsRenderer.refresh(inscription);
        this.objectContentsList.repaint();
    }

    public void refreshList() {
        int oldIndex = this.objectContentsList.getSelectedIndex();
        long oldId = 0L;
        if (oldIndex >= 0) {
            oldId = ((HiObjectContent)this.objectContentsListModel.getElementAt(oldIndex)).getId();
        }
        this.populateList();
        int newIndex = -1;
        int i = 0;
        while (i < this.objectContentsListModel.size()) {
            if (((HiObjectContent)this.objectContentsListModel.elementAt(i)).getId() == oldId) {
                newIndex = i;
            }
            ++i;
        }
        if (newIndex >= 0) {
            this.objectContentsList.setSelectedIndex(newIndex);
        } else if (this.objectContentsListModel.size() > 0) {
            newIndex = Math.min(oldIndex, this.objectContentsListModel.size() - 1);
            this.objectContentsList.setSelectedIndex(newIndex);
        }
        if (this.objectContentsListModel.size() > 0) {
            this.listScroll.getViewport().setViewPosition(this.objectContentsList.indexToLocation(this.objectContentsList.getSelectedIndex()));
        }
    }

    public String getSortOrder() {
        String sortOrder = "";
        int index = 0;
        while (index < this.objectContentsListModel.size()) {
            sortOrder = String.valueOf(sortOrder) + "," + ((HiObjectContent)this.objectContentsListModel.get(index)).getId();
            ++index;
        }
        if (sortOrder.length() > 0) {
            sortOrder = sortOrder.substring(1);
        }
        return sortOrder;
    }

    private void sortObjectContent() {
        int index = 0;
        String[] stringArray = this.object.getSortOrder().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long contentID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < this.objectContentsListModel.size()) {
                    if (((HiObjectContent)this.objectContentsListModel.get(i)).getId() == contentID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiObjectContent content = (HiObjectContent)this.objectContentsListModel.get(contentIndex);
                        this.objectContentsListModel.remove(contentIndex);
                        this.object.getViews().remove(contentIndex);
                        this.objectContentsListModel.add(index, content);
                        this.object.getViews().add(index, content);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void showDefaultPopupMenu() {
        this.setPopupMenuState();
        this.popupMenu.show(this, this.objectContentsControlPanel.getLocation().x + 30, this.objectContentsControlPanel.getLocation().y + 20);
    }

    public void setMenuActionListener(ActionListener listener) {
        this.defaultViewToggleMenuItem.addActionListener(listener);
        this.newInscriptionMenuItem.addActionListener(listener);
        this.moveViewToTrashMenuItem.addActionListener(listener);
    }

    public void disablePopup() {
        this.objectContentsList.removeMouseListener(this);
    }

    private void populatePopupMenu() {
        this.popupMenu.add(this.defaultViewToggleMenuItem);
        this.popupMenu.add(this.newInscriptionMenuItem);
        this.popupMenu.add(new JSeparator());
        this.popupMenu.add(this.moveViewToTrashMenuItem);
    }

    private void setPopupMenuState() {
        boolean optionsEnabled = true;
        if (this.objectContentsListModel.size() == 0) {
            optionsEnabled = false;
        }
        this.defaultViewToggleMenuItem.setEnabled(optionsEnabled);
        this.moveViewToTrashMenuItem.setEnabled(optionsEnabled);
        if (this.object.getDefaultView() == null) {
            this.defaultViewToggleMenuItem.setSelected(false);
        } else if (this.object.getDefaultView().getId() == ((HiObjectContent)this.objectContentsListModel.get(this.objectContentsList.getSelectedIndex())).getId()) {
            this.defaultViewToggleMenuItem.setSelected(true);
        } else {
            this.defaultViewToggleMenuItem.setSelected(false);
        }
    }

    private void populateList() {
        this.objectContentsListModel.removeAllElements();
        for (HiObjectContent content : this.object.getViews()) {
            this.objectContentsListModel.addElement(content);
        }
        if (this.objectContentsListModel.size() > 0) {
            if (this.object.getDefaultView() == null) {
                this.setSelectedIndex(0);
            } else {
                HiObjectContent defView = this.object.getDefaultView();
                for (HiObjectContent content : this.object.getViews()) {
                    if (defView.getId() != content.getId()) continue;
                    defView = content;
                }
                this.setSelectedIndex(this.objectContentsListModel.indexOf(defView));
                this.listScroll.getViewport().setViewPosition(this.objectContentsList.indexToLocation(this.objectContentsList.getSelectedIndex()));
            }
        }
    }

    public void updateViewCount() {
        switch (this.object.getViews().size()) {
            case 0: {
                this.viewCountLabel.setText(Messages.getString("ObjectContentsListView.8"));
                break;
            }
            case 1: {
                this.viewCountLabel.setText(Messages.getString("ObjectContentsListView.9"));
                break;
            }
            default: {
                this.viewCountLabel.setText(String.valueOf(this.object.getViews().size()) + " " + Messages.getString("ObjectContentsListView.11"));
            }
        }
    }

    private void initComponents() {
        this.objectContentsPanel = new JPanel();
        this.listScroll = new JScrollPane();
        this.objectContentsList = new JList();
        this.objectContentsControlPanel = new JPanel();
        this.optionsButton = new OptionButton();
        this.viewCountLabel = new JLabel();
        this.objectContentsList.setSelectionMode(0);
        this.objectContentsList.setLayoutOrientation(2);
        this.objectContentsList.setVisibleRowCount(-1);
        this.listScroll.setViewportView(this.objectContentsList);
        GroupLayout obectContentsControlPanelLayout = new GroupLayout(this.objectContentsControlPanel);
        this.objectContentsControlPanel.setLayout(obectContentsControlPanelLayout);
        obectContentsControlPanelLayout.setHorizontalGroup(obectContentsControlPanelLayout.createParallelGroup(1).add(obectContentsControlPanelLayout.createSequentialGroup().add(this.optionsButton, -2, -1, -2).addPreferredGap(1).add(this.viewCountLabel).addContainerGap(42, Short.MAX_VALUE)));
        obectContentsControlPanelLayout.setVerticalGroup(obectContentsControlPanelLayout.createParallelGroup(1).add(obectContentsControlPanelLayout.createParallelGroup(3).add(this.optionsButton, -2, -1, -2).add(this.viewCountLabel)));
        GroupLayout objectContentsPanelLayout = new GroupLayout(this.objectContentsPanel);
        this.objectContentsPanel.setLayout(objectContentsPanelLayout);
        objectContentsPanelLayout.setHorizontalGroup(objectContentsPanelLayout.createParallelGroup(1).add(2, objectContentsPanelLayout.createSequentialGroup().addContainerGap().add(objectContentsPanelLayout.createParallelGroup(2).add(1, this.objectContentsControlPanel, -1, -1, Short.MAX_VALUE).add(1, this.listScroll, -1, 160, Short.MAX_VALUE)).addContainerGap()));
        objectContentsPanelLayout.setVerticalGroup(objectContentsPanelLayout.createParallelGroup(1).add(2, objectContentsPanelLayout.createSequentialGroup().addContainerGap().add(this.listScroll, -1, 280, Short.MAX_VALUE).addPreferredGap(0).add(this.objectContentsControlPanel, -2, -1, -2).addContainerGap()));
        this.objectContentsListModel = new DefaultListModel();
        this.objectContentsList.setModel(this.objectContentsListModel);
        this.objectContentsRenderer = new ObjectContentsCellRenderer(this.object, this.defaultLang);
        this.objectContentsList.setCellRenderer(this.objectContentsRenderer);
        this.objectContentsList.setBackground(Color.lightGray);
        this.popupMenu = new JPopupMenu();
        this.defaultViewToggleMenuItem = new JCheckBoxMenuItem();
        this.defaultViewToggleMenuItem.setActionCommand("defaultView");
        this.newInscriptionMenuItem = new JMenuItem();
        this.newInscriptionMenuItem.setActionCommand("newInscription");
        this.newInscriptionMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/create-menu.png")));
        this.moveViewToTrashMenuItem = new JMenuItem();
        this.moveViewToTrashMenuItem.setActionCommand("moveToTrash");
        this.moveViewToTrashMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/trashcan-icon.png")));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            e.consume();
            this.setPopupMenuState();
            this.popupMenu.show(this, e.getX() - this.listScroll.getViewport().getViewPosition().x + 20, e.getY() - this.listScroll.getViewport().getViewPosition().y + 15);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed() && e.isPopupTrigger()) {
            this.setPopupMenuState();
            this.popupMenu.show(this, e.getX() - this.listScroll.getViewport().getViewPosition().x + 20, e.getY() - this.listScroll.getViewport().getViewPosition().y + 15);
        }
    }
}

