/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.lists.ColorListCellRenderer;
import org.hyperimage.client.gui.lists.PolygonListCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.jdesktop.layout.GroupLayout;

public class PreferenceManagerView
extends GUIView
implements ListSelectionListener {
    private static final long serialVersionUID = -3293942365001635163L;
    private JLabel addInfoLabel;
    private JPanel buttonPanel;
    private JList colorPrefList;
    private JPanel colorPrefPanel;
    private JScrollPane colorPrefScroll;
    private JButton editButton;
    private JPanel managerPanel;
    private JList polygonPrefList;
    private JPanel polygonPrefPanel;
    private JScrollPane polygonPrefScroll;
    private JButton removeButton;
    private JLabel removeInfoLabel;
    private TitledBorder polygonPrefBorder;
    private TitledBorder colorPrefBorder;
    private DefaultListModel polygonModel;
    private DefaultListModel colorModel;
    private int[] emptySelection = new int[0];

    public PreferenceManagerView() {
        super(Messages.getString("PreferenceManagerView.0"));
        this.initComponents();
        this.setDisplayPanel(this.managerPanel);
        this.polygonPrefList.addListSelectionListener(this);
        this.colorPrefList.addListSelectionListener(this);
    }

    @Override
    public void updateLanguage() {
        super.setTitle(Messages.getString("PreferenceManagerView.0"));
        this.polygonPrefBorder.setTitle(Messages.getString("PreferenceManagerView.1"));
        this.colorPrefBorder.setTitle(Messages.getString("PreferenceManagerView.3"));
        this.addInfoLabel.setText("<html>" + Messages.getString("PreferenceManagerView.6") + "</html>");
        this.editButton.setText(Messages.getString("PreferenceManagerView.8"));
        this.removeInfoLabel.setText("<html><b>" + Messages.getString("PreferenceManagerView.11") + ":</b><br><br>" + Messages.getString("PreferenceManagerView.13") + "</html>");
        this.removeButton.setText(Messages.getString("PreferenceManagerView.15"));
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JButton getEdiButton() {
        return this.editButton;
    }

    public JList getPolygonPrefList() {
        return this.polygonPrefList;
    }

    public JList getColorPrefList() {
        return this.colorPrefList;
    }

    public void rebuildPreferenceLists(Vector<String> projectPolygons, Vector<Color> projectColors) {
        this.polygonModel.removeAllElements();
        this.colorModel.removeAllElements();
        ((PolygonListCellRenderer)this.polygonPrefList.getCellRenderer()).clearCache();
        for (String model : projectPolygons) {
            this.polygonModel.addElement(model);
        }
        for (Color color : projectColors) {
            this.colorModel.addElement(color);
        }
    }

    private void initComponents() {
        this.managerPanel = new JPanel();
        this.polygonPrefPanel = new JPanel();
        this.polygonPrefScroll = new JScrollPane();
        this.polygonPrefList = new JList();
        this.colorPrefPanel = new JPanel();
        this.colorPrefScroll = new JScrollPane();
        this.colorPrefList = new JList();
        this.addInfoLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.editButton = new JButton();
        this.removeInfoLabel = new JLabel();
        this.removeButton = new JButton();
        this.polygonPrefBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("PreferenceManagerView.1"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.polygonPrefPanel.setBorder(this.polygonPrefBorder);
        this.polygonPrefList.setSelectionMode(0);
        this.polygonPrefList.setLayoutOrientation(2);
        this.polygonPrefList.setVisibleRowCount(-1);
        this.polygonPrefScroll.setViewportView(this.polygonPrefList);
        GroupLayout polygonPrefPanelLayout = new GroupLayout(this.polygonPrefPanel);
        this.polygonPrefPanel.setLayout(polygonPrefPanelLayout);
        polygonPrefPanelLayout.setHorizontalGroup(polygonPrefPanelLayout.createParallelGroup(1).add(this.polygonPrefScroll, -1, 163, Short.MAX_VALUE));
        polygonPrefPanelLayout.setVerticalGroup(polygonPrefPanelLayout.createParallelGroup(1).add(this.polygonPrefScroll, -1, 232, Short.MAX_VALUE));
        this.colorPrefBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("PreferenceManagerView.3"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.colorPrefPanel.setBorder(this.colorPrefBorder);
        this.colorPrefList.setSelectionMode(0);
        this.colorPrefScroll.setViewportView(this.colorPrefList);
        GroupLayout colorPrefPanelLayout = new GroupLayout(this.colorPrefPanel);
        this.colorPrefPanel.setLayout(colorPrefPanelLayout);
        colorPrefPanelLayout.setHorizontalGroup(colorPrefPanelLayout.createParallelGroup(1).add(this.colorPrefScroll, -1, 176, Short.MAX_VALUE));
        colorPrefPanelLayout.setVerticalGroup(colorPrefPanelLayout.createParallelGroup(1).add(this.colorPrefScroll, -1, 232, Short.MAX_VALUE));
        this.editButton.setActionCommand("edit");
        this.editButton.setEnabled(false);
        this.removeInfoLabel.setVerticalAlignment(3);
        this.removeButton.setActionCommand("remove");
        this.removeButton.setEnabled(false);
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(1).add(buttonPanelLayout.createSequentialGroup().add(this.editButton, -1, 188, Short.MAX_VALUE).addContainerGap()).add(2, buttonPanelLayout.createSequentialGroup().add(this.removeButton, -1, 188, Short.MAX_VALUE).addContainerGap()).add(this.removeInfoLabel, -1, 205, Short.MAX_VALUE));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(1).add(buttonPanelLayout.createSequentialGroup().add(this.editButton).addPreferredGap(0).add(this.removeInfoLabel, -1, 186, Short.MAX_VALUE).addPreferredGap(0).add(this.removeButton)));
        GroupLayout managerPanelLayout = new GroupLayout(this.managerPanel);
        this.managerPanel.setLayout(managerPanelLayout);
        managerPanelLayout.setHorizontalGroup(managerPanelLayout.createParallelGroup(1).add(managerPanelLayout.createSequentialGroup().addContainerGap().add(managerPanelLayout.createParallelGroup(2).add(1, this.addInfoLabel, 0, 0, Short.MAX_VALUE).add(1, managerPanelLayout.createSequentialGroup().add(this.polygonPrefPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add(this.colorPrefPanel, -2, -1, -2))).addPreferredGap(0).add(this.buttonPanel, -2, -1, -2).addContainerGap()));
        managerPanelLayout.setVerticalGroup(managerPanelLayout.createParallelGroup(1).add(2, managerPanelLayout.createSequentialGroup().addContainerGap().add(managerPanelLayout.createParallelGroup(2).add(1, this.buttonPanel, -1, -1, Short.MAX_VALUE).add(1, this.colorPrefPanel, -1, -1, Short.MAX_VALUE).add(1, this.polygonPrefPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(this.addInfoLabel).addContainerGap()));
        this.polygonModel = new DefaultListModel();
        this.polygonPrefList.setModel(this.polygonModel);
        this.polygonPrefList.setSelectionMode(0);
        this.polygonPrefList.setCellRenderer(new PolygonListCellRenderer(this.polygonPrefList));
        this.colorModel = new DefaultListModel();
        this.colorPrefList.setModel(this.colorModel);
        this.colorPrefList.setSelectionMode(0);
        this.colorPrefList.setCellRenderer(new ColorListCellRenderer(HIRuntime.getManager().getProjectColors(), null));
        this.updateLanguage();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.polygonPrefList.getSelectedIndex() >= 0 && this.colorPrefList.getSelectedIndex() >= 0) {
            if (e.getSource() == this.polygonPrefList) {
                this.colorPrefList.setSelectedIndices(this.emptySelection);
            } else {
                this.polygonPrefList.setSelectedIndices(this.emptySelection);
            }
        }
        this.editButton.setEnabled(this.colorPrefList.getSelectedIndex() >= 0);
        this.removeButton.setEnabled(this.polygonPrefList.getSelectedIndex() >= 0 || this.colorPrefList.getSelectedIndex() >= 0);
    }
}

