/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.ProjectSettings;
import org.hyperimage.client.gui.ResetButton;
import org.hyperimage.client.gui.SaveButton;
import org.hyperimage.client.gui.lists.GroupContentsCellRenderer;
import org.hyperimage.client.gui.lists.LanguageListCellRenderer;
import org.hyperimage.client.gui.lists.QuickInfoCell;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiLanguage;
import org.hyperimage.client.ws.HiProjectMetadata;
import org.jdesktop.layout.GroupLayout;

public class ProjectSettingsView
extends GUIView
implements ActionListener {
    private static final long serialVersionUID = -8962637707426813845L;
    private JLabel availableLangLabel;
    private JList availableLangList;
    private JScrollPane avaliableLangScroll;
    private JComboBox defaultLangComboBox;
    private JLabel defaultLangLabel;
    private JPanel languagePanel;
    private JComboBox previewFieldComboBox;
    private JPanel previewFieldPanel;
    private JLabel projectLangLabel;
    private JList projectLangList;
    private JScrollPane projectLangScroll;
    private JPanel settingsPanel;
    private JPanel startElementPanel;
    private JList linkTargetList;
    private JLabel noLinkLabel;
    private ResetButton resetButton;
    private SaveButton saveButton;
    private JLabel titleLabel;
    private JTextField titleTextField;
    private JPanel metadataPanel;
    private JLabel languageLabel;
    private JComboBox languageComboBox;
    private JPanel quotaPanel;
    private JProgressBar quotaProgressBar;
    private Vector<String> titleMetadata = new Vector();
    private int curLangIndex = 0;
    private int defLangIndex = 0;
    private Vector<String> languageKeys = new Vector();
    private boolean hasChanges = false;
    private static final Border linkBorder = new LineBorder(Color.black, 1);
    private DefaultListModel availLangModel;
    private DefaultListModel projectLangModel;
    private DefaultComboBoxModel defaultLangModel;
    private DefaultComboBoxModel previewFieldComboBoxModel;

    public ProjectSettingsView() {
        this.initComponents();
        this.updateLanguage();
        this.setDisplayPanel(this.settingsPanel);
        this.availableLangList.setDragEnabled(true);
        this.availableLangList.setDropMode(DropMode.INSERT);
        this.projectLangList.setDragEnabled(true);
        this.projectLangList.setDropMode(DropMode.INSERT);
        this.linkTargetList.setDragEnabled(true);
        this.linkTargetList.setDropMode(DropMode.ON);
        this.fillLanguageLists();
        this.updateLanguageOptions();
        this.buildMetadataLanguages();
    }

    public String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return String.valueOf(bytes) + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf((si ? "kMGTPE" : "KMGTPE").charAt(exp - 1)) + (si ? "" : "i") + "B";
        String output = String.format("%.1f", (double)bytes / Math.pow(unit, exp));
        if (output.endsWith(".0") || output.endsWith(",0")) {
            output = output.substring(0, output.length() - 2);
        }
        return String.valueOf(output) + " " + pre;
    }

    public void updateQuotaInfo() {
        if (HIRuntime.getManager().getProject().getQuota() == 0L) {
            this.quotaProgressBar.setValue(0);
            this.quotaProgressBar.setString(String.valueOf(Messages.getString("ProjectSettingsView.used")) + ": " + this.humanReadableByteCount(HIRuntime.getManager().getProject().getUsed(), false));
        } else {
            this.quotaProgressBar.setValue(Math.min(100, (int)Math.round(100.0 * (double)HIRuntime.getManager().getProject().getUsed() / (double)HIRuntime.getManager().getProject().getQuota())));
            this.quotaProgressBar.setString(String.valueOf(this.humanReadableByteCount(HIRuntime.getManager().getProject().getUsed(), false)) + " / " + this.humanReadableByteCount(HIRuntime.getManager().getProject().getQuota(), false));
        }
    }

    public String getSelectedPreviewField() {
        return (String)this.previewFieldComboBoxModel.getSelectedItem();
    }

    public JComboBox getPreviewFieldComboBox() {
        return this.previewFieldComboBox;
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("ProjectSettingsView.0"));
        this.noLinkLabel.setText("<html><center><b>" + Messages.getString("ProjectSettingsView.2") + "</b><br><br>" + Messages.getString("ProjectSettingsView.4") + "</center></html>");
        ((TitledBorder)this.metadataPanel.getBorder()).setTitle(Messages.getString("ProjectSettingsView.1"));
        this.metadataPanel.repaint();
        String quotaTitle = Messages.getString("ProjectSettingsView.noquota");
        if (HIRuntime.getManager().getProject().getQuota() > 0L) {
            quotaTitle = Messages.getString("ProjectSettingsView.quota");
        }
        ((TitledBorder)this.quotaPanel.getBorder()).setTitle(quotaTitle);
        ((TitledBorder)this.languagePanel.getBorder()).setTitle(Messages.getString("ProjectSettingsView.6"));
        this.languagePanel.repaint();
        ((TitledBorder)this.startElementPanel.getBorder()).setTitle(Messages.getString("ProjectSettingsView.7"));
        this.startElementPanel.repaint();
        ((TitledBorder)this.previewFieldPanel.getBorder()).setTitle(Messages.getString("ProjectSettingsView.8"));
        this.previewFieldPanel.repaint();
        this.availableLangLabel.setText(Messages.getString("ProjectSettingsView.9"));
        this.projectLangLabel.setText(Messages.getString("ProjectSettingsView.10"));
        this.defaultLangLabel.setText(Messages.getString("ProjectSettingsView.11"));
        this.languageLabel.setText(Messages.getString("MetadataEditorControl.18"));
        this.titleLabel.setText(Messages.getString("ProjectSettingsView.3"));
        this.saveButton.setToolTipText(Messages.getString("ProjectSettingsView.5"));
        this.resetButton.setToolTipText(Messages.getString("ProjectSettingsView.12"));
        this.updateQuotaInfo();
    }

    public boolean hasChanges() {
        this.syncToBuffer();
        if (!this.hasChanges && this.entryModified()) {
            this.hasChanges = true;
        }
        return this.hasChanges;
    }

    public void syncChanges() {
        if (this.hasChanges()) {
            int i = 0;
            while (i < this.languageKeys.size()) {
                MetadataHelper.setValue(HIRuntime.getManager().getProject(), this.languageKeys.get(i), this.titleMetadata.get(i));
                ++i;
            }
            this.hasChanges = false;
        }
    }

    public void resetChanges() {
        int i = 0;
        while (i < this.languageKeys.size()) {
            this.titleMetadata.setElementAt(MetadataHelper.findValue(HIRuntime.getManager().getProject(), this.languageKeys.get(i)), i);
            ++i;
        }
        this.hasChanges = false;
        this.setMetadataFields();
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getResetButton() {
        return this.resetButton;
    }

    public JList getStartElementList() {
        return this.linkTargetList;
    }

    public QuickInfoCell getElementLinkPreview() {
        if (HIRuntime.getManager().getProject().getStartObjectInfo() == null) {
            return null;
        }
        GroupContentsCellRenderer renderer = (GroupContentsCellRenderer)this.linkTargetList.getCellRenderer();
        return renderer.getCellForContent(HIRuntime.getManager().getProject().getStartObjectInfo());
    }

    public void updateStartElementLink() {
        DefaultListModel model = (DefaultListModel)this.linkTargetList.getModel();
        model.removeAllElements();
        GroupContentsCellRenderer renderer = (GroupContentsCellRenderer)this.linkTargetList.getCellRenderer();
        renderer.clearCache();
        if (HIRuntime.getManager().getProject().getStartObjectInfo() != null) {
            model.addElement(HIRuntime.getManager().getProject().getStartObjectInfo());
            if (this.getElementLinkPreview() != null) {
                this.getElementLinkPreview().setBorder(new EmptyBorder(0, 0, 0, 0));
            }
            this.linkTargetList.setVisible(true);
            this.noLinkLabel.setVisible(false);
        } else {
            this.linkTargetList.setVisible(false);
            this.noLinkLabel.setVisible(true);
        }
        this.linkTargetList.repaint();
    }

    public void setLinkTransferHandler(ProjectSettings.LinkTransferHandler linkTransferHandler) {
        this.linkTargetList.setTransferHandler(linkTransferHandler);
        this.noLinkLabel.setTransferHandler(linkTransferHandler);
    }

    public JComboBox getDefaultLangComboBox() {
        return this.defaultLangComboBox;
    }

    public JList getAvailableLangList() {
        return this.availableLangList;
    }

    public JList getProjectLangList() {
        return this.projectLangList;
    }

    public void updateLanguageOptions() {
        this.defaultLangModel.removeAllElements();
        int i = 0;
        while (i < this.projectLangModel.size()) {
            this.defaultLangModel.addElement(this.projectLangModel.get(i));
            ++i;
        }
        this.defaultLangComboBox.setSelectedItem(MetadataHelper.langToLocale(HIRuntime.getManager().getProject().getDefaultLanguage()));
        this.buildMetadataLanguages();
    }

    private void setMetadataFields() {
        this.titleTextField.setText(this.titleMetadata.elementAt(this.curLangIndex));
    }

    private boolean entryModified() {
        int i = 0;
        while (i < this.languageKeys.size()) {
            if (this.titleMetadata.get(i).compareTo(MetadataHelper.findValue(HIRuntime.getManager().getProject(), this.languageKeys.get(i))) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void syncToBuffer() {
        this.titleMetadata.setElementAt(this.titleTextField.getText(), this.curLangIndex);
    }

    private void buildMetadataLanguages() {
        this.languageComboBox.removeActionListener(this);
        this.languageKeys.removeAllElements();
        this.languageComboBox.removeAllItems();
        for (HiProjectMetadata record : HIRuntime.getManager().getProject().getMetadata()) {
            this.languageKeys.addElement(record.getLanguageID());
            if (record.getLanguageID().compareTo(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()) == 0) {
                this.defLangIndex = this.languageKeys.size() - 1;
            }
            this.languageComboBox.addItem(MetadataHelper.langToLocale(record.getLanguageID()).getDisplayLanguage());
        }
        if (this.languageComboBox.getModel().getSize() > this.defLangIndex) {
            this.languageComboBox.setSelectedIndex(this.defLangIndex);
        }
        this.curLangIndex = this.defLangIndex;
        this.languageComboBox.addActionListener(this);
        this.titleMetadata.removeAllElements();
        for (String lang : this.languageKeys) {
            this.titleMetadata.addElement(MetadataHelper.findValue(HIRuntime.getManager().getProject(), lang));
        }
        this.setMetadataFields();
        this.hasChanges = false;
    }

    private void fillLanguageLists() {
        this.availLangModel.removeAllElements();
        this.projectLangModel.removeAllElements();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale lang = localeArray[n2];
            if (lang.getVariant().length() == 0 && (lang.getCountry().length() <= 0 || lang.getCountry().equalsIgnoreCase(lang.getLanguage())) && !this.availLangModel.contains(new Locale(lang.getLanguage()))) {
                this.availLangModel.addElement(new Locale(lang.getLanguage()));
            }
            ++n2;
        }
        for (HiLanguage hiLang : HIRuntime.getManager().getProject().getLanguages()) {
            int removeIndex = this.availLangModel.indexOf(MetadataHelper.langToLocale(hiLang));
            if (removeIndex >= 0) {
                this.availLangModel.remove(removeIndex);
            }
            this.projectLangModel.addElement(MetadataHelper.langToLocale(hiLang));
        }
    }

    private void initComponents() {
        this.noLinkLabel = new JLabel();
        this.noLinkLabel.setSize(136, 171);
        this.noLinkLabel.setPreferredSize(new Dimension(134, 169));
        this.noLinkLabel.setBackground(Color.white);
        this.noLinkLabel.setOpaque(true);
        this.noLinkLabel.setBorder(linkBorder);
        this.settingsPanel = new JPanel();
        this.quotaPanel = new JPanel();
        this.quotaProgressBar = new JProgressBar();
        this.metadataPanel = new JPanel();
        this.languageLabel = new JLabel();
        this.languageComboBox = new JComboBox();
        this.titleTextField = new JTextField();
        this.titleLabel = new JLabel();
        this.saveButton = new SaveButton();
        this.resetButton = new ResetButton();
        this.languagePanel = new JPanel();
        this.availableLangLabel = new JLabel();
        this.projectLangLabel = new JLabel();
        this.avaliableLangScroll = new JScrollPane();
        this.availableLangList = new JList();
        this.projectLangScroll = new JScrollPane();
        this.projectLangList = new JList();
        this.defaultLangLabel = new JLabel();
        this.defaultLangComboBox = new JComboBox();
        this.startElementPanel = new JPanel();
        this.previewFieldPanel = new JPanel();
        this.previewFieldComboBox = new JComboBox();
        this.quotaPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, null, Color.blue));
        this.quotaProgressBar.setMaximum(100);
        this.quotaProgressBar.setStringPainted(true);
        GroupLayout quotaPanelLayout = new GroupLayout(this.quotaPanel);
        this.quotaPanel.setLayout(quotaPanelLayout);
        quotaPanelLayout.setHorizontalGroup(quotaPanelLayout.createParallelGroup(1).add(quotaPanelLayout.createSequentialGroup().addContainerGap().add(this.quotaProgressBar, -1, -1, Short.MAX_VALUE).addContainerGap()));
        quotaPanelLayout.setVerticalGroup(quotaPanelLayout.createParallelGroup(1).add(quotaPanelLayout.createSequentialGroup().addContainerGap().add(this.quotaProgressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.metadataPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue));
        this.languageLabel.setText(Messages.getString("MetadataEditorControl.18"));
        GroupLayout metadataPanelLayout = new GroupLayout(this.metadataPanel);
        this.metadataPanel.setLayout(metadataPanelLayout);
        metadataPanelLayout.setHorizontalGroup(metadataPanelLayout.createParallelGroup(1).add(metadataPanelLayout.createSequentialGroup().addContainerGap().add(metadataPanelLayout.createParallelGroup(2).add(metadataPanelLayout.createSequentialGroup().add(this.resetButton, -2, -1, -2).addPreferredGap(0).add(this.saveButton, -2, -1, -2)).add(1, metadataPanelLayout.createSequentialGroup().add(this.titleLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(this.languageLabel).addPreferredGap(0).add(this.languageComboBox, -2, 187, -2)).add(this.titleTextField)).addContainerGap()));
        metadataPanelLayout.setVerticalGroup(metadataPanelLayout.createParallelGroup(1).add(metadataPanelLayout.createSequentialGroup().add(metadataPanelLayout.createParallelGroup(1).add(metadataPanelLayout.createParallelGroup(3).add(this.languageComboBox, -2, -1, -2).add(this.languageLabel)).add(metadataPanelLayout.createSequentialGroup().add(14, 14, 14).add(this.titleLabel))).addPreferredGap(0).add(this.titleTextField, -2, -1, -2).addPreferredGap(0).add(metadataPanelLayout.createParallelGroup(3).add(this.saveButton, -2, -1, -2).add(this.resetButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.languagePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue));
        this.avaliableLangScroll.setViewportView(this.availableLangList);
        this.projectLangScroll.setViewportView(this.projectLangList);
        GroupLayout languagePanelLayout = new GroupLayout(this.languagePanel);
        this.languagePanel.setLayout(languagePanelLayout);
        languagePanelLayout.setHorizontalGroup(languagePanelLayout.createParallelGroup(1).add(2, languagePanelLayout.createSequentialGroup().addContainerGap().add(languagePanelLayout.createParallelGroup(1).add(this.avaliableLangScroll, -2, 0, Short.MAX_VALUE).add(this.availableLangLabel, -1, 160, Short.MAX_VALUE)).add(30, 30, 30).add(languagePanelLayout.createParallelGroup(2).add(1, this.defaultLangComboBox, 0, -1, Short.MAX_VALUE).add(1, this.defaultLangLabel, -1, 136, Short.MAX_VALUE).add(1, this.projectLangScroll, -2, 0, Short.MAX_VALUE).add(1, this.projectLangLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        languagePanelLayout.setVerticalGroup(languagePanelLayout.createParallelGroup(1).add(languagePanelLayout.createSequentialGroup().add(languagePanelLayout.createParallelGroup(3).add(this.availableLangLabel).add(this.projectLangLabel)).addPreferredGap(0).add(languagePanelLayout.createParallelGroup(1).add(languagePanelLayout.createSequentialGroup().add(this.projectLangScroll).addPreferredGap(0).add(this.defaultLangLabel, -2, 16, -2).addPreferredGap(0).add(this.defaultLangComboBox, -2, 27, -2)).add(this.avaliableLangScroll)).addContainerGap()));
        this.startElementPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue));
        this.startElementPanel.setPreferredSize(new Dimension(150, 210));
        this.previewFieldPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue));
        GroupLayout previewFieldPanelLayout = new GroupLayout(this.previewFieldPanel);
        this.previewFieldPanel.setLayout(previewFieldPanelLayout);
        previewFieldPanelLayout.setHorizontalGroup(previewFieldPanelLayout.createParallelGroup(1).add(this.previewFieldComboBox, 0, 144, Short.MAX_VALUE));
        previewFieldPanelLayout.setVerticalGroup(previewFieldPanelLayout.createParallelGroup(1).add(previewFieldPanelLayout.createSequentialGroup().add(this.previewFieldComboBox, -1, 27, Short.MAX_VALUE).addContainerGap()));
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(1).add(2, settingsPanelLayout.createSequentialGroup().addContainerGap().add(settingsPanelLayout.createParallelGroup(2).add(this.metadataPanel, -1, -1, Short.MAX_VALUE).add(settingsPanelLayout.createSequentialGroup().add(settingsPanelLayout.createParallelGroup(1).add(this.previewFieldPanel, -1, -1, Short.MAX_VALUE).add(settingsPanelLayout.createSequentialGroup().add(this.startElementPanel, -2, 142, -2).add(0, 0, Short.MAX_VALUE)).add(this.quotaPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add(this.languagePanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(1).add(settingsPanelLayout.createSequentialGroup().add(8, 8, 8).add(this.metadataPanel, -2, -1, -2).addPreferredGap(0).add(settingsPanelLayout.createParallelGroup(1).add(settingsPanelLayout.createSequentialGroup().add(this.startElementPanel, -2, -1, -2).addPreferredGap(1).add(this.previewFieldPanel, -2, -1, -2).addPreferredGap(0).add(this.quotaPanel, -2, -1, -2).add(0, 67, Short.MAX_VALUE)).add(settingsPanelLayout.createSequentialGroup().add(this.languagePanel, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        this.linkTargetList = new JList();
        this.availLangModel = new DefaultListModel();
        this.availableLangList.setModel(this.availLangModel);
        this.availableLangList.setCellRenderer(new LanguageListCellRenderer());
        this.availableLangList.setSelectionMode(0);
        this.projectLangModel = new DefaultListModel();
        this.projectLangList.setModel(this.projectLangModel);
        this.projectLangList.setCellRenderer(new LanguageListCellRenderer());
        this.projectLangList.setSelectionMode(0);
        this.defaultLangModel = new DefaultComboBoxModel();
        this.defaultLangComboBox.setModel(this.defaultLangModel);
        this.defaultLangComboBox.setRenderer(new LanguageListCellRenderer());
        this.startElementPanel.add(this.linkTargetList);
        this.startElementPanel.add(this.noLinkLabel);
        GroupContentsCellRenderer renderer = new GroupContentsCellRenderer();
        renderer.setLayout(new FlowLayout(1, 0, 0));
        this.linkTargetList.setCellRenderer(renderer);
        this.linkTargetList.setModel(new DefaultListModel());
        this.linkTargetList.setPreferredSize(new Dimension(132, 166));
        this.linkTargetList.setBackground(this.startElementPanel.getBackground());
        this.linkTargetList.setBorder(linkBorder);
        this.linkTargetList.setVisible(false);
        this.previewFieldComboBoxModel = new DefaultComboBoxModel();
        this.previewFieldComboBox.setModel(this.previewFieldComboBoxModel);
        for (HiFlexMetadataTemplate template : HIRuntime.getManager().getProject().getTemplates()) {
            if (template.getNamespacePrefix().compareTo("HIBase") == 0) continue;
            for (HiFlexMetadataSet entry : template.getEntries()) {
                if (entry.isRichText()) continue;
                this.previewFieldComboBoxModel.addElement(String.valueOf(template.getNamespacePrefix()) + "." + entry.getTagname());
            }
        }
        int index = -1;
        if (MetadataHelper.findPreference(HIRuntime.getManager().getProject(), "admin.preview.objectTitleField") != null) {
            index = this.previewFieldComboBoxModel.getIndexOf(MetadataHelper.findPreference(HIRuntime.getManager().getProject(), "admin.preview.objectTitleField").getValue());
        }
        this.previewFieldComboBox.setSelectedIndex(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.languageKeys.size() > 0) {
            this.hasChanges();
            this.syncToBuffer();
            this.curLangIndex = this.languageComboBox.getSelectedIndex();
            this.setMetadataFields();
        }
    }
}

