/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.model.HIRepository;
import org.hyperimage.client.ws.HiRepository;
import org.jdesktop.layout.GroupLayout;

public class RepositoryBrowserView
extends GUIView {
    private static final long serialVersionUID = 3456992248005430602L;
    private JPanel browserPanel;
    private JButton addButton;
    private JPanel browserTreePanel;
    private JPanel controlPanel;
    private JButton removeButton;
    private JScrollPane repoTreeScroll;
    private JTree repositoryTree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode rootNode;
    private Vector<HIRepository> repositories;

    public RepositoryBrowserView(List<HiRepository> modelRepositories) {
        super(Messages.getString("RepositoryBrowserView.0"));
        this.initComponents();
        this.setDisplayPanel(this.browserPanel);
        this.repositories = new Vector();
        for (HiRepository repository : modelRepositories) {
            HIRepository rep = new HIRepository(repository);
            this.repositories.addElement(rep);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(rep), this.rootNode, 0);
        }
    }

    public void addRepository(HiRepository repos) {
        HIRepository rep = new HIRepository(repos);
        this.repositories.addElement(rep);
        this.treeModel.insertNodeInto(new DefaultMutableTreeNode(rep), this.rootNode, this.repositories.size() - 1);
    }

    public void removeRepository(HIRepository repos) {
        int index = this.repositories.indexOf(repos);
        if (index < 0) {
            return;
        }
        ((DefaultMutableTreeNode)this.treeModel.getRoot()).removeAllChildren();
        this.repositories.remove(repos);
        for (HIRepository rep : this.repositories) {
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(rep), this.rootNode, 0);
        }
        this.treeModel.reload();
        this.repositoryTree.repaint();
    }

    public JTree getRepositoryTree() {
        return this.repositoryTree;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public Vector<HIRepository> getRepositories() {
        return this.repositories;
    }

    public void setSelectedIndex(int index) {
        if (index >= this.repositories.size()) {
            return;
        }
        if (index < 0) {
            this.repositoryTree.setSelectionPath(null);
            return;
        }
        Object[] pathToRep = new DefaultMutableTreeNode[]{this.rootNode, (DefaultMutableTreeNode)this.treeModel.getChild(null, index)};
        TreePath path = new TreePath(pathToRep);
        this.repositoryTree.setSelectionPath(path);
    }

    public int getSelectedIndex() {
        if (this.repositoryTree.getSelectionPath() == null) {
            return -1;
        }
        int i = 0;
        while (i < this.repositories.size()) {
            if (((DefaultMutableTreeNode)this.repositoryTree.getSelectionPath().getPath()[1]).getUserObject() == this.repositories.get(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    private void initComponents() {
        this.browserPanel = new JPanel();
        this.browserTreePanel = new JPanel();
        this.repoTreeScroll = new JScrollPane();
        this.repositoryTree = new JTree();
        this.controlPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.repoTreeScroll.setViewportView(this.repositoryTree);
        GroupLayout browserTreePanelLayout = new GroupLayout(this.browserTreePanel);
        this.browserTreePanel.setLayout(browserTreePanelLayout);
        browserTreePanelLayout.setHorizontalGroup(browserTreePanelLayout.createParallelGroup(1).add(this.repoTreeScroll, -1, 150, Short.MAX_VALUE));
        browserTreePanelLayout.setVerticalGroup(browserTreePanelLayout.createParallelGroup(1).add(this.repoTreeScroll, -1, 300, Short.MAX_VALUE));
        this.addButton.setActionCommand("addRep");
        this.addButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addButton.setPreferredSize(new Dimension(24, 24));
        this.removeButton.setActionCommand("removeRep");
        this.removeButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.removeButton.setPreferredSize(new Dimension(24, 24));
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(1).add(controlPanelLayout.createSequentialGroup().add(this.addButton, -2, -1, -2).addPreferredGap(0).add(this.removeButton, -2, -1, -2).addContainerGap(150, Short.MAX_VALUE)));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(1).add(controlPanelLayout.createParallelGroup(3).add(this.addButton, -2, -1, -2).add(this.removeButton, -2, -1, -2)));
        GroupLayout browserPanelLayout = new GroupLayout(this.browserPanel);
        this.browserPanel.setLayout(browserPanelLayout);
        browserPanelLayout.setHorizontalGroup(browserPanelLayout.createParallelGroup(1).add(browserPanelLayout.createSequentialGroup().addContainerGap().add(browserPanelLayout.createParallelGroup(1).add(2, this.browserTreePanel, -1, -1, Short.MAX_VALUE).add(2, this.controlPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        browserPanelLayout.setVerticalGroup(browserPanelLayout.createParallelGroup(1).add(2, browserPanelLayout.createSequentialGroup().addContainerGap().add(this.browserTreePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add(this.controlPanel, -2, -1, -2).addContainerGap()));
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add.png")));
        this.addButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-active.png")));
        this.addButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-disabled.png")));
        this.addButton.setToolTipText(Messages.getString("RepositoryBrowserView.3"));
        this.addButton.setEnabled(true);
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove.png")));
        this.removeButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-active.png")));
        this.removeButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-disabled.png")));
        this.removeButton.setToolTipText(Messages.getString("RepositoryBrowserView.4"));
        this.removeButton.setEnabled(false);
        this.rootNode = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.rootNode, true);
        this.repositoryTree.setModel(this.treeModel);
        this.repositoryTree.setRootVisible(false);
        this.repositoryTree.setScrollsOnExpand(true);
        this.repositoryTree.getSelectionModel().setSelectionMode(1);
    }
}

