/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiLanguage;
import org.jdesktop.layout.GroupLayout;

public class SearchView
extends GUIView
implements DocumentListener {
    private static final long serialVersionUID = 1955083116920356788L;
    private JComboBox fieldComboBox;
    private JPanel fieldSearchPanel;
    private JTextField fieldSearchTextField;
    private JComboBox languageComboBox;
    private JLabel languageLabel;
    private JLabel notImplementedLabel;
    private JButton searchButton;
    private JPanel searchFieldPanel;
    private JPanel searchPanel;
    private TitledBorder searchFieldBorder;
    private TitledBorder fieldSearchBorder;
    private JTextField searchTextField;
    private int defLangIndex = 0;
    private String defLang;
    private Vector<String> languageKeys;
    private Vector<String> fieldKeys;
    private List<HiLanguage> languages;

    public SearchView(List<HiLanguage> languages, HiLanguage defLanguage) {
        super(Messages.getString("SearchView.0"));
        this.initComponents();
        this.setDisplayPanel(this.searchPanel);
        this.defLang = defLanguage.getLanguageId();
        this.languages = languages;
        this.languageKeys = new Vector();
        this.fieldKeys = new Vector();
        this.buildLanguages();
        this.buildFields();
        this.searchTextField.getDocument().addDocumentListener(this);
        this.fieldSearchTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public void updateLanguage() {
        this.searchFieldBorder.setTitle(Messages.getString("SearchView.22"));
        this.fieldSearchBorder.setTitle(Messages.getString("SearchView.28"));
        this.languageLabel.setText(Messages.getString("SearchView.26"));
        this.notImplementedLabel.setText(Messages.getString("SearchView.27"));
        this.buildLanguages();
        this.buildFields();
        super.setTitle(Messages.getString("SearchView.0"));
    }

    public String getSearchText() {
        return this.searchTextField.getText();
    }

    public String getFieldSearchText() {
        return this.fieldSearchTextField.getText();
    }

    public String getSearchField() {
        return this.fieldKeys.get(this.fieldComboBox.getSelectedIndex());
    }

    public JComboBox getFieldComboBox() {
        return this.fieldComboBox;
    }

    public String getSelectedLanguage() {
        if (this.languageComboBox.getSelectedIndex() < this.languageKeys.size() - 1) {
            return this.languageKeys.get(this.languageComboBox.getSelectedIndex());
        }
        return "all";
    }

    public void setSearchEnabled(boolean enabled) {
        this.searchTextField.setEnabled(enabled);
        this.searchTextField.setEditable(enabled);
        this.fieldSearchTextField.setEnabled(enabled);
        this.fieldSearchTextField.setEditable(enabled);
        this.searchButton.setEnabled(enabled);
    }

    public void attachListeners(ActionListener listener) {
        this.searchTextField.addActionListener(listener);
        this.fieldSearchTextField.addActionListener(listener);
        this.searchButton.addActionListener(listener);
    }

    public void rebuildLanguages(List<HiLanguage> languages) {
        this.languages = languages;
        this.buildLanguages();
    }

    private void buildLanguages() {
        this.languageKeys.removeAllElements();
        for (HiLanguage lang : this.languages) {
            this.languageKeys.addElement(lang.getLanguageId());
        }
        this.languageKeys.addElement("all");
        this.languageComboBox.removeAllItems();
        int index = 0;
        for (String lang : this.languageKeys) {
            if (lang.compareTo(this.defLang) == 0) {
                this.defLangIndex = index;
            }
            this.languageComboBox.addItem(new Locale(lang).getDisplayLanguage());
            ++index;
        }
        if (this.languageComboBox.getModel().getSize() > this.defLangIndex) {
            this.languageComboBox.setSelectedIndex(this.defLangIndex);
        }
    }

    private void buildFields() {
        this.fieldKeys.removeAllElements();
        this.fieldComboBox.removeAllItems();
        this.fieldKeys.add("id");
        this.fieldComboBox.addItem(Messages.getString("SearchView.4"));
        this.fieldKeys.add("HIBase.title");
        this.fieldComboBox.addItem(Messages.getString("SearchView.6"));
        this.fieldKeys.add("HIBase.content");
        this.fieldComboBox.addItem(Messages.getString("SearchView.8"));
        this.fieldKeys.add("HIBase.source");
        this.fieldComboBox.addItem(Messages.getString("SearchView.10"));
        this.fieldKeys.add("HIBase.comment");
        this.fieldComboBox.addItem(Messages.getString("SearchView.12"));
        for (HiFlexMetadataTemplate template : HIRuntime.getManager().getProject().getTemplates()) {
            if (template.getNamespacePrefix().equalsIgnoreCase("HIBase")) continue;
            String templateString = template.getNamespacePrefix();
            if (templateString.equalsIgnoreCase("dc")) {
                templateString = Messages.getString("SearchView.15");
            }
            if (templateString.equalsIgnoreCase("HIClassic")) {
                templateString = Messages.getString("SearchView.17");
            }
            if (templateString.equalsIgnoreCase("HIInternal")) {
                templateString = Messages.getString("SearchView.19");
            }
            for (HiFlexMetadataSet set : template.getEntries()) {
                this.fieldKeys.add(String.valueOf(template.getNamespacePrefix()) + "." + set.getTagname());
                String fieldTitle = MetadataHelper.getTemplateKeyDisplayName(template, set.getTagname(), HIRuntime.getGUILanguage().getLanguage());
                if (fieldTitle == null || fieldTitle.length() == 0) {
                    fieldTitle = set.getTagname();
                }
                this.fieldComboBox.addItem(String.valueOf(templateString) + ": " + fieldTitle);
            }
        }
    }

    private void initComponents() {
        this.searchPanel = new JPanel();
        this.searchFieldPanel = new JPanel();
        this.searchTextField = new JTextField();
        this.searchButton = new JButton();
        this.languageComboBox = new JComboBox();
        this.languageLabel = new JLabel();
        this.fieldSearchPanel = new JPanel();
        this.fieldComboBox = new JComboBox();
        this.fieldSearchTextField = new JTextField();
        this.notImplementedLabel = new JLabel();
        this.searchFieldBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("SearchView.22"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.searchFieldPanel.setBorder(this.searchFieldBorder);
        GroupLayout searchFieldPanelLayout = new GroupLayout(this.searchFieldPanel);
        this.searchFieldPanel.setLayout(searchFieldPanelLayout);
        searchFieldPanelLayout.setHorizontalGroup(searchFieldPanelLayout.createParallelGroup(1).add(2, searchFieldPanelLayout.createSequentialGroup().addContainerGap().add(this.searchTextField, -1, 271, Short.MAX_VALUE).addContainerGap()));
        searchFieldPanelLayout.setVerticalGroup(searchFieldPanelLayout.createParallelGroup(1).add(this.searchTextField, -2, -1, -2));
        this.languageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getString("SearchView.24"), Messages.getString("SearchView.25")}));
        this.languageLabel.setText(Messages.getString("SearchView.26"));
        this.notImplementedLabel.setText(Messages.getString("SearchView.27"));
        this.fieldSearchBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("SearchView.28"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.fieldSearchPanel.setBorder(this.fieldSearchBorder);
        GroupLayout fieldSearchPanelLayout = new GroupLayout(this.fieldSearchPanel);
        this.fieldSearchPanel.setLayout(fieldSearchPanelLayout);
        fieldSearchPanelLayout.setHorizontalGroup(fieldSearchPanelLayout.createParallelGroup(1).add(fieldSearchPanelLayout.createSequentialGroup().addContainerGap().add(fieldSearchPanelLayout.createParallelGroup(1).add(2, this.fieldSearchTextField, -1, 271, Short.MAX_VALUE).add(2, this.fieldComboBox, 0, 271, Short.MAX_VALUE)).addContainerGap()));
        fieldSearchPanelLayout.setVerticalGroup(fieldSearchPanelLayout.createParallelGroup(1).add(fieldSearchPanelLayout.createSequentialGroup().add(this.fieldComboBox, -2, -1, -2).addPreferredGap(0).add(this.fieldSearchTextField, -2, -1, -2)));
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(1).add(2, searchPanelLayout.createSequentialGroup().addContainerGap().add(searchPanelLayout.createParallelGroup(2).add(1, this.notImplementedLabel, -1, 323, Short.MAX_VALUE).add(1, this.fieldSearchPanel, -1, -1, Short.MAX_VALUE).add(searchPanelLayout.createSequentialGroup().add(this.languageLabel).addPreferredGap(0).add(this.languageComboBox, -2, 187, -2)).add(this.searchFieldPanel, -1, -1, Short.MAX_VALUE).add(this.searchButton, -2, -1, -2)).addContainerGap()));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(1).add(searchPanelLayout.createSequentialGroup().addContainerGap().add(searchPanelLayout.createParallelGroup(3).add(this.languageComboBox, -2, -1, -2).add(this.languageLabel)).addPreferredGap(0).add(this.searchFieldPanel, -2, -1, -2).addPreferredGap(1).add(this.fieldSearchPanel, -2, -1, -2).add(18, 18, 18).add(this.notImplementedLabel).addPreferredGap(0, 44, Short.MAX_VALUE).add(this.searchButton, -2, -1, -2).addContainerGap()));
        this.searchButton.setPreferredSize(new Dimension(24, 24));
        this.searchButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.searchButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/find.png")));
        this.searchButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/find-active.png")));
        this.searchButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/find-disabled.png")));
        this.searchButton.setToolTipText(Messages.getString("SearchView.30"));
        this.searchButton.setActionCommand("search");
        this.searchButton.setEnabled(false);
        this.searchTextField.setActionCommand("simpleSearch");
        this.fieldSearchTextField.setActionCommand("fieldSearch");
    }

    private void updateSearchStatus() {
        if (this.searchTextField.getText().length() > 0 || this.fieldSearchTextField.getText().length() > 0) {
            this.searchButton.setEnabled(true);
        } else {
            this.searchButton.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateSearchStatus();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateSearchStatus();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateSearchStatus();
    }
}

