/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.OptionButton;
import org.hyperimage.client.gui.lists.GroupContentsCellRenderer;
import org.hyperimage.client.gui.lists.GroupContentsList;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiQuickInfo;
import org.jdesktop.layout.GroupLayout;

public class TagContentsView
extends GUIView
implements MouseListener {
    private static final long serialVersionUID = -5222432024095462853L;
    private JPanel groupContentsPanel;
    private JPanel groupContentsInfoPanel;
    private JPanel controlPanel;
    private GroupContentsList tagContentsList = new GroupContentsList();
    private JScrollPane listScrollPane;
    private JLabel elementCountLabel;
    private JButton listStyleButton;
    public OptionButton optionsButton;
    private JProgressBar loadingIndicator;
    private DefaultListModel model = new DefaultListModel();
    private List<HiQuickInfo> contents;
    private HiGroup currentTag = null;
    private JPopupMenu popupMenu;
    private JMenuItem newGroupFromSelectionMenuItem;
    private JMenuItem removeSelectionMenuItem;
    private ImageIcon deleteIcon;
    public ImageIcon iconStyleIcon;
    public ImageIcon listStyleIcon;
    private int elementCount = 0;

    public TagContentsView() {
        super(new Color(33, 73, 138));
        this.tagContentsList.setModel(this.model);
        this.initComponents();
        this.updateLanguage();
        this.populatePopupMenu();
        this.tagContentsList.setDragEnabled(true);
        this.tagContentsList.setDropMode(DropMode.INSERT);
        this.tagContentsList.addMouseListener(this);
        this.setDisplayPanel(this.groupContentsPanel);
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("TagContentsView.0"));
        this.newGroupFromSelectionMenuItem.setText(Messages.getString("TagContentsView.21"));
        this.removeSelectionMenuItem.setText(Messages.getString("TagContentsView.23"));
        this.optionsButton.updateLanguage();
        if (this.currentTag != null) {
            this.setPopupMenuState();
            ((GroupContentsCellRenderer)this.tagContentsList.getCellRenderer()).updateLanguage();
        }
        if (this.loadingIndicator.isVisible()) {
            this.elementCountLabel.setText(Messages.getString("TagContentsView.29"));
        } else if (this.elementCount >= 0) {
            if (this.elementCount != 1) {
                this.elementCountLabel.setText(String.valueOf(this.elementCount) + Messages.getString("TagContentsView.30"));
            } else {
                this.elementCountLabel.setText(Messages.getString("TagContentsView.31"));
            }
        } else {
            this.elementCountLabel.setText(Messages.getString("TagContentsView.notag"));
        }
    }

    public List<HiQuickInfo> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<HiQuickInfo>();
            int i = 0;
            while (i < this.model.getSize()) {
                this.contents.add((HiQuickInfo)this.model.get(i));
                ++i;
            }
        }
        return this.contents;
    }

    public String getSortOrder() {
        String sortOrder = "";
        if (this.contents != null) {
            for (HiQuickInfo content : this.contents) {
                sortOrder = String.valueOf(sortOrder) + "," + content.getBaseID();
            }
            if (sortOrder.length() > 0) {
                sortOrder = sortOrder.substring(1);
            }
        }
        return sortOrder;
    }

    public void setMenuActionListener(ActionListener listener) {
        this.newGroupFromSelectionMenuItem.addActionListener(listener);
        this.removeSelectionMenuItem.addActionListener(listener);
    }

    public JButton getListStyleButton() {
        return this.listStyleButton;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void showDefaultPopupMenu() {
        this.setPopupMenuState();
        this.popupMenu.show(this, this.controlPanel.getLocation().x + 30, this.controlPanel.getLocation().y + 20);
    }

    private Point getRelativeMenuLocation(int x, int y) {
        Point menuLoc = new Point(x - this.listScrollPane.getViewport().getViewPosition().x, y - this.listScrollPane.getViewport().getViewPosition().y + 30);
        return menuLoc;
    }

    private void populatePopupMenu() {
        this.popupMenu.add(this.newGroupFromSelectionMenuItem);
        this.popupMenu.add(this.removeSelectionMenuItem);
    }

    private void setPopupMenuState() {
    }

    private void initComponents() {
        this.groupContentsPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.listScrollPane = new JScrollPane();
        this.elementCountLabel = new JLabel();
        this.groupContentsInfoPanel = new JPanel();
        this.listStyleButton = new JButton();
        this.optionsButton = new OptionButton();
        this.loadingIndicator = new JProgressBar();
        this.loadingIndicator.setIndeterminate(true);
        this.listScrollPane.setViewportView(this.tagContentsList);
        this.groupContentsInfoPanel.setLayout(new BorderLayout(10, 0));
        this.groupContentsInfoPanel.add((Component)this.elementCountLabel, "West");
        this.groupContentsInfoPanel.add((Component)this.loadingIndicator, "Center");
        this.prepareElementLoading();
        this.controlPanel.setLayout(new BorderLayout(10, 0));
        this.listStyleButton.setActionCommand("changeListStyle");
        this.listStyleButton.setBorder(BorderFactory.createEmptyBorder());
        this.listStyleButton.setPreferredSize(new Dimension(24, 24));
        this.controlPanel.add((Component)this.listStyleButton, "East");
        this.controlPanel.add((Component)this.optionsButton, "West");
        this.elementCountLabel.setText(Messages.getString("TagContentsView.8"));
        this.groupContentsInfoPanel.add((Component)this.elementCountLabel, "West");
        this.controlPanel.add((Component)this.groupContentsInfoPanel, "Center");
        GroupLayout groupContentsPanelLayout = new GroupLayout(this.groupContentsPanel);
        this.groupContentsPanel.setLayout(groupContentsPanelLayout);
        groupContentsPanelLayout.setHorizontalGroup(groupContentsPanelLayout.createParallelGroup(1).add(groupContentsPanelLayout.createSequentialGroup().addContainerGap().add(groupContentsPanelLayout.createParallelGroup(1).add(2, this.controlPanel, -1, 620, Short.MAX_VALUE).add(2, this.listScrollPane, -1, 620, Short.MAX_VALUE)).addContainerGap()));
        groupContentsPanelLayout.setVerticalGroup(groupContentsPanelLayout.createParallelGroup(1).add(2, groupContentsPanelLayout.createSequentialGroup().addContainerGap().add(this.listScrollPane, -1, 213, Short.MAX_VALUE).add(7, 7, 7).add(this.controlPanel, -2, -1, -2).addContainerGap()));
        this.groupContentsPanel.setPreferredSize(new Dimension(200, 300));
        this.iconStyleIcon = new ImageIcon(this.getClass().getResource("/resources/icons/group-iconstyle.png"));
        this.listStyleIcon = new ImageIcon(this.getClass().getResource("/resources/icons/group-liststyle.png"));
        this.listStyleButton.setIcon(this.listStyleIcon);
        this.listStyleButton.setToolTipText(Messages.getString("TagContentsView.11"));
        this.popupMenu = new JPopupMenu();
        this.newGroupFromSelectionMenuItem = new JMenuItem();
        this.newGroupFromSelectionMenuItem.setActionCommand("groupFromSelection");
        this.removeSelectionMenuItem = new JMenuItem();
        this.removeSelectionMenuItem.setActionCommand("removeSelection");
        this.deleteIcon = new ImageIcon(this.getClass().getResource("/resources/icons/link-remove.png"));
    }

    private void setLoading(boolean loading) {
        this.optionsButton.setEnabled(!loading);
        if (loading) {
            this.elementCountLabel.setText(Messages.getString("TagContentsView.29"));
        } else if (this.elementCount >= 0) {
            if (this.elementCount != 1) {
                this.elementCountLabel.setText(String.valueOf(this.elementCount) + Messages.getString("TagContentsView.30"));
            } else {
                this.elementCountLabel.setText(Messages.getString("TagContentsView.31"));
            }
        } else {
            this.elementCountLabel.setText(Messages.getString("TagContentsView.notag"));
        }
        this.loadingIndicator.setVisible(loading);
    }

    public void setCurrentTag(HiGroup tag) {
        this.currentTag = tag;
        if (tag == null) {
            this.setContents(null);
        }
    }

    public HiGroup getCurrentTag() {
        return this.currentTag;
    }

    public GroupContentsList getContentsList() {
        return this.tagContentsList;
    }

    public HiQuickInfo getSelectedElement() {
        if (this.tagContentsList.getSelectedIndex() > -1) {
            return (HiQuickInfo)this.model.getElementAt(this.tagContentsList.getSelectedIndex());
        }
        return null;
    }

    public void prepareElementLoading() {
        this.model.removeAllElements();
        this.elementCount = 0;
        this.setLoading(true);
    }

    public void setContents(List<HiQuickInfo> infoList) {
        this.model.removeAllElements();
        if (infoList != null) {
            this.contents = infoList;
            ((GroupContentsCellRenderer)this.tagContentsList.getCellRenderer()).clearCache();
            this.elementCount = 0;
            for (HiQuickInfo info : this.contents) {
                this.model.addElement(info);
            }
            this.elementCount = infoList.size();
            this.sortContents();
            this.setLoading(false);
        } else {
            this.elementCount = -1;
            this.contents = new ArrayList<HiQuickInfo>();
            this.setLoading(false);
        }
    }

    public void sortContents() {
        if (this.contents == null || this.currentTag == null) {
            return;
        }
        int index = 0;
        String[] stringArray = this.currentTag.getSortOrder().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long contentID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < this.model.size()) {
                    if (this.contents.get(i).getBaseID() == contentID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiQuickInfo content = this.contents.get(contentIndex);
                        this.model.remove(contentIndex);
                        this.contents.remove(contentIndex);
                        this.model.add(index, content);
                        this.contents.add(index, content);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void updateQuickInfo(HiQuickInfo newInfo) {
        int index = -1;
        HiQuickInfo oldInfo = null;
        int i = 0;
        while (i < this.model.size()) {
            if (((HiQuickInfo)this.model.getElementAt(i)).getBaseID() == newInfo.getBaseID()) {
                index = i;
                oldInfo = (HiQuickInfo)this.model.getElementAt(i);
            }
            ++i;
        }
        ((GroupContentsCellRenderer)this.tagContentsList.getCellRenderer()).removeContentFromCache(oldInfo);
        if (index >= 0) {
            this.model.setElementAt(newInfo, index);
        }
        this.tagContentsList.repaint();
    }

    public void addContent(HiQuickInfo info) {
        boolean contains = false;
        for (HiQuickInfo content : this.contents) {
            if (content.getBaseID() != info.getBaseID()) continue;
            contains = true;
        }
        if (!contains) {
            this.contents.add(info);
        }
        this.model.addElement(info);
        this.elementCount = this.contents.size();
        this.setLoading(false);
        this.tagContentsList.setSelectedIndex(this.model.getSize() - 1);
    }

    public void addContent(HiQuickInfo info, int index) {
        index = Math.max(0, index);
        boolean contains = false;
        for (HiQuickInfo content : this.contents) {
            if (content.getBaseID() != info.getBaseID()) continue;
            contains = true;
        }
        if (!contains) {
            this.contents.add(index, info);
        }
        this.model.add(index, info);
        this.elementCount = this.contents.size();
        this.setLoading(false);
        this.tagContentsList.setSelectedIndex(index);
    }

    public void removeContent(HiQuickInfo info) {
        int index = -1;
        int i = 0;
        while (i < this.model.getSize()) {
            if (((HiQuickInfo)this.model.get(i)).getBaseID() == info.getBaseID()) {
                index = i;
            }
            ++i;
        }
        if (index >= 0) {
            this.contents.remove(index);
            this.model.remove(index);
            this.elementCount = this.contents.size();
            this.setLoading(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            e.consume();
            this.setPopupMenuState();
            Point menuLoc = this.getRelativeMenuLocation(e.getX(), e.getY());
            this.popupMenu.show(this, menuLoc.x, menuLoc.y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed() && e.isPopupTrigger()) {
            this.setPopupMenuState();
            Point menuLoc = this.getRelativeMenuLocation(e.getX(), e.getY());
            this.popupMenu.show(this, menuLoc.x, menuLoc.y);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

