/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.lists.TagExplorerListCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiGroup;
import org.jdesktop.layout.GroupLayout;

public class TagListView
extends GUIView
implements ListSelectionListener {
    private static final long serialVersionUID = 3913008821465269712L;
    private JButton createTagButton;
    private JList tagList;
    private DefaultListModel tagListModel;
    private JScrollPane tagListScrollPane;
    private JButton removeTagButton;
    private JPanel tagListPanel;
    private Vector<HiGroup> tags = new Vector();
    private JPopupMenu popupMenu;
    private JMenuItem titleItem;
    private JMenuItem createTagMenuItem;
    private JMenuItem removeTagMenuItem;

    public TagListView(String defaultLang) {
        super(new Color(33, 73, 138));
        this.initComponents();
        this.updateLanguage();
        this.tagList.setCellRenderer(new TagExplorerListCellRenderer(defaultLang));
        this.tagList.setDragEnabled(true);
        this.tagList.setDropMode(DropMode.ON_OR_INSERT);
        this.tagList.addListSelectionListener(this);
        this.setTags();
        this.setDisplayPanel(this.tagListPanel);
    }

    @Override
    public void updateContent() {
        this.tagList.repaint();
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("TagListView.0"));
        this.createTagButton.setToolTipText(Messages.getString("TagListView.1"));
        this.removeTagButton.setToolTipText(Messages.getString("TagListView.2"));
        this.titleItem.setText(Messages.getString("TagListView.3"));
        this.createTagMenuItem.setText(Messages.getString("TagListView.4"));
        this.removeTagMenuItem.setText(Messages.getString("TagListView.5"));
    }

    public void setTags(List<HiGroup> tags) {
        this.tags.removeAllElements();
        for (HiGroup tag : tags) {
            this.tags.addElement(tag);
        }
        this.setTags();
    }

    public void resetAllTags(List<HiGroup> tags) {
        this.setTags(tags);
        if (this.tagList.getModel().getSize() > 0) {
            this.tagList.setSelectedIndex(0);
        }
    }

    private void setTags() {
        ListSelectionListener[] listeners;
        int selectedIndex = -1;
        HiGroup selTag = null;
        if (this.tagListModel.size() > 0 && (selectedIndex = this.tagList.getSelectedIndex()) >= 0) {
            selTag = (HiGroup)this.tagListModel.get(selectedIndex);
        }
        ListSelectionListener[] listSelectionListenerArray = listeners = (ListSelectionListener[])this.tagList.getListeners(ListSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ListSelectionListener listener = listSelectionListenerArray[n2];
            this.tagList.removeListSelectionListener(listener);
            ++n2;
        }
        this.tagListModel.removeAllElements();
        for (HiGroup group : this.tags) {
            this.tagListModel.addElement(group);
        }
        if (selectedIndex >= 0) {
            int i = 0;
            while (i < this.tagListModel.size()) {
                if (((HiGroup)this.tagListModel.get(i)).getId() == selTag.getId()) {
                    selectedIndex = i;
                }
                ++i;
            }
        }
        this.tagList.setSelectedIndex(-1);
        listSelectionListenerArray = listeners;
        n = listeners.length;
        int n3 = 0;
        while (n3 < n) {
            ListSelectionListener listener = listSelectionListenerArray[n3];
            this.tagList.addListSelectionListener(listener);
            ++n3;
        }
        if (selectedIndex >= 0 && selectedIndex < this.tagListModel.size()) {
            this.tagList.setSelectedIndex(selectedIndex);
        } else {
            this.tagList.setSelectedIndex(0);
        }
        this.removeTagButton.setEnabled(this.tagList.getModel().getSize() > 0);
        this.removeTagMenuItem.setEnabled(this.tagList.getModel().getSize() > 0);
    }

    public JList getList() {
        return this.tagList;
    }

    private void initComponents() {
        this.tagListPanel = new JPanel();
        this.createTagButton = new JButton();
        this.removeTagButton = new JButton();
        this.tagListScrollPane = new JScrollPane();
        this.tagList = new JList();
        this.tagListModel = new DefaultListModel();
        this.tagList.setModel(this.tagListModel);
        this.tagList.setSelectionMode(0);
        this.createTagButton.setBorder(BorderFactory.createEmptyBorder());
        this.createTagButton.setPreferredSize(new Dimension(24, 24));
        this.removeTagButton.setBorder(BorderFactory.createEmptyBorder());
        this.removeTagButton.setOpaque(true);
        this.removeTagButton.setPreferredSize(new Dimension(24, 24));
        this.tagListScrollPane.setViewportView(this.tagList);
        GroupLayout tagListPanelLayout = new GroupLayout(this.tagListPanel);
        this.tagListPanel.setLayout(tagListPanelLayout);
        tagListPanelLayout.setHorizontalGroup(tagListPanelLayout.createParallelGroup(1).add(tagListPanelLayout.createSequentialGroup().addContainerGap().add(tagListPanelLayout.createParallelGroup(1).add(tagListPanelLayout.createSequentialGroup().add(this.createTagButton, -2, -1, -2).addPreferredGap(0).add(this.removeTagButton, -2, -1, -2)).add(2, this.tagListScrollPane, -1, 166, Short.MAX_VALUE)).addContainerGap()));
        tagListPanelLayout.setVerticalGroup(tagListPanelLayout.createParallelGroup(1).add(2, tagListPanelLayout.createSequentialGroup().addContainerGap().add(this.tagListScrollPane, -1, 229, Short.MAX_VALUE).addPreferredGap(0).add(tagListPanelLayout.createParallelGroup(3).add(this.createTagButton, -2, -1, -2).add(this.removeTagButton, -2, -1, -2)).addContainerGap()));
        this.createTagButton.setActionCommand("create");
        this.createTagButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add.png")));
        this.createTagButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-active.png")));
        this.createTagButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-disabled.png")));
        this.removeTagButton.setActionCommand("remove");
        this.removeTagButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove.png")));
        this.removeTagButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-active.png")));
        this.removeTagButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-disabled.png")));
        this.popupMenu = new JPopupMenu();
        this.titleItem = new JMenuItem();
        this.titleItem.setEnabled(false);
        this.popupMenu.add(this.titleItem);
        this.popupMenu.add(new JSeparator());
        this.createTagMenuItem = new JMenuItem();
        this.createTagMenuItem.setActionCommand("create");
        this.popupMenu.add(this.createTagMenuItem);
        this.createTagMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/create-menu.png")));
        this.removeTagMenuItem = new JMenuItem();
        this.removeTagMenuItem.setActionCommand("remove");
        this.popupMenu.add(this.removeTagMenuItem);
    }

    public HiGroup getCurrentTag() {
        if (this.tagList.getSelectedIndex() == -1) {
            return null;
        }
        return (HiGroup)this.tagListModel.get(this.tagList.getSelectedIndex());
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void showPopupMenu(int x, int y) {
        this.popupMenu.show(this, x, y + 10);
    }

    public void attachActionListeners(ActionListener listener) {
        this.createTagButton.addActionListener(listener);
        this.removeTagButton.addActionListener(listener);
        this.createTagMenuItem.addActionListener(listener);
        this.removeTagMenuItem.addActionListener(listener);
    }

    public HiGroup getTag(int index) {
        return (HiGroup)this.tagListModel.get(index);
    }

    public HiGroup getTag(HiGroup refTag) {
        HiGroup foundTag = refTag;
        int i = 0;
        while (i < this.tagListModel.getSize()) {
            if (((HiGroup)this.tagListModel.get(i)).getId() == refTag.getId()) {
                foundTag = (HiGroup)this.tagListModel.get(i);
            }
            ++i;
        }
        return foundTag;
    }

    public void setSelectedTag(HiGroup tag) {
        int i = 0;
        while (i < this.tagListModel.getSize()) {
            if (((HiGroup)this.tagListModel.get(i)).getId() == tag.getId()) {
                this.tagList.setSelectedIndex(i);
            }
            ++i;
        }
    }

    public void updateTag(HiGroup tag) {
        int i = 0;
        while (i < this.tagListModel.size()) {
            if (((HiGroup)this.tagListModel.getElementAt(i)).getId() == tag.getId()) {
                this.tagListModel.setElementAt(tag, i);
            }
            ++i;
        }
        this.updateContent();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.removeTagButton.setEnabled(this.tagList.getModel().getSize() > 0);
        this.removeTagMenuItem.setEnabled(this.tagList.getModel().getSize() > 0);
    }
}

