/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.EditButton;
import org.hyperimage.client.gui.lists.TagListCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiGroup;

public class TagManagerView
extends GUIView
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private List<HiGroup> tags;
    private JButton addTagButton;
    private EditButton editTagButton;
    private JButton removeTagButton;
    private JList tagList;
    private DefaultListModel tagListModel;
    private JPanel tagListPanel;
    private JScrollPane tagListScroll;

    public TagManagerView(List<HiGroup> tags) {
        super(Messages.getString("TagManagerView.title"));
        this.tags = tags;
        this.initComponents();
        this.updateLanguage();
        this.setTagList();
        this.updateButtonState();
        this.tagList.addListSelectionListener(this);
        this.setDisplayPanel(this.tagListPanel);
    }

    public JButton getAddButton() {
        return this.addTagButton;
    }

    public JButton getEditButton() {
        return this.editTagButton;
    }

    public JButton getRemoveButton() {
        return this.removeTagButton;
    }

    public void updateList() {
        this.setTagList();
        this.tagList.repaint();
    }

    private void setTagList() {
        int savedIndex = -1;
        HiGroup selectedTag = null;
        if (this.tagList.getSelectedIndex() >= 0) {
            selectedTag = (HiGroup)this.tagList.getSelectedValue();
        }
        this.tagListModel.removeAllElements();
        int i = 0;
        for (HiGroup tag : this.tags) {
            this.tagListModel.addElement(tag);
            if (tag != null && selectedTag != null && tag.getId() == selectedTag.getId()) {
                savedIndex = i;
            }
            ++i;
        }
        if (this.tagListModel.size() > 0) {
            if (savedIndex < 0) {
                this.tagList.setSelectedIndex(0);
            } else {
                this.tagList.setSelectedIndex(savedIndex);
            }
        }
    }

    private void updateButtonState() {
        this.editTagButton.setEnabled(this.tagList.getSelectedIndex() >= 0);
        this.removeTagButton.setEnabled(this.tagList.getSelectedIndex() >= 0);
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("TagManagerView.title"));
        this.addTagButton.setToolTipText(Messages.getString("TagManagerView.addTag"));
        this.editTagButton.setToolTipText(Messages.getString("TagManagerView.editTag"));
        this.removeTagButton.setToolTipText(Messages.getString("TagManagerView.removeTag"));
    }

    private void initComponents() {
        this.tagListPanel = new JPanel();
        this.tagListScroll = new JScrollPane();
        this.tagList = new JList();
        this.editTagButton = new EditButton();
        this.addTagButton = new JButton();
        this.removeTagButton = new JButton();
        this.tagListScroll.setViewportView(this.tagList);
        this.editTagButton.setPreferredSize(new Dimension(24, 24));
        this.addTagButton.setPreferredSize(new Dimension(24, 24));
        this.removeTagButton.setPreferredSize(new Dimension(24, 24));
        GroupLayout tagListPanelLayout = new GroupLayout(this.tagListPanel);
        this.tagListPanel.setLayout(tagListPanelLayout);
        tagListPanelLayout.setHorizontalGroup(tagListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tagListPanelLayout.createSequentialGroup().addContainerGap().addGroup(tagListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tagListScroll, -1, 245, Short.MAX_VALUE).addGroup(tagListPanelLayout.createSequentialGroup().addComponent(this.editTagButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.addTagButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.removeTagButton, -2, -1, -2))).addContainerGap()));
        tagListPanelLayout.setVerticalGroup(tagListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tagListPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tagListScroll, -1, 327, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tagListPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.editTagButton, -2, -1, -2).addComponent(this.removeTagButton, -2, -1, -2).addComponent(this.addTagButton, -2, -1, -2)).addContainerGap()));
        this.addTagButton.setActionCommand("addTag");
        this.addTagButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add.png")));
        this.addTagButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-active.png")));
        this.addTagButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-disabled.png")));
        this.removeTagButton.setActionCommand("removeTag");
        this.removeTagButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove.png")));
        this.removeTagButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-active.png")));
        this.removeTagButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-disabled.png")));
        this.editTagButton.setActionCommand("editTag");
        this.tagListModel = new DefaultListModel();
        this.tagList.setModel(this.tagListModel);
        this.tagList.setSelectionMode(0);
        this.tagList.setCellRenderer(new TagListCellRenderer());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtonState();
    }

    public HiGroup getSelectedTag() {
        return (HiGroup)this.tagList.getSelectedValue();
    }
}

