/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.MetadataEditorControl;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;
import org.jdesktop.layout.GroupLayout;

public class TagMetadataEditorView
extends GUIView
implements ItemListener {
    private static final long serialVersionUID = -2280958055442791286L;
    private HiGroup tag = null;
    private JPanel editorPanel;
    private MetadataEditorControl metadataEditorControl;
    private boolean propertyChanged = false;

    public TagMetadataEditorView() {
        super(new Color(33, 73, 138));
        this.initComponents();
        this.updateLanguage();
        this.setDisplayPanel(this.editorPanel);
    }

    @Override
    public void updateContent() {
        if (this.tag != null) {
            this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(this.tag.getTimestamp()));
        }
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("TagMetadataEditorView.0"));
        this.metadataEditorControl.setIdLabel(Messages.getString("TagMetadataEditorView.1"));
        this.metadataEditorControl.updateLanguage(Messages.getString("TagMetadataEditorView.6"), null, Messages.getString("TagMetadataEditorView.8"));
        if (this.tag != null) {
            if (this.tag.getType() == GroupTypes.HIGROUP_TAG) {
                this.metadataEditorControl.setEmptyText(String.valueOf(Messages.getString("TagMetadataEditorView.2")) + " (G" + this.tag.getId() + ")");
            }
            if (this.tag.getUUID() == null) {
                this.metadataEditorControl.setIdLabel("G" + this.tag.getId());
            } else {
                this.metadataEditorControl.setIdLabel(this.tag.getUUID());
            }
            this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(this.tag.getTimestamp()));
        }
    }

    public List<HiFlexMetadataRecord> getMetadata() {
        return this.metadataEditorControl.getMetadata();
    }

    public JButton getSaveButton() {
        return this.metadataEditorControl.getSaveButton();
    }

    public JButton getResetButton() {
        return this.metadataEditorControl.getResetButton();
    }

    public void setTag(HiGroup tag, String defLang) {
        this.tag = tag;
        if (tag != null) {
            if (tag.getType() == GroupTypes.HIGROUP_TAG) {
                this.metadataEditorControl.setBaseID(tag.getId());
                if (tag.getUUID() == null) {
                    this.metadataEditorControl.setIdLabel("Tag" + tag.getId());
                } else {
                    this.metadataEditorControl.setIdLabel(tag.getUUID());
                }
                this.metadataEditorControl.setTimeLabel(MetadataHelper.getFuzzyDate(tag.getTimestamp()));
                this.metadataEditorControl.setMetadata(this.tag.getMetadata(), defLang);
                if (tag.getType() == GroupTypes.HIGROUP_TAG) {
                    this.metadataEditorControl.setEmptyText(String.valueOf(Messages.getString("TagMetadataEditorView.2")) + " (" + tag.getUUID().split("-")[4] + ")");
                }
            }
            this.propertyChanged = false;
        } else {
            this.metadataEditorControl.setEmptyText("");
            this.metadataEditorControl.setMetadata(null, defLang);
        }
    }

    public boolean hasChanges() {
        return this.metadataEditorControl.hasChanges() || this.propertyChanged;
    }

    public boolean hasPropertyChanges() {
        return false;
    }

    public boolean hasMetadataChanges() {
        return this.metadataEditorControl.hasChanges();
    }

    public void syncChanges() {
        this.propertyChanged = false;
        this.metadataEditorControl.syncChanges();
    }

    public void resetChanges() {
        this.propertyChanged = false;
        this.metadataEditorControl.resetChanges();
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.metadataEditorControl = new MetadataEditorControl("title", Messages.getString("TagMetadataEditorView.6"), null, null, null, null, false);
        GroupLayout editorPanelLayout = new GroupLayout(this.editorPanel);
        this.editorPanel.setLayout(editorPanelLayout);
        editorPanelLayout.setHorizontalGroup(editorPanelLayout.createParallelGroup(1).add(2, editorPanelLayout.createSequentialGroup().addContainerGap().add(editorPanelLayout.createParallelGroup(2).add(1, this.metadataEditorControl, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        editorPanelLayout.setVerticalGroup(editorPanelLayout.createParallelGroup(1).add(editorPanelLayout.createSequentialGroup().addContainerGap().add(this.metadataEditorControl, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.propertyChanged = false;
    }
}

