/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.EditButton;
import org.hyperimage.client.gui.lists.TemplateFieldsListCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;

public class TemplateFieldsView
extends GUIView
implements ActionListener,
ListSelectionListener {
    private JButton addFieldButton;
    private EditButton editFieldButton;
    private JButton removeFieldButton;
    private JPanel fieldsButtonPanel;
    private JList fieldsList;
    private DefaultListModel fieldsListModel;
    private JScrollPane fieldsListScrollPane;
    private JComboBox screenLanguageComboBox;
    private JLabel screenLanguageLabel;
    private JPanel templateFieldsPanel;
    private HiFlexMetadataTemplate template;
    private TemplateFieldsListCellRenderer fieldsListRenderer;
    private int lastFieldIndex = -1;
    private HiFlexMetadataSet savedSet = null;

    public TemplateFieldsView(HiFlexMetadataTemplate template) {
        super(Messages.getString("TemplateFieldsView.TEMPLATEFELDER"));
        this.template = template;
        this.initComponents();
        this.updateFieldsList();
        this.updateLanguage();
        this.fieldsList.setDragEnabled(true);
        this.fieldsList.setDropMode(DropMode.INSERT);
        this.fieldsList.addListSelectionListener(this);
        this.screenLanguageComboBox.addActionListener(this);
        this.updateButtonState();
        this.setDisplayPanel(this.templateFieldsPanel);
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("TemplateFieldsView.TEMPLATEFELDER"));
        this.screenLanguageLabel.setText(Messages.getString("TemplateFieldsView.BILDSCHIRMSPRACHE"));
        this.addFieldButton.setToolTipText(Messages.getString("TemplateFieldsView.METADATENFELD_HINZUFUEGEN"));
        this.editFieldButton.setToolTipText(Messages.getString("TemplateFieldsView.METADATENFELD_ANZEIGENAME_BEARBEITEN"));
        this.removeFieldButton.setToolTipText(Messages.getString("TemplateFieldsView.METADATENFELD_LOESCHEN"));
        int index = this.screenLanguageComboBox.getSelectedIndex();
        this.screenLanguageComboBox.removeAllItems();
        Locale[] localeArray = HIRuntime.supportedLanguages;
        int n = HIRuntime.supportedLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            Locale guiLang = localeArray[n2];
            this.screenLanguageComboBox.addItem(guiLang.getDisplayLanguage());
            ++n2;
        }
        this.screenLanguageComboBox.setSelectedIndex(index);
    }

    public void setTemplate(HiFlexMetadataTemplate template) {
        if (template == null) {
            return;
        }
        this.savedSet = null;
        if (this.template != null && this.template.getNamespacePrefix().compareTo(template.getNamespacePrefix()) == 0 && this.fieldsList.getSelectedIndex() >= 0) {
            this.savedSet = this.getSelectedSet();
        }
        this.template = template;
        this.fieldsListRenderer.setReferenceTemplate(template);
        this.updateFieldsList();
    }

    public Locale getSelectedScreenLanguage() {
        return HIRuntime.supportedLanguages[this.screenLanguageComboBox.getSelectedIndex()];
    }

    public HiFlexMetadataSet getSelectedSet() {
        if (this.fieldsList.getSelectedIndex() < 0) {
            return null;
        }
        return (HiFlexMetadataSet)this.fieldsListModel.get(this.fieldsList.getSelectedIndex());
    }

    public JButton getAddButton() {
        return this.addFieldButton;
    }

    public JButton getRemoveButton() {
        return this.removeFieldButton;
    }

    public JButton getEditButton() {
        return this.editFieldButton;
    }

    public JList getFieldsList() {
        return this.fieldsList;
    }

    private void updateFieldsList() {
        this.lastFieldIndex = -1;
        this.fieldsListModel.removeAllElements();
        for (HiFlexMetadataSet set : this.template.getEntries()) {
            this.fieldsListModel.addElement(set);
        }
        if (this.fieldsListModel.size() > 0) {
            if (this.savedSet != null) {
                int newIndex = 0;
                int index = 0;
                while (index < this.fieldsListModel.size()) {
                    if (this.template.getEntries().get(index).getId() == this.savedSet.getId()) {
                        newIndex = index;
                    }
                    ++index;
                }
                this.fieldsList.setSelectedIndex(newIndex);
            } else {
                this.fieldsList.setSelectedIndex(0);
            }
        }
        this.updateButtonState();
    }

    private void updateButtonState() {
        this.editFieldButton.setEnabled(false);
        if (this.fieldsList.getSelectedIndex() >= 0 && this.template.getNamespacePrefix().toLowerCase().compareTo("custom") == 0) {
            this.editFieldButton.setEnabled(true);
        }
        if (this.template.getNamespacePrefix().toLowerCase().compareTo("custom") == 0) {
            this.addFieldButton.setEnabled(true);
            if (this.fieldsListModel.size() > 0 && this.fieldsList.getSelectedIndex() >= 0) {
                this.removeFieldButton.setEnabled(true);
            } else {
                this.removeFieldButton.setEnabled(false);
            }
        } else {
            this.addFieldButton.setEnabled(false);
            this.removeFieldButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.templateFieldsPanel = new JPanel();
        this.screenLanguageLabel = new JLabel();
        this.screenLanguageComboBox = new JComboBox();
        this.fieldsListScrollPane = new JScrollPane();
        this.fieldsList = new JList();
        this.fieldsButtonPanel = new JPanel();
        this.editFieldButton = new EditButton();
        this.addFieldButton = new JButton();
        this.removeFieldButton = new JButton();
        this.screenLanguageLabel.setHorizontalAlignment(4);
        this.fieldsListScrollPane.setViewportView(this.fieldsList);
        this.addFieldButton.setBorder(BorderFactory.createEmptyBorder());
        this.addFieldButton.setPreferredSize(new Dimension(24, 24));
        this.removeFieldButton.setBorder(BorderFactory.createEmptyBorder());
        this.removeFieldButton.setPreferredSize(new Dimension(24, 24));
        GroupLayout fieldsButtonPanelLayout = new GroupLayout(this.fieldsButtonPanel);
        this.fieldsButtonPanel.setLayout(fieldsButtonPanelLayout);
        fieldsButtonPanelLayout.setHorizontalGroup(fieldsButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fieldsButtonPanelLayout.createSequentialGroup().addComponent(this.editFieldButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 264, Short.MAX_VALUE).addComponent(this.addFieldButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.removeFieldButton, -2, -1, -2)));
        fieldsButtonPanelLayout.setVerticalGroup(fieldsButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fieldsButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.editFieldButton, -2, -1, -2).addComponent(this.removeFieldButton, -2, -1, -2).addComponent(this.addFieldButton, -2, -1, -2)));
        GroupLayout templateFieldsPanelLayout = new GroupLayout(this.templateFieldsPanel);
        this.templateFieldsPanel.setLayout(templateFieldsPanelLayout);
        templateFieldsPanelLayout.setHorizontalGroup(templateFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(templateFieldsPanelLayout.createSequentialGroup().addContainerGap().addGroup(templateFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fieldsListScrollPane, GroupLayout.Alignment.TRAILING, -1, 348, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, templateFieldsPanelLayout.createSequentialGroup().addComponent(this.screenLanguageLabel, -1, 172, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.screenLanguageComboBox, -2, 170, -2)).addComponent(this.fieldsButtonPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        templateFieldsPanelLayout.setVerticalGroup(templateFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(templateFieldsPanelLayout.createSequentialGroup().addContainerGap().addGroup(templateFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.screenLanguageComboBox, -2, -1, -2).addComponent(this.screenLanguageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldsListScrollPane, -1, 315, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldsButtonPanel, -2, -1, -2).addContainerGap()));
        this.addFieldButton.setActionCommand("addField");
        this.addFieldButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add.png")));
        this.addFieldButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-active.png")));
        this.addFieldButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-disabled.png")));
        this.removeFieldButton.setActionCommand("removeField");
        this.removeFieldButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove.png")));
        this.removeFieldButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-active.png")));
        this.removeFieldButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-disabled.png")));
        this.editFieldButton.setActionCommand("editField");
        Locale[] localeArray = HIRuntime.supportedLanguages;
        int n = HIRuntime.supportedLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            Locale guiLang = localeArray[n2];
            this.screenLanguageComboBox.addItem(guiLang.getDisplayLanguage());
            ++n2;
        }
        this.screenLanguageComboBox.setSelectedIndex(0);
        this.fieldsListModel = new DefaultListModel();
        this.fieldsList.setModel(this.fieldsListModel);
        this.fieldsList.setSelectionMode(0);
        this.fieldsListRenderer = new TemplateFieldsListCellRenderer(this.template, HIRuntime.supportedLanguages[this.screenLanguageComboBox.getSelectedIndex()]);
        this.fieldsList.setCellRenderer(this.fieldsListRenderer);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.screenLanguageComboBox.getSelectedIndex() < 0) {
            return;
        }
        this.fieldsListRenderer.setScreenLanguage(HIRuntime.supportedLanguages[this.screenLanguageComboBox.getSelectedIndex()]);
        this.fieldsList.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.fieldsList.getSelectedIndex() < 0 && this.fieldsListModel.size() > 0 && this.lastFieldIndex < this.fieldsListModel.size()) {
            if (this.lastFieldIndex < 0) {
                this.lastFieldIndex = 0;
            }
            this.fieldsList.setSelectedIndex(this.lastFieldIndex);
        }
        if (this.lastFieldIndex != this.fieldsList.getSelectedIndex()) {
            this.lastFieldIndex = this.fieldsList.getSelectedIndex();
            this.updateButtonState();
        }
    }
}

