/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.EditButton;
import org.hyperimage.client.gui.lists.TemplateListCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;

public class TemplateSetView
extends GUIView
implements ListSelectionListener,
MouseListener,
MouseMotionListener {
    private JButton addTemplateButton;
    private EditButton editTemplateButton;
    private JButton removeTemplateButton;
    private JPanel templateButtonPanel;
    private JList templateList;
    private DefaultListModel templateListModel;
    private JScrollPane templateListScrollPane;
    private JPanel templateSetPanel;
    private int lastTemplateIndex = 0;
    private List<HiFlexMetadataTemplate> templates;

    public TemplateSetView(List<HiFlexMetadataTemplate> templates) {
        super(Messages.getString("TemplateSetView.TEMPLATES"));
        this.templates = templates;
        this.initComponents();
        this.updateLanguage();
        this.refreshTemplates();
        this.templateList.setDragEnabled(true);
        this.templateList.setDropMode(DropMode.INSERT);
        this.templateList.addListSelectionListener(this);
        this.templateList.addMouseListener(this);
        this.templateList.addMouseMotionListener(this);
        this.updateButtonState();
        this.setDisplayPanel(this.templateSetPanel);
    }

    @Override
    public void updateLanguage() {
        this.menuTitle.setText(Messages.getString("TemplateSetView.TEMPLATES"));
        this.addTemplateButton.setToolTipText(Messages.getString("TemplateSetView.TEMPLATE_ZUM_PROJEKT_HINZUFUEGEN"));
        this.editTemplateButton.setToolTipText(Messages.getString("TemplateSetView.TEMPLATE_BEARBEITEN"));
        this.removeTemplateButton.setToolTipText(Messages.getString("TemplateSetView.TEMPLATE_AUS_DEM_PROJEKT_LOESCHEN"));
    }

    public void setTemplates(List<HiFlexMetadataTemplate> templates) {
        this.templates = templates;
        this.refreshTemplates();
        this.updateButtonState();
    }

    private void refreshTemplates() {
        int savedIndex = -1;
        HiFlexMetadataTemplate template = null;
        if (this.templateList.getSelectedIndex() >= 0) {
            template = (HiFlexMetadataTemplate)this.templateListModel.getElementAt(this.templateList.getSelectedIndex());
        }
        this.templateListModel.removeAllElements();
        int i = 0;
        for (HiFlexMetadataTemplate temp : this.templates) {
            if (temp.getNamespacePrefix().compareTo("HIBase") == 0) continue;
            this.templateListModel.addElement(temp);
            if (template != null && temp.getId() == template.getId()) {
                savedIndex = i;
            }
            ++i;
        }
        if (savedIndex < 0 || savedIndex >= this.templateListModel.size()) {
            this.templateList.setSelectedIndex(0);
        } else {
            this.templateList.setSelectedIndex(savedIndex);
        }
    }

    public HiFlexMetadataTemplate getSelectedTemplate() {
        if (this.templateList.getSelectedIndex() < 0) {
            return null;
        }
        return (HiFlexMetadataTemplate)this.templateListModel.get(this.templateList.getSelectedIndex());
    }

    public JList getTemplateList() {
        return this.templateList;
    }

    public JButton getAddButton() {
        return this.addTemplateButton;
    }

    public JButton getRemoveButton() {
        return this.removeTemplateButton;
    }

    public JButton getEditButton() {
        return this.editTemplateButton;
    }

    private void updateButtonState() {
        this.editTemplateButton.setEnabled(false);
        if (this.getSelectedTemplate() == null) {
            return;
        }
        if (this.templateList.getSelectedIndex() >= 0 && this.getSelectedTemplate().getNamespacePrefix().toLowerCase().compareTo("custom") == 0) {
            this.editTemplateButton.setEnabled(true);
        }
        this.removeTemplateButton.setEnabled(false);
        if (this.templateListModel.size() > 1 && this.getSelectedTemplate().getNamespacePrefix().compareTo("HIInternal") != 0) {
            this.removeTemplateButton.setEnabled(true);
        }
        this.addTemplateButton.setEnabled(true);
    }

    private void initComponents() {
        this.templateSetPanel = new JPanel();
        this.templateListScrollPane = new JScrollPane();
        this.templateList = new JList();
        this.templateButtonPanel = new JPanel();
        this.editTemplateButton = new EditButton();
        this.addTemplateButton = new JButton();
        this.removeTemplateButton = new JButton();
        this.templateListScrollPane.setViewportView(this.templateList);
        this.addTemplateButton.setBorder(BorderFactory.createEmptyBorder());
        this.addTemplateButton.setPreferredSize(new Dimension(24, 24));
        this.removeTemplateButton.setBorder(BorderFactory.createEmptyBorder());
        this.removeTemplateButton.setPreferredSize(new Dimension(24, 24));
        GroupLayout templateButtonPanelLayout = new GroupLayout(this.templateButtonPanel);
        this.templateButtonPanel.setLayout(templateButtonPanelLayout);
        templateButtonPanelLayout.setHorizontalGroup(templateButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, templateButtonPanelLayout.createSequentialGroup().addComponent(this.editTemplateButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 168, Short.MAX_VALUE).addComponent(this.addTemplateButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.removeTemplateButton, -2, -1, -2)));
        templateButtonPanelLayout.setVerticalGroup(templateButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(templateButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeTemplateButton, -2, -1, -2).addComponent(this.editTemplateButton, -2, -1, -2).addComponent(this.addTemplateButton, -2, -1, -2)));
        GroupLayout templateSetPanelLayout = new GroupLayout(this.templateSetPanel);
        this.templateSetPanel.setLayout(templateSetPanelLayout);
        templateSetPanelLayout.setHorizontalGroup(templateSetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, templateSetPanelLayout.createSequentialGroup().addContainerGap().addGroup(templateSetPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.templateListScrollPane, GroupLayout.Alignment.LEADING, -1, 252, Short.MAX_VALUE).addComponent(this.templateButtonPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        templateSetPanelLayout.setVerticalGroup(templateSetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, templateSetPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.templateListScrollPane, -1, 352, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templateButtonPanel, -2, -1, -2).addContainerGap()));
        this.addTemplateButton.setActionCommand("addTemplate");
        this.addTemplateButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add.png")));
        this.addTemplateButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-active.png")));
        this.addTemplateButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-add-disabled.png")));
        this.removeTemplateButton.setActionCommand("removeTemplate");
        this.removeTemplateButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove.png")));
        this.removeTemplateButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-active.png")));
        this.removeTemplateButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/group-remove-disabled.png")));
        this.editTemplateButton.setActionCommand("editTemplate");
        this.templateListModel = new DefaultListModel();
        this.templateList.setModel(this.templateListModel);
        this.templateList.setSelectionMode(0);
        this.templateList.setCellRenderer(new TemplateListCellRenderer());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.templateList.getSelectedIndex() < 0 && this.templateListModel.size() > 0 && this.lastTemplateIndex < this.templateListModel.size()) {
            if (this.lastTemplateIndex < 0) {
                this.lastTemplateIndex = 0;
            }
            this.templateList.setSelectedIndex(this.lastTemplateIndex);
        }
        if (this.lastTemplateIndex != this.templateList.getSelectedIndex()) {
            this.lastTemplateIndex = this.templateList.getSelectedIndex();
            this.updateButtonState();
        }
    }

    private void updateTemplateToolTip(Point location) {
        int index = this.templateList.locationToIndex(location);
        HiFlexMetadataTemplate template = null;
        if (index >= 0) {
            template = (HiFlexMetadataTemplate)this.templateListModel.get(index);
        }
        if (template != null) {
            String text = "<html>";
            text = String.valueOf(text) + "<b>Namespace Prefix:</b> " + template.getNamespacePrefix() + "<br>";
            text = String.valueOf(text) + "<b>Namespace URI:</b> " + template.getNamespaceURI() + "<br>";
            text = String.valueOf(text) + "<b>Schema Location:</b> " + template.getNamespaceURL() + "</html>";
            this.templateList.setToolTipText(text);
        } else {
            this.templateList.setToolTipText("");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateTemplateToolTip(e.getPoint());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.templateList.setToolTipText("");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateTemplateToolTip(e.getPoint());
    }
}

