/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.jdesktop.layout.GroupLayout;

public class TemplateView
extends GUIView {
    private static final long serialVersionUID = 1510444418592115462L;
    private List<HiFlexMetadataTemplate> templates;
    private JLabel notImplementedLabel;
    private JButton tempButton;
    private JPanel templatePanel;
    private JScrollPane templateScroll;
    private JTree templateTree;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel model;

    public TemplateView(List<HiFlexMetadataTemplate> templates) {
        super("Projekt Templates");
        this.templates = templates;
        this.initComponents();
        this.initTemplateTree();
        this.setDisplayPanel(this.templatePanel);
    }

    private void initTemplateTree() {
        for (HiFlexMetadataTemplate template : this.templates) {
            if (template.getNamespacePrefix().equalsIgnoreCase("HIBase")) continue;
            DefaultMutableTreeNode templateNode = new DefaultMutableTreeNode(template.getNamespacePrefix());
            this.model.insertNodeInto(templateNode, this.rootNode, 0);
            this.templateTree.expandRow(0);
            int i = 0;
            while (i < template.getEntries().size()) {
                HiFlexMetadataSet set = template.getEntries().get(i);
                DefaultMutableTreeNode entryNode = new DefaultMutableTreeNode(MetadataHelper.getTemplateKeyDisplayName(template, set.getTagname(), HIRuntime.getGUILanguage().getLanguage()));
                this.model.insertNodeInto(entryNode, templateNode, i);
                ++i;
            }
        }
    }

    private void initComponents() {
        this.templatePanel = new JPanel();
        this.templateScroll = new JScrollPane();
        this.templateTree = new JTree();
        this.tempButton = new JButton();
        this.notImplementedLabel = new JLabel();
        this.templateScroll.setViewportView(this.templateTree);
        this.tempButton.setText("X");
        this.tempButton.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.tempButton.setPreferredSize(new Dimension(24, 24));
        this.notImplementedLabel.setText("Editieren / Optionen noch nicht implementiert");
        GroupLayout templatePanelLayout = new GroupLayout(this.templatePanel);
        this.templatePanel.setLayout(templatePanelLayout);
        templatePanelLayout.setHorizontalGroup(templatePanelLayout.createParallelGroup(1).add(templatePanelLayout.createSequentialGroup().addContainerGap().add(templatePanelLayout.createParallelGroup(1).add(this.templateScroll, -1, 333, Short.MAX_VALUE).add(2, templatePanelLayout.createSequentialGroup().add(this.notImplementedLabel, -1, 300, Short.MAX_VALUE).addPreferredGap(0).add(this.tempButton, -2, -1, -2))).addContainerGap()));
        templatePanelLayout.setVerticalGroup(templatePanelLayout.createParallelGroup(1).add(2, templatePanelLayout.createSequentialGroup().addContainerGap().add(this.templateScroll, -1, 350, Short.MAX_VALUE).add(13, 13, 13).add(templatePanelLayout.createParallelGroup(3).add(this.notImplementedLabel).add(this.tempButton, -2, -1, -2)).addContainerGap()));
        this.rootNode = new DefaultMutableTreeNode();
        this.model = new DefaultTreeModel(this.rootNode, true);
        this.model.setAsksAllowsChildren(true);
        this.templateTree.setModel(this.model);
        this.templateTree.setRootVisible(false);
        this.templateTree.setScrollsOnExpand(true);
        this.templateTree.getSelectionModel().setSelectionMode(1);
    }
}

