/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.views;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.lists.UserListCellRenderer;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiUser;
import org.jdesktop.layout.GroupLayout;

public class UserManagerView
extends GUIView {
    private static final long serialVersionUID = 5632733075676981394L;
    private JPanel assignPanel;
    private JLabel infoLabel;
    private JList projectGuestsList;
    private JPanel projectGuestsPanel;
    private JScrollPane projectGuestsScroll;
    private JList projectUsersList;
    private JPanel projectUsersPanel;
    private JScrollPane projectUsersScroll;
    private JList systemUsersList;
    private JPanel systemUsersPanel;
    private JScrollPane systemUsersScroll;
    private TitledBorder systemUsersBorder;
    private TitledBorder projectUsersBorder;
    private TitledBorder projectGuestsBorder;
    private DefaultListModel systemUsersModel;
    private DefaultListModel projectUsersModel;
    private DefaultListModel guestUsersModel;

    public UserManagerView(List<HiUser> users, List<HiUser> projectUsers, List<HiUser> projectGuests) {
        super(Messages.getString("UserManagerView.0"));
        this.initComponents();
        Vector<HiUser> systemUsers = new Vector<HiUser>();
        for (HiUser user : users) {
            boolean isInProject = false;
            for (HiUser projUser : projectUsers) {
                if (projUser.getId() != user.getId()) continue;
                isInProject = true;
            }
            for (HiUser projUser : projectGuests) {
                if (projUser.getId() != user.getId()) continue;
                isInProject = true;
            }
            if (isInProject) continue;
            systemUsers.addElement(user);
        }
        if (users != null && projectUsers != null && projectGuests != null) {
            for (HiUser user : systemUsers) {
                if (user.getUserName().compareTo("sysop") == 0) continue;
                this.systemUsersModel.addElement(user);
            }
            for (HiUser user : projectUsers) {
                if (user.getUserName().compareTo("sysop") == 0) continue;
                this.projectUsersModel.addElement(user);
            }
            for (HiUser user : projectGuests) {
                if (user.getUserName().compareTo("sysop") == 0) continue;
                this.guestUsersModel.addElement(user);
            }
        }
        this.systemUsersList.setDragEnabled(true);
        this.systemUsersList.setDropMode(DropMode.INSERT);
        this.projectUsersList.setDragEnabled(true);
        this.projectUsersList.setDropMode(DropMode.INSERT);
        this.projectGuestsList.setDragEnabled(true);
        this.projectGuestsList.setDropMode(DropMode.INSERT);
        this.setDisplayPanel(this.assignPanel);
    }

    @Override
    public void updateLanguage() {
        this.infoLabel.setText(Messages.getString("UserManagerView.6"));
        this.systemUsersBorder.setTitle(Messages.getString("UserManagerView.4"));
        this.projectUsersBorder.setTitle(Messages.getString("UserManagerView.7"));
        this.projectGuestsBorder.setTitle(Messages.getString("UserManagerView.9"));
        super.setTitle(Messages.getString("UserManagerView.0"));
    }

    public JList getSystemUsersList() {
        return this.systemUsersList;
    }

    public JList getProjectUsersList() {
        return this.projectUsersList;
    }

    public JList getProjectGuestsList() {
        return this.projectGuestsList;
    }

    private void initComponents() {
        this.assignPanel = new JPanel();
        this.systemUsersPanel = new JPanel();
        this.systemUsersScroll = new JScrollPane();
        this.systemUsersList = new JList();
        this.infoLabel = new JLabel();
        this.projectUsersPanel = new JPanel();
        this.projectUsersScroll = new JScrollPane();
        this.projectUsersList = new JList();
        this.projectGuestsPanel = new JPanel();
        this.projectGuestsScroll = new JScrollPane();
        this.projectGuestsList = new JList();
        this.systemUsersBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("UserManagerView.4"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.systemUsersPanel.setBorder(this.systemUsersBorder);
        this.systemUsersList.setSelectionMode(0);
        this.systemUsersScroll.setViewportView(this.systemUsersList);
        GroupLayout systemUsersPanelLayout = new GroupLayout(this.systemUsersPanel);
        this.systemUsersPanel.setLayout(systemUsersPanelLayout);
        systemUsersPanelLayout.setHorizontalGroup(systemUsersPanelLayout.createParallelGroup(1).add(this.systemUsersScroll, -1, 212, Short.MAX_VALUE));
        systemUsersPanelLayout.setVerticalGroup(systemUsersPanelLayout.createParallelGroup(1).add(this.systemUsersScroll, -1, 302, Short.MAX_VALUE));
        this.projectUsersBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("UserManagerView.7"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.projectUsersPanel.setBorder(this.projectUsersBorder);
        this.projectUsersList.setSelectionMode(0);
        this.projectUsersScroll.setViewportView(this.projectUsersList);
        GroupLayout projectUsersPanelLayout = new GroupLayout(this.projectUsersPanel);
        this.projectUsersPanel.setLayout(projectUsersPanelLayout);
        projectUsersPanelLayout.setHorizontalGroup(projectUsersPanelLayout.createParallelGroup(1).add(this.projectUsersScroll, -1, 242, Short.MAX_VALUE));
        projectUsersPanelLayout.setVerticalGroup(projectUsersPanelLayout.createParallelGroup(1).add(this.projectUsersScroll, -1, 160, Short.MAX_VALUE));
        this.projectGuestsBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("UserManagerView.9"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.projectGuestsPanel.setBorder(this.projectGuestsBorder);
        this.projectGuestsList.setSelectionMode(0);
        this.projectGuestsScroll.setViewportView(this.projectGuestsList);
        GroupLayout projectGuestsPanelLayout = new GroupLayout(this.projectGuestsPanel);
        this.projectGuestsPanel.setLayout(projectGuestsPanelLayout);
        projectGuestsPanelLayout.setHorizontalGroup(projectGuestsPanelLayout.createParallelGroup(1).add(this.projectGuestsScroll, -1, 242, Short.MAX_VALUE));
        projectGuestsPanelLayout.setVerticalGroup(projectGuestsPanelLayout.createParallelGroup(1).add(this.projectGuestsScroll, -1, 100, Short.MAX_VALUE));
        GroupLayout assignPanelLayout = new GroupLayout(this.assignPanel);
        this.assignPanel.setLayout(assignPanelLayout);
        assignPanelLayout.setHorizontalGroup(assignPanelLayout.createParallelGroup(1).add(2, assignPanelLayout.createSequentialGroup().addContainerGap().add(assignPanelLayout.createParallelGroup(2).add(1, this.infoLabel, -1, 492, Short.MAX_VALUE).add(assignPanelLayout.createSequentialGroup().add(this.systemUsersPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add(assignPanelLayout.createParallelGroup(1).add(this.projectGuestsPanel, -1, -1, Short.MAX_VALUE).add(this.projectUsersPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        assignPanelLayout.setVerticalGroup(assignPanelLayout.createParallelGroup(1).add(assignPanelLayout.createSequentialGroup().add(20, 20, 20).add(assignPanelLayout.createParallelGroup(1).add(assignPanelLayout.createSequentialGroup().add(this.projectUsersPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add(this.projectGuestsPanel, -1, -1, Short.MAX_VALUE)).add(this.systemUsersPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(this.infoLabel, -2, 16, -2).addContainerGap()));
        UserListCellRenderer renderer = new UserListCellRenderer();
        this.systemUsersModel = new DefaultListModel();
        this.projectUsersModel = new DefaultListModel();
        this.guestUsersModel = new DefaultListModel();
        this.systemUsersList.setCellRenderer(renderer);
        this.systemUsersList.setModel(this.systemUsersModel);
        this.projectUsersList.setCellRenderer(renderer);
        this.projectUsersList.setModel(this.projectUsersModel);
        this.projectGuestsList.setCellRenderer(renderer);
        this.projectGuestsList.setModel(this.guestUsersModel);
        this.updateLanguage();
    }
}

