/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.model;

import java.awt.Color;
import java.util.Vector;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.ws.HiLayer;

public class HILayer {
    private Vector<RelativePolygon> polygons = new Vector();
    private Color layerColour;
    private HiLayer model;
    private int scaleX;
    private int scaleY;

    public HILayer(HiLayer model, int scaleX, int scaleY) {
        this.model = model;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.layerColour = new Color(model.getRed(), model.getGreen(), model.getBlue(), (int)(model.getOpacity() * 255.0f));
        if (model.getPolygons().length() > 0) {
            String[] stringArray = model.getPolygons().split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String polygon = stringArray[n2];
                this.polygons.addElement(new RelativePolygon(polygon, scaleX, scaleY));
                ++n2;
            }
        }
    }

    public void setScale(int scaleX, int scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        for (RelativePolygon polygon : this.polygons) {
            polygon.setScale(scaleX, scaleY);
        }
    }

    public Color getColour() {
        return this.layerColour;
    }

    public Color getSolidColour() {
        return new Color(this.layerColour.getRed(), this.layerColour.getGreen(), this.layerColour.getBlue());
    }

    public boolean hasChanges() {
        return this.layerColour.getRed() != this.model.getRed() || this.layerColour.getGreen() != this.model.getGreen() || this.layerColour.getBlue() != this.model.getBlue();
    }

    public boolean hasPolygonChanges() {
        return this.model.getPolygons().compareTo(this.serializePolygons()) != 0;
    }

    public void resetChanges() {
        this.layerColour = new Color(this.model.getRed(), this.model.getGreen(), this.model.getBlue(), (int)(this.model.getOpacity() * 255.0f));
    }

    public void syncChanges() {
        this.model.setRed(this.layerColour.getRed());
        this.model.setGreen(this.layerColour.getGreen());
        this.model.setBlue(this.layerColour.getBlue());
        this.model.setOpacity((float)this.layerColour.getAlpha() / 255.0f);
    }

    public void resetPolygonChanges() {
        this.polygons.removeAllElements();
        if (this.model.getPolygons().length() > 0) {
            String[] stringArray = this.model.getPolygons().split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String polygon = stringArray[n2];
                this.polygons.addElement(new RelativePolygon(polygon, this.scaleX, this.scaleY));
                ++n2;
            }
        }
    }

    private String serializePolygons() {
        String polygonString = null;
        if (this.polygons.size() > 0) {
            for (RelativePolygon polygon : this.polygons) {
                polygon.commitChangesToModel();
                String polygonModel = polygon.getModel();
                if (polygonModel.split(";", 2)[1].length() <= 0 || polygonModel.split(";", 2)[1].compareTo("0.0#0.0") == 0) continue;
                polygonString = polygonString != null ? String.valueOf(polygonString) + "|" + polygonModel : polygonModel;
            }
        }
        if (polygonString == null) {
            polygonString = "";
        }
        return polygonString;
    }

    public void syncPolygonChanges() {
        this.model.setPolygons(this.serializePolygons());
    }

    public void setColour(Color layerColour) {
        this.layerColour = new Color(layerColour.getRed(), layerColour.getGreen(), layerColour.getBlue(), this.layerColour.getAlpha());
    }

    public void setOpacity(int opacity) {
        this.layerColour = new Color(this.layerColour.getRed(), this.layerColour.getGreen(), this.layerColour.getBlue(), opacity);
    }

    public int getOpacity() {
        return this.layerColour.getAlpha();
    }

    public void setOpacity(float relOpacity) {
        int opacity = (int)relOpacity * 255;
        this.layerColour = new Color(this.layerColour.getRed(), this.layerColour.getGreen(), this.layerColour.getBlue(), opacity);
    }

    public Vector<RelativePolygon> getRelativePolygons() {
        return this.polygons;
    }

    public HiLayer getModel() {
        return this.model;
    }
}

