/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.model;

import java.util.Scanner;
import java.util.Vector;
import org.hyperimage.client.model.HIRichTextChunk;

public class HIRichText {
    private Vector<HIRichTextChunk> chunks = new Vector();

    public HIRichText() {
    }

    public HIRichText(String model) {
        this.modelToWrapper(model);
    }

    public Vector<HIRichTextChunk> getChunks() {
        return this.chunks;
    }

    public String getModel() {
        return this.wrapperToModel();
    }

    public String getHTMLModel() {
        return this.wrapperToHTMLModel();
    }

    public void addChunk(HIRichTextChunk.chunkTypes chunkType, String value) {
        this.chunks.add(new HIRichTextChunk(chunkType, value));
    }

    public void addChunk(HIRichTextChunk.chunkTypes chunkType, String value, String ref) {
        this.chunks.add(new HIRichTextChunk(chunkType, value, ref));
    }

    public void addChunk(HIRichTextChunk chunk) {
        this.chunks.add(chunk);
    }

    private String wrapperToModel() {
        String model = "";
        for (HIRichTextChunk chunk : this.chunks) {
            model = String.valueOf(model) + chunk.getModel();
        }
        return model;
    }

    private String wrapperToHTMLModel() {
        String model = "";
        for (HIRichTextChunk chunk : this.chunks) {
            model = String.valueOf(model) + chunk.getHTMLModel();
        }
        model = model.replaceAll("\n", "<br>");
        return "<html>" + model + "</html>";
    }

    private void modelToWrapper(String model) {
        this.chunks.removeAllElements();
        String ref = null;
        if (model == null) {
            return;
        }
        Scanner scanner = new Scanner(model).useDelimiter("\\{#\\}");
        while (scanner.hasNext()) {
            String key = scanner.next();
            if (key.indexOf(":") != -1) {
                ref = key.split(":", 2)[1];
            }
            if (!scanner.hasNext()) continue;
            String value = scanner.next();
            if (key.compareTo("bold") == 0) {
                this.addChunk(HIRichTextChunk.chunkTypes.BOLD, value);
                continue;
            }
            if (key.compareTo("italic") == 0) {
                this.addChunk(HIRichTextChunk.chunkTypes.ITALIC, value);
                continue;
            }
            if (key.compareTo("underline") == 0) {
                this.addChunk(HIRichTextChunk.chunkTypes.UNDERLINE, value);
                continue;
            }
            if (key.compareTo("subscript") == 0) {
                this.addChunk(HIRichTextChunk.chunkTypes.SUBSCRIPT, value);
                continue;
            }
            if (key.compareTo("superscript") == 0) {
                this.addChunk(HIRichTextChunk.chunkTypes.SUPERSCRIPT, value);
                continue;
            }
            if (key.compareTo("literal") == 0) {
                this.addChunk(HIRichTextChunk.chunkTypes.LITERAL, value);
                continue;
            }
            if (key.startsWith("link")) {
                this.addChunk(HIRichTextChunk.chunkTypes.LINK, value, ref);
                continue;
            }
            this.addChunk(HIRichTextChunk.chunkTypes.REGULAR, value);
        }
    }
}

