/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.model;

public class HIRichTextChunk {
    private chunkTypes chunkType;
    private String value;
    private String ref;

    public HIRichTextChunk(chunkTypes chunkType, String value) {
        this(chunkType, value, null);
    }

    public HIRichTextChunk(chunkTypes chunkType, String value, String ref) {
        this.chunkType = chunkType;
        this.value = value;
        this.value = value.replaceAll("\\{\\\\#\\}", "{#}");
        this.ref = null;
        if (chunkType == chunkTypes.LINK) {
            this.ref = ref;
        }
    }

    public chunkTypes getChunkType() {
        return this.chunkType;
    }

    public void setChunkType(chunkTypes chunkType) {
        this.chunkType = chunkType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getModel() {
        String key = "regular";
        if (this.chunkType == chunkTypes.BOLD) {
            key = "bold";
        } else if (this.chunkType == chunkTypes.ITALIC) {
            key = "italic";
        } else if (this.chunkType == chunkTypes.UNDERLINE) {
            key = "underline";
        } else if (this.chunkType == chunkTypes.SUBSCRIPT) {
            key = "subscript";
        } else if (this.chunkType == chunkTypes.SUPERSCRIPT) {
            key = "superscript";
        } else if (this.chunkType == chunkTypes.LITERAL) {
            key = "literal";
        } else if (this.chunkType == chunkTypes.LINK) {
            key = "link:" + this.ref;
        }
        return "{#}" + key + "{#}" + this.value.replaceAll("\\{#\\}", "{\\\\#}");
    }

    public String getHTMLModel() {
        String key = "";
        if (this.chunkType == chunkTypes.BOLD) {
            key = "b";
        } else if (this.chunkType == chunkTypes.ITALIC) {
            key = "i";
        } else if (this.chunkType == chunkTypes.UNDERLINE) {
            key = "u";
        } else if (this.chunkType == chunkTypes.SUBSCRIPT) {
            key = "sub";
        } else if (this.chunkType == chunkTypes.SUPERSCRIPT) {
            key = "sup";
        }
        String text = this.value;
        if (this.chunkType != chunkTypes.LITERAL) {
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
        }
        if (key.length() > 0) {
            text = "<" + key + ">" + text + "</" + key + ">";
        } else if (this.chunkType == chunkTypes.LINK) {
            text = "<a href=\"PeTAL://" + this.ref + "\">" + text + "</a>";
        }
        return text;
    }

    public static enum chunkTypes {
        REGULAR,
        BOLD,
        ITALIC,
        UNDERLINE,
        LINK,
        SUBSCRIPT,
        SUPERSCRIPT,
        LITERAL;

    }
}

