/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.model;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class RelativePolygon {
    private int scaleX = 0;
    private int scaleY = 0;
    private Vector<Double> pointsX = new Vector();
    private Vector<Double> pointsY = new Vector();
    private Vector<Line2D.Double> lines = new Vector();
    private HiPolygonTypes type = HiPolygonTypes.HI_FREEDESIGN;
    private String model;
    private GeneralPath polygonPath;
    private boolean closed = true;
    private boolean hasChanges = false;

    public RelativePolygon(String model, int scaleX, int scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.model = model;
        this.polygonPath = new GeneralPath();
        this.getPointsFromModel();
        this.createDisplayablePath();
    }

    public RelativePolygon(HiPolygonTypes type, int x, int y, int width, int height, String modelDesign, int scaleX, int scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.type = type;
        this.polygonPath = new GeneralPath();
        if (type == HiPolygonTypes.HI_FREEDESIGN) {
            this.addPoint(x, y);
            this.commitChangesToModel();
        } else if (type == HiPolygonTypes.HI_RECTANGLE) {
            this.addPoint(x, y);
            this.addPoint(x + width, y);
            this.addPoint(x + width, y + height);
            this.addPoint(x, y + height);
            this.commitChangesToModel();
        } else if (type == HiPolygonTypes.HI_FREEHAND) {
            this.addPoint(x, y);
            this.commitChangesToModel();
        } else if (type == HiPolygonTypes.HI_ARROW) {
            this.addPoint(x - width / 2, y - 7);
            this.addPoint(x, y - 7);
            this.addPoint(x, y - 14);
            this.addPoint(x + width / 3, y);
            this.addPoint(x, y + 14);
            this.addPoint(x, y + 7);
            this.addPoint(x - width / 2, y + 7);
            this.addPoint(x - width / 2, y - 7);
            this.commitChangesToModel();
        } else if (type == HiPolygonTypes.HI_CIRCLE) {
            int phi = 0;
            while (phi <= 640) {
                double xn = (double)width * Math.cos((double)phi / 100.0);
                double yn = (double)width * Math.sin((double)phi / 100.0);
                int tx = x + (int)xn;
                int ty = y + (int)yn;
                this.addPoint(tx, ty);
                phi += 6;
            }
            this.commitChangesToModel();
        } else {
            this.model = modelDesign;
        }
        this.getPointsFromModel();
        this.type = type;
        this.createDisplayablePath();
    }

    public String getChangedModel() {
        String points = String.valueOf(this.getModelType()) + ";";
        int i = 0;
        while (i < this.pointsX.size()) {
            points = String.valueOf(points) + this.pointsX.get(i) + "#" + this.pointsY.get(i);
            if (i < this.pointsX.size() - 1) {
                points = String.valueOf(points) + ";";
            }
            ++i;
        }
        if (this.pointsX.size() == 0) {
            points = String.valueOf(this.getModelType()) + ";0.0#0.0";
        }
        return points;
    }

    public void commitChangesToModel() {
        this.model = this.getChangedModel();
    }

    public void discardChanges() {
        this.getPointsFromModel();
        this.createDisplayablePath();
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void addPoint(double x, double y) {
        this.pointsX.add(x);
        this.pointsY.add(y);
        this.hasChanges = true;
        this.createDisplayablePath();
    }

    public void addPoint(int x, int y) {
        this.pointsX.add(new Double((double)x / (double)this.scaleX));
        this.pointsY.add(new Double((double)y / (double)this.scaleY));
        this.hasChanges = true;
        this.createDisplayablePath();
    }

    public void insertPointAfter(int index, int x, int y) {
        int insertIndex = Math.max(index, 0);
        insertIndex = Math.min(insertIndex, this.size() - 1);
        this.pointsX.insertElementAt((double)x / (double)this.scaleX, insertIndex + 1);
        this.pointsY.insertElementAt((double)y / (double)this.scaleY, insertIndex + 1);
        this.hasChanges = true;
        this.createDisplayablePath();
    }

    public void setScale(int scaleX, int scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.createDisplayablePath();
    }

    public void scale(int scaleX, int scaleY) {
        int i = 0;
        while (i < this.pointsX.size()) {
            this.pointsX.set(i, this.pointsX.get(i) * (double)scaleX);
            this.pointsY.set(i, this.pointsY.get(i) * (double)scaleY);
            ++i;
        }
    }

    public String toString() {
        String polygonString = "";
        if (this.pointsX.size() == 0) {
            return "0.0#0.0";
        }
        int i = 0;
        while (i < this.pointsX.size()) {
            polygonString = String.valueOf(polygonString) + this.pointsX.get(i).toString() + "#" + this.pointsY.get(i).toString() + ";";
            ++i;
        }
        return polygonString.substring(0, polygonString.length() - 1);
    }

    public void translate(int deltaX, int deltaY) {
        double dx = (double)deltaX / (double)this.scaleX;
        double dy = (double)deltaY / (double)this.scaleY;
        int i = 0;
        while (i < this.pointsX.size()) {
            this.pointsX.set(i, this.pointsX.get(i) + dx);
            this.pointsY.set(i, this.pointsY.get(i) + dy);
            this.hasChanges = true;
            this.createDisplayablePath();
            ++i;
        }
    }

    public void translate(double deltaX, double deltaY) {
        int i = 0;
        while (i < this.pointsX.size()) {
            this.pointsX.set(i, this.pointsX.get(i) + deltaX);
            this.pointsY.set(i, this.pointsY.get(i) + deltaY);
            ++i;
        }
        this.translate(new Long(Math.round(deltaX * (double)this.scaleX)).intValue(), new Long(Math.round(deltaY * (double)this.scaleY)).intValue());
        this.hasChanges = true;
    }

    public void movePoint(int index, int deltaX, int deltaY) {
        double dx = (double)deltaX / (double)this.scaleX;
        double dy = (double)deltaY / (double)this.scaleY;
        if (index >= 0 && index < this.pointsX.size()) {
            this.pointsX.set(index, this.pointsX.get(index) + dx);
            if (this.pointsX.get(index) > 1.0) {
                this.pointsX.set(index, 1.0);
            }
            if (this.pointsX.get(index) < 0.0) {
                this.pointsX.set(index, 0.0);
            }
            this.pointsY.set(index, this.pointsY.get(index) + dy);
            if (this.pointsY.get(index) > 1.0) {
                this.pointsY.set(index, 1.0);
            }
            if (this.pointsY.get(index) < 0.0) {
                this.pointsY.set(index, 0.0);
            }
            this.hasChanges = true;
            this.createDisplayablePath();
        }
    }

    public void movePointTo(int index, int x, int y) {
        double dx = (double)x / (double)this.scaleX;
        double dy = (double)y / (double)this.scaleY;
        if (index >= 0 && index < this.pointsX.size()) {
            this.pointsX.set(index, dx);
            if (this.pointsX.get(index) > 1.0) {
                this.pointsX.set(index, 1.0);
            }
            if (this.pointsX.get(index) < 0.0) {
                this.pointsX.set(index, 0.0);
            }
            this.pointsY.set(index, dy);
            if (this.pointsY.get(index) > 1.0) {
                this.pointsY.set(index, 1.0);
            }
            if (this.pointsY.get(index) < 0.0) {
                this.pointsY.set(index, 0.0);
            }
            this.hasChanges = true;
            this.createDisplayablePath();
        }
    }

    public void transformBy(double relX, double relY, PolygonResizeCorners corner) {
        if (corner != PolygonResizeCorners.LOWER_RIGHT) {
            return;
        }
        GeneralPath transformPath = new GeneralPath();
        if (this.pointsX.size() > 0) {
            transformPath.moveTo(this.pointsX.get(0), this.pointsY.get(0));
            int i = 1;
            while (i < this.pointsX.size()) {
                transformPath.lineTo(this.pointsX.get(i), this.pointsY.get(i));
                ++i;
            }
        }
        double oldX = transformPath.getBounds2D().getX();
        double oldY = transformPath.getBounds2D().getY();
        transformPath.transform(AffineTransform.getScaleInstance(relX, relY));
        double[] coords = new double[6];
        double transX = 0.0;
        double transY = 0.0;
        if (corner == PolygonResizeCorners.LOWER_RIGHT) {
            transX = oldX - transformPath.getBounds2D().getX();
            transY = oldY - transformPath.getBounds2D().getY();
        }
        PathIterator segments = transformPath.getPathIterator(AffineTransform.getTranslateInstance(transX, transY));
        int i = 0;
        while (i < this.pointsX.size()) {
            segments.currentSegment(coords);
            this.pointsX.set(i, coords[0]);
            this.pointsY.set(i, coords[1]);
            segments.next();
            ++i;
        }
        this.createDisplayablePath();
    }

    public void transformByAngle(double theta, PolygonResizeCorners corner) {
        double yk = (double)this.scaleX / (double)this.scaleY;
        GeneralPath transformPath = new GeneralPath();
        if (this.pointsX.size() > 0) {
            transformPath.moveTo(this.pointsX.get(0), this.pointsY.get(0) * (1.0 / yk));
            int i = 1;
            while (i < this.pointsX.size()) {
                transformPath.lineTo(this.pointsX.get(i), this.pointsY.get(i) * (1.0 / yk));
                ++i;
            }
        }
        double oldX = transformPath.getBounds2D().getX();
        double oldY = transformPath.getBounds2D().getY();
        transformPath.transform(AffineTransform.getRotateInstance(theta));
        double[] coords = new double[6];
        double transX = 0.0;
        double transY = 0.0;
        transX = oldX - transformPath.getBounds2D().getX();
        transY = oldY - transformPath.getBounds2D().getY();
        PathIterator segments = transformPath.getPathIterator(AffineTransform.getTranslateInstance(transX, transY));
        int i = 0;
        while (i < this.pointsX.size()) {
            segments.currentSegment(coords);
            this.pointsX.set(i, coords[0]);
            this.pointsY.set(i, coords[1] * yk);
            segments.next();
            ++i;
        }
        this.createDisplayablePath();
    }

    public void transformBy(int divX, int divY, PolygonResizeCorners corner) {
        if (corner != PolygonResizeCorners.LOWER_RIGHT) {
            return;
        }
        if (this.polygonPath.getBounds().width + divX < 10 || this.polygonPath.getBounds().height + divY < 10) {
            return;
        }
        double relX = (double)(this.polygonPath.getBounds().width + divX) / (double)this.polygonPath.getBounds().width;
        double relY = (double)(this.polygonPath.getBounds().height + divY) / (double)this.polygonPath.getBounds().height;
        this.transformBy(relX, relY, corner);
    }

    public void clipTo(int width, int height) {
        double scale;
        this.translate(-this.getPolygonPath().getBounds().x, -this.getPolygonPath().getBounds().y);
        GeneralPath transformPath = new GeneralPath();
        if (this.pointsX.size() > 0) {
            transformPath.moveTo(this.pointsX.get(0), this.pointsY.get(0));
            int i = 1;
            while (i < this.pointsX.size()) {
                transformPath.lineTo(this.pointsX.get(i), this.pointsY.get(i));
                ++i;
            }
        }
        if ((scale = Math.max(transformPath.getBounds2D().getWidth(), transformPath.getBounds2D().getHeight())) > 0.0) {
            this.transformBy(1.0 / scale, 1.0 / scale, PolygonResizeCorners.LOWER_RIGHT);
        }
        this.setScale(width, height);
    }

    public void removePoint(int index) {
        if (this.pointsX.size() > 1) {
            this.pointsX.remove(index);
            this.pointsY.remove(index);
            if (this.pointsX.size() == 1) {
                this.closed = false;
            }
            this.hasChanges = true;
            this.createDisplayablePath();
        }
    }

    public int size() {
        return this.pointsX.size();
    }

    public Point2D.Double getRelativePoint(int index) {
        return new Point2D.Double(this.pointsX.get(index), this.pointsY.get(index));
    }

    public Point getPoint(int index) {
        int insertIndex = index;
        if (insertIndex < 0 || insertIndex >= this.size()) {
            insertIndex = 0;
        }
        return new Point((int)(this.pointsX.get(insertIndex) * (double)this.scaleX), (int)(this.pointsY.get(insertIndex) * (double)this.scaleY));
    }

    public Point[] getPoints() {
        Point[] points = new Point[this.size()];
        int i = 0;
        while (i < this.size()) {
            points[i] = this.getPoint(i);
            ++i;
        }
        return points;
    }

    public void setPoints(Point[] points) {
        this.pointsX.clear();
        this.pointsY.clear();
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            if (point != null) {
                this.pointsX.add((double)point.x / (double)this.scaleX);
                this.pointsY.add((double)point.y / (double)this.scaleY);
            }
            ++n2;
        }
        this.hasChanges = true;
        this.createDisplayablePath();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        if (this.closed != closed) {
            this.closed = closed;
            this.createDisplayablePath();
        }
    }

    public String getModel() {
        return this.model;
    }

    public GeneralPath getPolygonPath() {
        return this.polygonPath;
    }

    public boolean isOnLine(int x, int y) {
        return this.getLinePoint(x, y) >= 0;
    }

    public int getLinePoint(int x, int y) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x - 2, y - 2, 4.0, 4.0);
        int count = 0;
        for (Line2D.Double line : this.lines) {
            if (line.intersects(rect)) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    public boolean isOnAnchor(int x, int y) {
        return this.getDragAnchor(x, y) >= 0;
    }

    public int getDragAnchor(int x, int y) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x - 3, y - 3, 6.0, 6.0);
        double[] coords = new double[6];
        int count = 0;
        PathIterator segments = this.polygonPath.getPathIterator(null);
        while (!segments.isDone()) {
            switch (segments.currentSegment(coords)) {
                case 0: 
                case 1: {
                    if (rect.contains(coords[0], coords[1])) {
                        return count;
                    }
                    segments.next();
                    ++count;
                    break;
                }
                default: {
                    segments.next();
                }
            }
        }
        return -1;
    }

    private void createDisplayablePath() {
        this.polygonPath.reset();
        this.lines.removeAllElements();
        this.polygonPath.setWindingRule(0);
        int i = 0;
        while (i < this.pointsX.size()) {
            if (i == 0) {
                this.polygonPath.moveTo((int)(this.pointsX.get(i) * (double)this.scaleX), (int)(this.pointsY.get(i) * (double)this.scaleY));
            } else {
                this.polygonPath.lineTo((int)(this.pointsX.get(i) * (double)this.scaleX), (int)(this.pointsY.get(i) * (double)this.scaleY));
                this.lines.addElement(new Line2D.Double(this.pointsX.get(i - 1) * (double)this.scaleX, this.pointsY.get(i - 1) * (double)this.scaleY, this.pointsX.get(i) * (double)this.scaleX, this.pointsY.get(i) * (double)this.scaleY));
            }
            ++i;
        }
        if (this.closed) {
            this.polygonPath.closePath();
            if (this.size() > 1) {
                this.lines.addElement(new Line2D.Double(this.pointsX.get(this.size() - 1) * (double)this.scaleX, this.pointsY.get(this.size() - 1) * (double)this.scaleY, this.pointsX.get(0) * (double)this.scaleX, this.pointsY.get(0) * (double)this.scaleY));
            }
        }
    }

    public HiPolygonTypes getType() {
        return this.type;
    }

    private String getModelType() {
        if (this.type == HiPolygonTypes.HI_RECTANGLE) {
            return "R";
        }
        if (this.type == HiPolygonTypes.HI_CIRCLE) {
            return "C";
        }
        if (this.type == HiPolygonTypes.HI_ARROW) {
            return "A";
        }
        if (this.type == HiPolygonTypes.HI_USERDESIGN) {
            return "U";
        }
        return "F";
    }

    public static String getModelType(HiPolygonTypes type) {
        if (type == HiPolygonTypes.HI_RECTANGLE) {
            return "R";
        }
        if (type == HiPolygonTypes.HI_CIRCLE) {
            return "C";
        }
        if (type == HiPolygonTypes.HI_ARROW) {
            return "A";
        }
        if (type == HiPolygonTypes.HI_USERDESIGN) {
            return "U";
        }
        return "F";
    }

    private HiPolygonTypes getTypeFromModel(String modelType) {
        HiPolygonTypes type = modelType == null ? HiPolygonTypes.HI_FREEDESIGN : (modelType.length() == 0 ? HiPolygonTypes.HI_FREEDESIGN : (modelType.startsWith("U") ? HiPolygonTypes.HI_USERDESIGN : (modelType.startsWith("R") ? HiPolygonTypes.HI_RECTANGLE : (modelType.startsWith("C") ? HiPolygonTypes.HI_CIRCLE : (modelType.startsWith("A") ? HiPolygonTypes.HI_ARROW : HiPolygonTypes.HI_FREEDESIGN)))));
        return type;
    }

    private void getPointsFromModel() {
        this.pointsX.removeAllElements();
        this.pointsY.removeAllElements();
        if (this.model == null) {
            this.model = String.valueOf(this.getModelType()) + ";";
        }
        if (this.model.compareTo("") == 0) {
            this.model = String.valueOf(this.getModelType()) + ";0.0#0.0";
        }
        this.type = this.getTypeFromModel(this.model.split(";", 2)[0]);
        String vertices = this.model.split(";", 2).length > 1 ? this.model.split(";", 2)[1] : "0.0#0.0";
        String[] stringArray = vertices.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String coords = stringArray[n2];
            String[] point = coords.split("#");
            this.addPoint(Double.parseDouble(point[0]), Double.parseDouble(point[1]));
            ++n2;
        }
        this.hasChanges = false;
    }

    public int getScaleX() {
        return this.scaleX;
    }

    public int getScaleY() {
        return this.scaleY;
    }

    public void convertToFreeDesign() {
        this.type = HiPolygonTypes.HI_FREEDESIGN;
    }

    public static enum HiPolygonTypes {
        HI_FREEDESIGN,
        HI_RECTANGLE,
        HI_CIRCLE,
        HI_ARROW,
        HI_FREEHAND,
        HI_USERDESIGN;

    }

    public static enum PolygonResizeCorners {
        NONE,
        UPPER_LEFT,
        UPPER_RIGHT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }
}

