/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class HIPreferenceManager {
    private static Preferences m_prefs = null;
    private static final String NODENAME = "/org/hyperimage/hieditor";
    private static final String PREF_FILENAME = "HyperPreferences.xml";
    private static final String DELIM = ",";
    private static final Integer DEF_SVR_HISTORY_SIZE = 4;
    private static final String SVR_PREF = "serverlist";
    private static final String DEF_SVR = "http://localhost";
    private static final String BACKING_STORE_AVAIL = "BackingStoreAvail";

    public HIPreferenceManager() {
        m_prefs = Preferences.userRoot().node(NODENAME);
        File prefFile = new File(PREF_FILENAME);
        if (!prefFile.exists() && HIPreferenceManager.backingStoreAvailable()) {
            this.initPrefs();
        }
    }

    public void initPrefs() {
        m_prefs.put(SVR_PREF, DEF_SVR);
        this.syncPrefs();
        this.exportPrefs();
    }

    public void putServerPref(String strNewSvr, Integer nServerHistory) {
        String strUpdatedServers = "";
        this.loadPrefs();
        ArrayDeque<String> serverLIFO = this.getServerPref();
        if (serverLIFO.contains(strNewSvr)) {
            if (strNewSvr.compareTo(serverLIFO.peekFirst()) == 0) {
                return;
            }
            serverLIFO.remove(strNewSvr);
        }
        serverLIFO.addFirst(strNewSvr);
        if (serverLIFO.size() < nServerHistory) {
            nServerHistory = serverLIFO.size();
        }
        int i = 0;
        while (i < nServerHistory) {
            String server = serverLIFO.removeFirst();
            strUpdatedServers = serverLIFO.size() == 0 ? String.valueOf(strUpdatedServers) + server : String.valueOf(strUpdatedServers) + server + DELIM;
            ++i;
        }
        m_prefs.put(SVR_PREF, strUpdatedServers);
        this.syncPrefs();
        this.exportPrefs();
    }

    public void putServerPref(String strNewSvr) {
        this.putServerPref(strNewSvr, DEF_SVR_HISTORY_SIZE);
    }

    public ArrayDeque<String> getServerPref() {
        String[] strarrSvrs;
        ArrayDeque<String> serverLIFO = new ArrayDeque<String>(DEF_SVR_HISTORY_SIZE + 1);
        this.loadPrefs();
        String strSvrs = m_prefs.get(SVR_PREF, DEF_SVR);
        String[] stringArray = strarrSvrs = strSvrs.split(DELIM);
        int n = strarrSvrs.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            serverLIFO.add(server);
            ++n2;
        }
        return serverLIFO;
    }

    public void loadPrefs() {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(PREF_FILENAME));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            Preferences.importPreferences(is);
        }
        catch (InvalidPreferencesFormatException ipfe) {
            ipfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void exportPrefs() {
        try {
            m_prefs.exportNode(new FileOutputStream(PREF_FILENAME));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    public void resetPrefs() {
        try {
            m_prefs.clear();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    private void syncPrefs() {
        try {
            m_prefs.sync();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    private static boolean backingStoreAvailable() {
        Preferences prefs = Preferences.userRoot().node("<temporary>");
        try {
            boolean oldValue = prefs.getBoolean(BACKING_STORE_AVAIL, false);
            prefs.putBoolean(BACKING_STORE_AVAIL, !oldValue);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            return false;
        }
        return true;
    }

    public void putPrefTest() {
        m_prefs.put("myString", "a string");
        m_prefs.putBoolean("myBoolean", true);
        m_prefs.putInt("myInt", 123);
        m_prefs.putLong("myLong", 123L);
        m_prefs.putFloat("myFloat", 12.3f);
        m_prefs.putDouble("myDouble", 12.3);
        byte[] bytes = new byte[10];
        m_prefs.putByteArray("myByteArray", bytes);
    }

    public String getPrefTest() {
        String prefValue = "SERVER: " + m_prefs.get(SVR_PREF, "could not retrieve the server");
        prefValue = String.valueOf(prefValue) + "BOOLEAN: " + m_prefs.getBoolean("myBoolean", false);
        return prefValue;
    }
}

