/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.util;

import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayInputStream;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ScaleDescriptor;
import javax.media.jai.operator.SubsampleAverageDescriptor;

public class ImageHelper {
    public static PlanarImage convertByteArrayToPlanarImage(byte[] data) {
        if (data == null) {
            return null;
        }
        return JAI.create("stream", SeekableStream.wrapInputStream(new ByteArrayInputStream(data), true));
    }

    public static RenderableImage convertByteArrayToRenderableImage(byte[] data) {
        if (data == null) {
            return null;
        }
        RenderedOp originalImage = JAI.create("stream", SeekableStream.wrapInputStream(new ByteArrayInputStream(data), true));
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(originalImage);
        pb.add(null).add(null).add(null).add(null).add(null);
        RenderableOp ren = JAI.createRenderable("renderable", pb);
        return ren;
    }

    public static PlanarImage scaleImageTo(PlanarImage originalImage, double relScale) {
        PlanarImage thumbnailImage = null;
        if (originalImage == null) {
            return null;
        }
        if (relScale == 1.0 || relScale == 0.0) {
            return originalImage;
        }
        if (relScale < 1.0) {
            PlanarImage ren = originalImage;
            thumbnailImage = SubsampleAverageDescriptor.create(ren, relScale, relScale, null).getRendering();
        } else {
            thumbnailImage = ScaleDescriptor.create(originalImage, new Float(relScale), new Float(relScale), new Float(0.0f), new Float(0.0f), Interpolation.getInstance(0), null);
        }
        return thumbnailImage;
    }

    public static PlanarImage scaleImageTo(RenderableImage originalImage, double relScale) {
        if (originalImage == null) {
            return null;
        }
        PlanarImage thumbnailImage = (PlanarImage)originalImage.createScaledRendering((int)((double)originalImage.getWidth() * relScale), (int)((double)originalImage.getHeight() * relScale), null);
        return thumbnailImage;
    }
}

