/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.model.HIRichText;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataName;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiKeyValue;
import org.hyperimage.client.ws.HiLanguage;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiPreference;
import org.hyperimage.client.ws.HiProject;
import org.hyperimage.client.ws.HiProjectMetadata;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;

public class MetadataHelper {
    private static final Charset syscharset = Charset.forName(System.getProperty("file.encoding"));
    private static final Charset utf8charset = Charset.forName("UTF-8");
    private static final CharsetDecoder decoder = syscharset.newDecoder();
    private static final CharsetEncoder encoder = utf8charset.newEncoder();

    public static List<HiFlexMetadataRecord> resolveMetadataRecords(HiBase base) {
        List<HiFlexMetadataRecord> records = null;
        records = !(base instanceof Hiurl) ? base.getMetadata() : new ArrayList<HiFlexMetadataRecord>();
        return records;
    }

    public static HiFlexMetadataRecord getDefaultMetadataRecord(HiBase base, HiLanguage language) {
        return MetadataHelper.getDefaultMetadataRecord(base, language.getLanguageId());
    }

    public static HiFlexMetadataRecord getDefaultMetadataRecord(HiBase base, String language) {
        HiFlexMetadataRecord record = null;
        if (base == null) {
            return record;
        }
        if (language == null) {
            return record;
        }
        List<HiFlexMetadataRecord> records = MetadataHelper.resolveMetadataRecords(base);
        for (HiFlexMetadataRecord rec : records) {
            if (rec.getLanguage().compareTo(language) != 0) continue;
            record = rec;
        }
        return record;
    }

    public static HiFlexMetadataRecord getDefaultMetadataRecord(List<HiFlexMetadataRecord> records, String language) {
        HiFlexMetadataRecord record = null;
        if (records == null) {
            return record;
        }
        for (HiFlexMetadataRecord rec : records) {
            if (rec.getLanguage().compareTo(language) != 0) continue;
            record = rec;
        }
        return record;
    }

    public static String findValue(HiFlexMetadataTemplate template, String key, HiFlexMetadataRecord record) {
        return MetadataHelper.findValue(template.getNamespacePrefix(), key, record);
    }

    public static String findValue(String template, String key, HiFlexMetadataRecord record) {
        String value = null;
        if (record == null) {
            return null;
        }
        for (HiKeyValue kvPair : record.getContents()) {
            if (kvPair.getKey().compareTo(String.valueOf(template) + "." + key) != 0) continue;
            value = kvPair.getValue();
        }
        return value;
    }

    public static boolean setValue(HiFlexMetadataTemplate template, String key, String value, HiFlexMetadataRecord record) {
        return MetadataHelper.setValue(template.getNamespacePrefix(), key, value, record);
    }

    public static boolean setValue(String template, String key, String value, HiFlexMetadataRecord record) {
        for (HiKeyValue kvPair : record.getContents()) {
            if (kvPair.getKey().compareTo(String.valueOf(template) + "." + key) != 0) continue;
            kvPair.setValue(value);
            return true;
        }
        return false;
    }

    public static String richTextToHTML(String richText) {
        HIRichText text = new HIRichText(richText);
        return text.getHTMLModel();
    }

    public static HiFlexMetadataTemplate getTemplateByNSPrefix(String nsPrefix) {
        for (HiFlexMetadataTemplate projTemplate : HIRuntime.getManager().getProject().getTemplates()) {
            if (projTemplate.getNamespacePrefix().compareTo(nsPrefix) != 0) continue;
            return projTemplate;
        }
        return null;
    }

    public static String getTemplateKeyDisplayName(HiFlexMetadataTemplate template, HiFlexMetadataSet keySet, String guiLang) {
        String displayName;
        block3: {
            block2: {
                displayName = null;
                displayName = keySet.getTagname();
                if (template == null || template.getNamespacePrefix().compareTo("HIInternal") != 0) break block2;
                if (guiLang.compareTo("de") != 0) break block3;
                if (keySet.getTagname().compareTo("catchall") == 0) {
                    displayName = "Zusatz";
                }
                if (keySet.getTagname().compareTo("note") != 0) break block3;
                displayName = "Notiz";
                break block3;
            }
            for (HiFlexMetadataName name : keySet.getDisplayNames()) {
                if (name.getLanguage().compareTo(guiLang) != 0) continue;
                displayName = name.getDisplayName();
            }
        }
        return displayName;
    }

    public static boolean setHasDisplayNameEntry(HiFlexMetadataSet set, String guiLang) {
        for (HiFlexMetadataName name : set.getDisplayNames()) {
            if (name.getLanguage().compareTo(guiLang) != 0) continue;
            return true;
        }
        return false;
    }

    public static String getTemplateKeyDisplayName(HiFlexMetadataTemplate template, String key, String guiLang) {
        HiFlexMetadataSet keySet = null;
        for (HiFlexMetadataSet entry : template.getEntries()) {
            if (entry.getTagname().compareTo(key) != 0) continue;
            keySet = entry;
        }
        if (keySet == null) {
            return key;
        }
        return MetadataHelper.getTemplateKeyDisplayName(template, keySet, guiLang);
    }

    public static HiFlexMetadataSet findTemplateEntryByTagName(String tagName, HiFlexMetadataTemplate template) {
        if (tagName == null || template == null) {
            return null;
        }
        for (HiFlexMetadataSet entry : template.getEntries()) {
            if (entry.getTagname().compareTo(tagName) != 0) continue;
            return entry;
        }
        return null;
    }

    public static HiPreference findPreference(HiProject project, String key) {
        for (HiPreference pref : project.getPreferences()) {
            if (pref.getKey().compareTo(key) != 0) continue;
            return pref;
        }
        return null;
    }

    public static String findPreferenceValue(HiProject project, String key) {
        for (HiPreference pref : project.getPreferences()) {
            if (pref.getKey().compareTo(key) != 0) continue;
            return pref.getValue();
        }
        return null;
    }

    public static boolean setPreferenceValue(HiProject project, String key, String value) {
        for (HiPreference pref : project.getPreferences()) {
            if (pref.getKey().compareTo(key) != 0) continue;
            pref.setValue(value);
            return true;
        }
        return false;
    }

    public static String getFullyQualifiedURI(HiQuickInfo info) {
        if (info.getUUID() != null) {
            return info.getUUID();
        }
        return String.valueOf(MetadataHelper.getProjectFullyQualifiedURI()) + "/" + MetadataHelper.getDisplayableID(info);
    }

    public static String getFullyQualifiedURI(HiBase base) {
        if (base.getUUID() != null) {
            return base.getUUID();
        }
        return String.valueOf(MetadataHelper.getProjectFullyQualifiedURI()) + "/" + MetadataHelper.getDisplayableID(base);
    }

    public static String getBaseIDQualifiedURI(HiQuickInfo info) {
        return String.valueOf(MetadataHelper.getProjectFullyQualifiedURI()) + "/" + MetadataHelper.getDisplayableID(info, true);
    }

    public static String getBaseIDQualifiedURI(HiBase base) {
        return String.valueOf(MetadataHelper.getProjectFullyQualifiedURI()) + "/" + MetadataHelper.getDisplayableID(base, true);
    }

    public static String getProjectFullyQualifiedURI() {
        String serverURL = HIRuntime.getManager().getServerURL();
        if (!serverURL.endsWith("/")) {
            serverURL = String.valueOf(serverURL) + "/";
        }
        String uriString = String.valueOf(serverURL) + "project/P" + HIRuntime.getManager().getProject().getId();
        return uriString;
    }

    public static String getDisplayableID(HiQuickInfo info) {
        return MetadataHelper.getDisplayableID(info, false);
    }

    public static String getDisplayableID(HiQuickInfo info, boolean disableUUID) {
        String dispID = "";
        if (info != null) {
            if (info.getContentType() == HiBaseTypes.HI_GROUP) {
                dispID = "G";
            }
            if (info.getContentType() == HiBaseTypes.HI_INSCRIPTION) {
                dispID = "I";
            }
            if (info.getContentType() == HiBaseTypes.HI_LAYER) {
                dispID = "L";
            }
            if (info.getContentType() == HiBaseTypes.HI_LIGHT_TABLE) {
                dispID = "X";
            }
            if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
                dispID = "O";
            }
            if (info.getContentType() == HiBaseTypes.HI_TEXT) {
                dispID = "T";
            }
            if (info.getContentType() == HiBaseTypes.HI_VIEW) {
                dispID = "V";
            }
            if (info.getContentType() == HiBaseTypes.HIURL) {
                dispID = "U";
            }
            dispID = info.getUUID() == null || disableUUID ? String.valueOf(dispID) + info.getBaseID() : info.getUUID();
        }
        return dispID;
    }

    public static String getDefaultLightTableXML() {
        String xml = "<lita id =\"\"><title xml:lang=\"\" /></lita>";
        return "<lita id =\"\"><title xml:lang=\"\" /></lita>";
    }

    public static String convertToUTF8(String input) {
        String output = input;
        try {
            ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(input));
            CharBuffer cbuf = decoder.decode(bbuf);
            output = cbuf.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return output;
    }

    public static String getDisplayableID(HiBase base) {
        return MetadataHelper.getDisplayableID(base, false);
    }

    public static String getDisplayableID(HiBase base, boolean disableUUID) {
        String dispID = "";
        if (base != null) {
            if (base instanceof HiGroup) {
                dispID = "G";
            }
            if (base instanceof HiInscription) {
                dispID = "I";
            }
            if (base instanceof HiLayer) {
                dispID = "L";
            }
            if (base instanceof HiLightTable) {
                dispID = "X";
            }
            if (base instanceof HiObject) {
                dispID = "O";
            }
            if (base instanceof HiText) {
                dispID = "T";
            }
            if (base instanceof Hiurl) {
                dispID = "U";
            }
            if (base instanceof HiView) {
                dispID = "V";
            }
            dispID = base.getUUID() == null || disableUUID ? String.valueOf(dispID) + base.getId() : base.getUUID();
        }
        return dispID;
    }

    public static String findValue(HiProject project, String languageId) {
        String title = null;
        if (project == null || project.getMetadata() == null) {
            return title;
        }
        for (HiProjectMetadata metadata : project.getMetadata()) {
            if (metadata.getLanguageID().compareTo(languageId) != 0) continue;
            title = metadata.getTitle();
        }
        return title;
    }

    public static boolean setValue(HiProject project, String languageId, String title) {
        if (project == null || project.getMetadata() == null) {
            return false;
        }
        for (HiProjectMetadata metadata : project.getMetadata()) {
            if (metadata.getLanguageID().compareTo(languageId) != 0) continue;
            metadata.setTitle(title);
            return true;
        }
        return false;
    }

    public static Locale langToLocale(HiLanguage hiLang) {
        return MetadataHelper.langToLocale(hiLang.getLanguageId());
    }

    public static Locale langToLocale(String language) {
        if (language.indexOf("_") >= 0) {
            return new Locale(language.substring(0, language.indexOf(95)), language.substring(language.indexOf(95) + 1));
        }
        return new Locale(language);
    }

    public static String localeToLangID(Locale lang) {
        String langID = lang.getLanguage();
        if (lang.getCountry().length() > 0 && !lang.getCountry().equalsIgnoreCase(langID)) {
            langID = String.valueOf(langID) + "_" + lang.getCountry();
        }
        langID = langID.toLowerCase();
        return langID;
    }

    private static void addMetadataSet(HiFlexMetadataTemplate metadataTemplate, boolean isRichText, String strTagName, String[][] arrLanguageName) {
        HiFlexMetadataSet metadataSet = new HiFlexMetadataSet();
        metadataSet.setRichText(isRichText);
        metadataSet.setTagname(strTagName);
        String[][] stringArray = arrLanguageName;
        int n = arrLanguageName.length;
        int n2 = 0;
        while (n2 < n) {
            String[] arrLanguageNameEntry = stringArray[n2];
            HiFlexMetadataName metadataName = new HiFlexMetadataName();
            metadataName.setLanguage(arrLanguageNameEntry[0]);
            metadataName.setDisplayName(arrLanguageNameEntry[1]);
            metadataSet.getDisplayNames().add(metadataName);
            ++n2;
        }
        metadataTemplate.getEntries().add(metadataSet);
    }

    public static HiFlexMetadataTemplate getVRACore4TemplateBlueprint() {
        HiFlexMetadataTemplate vra4Template = new HiFlexMetadataTemplate();
        vra4Template.setNamespacePrefix("vra4");
        vra4Template.setNamespaceURI("http://www.vraweb.org/vracore4.htm");
        vra4Template.setNamespaceURL("http://www.vraweb.org/vracore4.htm");
        String[][] strarrLangName = null;
        strarrLangName = new String[][]{{"en", "Work"}, {"de", "Werk"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "work", strarrLangName);
        strarrLangName = new String[][]{{"en", "Agent"}, {"de", "Agent"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "agent", strarrLangName);
        strarrLangName = new String[][]{{"en", "Cultural Context"}, {"de", "Kultureller Kontext"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "culturalContext", strarrLangName);
        strarrLangName = new String[][]{{"en", "Date"}, {"de", "Datum"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "date", strarrLangName);
        strarrLangName = new String[][]{{"en", "Description"}, {"de", "Beschreibung"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "description", strarrLangName);
        strarrLangName = new String[][]{{"en", "Location"}, {"de", "Ort"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "location", strarrLangName);
        strarrLangName = new String[][]{{"en", "Material"}, {"de", "Material"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "material", strarrLangName);
        strarrLangName = new String[][]{{"en", "Measurements"}, {"de", "Ma\u00dfe"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "measurements", strarrLangName);
        strarrLangName = new String[][]{{"en", "Relation"}, {"de", "Beziehung"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "relation", strarrLangName);
        strarrLangName = new String[][]{{"en", "Rights"}, {"de", "Rechte"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "rights", strarrLangName);
        strarrLangName = new String[][]{{"en", "Source"}, {"de", "Quelle"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "source", strarrLangName);
        strarrLangName = new String[][]{{"en", "State / Edition"}, {"de", "Zustand / Edition"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "stateEdition", strarrLangName);
        strarrLangName = new String[][]{{"en", "Style / Period"}, {"de", "Stil / Periode"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "stylePeriod", strarrLangName);
        strarrLangName = new String[][]{{"en", "Subject"}, {"de", "Thema / Gegenstand"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "subject", strarrLangName);
        strarrLangName = new String[][]{{"en", "Technique"}, {"de", "Technik / Methode"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "technique", strarrLangName);
        strarrLangName = new String[][]{{"en", "Text Ref"}, {"de", "Text Ref"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "textref", strarrLangName);
        strarrLangName = new String[][]{{"en", "Title"}, {"de", "Titel"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "title", strarrLangName);
        strarrLangName = new String[][]{{"en", "Work Type"}, {"de", "Werkart"}};
        MetadataHelper.addMetadataSet(vra4Template, true, "worktype", strarrLangName);
        return vra4Template;
    }

    private String[][] prepVRA4GlobalMetadata(String strBaseEN, String strBaseDE) {
        String[][] strarrLangName = new String[][]{{"en", String.valueOf(strBaseEN) + ".id"}, {"de", String.valueOf(strBaseDE) + ".id"}};
        return strarrLangName;
    }

    public static HiFlexMetadataTemplate getVRACore4HdlbgExtTemplateBlueprint() {
        HiFlexMetadataTemplate vra4HdlbgExtTemplate = MetadataHelper.getVRACore4TemplateBlueprint();
        vra4HdlbgExtTemplate.setNamespacePrefix("vra4hdlbg");
        vra4HdlbgExtTemplate.setNamespaceURI("http://www.vraweb.org/vracore4.htm");
        vra4HdlbgExtTemplate.setNamespaceURL("http://www.vraweb.org/vracore4.htm");
        String[][] strarrLangName = null;
        strarrLangName = new String[][]{{"en", "Extension"}, {"de", "Erweiterung"}};
        MetadataHelper.addMetadataSet(vra4HdlbgExtTemplate, true, "extension", strarrLangName);
        return vra4HdlbgExtTemplate;
    }

    public static HiFlexMetadataTemplate getDCTemplateBlueprint() {
        HiFlexMetadataTemplate dcTemplate = new HiFlexMetadataTemplate();
        dcTemplate.setNamespacePrefix("dc");
        dcTemplate.setNamespaceURI("http://purl.org/dc/elements/1.1/");
        dcTemplate.setNamespaceURL("http://purl.org/dc/elements/1.1/");
        HiFlexMetadataSet dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("contributor");
        HiFlexMetadataName dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Mitwirkende / Mitwirkender");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("contributor");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("coverage");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Geltungsbereich");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("coverage");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("creator");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Urheberin / Urheber");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("creator");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("date");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Zeitangabe");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("date");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("description");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Beschreibung");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("description");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("format");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Format");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("format");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("identifier");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Identifikator");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("identifier");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("language");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Sprache");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("language");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("publisher");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Verlegerin / Verleger");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("publisher");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("relation");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Beziehung");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("relation");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("rights");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Rechte");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("rights");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("source");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Quelle");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("source");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("subject");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Thema");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("subject");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("title");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Titel");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("title");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        dcSet = new HiFlexMetadataSet();
        dcSet.setRichText(false);
        dcSet.setTagname("type");
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("Typ");
        dcName.setLanguage("de");
        dcSet.getDisplayNames().add(dcName);
        dcName = new HiFlexMetadataName();
        dcName.setDisplayName("type");
        dcName.setLanguage("en");
        dcSet.getDisplayNames().add(dcName);
        dcTemplate.getEntries().add(dcSet);
        return dcTemplate;
    }

    public static HiFlexMetadataTemplate getCDWALiteTemplateBlueprint() {
        HiFlexMetadataTemplate cdwaTemplate = new HiFlexMetadataTemplate();
        cdwaTemplate.setNamespacePrefix("cdwalite");
        cdwaTemplate.setNamespaceURI("http://www.getty.edu/CDWA/CDWALite");
        cdwaTemplate.setNamespaceURL("http://www.getty.edu/CDWA/CDWALite/CDWALite-xsd-public-v1-1.xsd");
        HiFlexMetadataSet cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("objectWorkType");
        HiFlexMetadataName cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Objekt / Typ");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Object / Work Type");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("title");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Titel");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Title");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("displayCreator");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Anzeigedaten des Erstellers");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Display Creator");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("nameCreator");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Name des Erstellers");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Name of Creator");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("nationalityCreator");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Nationalit\u00e4t des Erstellers");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Nationality Creator");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("vitalDatesCreator");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Wichtige Vita-Daten des Erstellers");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Vital Dates Creator");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("roleCreator");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Rolle des Erstellers");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Role Creator");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("displayMeasurements");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Anzeige-Ma\u00dfe");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Display Measurements");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("displayMaterialsTech");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Materialien / Methoden");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Display Materials / Techniques");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("displayCreationDate");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Anzeige-Erstellungsdatum");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Display Creation Date");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("earliestDate");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Anfangsdatum");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Earliest Date");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("latestDate");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Enddatum");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Latest Date");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("locationName");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Standort / Repository Name");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Location / Repository Name");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("workID");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Repository Objekt ID");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Repository Work Identification Number");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("subjectTerm");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Beschreibung / Begriffe des Werkinhaltes");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Indexing Subject Term");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("recordID");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Lokale Datensatz ID");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Record ID");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        cdwaSet = new HiFlexMetadataSet();
        cdwaSet.setRichText(false);
        cdwaSet.setTagname("recordType");
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Datensatz Typ");
        cdwaName.setLanguage("de");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaName = new HiFlexMetadataName();
        cdwaName.setDisplayName("Record Type");
        cdwaName.setLanguage("en");
        cdwaSet.getDisplayNames().add(cdwaName);
        cdwaTemplate.getEntries().add(cdwaSet);
        return cdwaTemplate;
    }

    public static HiFlexMetadataTemplate getCustomTemplateBlueprint() {
        HiFlexMetadataTemplate customTemplate = new HiFlexMetadataTemplate();
        customTemplate.setNamespacePrefix("custom");
        customTemplate.setNamespaceURI("");
        customTemplate.setNamespaceURL("");
        return customTemplate;
    }

    public static String getFuzzyDate(long timestamp) {
        String fuzzyDate = "";
        long now = new Date().getTime();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(now - timestamp);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(now - timestamp);
        long hours = TimeUnit.MILLISECONDS.toHours(now - timestamp);
        long days = TimeUnit.MILLISECONDS.toDays(now - timestamp);
        long weeks = days / 7L;
        long months = days / 30L;
        long years = days / 365L;
        fuzzyDate = years > 0L ? (years == 1L ? Messages.getString("MetadataHelper.oneYearAgo") : String.format(Messages.getString("MetadataHelper.yearsAgo"), years)) : (months > 0L ? (months == 1L ? Messages.getString("MetadataHelper.oneMonthAgo") : String.format(Messages.getString("MetadataHelper.monthsAgo"), months)) : (weeks > 0L ? (weeks == 1L ? Messages.getString("MetadataHelper.oneWeekAgo") : String.format(Messages.getString("MetadataHelper.weeksAgo"), weeks)) : (days > 0L ? (days == 1L ? Messages.getString("MetadataHelper.oneDayAgo") : String.format(Messages.getString("MetadataHelper.daysAgo"), days)) : (hours > 0L ? (hours == 1L ? Messages.getString("MetadataHelper.oneHourAgo") : String.format(Messages.getString("MetadataHelper.hoursAgo"), hours)) : (minutes > 0L ? (minutes == 1L ? Messages.getString("MetadataHelper.oneMinuteAgo") : String.format(Messages.getString("MetadataHelper.minutesAgo"), minutes)) : (seconds > 4L ? String.format(Messages.getString("MetadataHelper.secondsAgo"), seconds) : Messages.getString("MetadataHelper.now")))))));
        return fuzzyDate;
    }
}

