/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.util;

import javax.media.jai.PlanarImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.util.LoadableImage;
import org.hyperimage.client.ws.HiImageSizes;

public class WSImageLoaderThread
extends Thread {
    private Thread thread = new Thread(this);
    private long viewID;
    private LoadableImage imageComponent;
    private JComponent container;
    private boolean cacheImage = true;
    private HiImageSizes imgSize;

    public void loadImage(long viewID, boolean cacheImage, HiImageSizes imgSize, LoadableImage imageComponent, JComponent container) {
        this.viewID = viewID;
        this.cacheImage = cacheImage;
        this.imgSize = imgSize;
        this.imageComponent = imageComponent;
        this.container = container;
        this.thread.start();
    }

    public void loadImage(long viewID, HiImageSizes imgSize, LoadableImage imageComponent, JComponent container) {
        this.viewID = viewID;
        this.cacheImage = true;
        this.imgSize = imgSize;
        this.imageComponent = imageComponent;
        this.container = container;
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            final PlanarImage thumbnail = HIRuntime.getManager().getImage(this.viewID, this.imgSize, this.cacheImage);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WSImageLoaderThread.this.imageComponent.setPreviewImage(thumbnail);
                    WSImageLoaderThread.this.container.repaint();
                    WSImageLoaderThread.this.container.doLayout();
                }
            });
        }
        catch (HIWebServiceException hIWebServiceException) {
            // empty catch block
        }
    }
}

