/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.xmlimportexport;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.model.HIRichText;
import org.hyperimage.client.model.HIRichTextChunk;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataName;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLanguage;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiProject;
import org.hyperimage.client.ws.HiProjectMetadata;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LegacyHIPeTALExporter {
    public static Vector<HiView> projectViews = new Vector();

    public static Document getProjectToPeTALXML(HiProject hiProject) {
        DocumentBuilder xmlDocumentBuilder;
        Document petalXML = null;
        Vector<Element> groupNodes = new Vector<Element>();
        HashMap<Long, Element> textNodes = new HashMap<Long, Element>();
        HashMap<Long, Element> objectNodes = new HashMap<Long, Element>();
        HashMap<Long, Element> litaNodes = new HashMap<Long, Element>();
        HashMap<Long, Element> urlNodes = new HashMap<Long, Element>();
        projectViews.removeAllElements();
        try {
            xmlDocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return petalXML;
        }
        petalXML = xmlDocumentBuilder.newDocument();
        Element project = petalXML.createElement("petal");
        project.setAttribute("xmlns", "http://www.hyperimage.eu/PeTAL/1.2");
        project.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        project.setAttribute("xsi:schemaLocation", "http://www.hyperimage.eu/PeTAL/1.2 http://hyperimage.cms.hu-berlin.de/2.0/schema/PeTAL_schema_1.2.xsd");
        project.setAttribute("version", "1.2");
        if (hiProject == null) {
            return petalXML;
        }
        project.setAttribute("id", "P" + hiProject.getId());
        String startRef = "";
        if (hiProject.getStartObjectInfo() != null) {
            startRef = MetadataHelper.getDisplayableID(hiProject.getStartObjectInfo());
        }
        project.setAttribute("startRef", startRef);
        petalXML.appendChild(project);
        for (HiLanguage lang : hiProject.getLanguages()) {
            Element tempLanguage = petalXML.createElement("language");
            if (lang.getId() == hiProject.getDefaultLanguage().getId()) {
                tempLanguage.setAttribute("standard", "true");
            }
            tempLanguage.appendChild(petalXML.createTextNode(lang.getLanguageId()));
            project.appendChild(tempLanguage);
        }
        for (HiProjectMetadata metadata : hiProject.getMetadata()) {
            Element tempTitle = petalXML.createElement("title");
            tempTitle.setAttribute("xml:lang", metadata.getLanguageID());
            tempTitle.appendChild(petalXML.createTextNode(LegacyHIPeTALExporter.validateUTF8(metadata.getTitle())));
            project.appendChild(tempTitle);
        }
        for (HiFlexMetadataTemplate template : hiProject.getTemplates()) {
            if (template.getNamespacePrefix().compareTo("HIBase") == 0) continue;
            Element tempTemplate = petalXML.createElement("template");
            tempTemplate.setAttribute("id", "T_" + template.getId() + "_" + template.getNamespacePrefix());
            tempTemplate.setAttribute("nsPrefix", template.getNamespacePrefix());
            tempTemplate.setAttribute("schema", template.getNamespaceURI());
            if (template.getNamespaceURL().length() > 0) {
                tempTemplate.setAttribute("schemaLocation", template.getNamespaceURL());
            }
            for (HiFlexMetadataSet set : template.getEntries()) {
                Element tempSet = petalXML.createElement("key");
                tempSet.setAttribute("tagName", set.getTagname());
                if (set.isRichText()) {
                    tempSet.setAttribute("richText", "true");
                }
                for (HiFlexMetadataName name : set.getDisplayNames()) {
                    Element tempDisplayName = petalXML.createElement("displayName");
                    tempDisplayName.setAttribute("xml:lang", name.getLanguage());
                    tempDisplayName.appendChild(petalXML.createTextNode(name.getDisplayName()));
                    tempSet.appendChild(tempDisplayName);
                }
                tempTemplate.appendChild(tempSet);
            }
            project.appendChild(tempTemplate);
        }
        try {
            List<HiGroup> groups = HIRuntime.getManager().getGroups();
            groups.add(0, HIRuntime.getManager().getImportGroup());
            float percentage = 100.0f / (float)(groups.size() - 1);
            float progress = 0.0f;
            int groupIndex = 0;
            while (groupIndex < groups.size()) {
                HiGroup group = groups.get(groupIndex);
                Element tempGroup = petalXML.createElement("group");
                tempGroup.setAttribute("id", "G" + group.getId());
                if (group.getType() == GroupTypes.HIGROUP_IMPORT) {
                    tempGroup.setAttribute("type", "import");
                } else if (group.getType() == GroupTypes.HIGROUP_REGULAR) {
                    tempGroup.setAttribute("type", "regular");
                } else {
                    tempGroup.setAttribute("type", "trash");
                }
                for (Element element : LegacyHIPeTALExporter.getSingleLineBaseElementNodes("title", "title", "HIBase", group.getMetadata(), petalXML)) {
                    tempGroup.appendChild(element);
                }
                for (Element element : LegacyHIPeTALExporter.getMultiLineBaseElementNodes("comment", "annotation", "HIBase", group.getMetadata(), petalXML)) {
                    tempGroup.appendChild(element);
                }
                List<HiQuickInfo> contents = HIRuntime.getManager().getGroupContents(group);
                LegacyHIPeTALExporter.sortContents(contents, group.getSortOrder());
                float contentPercentage = 0.0f;
                if (contents.size() > 0) {
                    contentPercentage = 1.0f / (float)contents.size();
                }
                int contentIndex = 0;
                while (contentIndex < contents.size()) {
                    HiQuickInfo content = contents.get(contentIndex);
                    float updatedProgress = percentage * (float)groupIndex + percentage * (contentPercentage * (float)contentIndex);
                    if ((int)updatedProgress != (int)progress) {
                        progress = updatedProgress;
                        HIRuntime.getGui().setProgress((int)progress);
                    }
                    Element tempContent = petalXML.createElement("member");
                    tempContent.setAttribute("ref", MetadataHelper.getDisplayableID(content));
                    tempGroup.appendChild(tempContent);
                    if (content.getContentType() == HiBaseTypes.HI_OBJECT && !objectNodes.containsKey(content.getBaseID())) {
                        objectNodes.put(content.getBaseID(), LegacyHIPeTALExporter.getObjectElement((HiObject)HIRuntime.getManager().getBaseElement(content.getBaseID()), hiProject, petalXML));
                    }
                    if (content.getContentType() == HiBaseTypes.HI_TEXT && !textNodes.containsKey(content.getBaseID())) {
                        textNodes.put(content.getBaseID(), LegacyHIPeTALExporter.getTextElement((HiText)HIRuntime.getManager().getBaseElement(content.getBaseID()), petalXML));
                    }
                    if (content.getContentType() == HiBaseTypes.HIURL && !urlNodes.containsKey(content.getBaseID())) {
                        urlNodes.put(content.getBaseID(), LegacyHIPeTALExporter.getURLElement((Hiurl)HIRuntime.getManager().getBaseElement(content.getBaseID()), petalXML));
                    }
                    if (content.getContentType() == HiBaseTypes.HI_LIGHT_TABLE && !litaNodes.containsKey(content.getBaseID())) {
                        litaNodes.put(content.getBaseID(), LegacyHIPeTALExporter.getLightTableElement((HiLightTable)HIRuntime.getManager().getBaseElement(content.getBaseID()), petalXML));
                    }
                    ++contentIndex;
                }
                groupNodes.addElement(tempGroup);
                ++groupIndex;
            }
            for (Long key : textNodes.keySet()) {
                project.appendChild((Node)textNodes.get(key));
            }
            for (Long key : objectNodes.keySet()) {
                project.appendChild((Node)objectNodes.get(key));
            }
            for (Long key : litaNodes.keySet()) {
                project.appendChild((Node)litaNodes.get(key));
            }
            for (Long key : urlNodes.keySet()) {
                project.appendChild((Node)urlNodes.get(key));
            }
            for (Element group : groupNodes) {
                project.appendChild(group);
            }
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, null);
            return petalXML;
        }
        HIRuntime.getGui().setProgress(-1);
        return petalXML;
    }

    public static String validateUTF8(String input) {
        return input;
    }

    private static void sortContents(List<HiQuickInfo> contents, String sortOrder) {
        if (contents == null) {
            return;
        }
        int index = 0;
        String[] stringArray = sortOrder.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long contentID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < contents.size()) {
                    if (contents.get(i).getBaseID() == contentID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiQuickInfo content = contents.get(contentIndex);
                        contents.remove(contentIndex);
                        contents.add(index, content);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static void sortLayers(List<HiLayer> layers, String sortOrder) {
        int index = 0;
        String[] stringArray = sortOrder.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long layerID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < layers.size()) {
                    if (layers.get(i).getId() == layerID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiLayer layer = layers.get(contentIndex);
                        layers.remove(contentIndex);
                        layers.add(index, layer);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static void sortObjectContent(List<HiObjectContent> contents, String sortOrder) {
        int index = 0;
        String[] stringArray = sortOrder.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long contentID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < contents.size()) {
                    if (contents.get(i).getId() == contentID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiObjectContent content = contents.get(contentIndex);
                        contents.remove(contentIndex);
                        contents.add(index, content);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static Element getLightTableElement(HiLightTable lightTable, Document creator) {
        Element lightTableElement = creator.createElement("lita");
        lightTableElement.setAttribute("id", "X" + lightTable.getId());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            factory.setNamespaceAware(false);
            builder = factory.newDocumentBuilder();
            if (builder != null) {
                builder.setErrorHandler(null);
            }
            builder.reset();
            ByteArrayInputStream input = new ByteArrayInputStream(MetadataHelper.convertToUTF8(lightTable.getXml()).getBytes());
            Document doc = builder.parse(input);
            lightTableElement = (Element)creator.adoptNode(doc.getElementsByTagName("lita").item(0));
            lightTableElement.setAttribute("id", "X" + lightTable.getId());
        }
        catch (ParserConfigurationException e) {
            return lightTableElement;
        }
        catch (SAXException e) {
            return lightTableElement;
        }
        catch (IOException e) {
            return lightTableElement;
        }
        return lightTableElement;
    }

    private static Element getURLElement(Hiurl url, Document creator) {
        Element urlElement = creator.createElement("url");
        urlElement.setAttribute("id", "U" + url.getId());
        urlElement.setAttribute("ref", url.getUrl());
        Element titleElement = creator.createElement("title");
        titleElement.appendChild(creator.createTextNode(LegacyHIPeTALExporter.validateUTF8(url.getTitle())));
        urlElement.appendChild(titleElement);
        Element annotationElement = creator.createElement("annotation");
        LegacyHIPeTALExporter.serializeMultiLineField(url.getLastAccess(), annotationElement, creator);
        urlElement.appendChild(annotationElement);
        urlElement.removeAttribute("xml:lang");
        return urlElement;
    }

    private static Element getTextElement(HiText text, Document creator) {
        Element textElement = creator.createElement("text");
        textElement.setAttribute("id", "T" + text.getId());
        for (HiFlexMetadataRecord record : text.getMetadata()) {
            textElement.appendChild(LegacyHIPeTALExporter.getSingleLineBaseElementNode("title", "title", "HIBase", record, creator));
            textElement.appendChild(LegacyHIPeTALExporter.getMultiLineBaseElementNode("content", "content", "HIBase", record, creator));
        }
        return textElement;
    }

    private static Element getObjectElement(HiObject object, HiProject project, Document creator) {
        Element objectElement = creator.createElement("object");
        if (object == null) {
            return objectElement;
        }
        objectElement.setAttribute("id", "O" + object.getId());
        if (object.getDefaultView() != null) {
            Element defViewElement = creator.createElement("standardView");
            defViewElement.setAttribute("ref", MetadataHelper.getDisplayableID(object.getDefaultView()));
            objectElement.appendChild(defViewElement);
        }
        LegacyHIPeTALExporter.sortObjectContent(object.getViews(), object.getSortOrder());
        for (HiObjectContent content : object.getViews()) {
            if (content instanceof HiView) {
                objectElement.appendChild(LegacyHIPeTALExporter.getViewElement((HiView)content, creator));
                continue;
            }
            objectElement.appendChild(LegacyHIPeTALExporter.getInscriptionElement((HiInscription)content, creator));
        }
        for (HiFlexMetadataRecord record : object.getMetadata()) {
            Element metadataElement = creator.createElement("metadata");
            metadataElement.setAttribute("xml:lang", record.getLanguage());
            for (HiFlexMetadataTemplate template : project.getTemplates()) {
                if (template.getNamespacePrefix().compareTo("HIBase") == 0) continue;
                Element recordElement = creator.createElement("record");
                recordElement.setAttribute("template", "T_" + template.getId() + "_" + template.getNamespacePrefix());
                for (HiFlexMetadataSet set : template.getEntries()) {
                    Element valueElement = set.isRichText() ? LegacyHIPeTALExporter.getMultiLineBaseElementNode(set.getTagname(), "value", template.getNamespacePrefix(), record, creator) : LegacyHIPeTALExporter.getSingleLineBaseElementNode(set.getTagname(), "value", template.getNamespacePrefix(), record, creator);
                    valueElement.setAttribute("key", set.getTagname());
                    valueElement.removeAttribute("xml:lang");
                    recordElement.appendChild(valueElement);
                }
                metadataElement.appendChild(recordElement);
            }
            objectElement.appendChild(metadataElement);
        }
        return objectElement;
    }

    private static Element getInscriptionElement(HiInscription inscription, Document creator) {
        Element inscriptionElement = creator.createElement("inscription");
        inscriptionElement.setAttribute("id", "I" + inscription.getId());
        for (Element element : LegacyHIPeTALExporter.getMultiLineBaseElementNodes("content", "content", "HIBase", inscription.getMetadata(), creator)) {
            inscriptionElement.appendChild(element);
        }
        return inscriptionElement;
    }

    private static Element getViewElement(HiView view, Document creator) {
        Element viewElement = creator.createElement("view");
        viewElement.setAttribute("id", "V" + view.getId());
        Element originalElement = creator.createElement("original");
        originalElement.setAttribute("filename", view.getFilename());
        originalElement.setAttribute("hash", view.getHash());
        viewElement.appendChild(originalElement);
        viewElement.appendChild(LegacyHIPeTALExporter.getImgElement(view.getWidth(), view.getHeight(), "img/V" + view.getId() + ".jpg", "pict", creator));
        if (view.getWidth() > 0 || view.getHeight() > 0) {
            double scale = 400.0 / (double)Math.max(view.getWidth(), view.getHeight());
            viewElement.appendChild(LegacyHIPeTALExporter.getImgElement((int)((double)view.getWidth() * scale), (int)((double)view.getHeight() * scale), "img/V" + view.getId() + "_prev.jpg", "pict", creator));
            scale = 128.0 / (double)Math.max(view.getWidth(), view.getHeight());
            viewElement.appendChild(LegacyHIPeTALExporter.getImgElement((int)((double)view.getWidth() * scale), (int)((double)view.getHeight() * scale), "img/V" + view.getId() + "_thumb.jpg", "thumb", creator));
        }
        for (Element element : LegacyHIPeTALExporter.getSingleLineBaseElementNodes("title", "title", "HIBase", view.getMetadata(), creator)) {
            viewElement.appendChild(element);
        }
        for (Element element : LegacyHIPeTALExporter.getSingleLineBaseElementNodes("source", "source", "HIBase", view.getMetadata(), creator)) {
            viewElement.appendChild(element);
        }
        for (Element element : LegacyHIPeTALExporter.getMultiLineBaseElementNodes("comment", "annotation", "HIBase", view.getMetadata(), creator)) {
            viewElement.appendChild(element);
        }
        boolean isInStore = false;
        for (HiView storedView : projectViews) {
            if (storedView.getId() != view.getId()) continue;
            isInStore = true;
        }
        if (!isInStore) {
            projectViews.addElement(view);
        }
        LegacyHIPeTALExporter.sortLayers(view.getLayers(), view.getSortOrder());
        int zOrder = view.getLayers().size();
        while (zOrder >= 1) {
            HiLayer layer = view.getLayers().get(zOrder - 1);
            viewElement.appendChild(LegacyHIPeTALExporter.getLayerElement(layer, zOrder, creator));
            --zOrder;
        }
        return viewElement;
    }

    private static Node getLayerElement(HiLayer layer, int order, Document creator) {
        Element layerElement = creator.createElement("layer");
        layerElement.setAttribute("id", "L" + layer.getId());
        String color = "#";
        color = Integer.toHexString(layer.getRed()).length() < 2 ? String.valueOf(color) + "0" + Integer.toHexString(layer.getRed()) : String.valueOf(color) + Integer.toHexString(layer.getRed());
        color = Integer.toHexString(layer.getGreen()).length() < 2 ? String.valueOf(color) + "0" + Integer.toHexString(layer.getGreen()) : String.valueOf(color) + Integer.toHexString(layer.getGreen());
        color = Integer.toHexString(layer.getBlue()).length() < 2 ? String.valueOf(color) + "0" + Integer.toHexString(layer.getBlue()) : String.valueOf(color) + Integer.toHexString(layer.getBlue());
        layerElement.setAttribute("color", color);
        layerElement.setAttribute("opacity", Float.toString(layer.getOpacity()));
        if (layer.getLinkInfo() != null) {
            layerElement.setAttribute("ref", MetadataHelper.getDisplayableID(layer.getLinkInfo()));
        }
        layerElement.setAttribute("order", Integer.toString(order));
        for (Element element : LegacyHIPeTALExporter.getSingleLineBaseElementNodes("title", "title", "HIBase", layer.getMetadata(), creator)) {
            layerElement.appendChild(element);
        }
        for (Element element : LegacyHIPeTALExporter.getMultiLineBaseElementNodes("comment", "annotation", "HIBase", layer.getMetadata(), creator)) {
            layerElement.appendChild(element);
        }
        HILayer wrapper = new HILayer(layer, 400, 400);
        for (RelativePolygon polygon : wrapper.getRelativePolygons()) {
            layerElement.appendChild(LegacyHIPeTALExporter.getPolygonElement(polygon, creator));
        }
        return layerElement;
    }

    private static Element getPolygonElement(RelativePolygon polygon, Document creator) {
        String points;
        Element polygonElement = creator.createElement("polygon");
        if (polygon.getType() == RelativePolygon.HiPolygonTypes.HI_RECTANGLE) {
            polygonElement.setAttribute("type", "rectangle");
        }
        if (polygon.getType() == RelativePolygon.HiPolygonTypes.HI_USERDESIGN) {
            polygonElement.setAttribute("type", "custom");
        }
        if ((points = polygon.getModel()).length() > 2) {
            points = points.substring(2);
        }
        points = points.replaceAll("#", ",");
        points = points.replaceAll(";", " ");
        polygonElement.setAttribute("points", points);
        return polygonElement;
    }

    private static Element getImgElement(int width, int height, String src, String use, Document creator) {
        Element imgElement = creator.createElement("img");
        imgElement.setAttribute("width", Integer.toString(width));
        imgElement.setAttribute("height", Integer.toString(height));
        imgElement.setAttribute("src", src);
        imgElement.setAttribute("use", use);
        return imgElement;
    }

    private static List<Element> getSingleLineBaseElementNodes(String key, String elementTitle, String template, List<HiFlexMetadataRecord> records, Document creator) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (records == null) {
            return elements;
        }
        for (HiFlexMetadataRecord record : records) {
            elements.add(LegacyHIPeTALExporter.getSingleLineBaseElementNode(key, elementTitle, template, record, creator));
        }
        return elements;
    }

    private static Element getSingleLineBaseElementNode(String key, String elementTitle, String template, HiFlexMetadataRecord record, Document creator) {
        Element tempElement = creator.createElement(elementTitle);
        tempElement.setAttribute("xml:lang", record.getLanguage());
        tempElement.appendChild(creator.createTextNode(LegacyHIPeTALExporter.validateUTF8(MetadataHelper.findValue(template, key, record))));
        return tempElement;
    }

    private static Vector<String> breakdownLines(String lines) {
        Vector<String> cutLines = new Vector<String>();
        do {
            String line;
            if (lines.indexOf("\n") < 0) {
                line = lines;
                continue;
            }
            line = lines.substring(0, lines.indexOf("\n"));
            lines = lines.substring(lines.indexOf("\n") + 1);
            cutLines.addElement(line);
        } while (lines.indexOf("\n") >= 0);
        cutLines.addElement(lines);
        return cutLines;
    }

    private static void serializeMultiLineField(String model, Element multiLineElement, Document creator) {
        HIRichText text = new HIRichText(model);
        HIRichTextChunk.chunkTypes chunkState = null;
        Element chunkNode = null;
        if (text.getChunks().size() == 0) {
            return;
        }
        if (text.getChunks().size() == 1 && text.getChunks().get(0).getValue().length() == 0) {
            return;
        }
        Element lineElement = creator.createElement("line");
        multiLineElement.appendChild(lineElement);
        chunkNode = lineElement;
        for (HIRichTextChunk chunk : text.getChunks()) {
            if (chunk.getChunkType() != HIRichTextChunk.chunkTypes.LINK) {
                if (chunkState != chunk.getChunkType()) {
                    if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.REGULAR) {
                        chunkNode = lineElement;
                    } else {
                        String tag = null;
                        if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.BOLD) {
                            tag = "b";
                        }
                        if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.ITALIC) {
                            tag = "i";
                        }
                        if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.UNDERLINE) {
                            tag = "u";
                        }
                        if (tag == null) {
                            chunkNode = lineElement;
                        } else {
                            chunkNode = creator.createElement(tag);
                            lineElement.appendChild(chunkNode);
                        }
                    }
                    chunkState = chunk.getChunkType();
                }
                Vector<String> lines = LegacyHIPeTALExporter.breakdownLines(chunk.getValue());
                int i = 0;
                while (i < lines.size()) {
                    String line = lines.get(i);
                    chunkNode.appendChild(creator.createTextNode(LegacyHIPeTALExporter.validateUTF8(line)));
                    if (i < lines.size() - 1) {
                        lineElement = creator.createElement("line");
                        multiLineElement.appendChild(lineElement);
                        if (chunkState == HIRichTextChunk.chunkTypes.REGULAR) {
                            chunkNode = lineElement;
                        } else {
                            String tag = null;
                            if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.BOLD) {
                                tag = "b";
                            }
                            if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.ITALIC) {
                                tag = "i";
                            }
                            if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.UNDERLINE) {
                                tag = "u";
                            }
                            if (tag == null) {
                                chunkNode = lineElement;
                            } else {
                                chunkNode = creator.createElement(tag);
                                lineElement.appendChild(chunkNode);
                            }
                        }
                    }
                    ++i;
                }
                continue;
            }
            Vector<String> lines = LegacyHIPeTALExporter.breakdownLines(chunk.getValue());
            int i = 0;
            while (i < lines.size()) {
                String line = lines.get(i);
                if (line.length() > 0) {
                    Element linkElement = creator.createElement("link");
                    linkElement.setAttribute("ref", chunk.getRef());
                    linkElement.appendChild(creator.createTextNode(LegacyHIPeTALExporter.validateUTF8(line)));
                    chunkNode.appendChild(linkElement);
                }
                if (i < lines.size() - 1) {
                    lineElement = creator.createElement("line");
                    multiLineElement.appendChild(lineElement);
                    if (chunkState == HIRichTextChunk.chunkTypes.REGULAR) {
                        chunkNode = lineElement;
                    } else {
                        String tag = null;
                        if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.BOLD) {
                            tag = "b";
                        }
                        if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.ITALIC) {
                            tag = "i";
                        }
                        if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.UNDERLINE) {
                            tag = "u";
                        }
                        if (tag == null) {
                            chunkNode = lineElement;
                        } else {
                            chunkNode = creator.createElement(tag);
                            lineElement.appendChild(chunkNode);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static Element getMultiLineBaseElementNode(String key, String elementTitle, String template, HiFlexMetadataRecord record, Document creator) {
        Element tempElement = creator.createElement(elementTitle);
        tempElement.setAttribute("xml:lang", record.getLanguage());
        LegacyHIPeTALExporter.serializeMultiLineField(MetadataHelper.findValue(template, key, record), tempElement, creator);
        return tempElement;
    }

    private static List<Element> getMultiLineBaseElementNodes(String key, String elementTitle, String template, List<HiFlexMetadataRecord> records, Document creator) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (records == null) {
            return elements;
        }
        for (HiFlexMetadataRecord record : records) {
            elements.add(LegacyHIPeTALExporter.getMultiLineBaseElementNode(key, elementTitle, template, record, creator));
        }
        return elements;
    }

    public static String serializeXMLDocument(Document doc) {
        OutputFormat xmlFormat = new OutputFormat();
        xmlFormat.setEncoding("UTF-8");
        xmlFormat.setVersion("1.0");
        xmlFormat.setIndenting(true);
        xmlFormat.setIndent(4);
        xmlFormat.setPreserveEmptyAttributes(true);
        ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
        XMLSerializer x = new XMLSerializer(xmlStream, xmlFormat);
        x.setOutputFormat(xmlFormat);
        x.setOutputByteStream(xmlStream);
        try {
            x.serialize(doc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xmlStream.toString();
    }

    public static void serializeXMLDocumentToFile(Document doc, File outputFile) {
        OutputFormat xmlFormat = new OutputFormat("XML", "UTF-8", true);
        xmlFormat.setIndenting(true);
        xmlFormat.setIndent(4);
        xmlFormat.setPreserveEmptyAttributes(true);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        XMLSerializer xmlSerializer = new XMLSerializer(fos, xmlFormat);
        try {
            xmlSerializer.asDOMSerializer().serialize(doc.getDocumentElement());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

