/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.xmlimportexport;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.HIRichTextFieldControl;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.model.HIRichText;
import org.hyperimage.client.model.HIRichTextChunk;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataName;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLanguage;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiPreference;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.hyperimage.client.xmlimportexport.PeTALExporter;
import org.hyperimage.client.xmlimportexport.XMLImporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PeTAL2Importer
extends XMLImporter {
    public PeTAL2Importer(File inputFile, Document xmlDocument) {
        this.xmlDocument = xmlDocument;
        this.inputFile = inputFile;
    }

    private String resolveDisplayableNewID(String oldURIID) {
        HiLayer layer;
        HiInscription inscription;
        HiView view;
        HiObject object;
        HiGroup group;
        HiLightTable lita;
        Hiurl url;
        HiText text;
        String newID = "";
        String oldID = oldURIID.substring(oldURIID.lastIndexOf("/") + 1);
        if (oldID.startsWith("T") && (text = (HiText)this.textIDMap.get(oldID)) != null) {
            newID = "T" + text.getId();
        }
        if (oldID.startsWith("U") && (url = (Hiurl)this.urlIDMap.get(oldID)) != null) {
            newID = "U" + url.getId();
        }
        if (oldID.startsWith("X") && (lita = (HiLightTable)this.litaIDMap.get(oldID)) != null) {
            newID = "X" + lita.getId();
        }
        if (oldID.startsWith("G") && (group = (HiGroup)this.groupIDMap.get(oldID)) != null) {
            newID = "G" + group.getId();
        }
        if (oldID.startsWith("O") && (object = (HiObject)this.objectIDMap.get(oldID)) != null) {
            newID = "O" + object.getId();
        }
        if (oldID.startsWith("V") && (view = (HiView)this.viewIDMap.get(oldID)) != null) {
            newID = "V" + view.getId();
        }
        if (oldID.startsWith("I") && (inscription = (HiInscription)this.inscriptionIDMap.get(oldID)) != null) {
            newID = "I" + inscription.getId();
        }
        if (oldID.startsWith("L") && (layer = (HiLayer)this.layerIDMap.get(oldID)) != null) {
            newID = "L" + layer.getId();
        }
        return newID;
    }

    private long resolveNewID(String oldURIID) {
        HiLayer layer;
        HiInscription inscription;
        HiView view;
        HiObject object;
        HiGroup group;
        HiLightTable lita;
        Hiurl url;
        HiText text;
        long newID = 0L;
        String oldID = oldURIID.substring(oldURIID.lastIndexOf("/") + 1);
        if (oldID.startsWith("T") && (text = (HiText)this.textIDMap.get(oldID)) != null) {
            newID = text.getId();
        }
        if (oldID.startsWith("U") && (url = (Hiurl)this.urlIDMap.get(oldID)) != null) {
            newID = url.getId();
        }
        if (oldID.startsWith("X") && (lita = (HiLightTable)this.litaIDMap.get(oldID)) != null) {
            newID = lita.getId();
        }
        if (oldID.startsWith("G") && (group = (HiGroup)this.groupIDMap.get(oldID)) != null) {
            newID = group.getId();
        }
        if (oldID.startsWith("O") && (object = (HiObject)this.objectIDMap.get(oldID)) != null) {
            newID = object.getId();
        }
        if (oldID.startsWith("V") && (view = (HiView)this.viewIDMap.get(oldID)) != null) {
            newID = view.getId();
        }
        if (oldID.startsWith("I") && (inscription = (HiInscription)this.inscriptionIDMap.get(oldID)) != null) {
            newID = inscription.getId();
        }
        if (oldID.startsWith("L") && (layer = (HiLayer)this.layerIDMap.get(oldID)) != null) {
            newID = layer.getId();
        }
        return newID;
    }

    private String getTextNodeContent(Node textNode) {
        String textContent = "";
        textContent = textNode.getTextContent();
        if ((textContent = textContent.replaceAll("[ ]*[\t\n]+[\t\n ]*\\z", "")).length() == 0) {
            textContent = " ";
        }
        textContent = textContent.replaceAll("[ ]*[\t\n]+[\t\n ]*", " ");
        return textContent;
    }

    private String getSubElementText(Element subElement) {
        String textContent = "";
        NodeList subNodes = subElement.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node subNode = subNodes.item(i);
            if (subNode.getNodeType() == 3) {
                textContent = String.valueOf(textContent) + this.getTextNodeContent(subNode);
            } else if (((Element)subNode).getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && ((Element)subNode).getLocalName().compareTo("br") == 0) {
                textContent = String.valueOf(textContent) + "\n";
            }
            ++i;
        }
        return textContent;
    }

    private void processSubNode(Element subElement, HIRichText hiText, HIRichTextChunk.chunkTypes chunkType) {
        String textContent = "";
        NodeList subNodes = subElement.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node subNode = subNodes.item(i);
            if (subNode.getNodeType() == 3) {
                if (i < subNodes.getLength() - 1 || subNode.getTextContent().replaceAll("[ \t\n]*", "").length() > 0) {
                    textContent = String.valueOf(textContent) + this.getTextNodeContent(subNode);
                }
            } else if (((Element)subNode).getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && ((Element)subNode).getLocalName().compareTo("br") == 0) {
                textContent = String.valueOf(textContent) + "\n";
            } else if (((Element)subNode).getNamespaceURI().compareTo("http://www.hyperimage.eu/PeTAL/2.0") == 0 && ((Element)subNode).getLocalName().compareTo("link") == 0) {
                if (textContent.length() > 0) {
                    hiText.addChunk(chunkType, textContent);
                }
                textContent = "";
                String href = ((Element)subNode).getAttributeNS("http://www.w3.org/1999/xlink", "href");
                if (href != null && href.length() > 0) {
                    href = this.resolveDisplayableNewID(href);
                    String subContent = this.getSubElementText((Element)subNode);
                    if (subContent.length() > 0) {
                        if (href.length() > 0) {
                            hiText.addChunk(HIRichTextChunk.chunkTypes.LINK, subContent, href);
                        } else {
                            hiText.addChunk(chunkType, subContent, href);
                        }
                    }
                }
            }
            ++i;
        }
        if (textContent.length() > 0) {
            hiText.addChunk(chunkType, textContent);
        }
    }

    private String getSingleLineTextContent(Element element, String namespace, String tagName) {
        String temp;
        String textContent = "";
        if (element == null) {
            return textContent;
        }
        if (element.getElementsByTagNameNS(namespace, tagName).getLength() > 0 && (temp = element.getElementsByTagNameNS(namespace, tagName).item(0).getTextContent()) != null) {
            textContent = temp.trim();
        }
        return textContent;
    }

    private String getMultiLineTextContent(Element element, String namespace, String tagName) {
        String textContent = new HIRichText().getModel();
        if (element == null) {
            return textContent;
        }
        if (element.getElementsByTagNameNS(namespace, tagName).getLength() > 0) {
            textContent = this.convertRichTextXMLField((Element)element.getElementsByTagNameNS(namespace, tagName).item(0));
        }
        HIRichTextFieldControl control = new HIRichTextFieldControl("import");
        control.setText(textContent);
        textContent = control.getText();
        return textContent;
    }

    private String convertRichTextXMLField(Element richTextElement) {
        String modelText = "";
        HIRichText hiText = new HIRichText();
        String chunkText = "";
        String chunkRef = "";
        NodeList chunkNodes = richTextElement.getChildNodes();
        int i = 0;
        while (i < chunkNodes.getLength()) {
            Node chunkNode = chunkNodes.item(i);
            if (chunkNode.getNodeType() == 3) {
                if (chunkNode.getTextContent().replaceAll("[ \t\n]*", "").length() == 0) {
                    if (i >= chunkNodes.getLength() - 1 || chunkNodes.item(i + 1).getNodeType() != 1 || ((Element)chunkNodes.item(i + 1)).getTagName().equalsIgnoreCase("html:br") || ((Element)chunkNodes.item(i + 1)).getTagName().equalsIgnoreCase("link")) {
                        chunkText = String.valueOf(chunkText) + this.getTextNodeContent(chunkNode);
                    }
                } else {
                    chunkText = String.valueOf(chunkText) + this.getTextNodeContent(chunkNode);
                }
            } else {
                Element chunkElement = (Element)chunkNode;
                if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("br") == 0) {
                    chunkText = String.valueOf(chunkText) + "\n";
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("b") == 0) {
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                    }
                    chunkText = "";
                    this.processSubNode(chunkElement, hiText, HIRichTextChunk.chunkTypes.BOLD);
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("i") == 0) {
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                    }
                    chunkText = "";
                    this.processSubNode(chunkElement, hiText, HIRichTextChunk.chunkTypes.ITALIC);
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("u") == 0) {
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                    }
                    chunkText = "";
                    this.processSubNode(chunkElement, hiText, HIRichTextChunk.chunkTypes.UNDERLINE);
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.hyperimage.eu/PeTAL/2.0") == 0 && chunkElement.getLocalName().compareTo("link") == 0) {
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                    }
                    chunkText = "";
                    String href = chunkElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                    if (href != null && href.length() > 0) {
                        href = this.resolveDisplayableNewID(href);
                        String subContent = this.getSubElementText(chunkElement);
                        if (subContent.length() > 0) {
                            if (href.length() > 0) {
                                hiText.addChunk(HIRichTextChunk.chunkTypes.LINK, subContent, href);
                            } else {
                                hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, subContent, href);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (chunkText.length() > 0) {
            hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
        }
        modelText = hiText.getModel();
        return modelText;
    }

    private void attachMetadataRecords(Element mdElement, List<HiFlexMetadataRecord> records, String nsURI1, String tagName1, String mdName1, String nsURI2, String tagName2, String mdName2, String nsURI3, String tagName3, String mdName3) throws HIWebServiceException {
        NodeList descElements = mdElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        int i = 0;
        while (i < descElements.getLength()) {
            Element descElement = (Element)descElements.item(i);
            String lang = descElement.getAttribute("xml:lang");
            if (this.checkLangInProject(lang)) {
                HiFlexMetadataRecord record;
                String tagContent1 = null;
                if (tagName1 != null) {
                    tagContent1 = this.getSingleLineTextContent(descElement, nsURI1, tagName1);
                }
                String tagContent2 = null;
                if (tagName2 != null) {
                    tagContent2 = this.getSingleLineTextContent(descElement, nsURI2, tagName2);
                }
                String tagContent3 = null;
                if (tagName3 != null) {
                    tagContent3 = this.getMultiLineTextContent(descElement, nsURI3, tagName3);
                }
                if ((record = MetadataHelper.getDefaultMetadataRecord(records, lang)) != null) {
                    if (mdName1 != null) {
                        MetadataHelper.setValue("HIBase", mdName1, tagContent1, record);
                    }
                    if (mdName2 != null) {
                        MetadataHelper.setValue("HIBase", mdName2, tagContent2, record);
                    }
                    if (mdName3 != null) {
                        MetadataHelper.setValue("HIBase", mdName3, tagContent3, record);
                    }
                }
                HIRuntime.getManager().updateFlexMetadataRecord(record);
            }
            ++i;
        }
    }

    private void setStartRef() {
        this.startRef = this.xmlDocument.getDocumentElement().getAttribute("startRef");
        if (this.startRef == null || this.startRef.length() == 0) {
            this.xmlDocument = null;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.42"));
        long newStartRef = this.resolveNewID(this.startRef);
        if (newStartRef > 0L) {
            try {
                HIRuntime.getManager().updateProjectStartElement(newStartRef);
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void importLanguages() {
        this.languages.clear();
        NodeList langElements = this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "language");
        String defLang = null;
        int i = 0;
        while (i < langElements.getLength()) {
            Element langElement = (Element)langElements.item(i);
            this.languages.add(langElement.getTextContent().trim());
            if (langElement.getAttribute("standard") != null && langElement.getAttribute("standard").equalsIgnoreCase("true")) {
                defLang = langElement.getTextContent().trim();
            }
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.8"));
        for (String lang : this.languages) {
            if (this.checkLangInProject(lang)) continue;
            try {
                HIRuntime.getManager().addLanguageToProject(lang);
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            HIRuntime.getManager().updateProjectDefaultLanguage(defLang);
        }
        catch (HIWebServiceException ex) {
            Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
        }
        ArrayList<String> unusedLangs = new ArrayList<String>();
        for (HiLanguage projLang : HIRuntime.getManager().getProject().getLanguages()) {
            boolean langIsInProject = false;
            for (String lang : this.languages) {
                if (!lang.equalsIgnoreCase(projLang.getLanguageId())) continue;
                langIsInProject = true;
            }
            if (langIsInProject) continue;
            unusedLangs.add(projLang.getLanguageId());
        }
        for (String unusedLang : unusedLangs) {
            try {
                HIRuntime.getManager().removeLanguageFromProject(unusedLang);
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void importProjectMetadata() {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.9"));
        if (this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "projectMetadata").getLength() > 0) {
            Element projMetadataElement = (Element)this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "projectMetadata").item(0);
            NodeList mdElements = projMetadataElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            int i = 0;
            while (i < mdElements.getLength()) {
                Element mdElement = (Element)mdElements.item(i);
                if (this.checkLangInProject((mdElement = (Element)mdElement.getElementsByTagNameNS("http://purl.org/dc/elements/1.1/", "title").item(0)).getAttribute("xml:lang"))) {
                    try {
                        HIRuntime.getManager().updateProject(mdElement.getAttribute("xml:lang"), mdElement.getTextContent().trim());
                    }
                    catch (HIWebServiceException ex) {
                        Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                ++i;
            }
        }
    }

    private void importTemplates() {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.10"));
        NodeList templateElements = this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "template");
        int i = 0;
        while (i < templateElements.getLength()) {
            Element templateElement = (Element)templateElements.item(i);
            if (!templateElement.getAttribute("nsPrefix").equalsIgnoreCase("HIBase")) {
                boolean templateIsInProject = false;
                for (HiFlexMetadataTemplate projTemplate : HIRuntime.getManager().getProject().getTemplates()) {
                    if (!projTemplate.getNamespacePrefix().equalsIgnoreCase(templateElement.getAttribute("nsPrefix")) && !projTemplate.getNamespaceURI().equalsIgnoreCase(templateElement.getAttribute("schema"))) continue;
                    this.templates.add(projTemplate);
                    templateIsInProject = true;
                }
                if (!templateIsInProject) {
                    HiFlexMetadataTemplate newTemplate = new HiFlexMetadataTemplate();
                    newTemplate.setNamespacePrefix(templateElement.getAttribute("nsPrefix"));
                    newTemplate.setNamespaceURI(templateElement.getAttribute("schema"));
                    newTemplate.setNamespaceURL(templateElement.getAttribute("schemaLocation"));
                    HiFlexMetadataSet newSet = null;
                    HiFlexMetadataName newName = null;
                    NodeList keyElements = templateElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "key");
                    int a = 0;
                    while (a < keyElements.getLength()) {
                        Element keyElement = (Element)keyElements.item(a);
                        newSet = new HiFlexMetadataSet();
                        newSet.setRichText(false);
                        if (keyElement.getAttribute("richText") != null && keyElement.getAttribute("richText").equalsIgnoreCase("true")) {
                            newSet.setRichText(true);
                        }
                        newSet.setTagname(keyElement.getAttribute("tagName"));
                        NodeList nameElements = keyElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "displayName");
                        int b = 0;
                        while (b < nameElements.getLength()) {
                            Element nameElement = (Element)nameElements.item(b);
                            newName = new HiFlexMetadataName();
                            newName.setDisplayName(nameElement.getTextContent().trim());
                            newName.setLanguage(nameElement.getAttribute("xml:lang"));
                            newSet.getDisplayNames().add(newName);
                            ++b;
                        }
                        newTemplate.getEntries().add(newSet);
                        ++a;
                    }
                    try {
                        if (HIRuntime.getManager().addTemplateToProject(newTemplate)) {
                            this.templates.add(newTemplate);
                        }
                    }
                    catch (HIWebServiceException ex) {
                        Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            ++i;
        }
    }

    private void importTexts() {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.11"));
        NodeList textElements = this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "text");
        int counter = 1;
        int i = 0;
        while (i < textElements.getLength()) {
            Element textElement = (Element)textElements.item(i);
            this.texts.add(textElement);
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.20"));
        for (Element textElement : this.texts) {
            HiText newText = null;
            try {
                newText = HIRuntime.getManager().createText();
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.textMap.put(newText, textElement);
            this.textIDMap.put(textElement.getAttribute("id"), newText);
        }
        for (Element textElement : this.textMap.values()) {
            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.34")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + this.textMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
            HiText text = (HiText)this.textIDMap.get(textElement.getAttribute("id"));
            try {
                this.attachMetadataRecords(textElement, text.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://www.hyperimage.eu/PeTAL/HIView/1.0", "content", "content");
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++counter;
        }
    }

    private void importURLs() {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.16"));
        NodeList urlElements = this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "url");
        int i = 0;
        while (i < urlElements.getLength()) {
            Element urlElement = (Element)urlElements.item(i);
            this.urls.add(urlElement);
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.21"));
        for (Element urlElement : this.urls) {
            Hiurl newURL = null;
            try {
                newURL = HIRuntime.getManager().createURL(urlElement.getAttributeNS("http://www.w3.org/1999/xlink", "href"), urlElement.getAttributeNS("http://www.w3.org/1999/xlink", "title"), "");
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.urlMap.put(newURL, urlElement);
            this.urlIDMap.put(urlElement.getAttribute("id"), newURL);
        }
    }

    private void stageObjectImport() {
        NodeList projElements = null;
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.12"));
        projElements = this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "object");
        int i = 0;
        while (i < projElements.getLength()) {
            Element objectElement = (Element)projElements.item(i);
            this.objects.add(objectElement);
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.13"));
        projElements = this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "view");
        i = 0;
        while (i < projElements.getLength()) {
            Element viewElement = (Element)projElements.item(i);
            this.views.add(viewElement);
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.14"));
        projElements = this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "inscription");
        i = 0;
        while (i < projElements.getLength()) {
            Element inscriptionElement = (Element)projElements.item(i);
            this.inscriptions.add(inscriptionElement);
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.15"));
        projElements = this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "layer");
        i = 0;
        while (i < projElements.getLength()) {
            Element layerElement = (Element)projElements.item(i);
            this.layers.add(layerElement);
            ++i;
        }
    }

    private void importObjectsViewsInscriptionsLayers() {
        String sortOrder = "";
        this.stageObjectImport();
        int counter = 1;
        for (Element objectElement : this.objects) {
            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + " " + Messages.getString("PeTALImporter.25") + " " + this.objects.size() + " " + Messages.getString("PeTALImporter.26"));
            HiObject newObject = null;
            try {
                newObject = HIRuntime.getManager().createObject();
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.objectMap.put(newObject, objectElement);
            this.objectIDMap.put(objectElement.getAttribute("id"), newObject);
            NodeList contentElements = objectElement.getChildNodes();
            String standardView = null;
            sortOrder = "";
            int i = 0;
            while (i < contentElements.getLength()) {
                if (contentElements.item(i).getNodeType() == 1) {
                    Element contentElement = (Element)contentElements.item(i);
                    if (contentElement.getTagName().compareTo("view") == 0 && !this.corruptViews.contains(contentElement.getAttribute("id"))) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.27"));
                        Element origElement = (Element)contentElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "original").item(0);
                        Element imgElement = (Element)contentElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "img").item(0);
                        String pathToFile = String.valueOf(this.inputFile.getParent()) + "/" + imgElement.getAttribute("src");
                        pathToFile = File.separator.compareTo("\\") == 0 ? pathToFile.replaceAll("/", "\\" + File.separator) : pathToFile.replaceAll("/", File.separator);
                        File binFile = new File(pathToFile);
                        boolean bytesRead = false;
                        byte[] data = null;
                        try {
                            data = HIRuntime.getBytesFromFile(binFile);
                            bytesRead = true;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (bytesRead && data != null) {
                            HiView newView = null;
                            try {
                                newView = HIRuntime.getManager().createView(newObject.getId(), origElement.getAttribute("filename"), "[PeTAL 2.0 XML Import]", binFile, UUID.randomUUID().toString());
                            }
                            catch (HIWebServiceException ex) {
                                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            this.viewMap.put(newView, contentElement);
                            this.viewIDMap.put(contentElement.getAttribute("id"), newView);
                            data = null;
                            sortOrder = String.valueOf(sortOrder) + "," + newView.getId();
                            if (sortOrder.startsWith(",")) {
                                sortOrder = sortOrder.substring(1);
                            }
                            String layerSortOrder = "";
                            NodeList layerElements = contentElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "layer");
                            int a = 0;
                            while (a < layerElements.getLength()) {
                                HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.28") + " : " + Messages.getString("PeTALImporter.29") + " " + (a + 1) + " " + Messages.getString("PeTALImporter.25") + " " + layerElements.getLength() + " " + Messages.getString("PeTALImporter.26"));
                                Element layerElement = (Element)layerElements.item(a);
                                if (layerElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "g").getLength() > 0) {
                                    Element svgElement = (Element)layerElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "g").item(0);
                                    String colorString = svgElement.getAttribute("fill");
                                    float opacity = 1.0f;
                                    if (svgElement.getAttribute("opacity") != null) {
                                        try {
                                            opacity = Float.parseFloat(svgElement.getAttribute("opacity"));
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    Color color = Color.decode(colorString);
                                    int red = color.getRed();
                                    int green = color.getGreen();
                                    int blue = color.getBlue();
                                    HiLayer newLayer = null;
                                    try {
                                        newLayer = HIRuntime.getManager().createLayer(newView, red, green, blue, opacity);
                                    }
                                    catch (HIWebServiceException ex) {
                                        Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                    this.layerMap.put(newLayer, layerElement);
                                    this.layerIDMap.put(layerElement.getAttribute("id"), newLayer);
                                    layerSortOrder = String.valueOf(layerSortOrder) + "," + newLayer.getId();
                                    if (layerSortOrder.startsWith(",")) {
                                        layerSortOrder = layerSortOrder.substring(1);
                                    }
                                    HILayer layerWrapper = new HILayer(newLayer, 100, 100);
                                    HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.28") + " : " + Messages.getString("PeTALImporter.29") + " " + (a + 1) + ": " + Messages.getString("PeTALImporter.30"));
                                    NodeList polygonElements = svgElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "polygon");
                                    int p = 0;
                                    while (p < polygonElements.getLength()) {
                                        String points;
                                        Element polygonElement = (Element)polygonElements.item(p);
                                        boolean isCustom = false;
                                        if (polygonElement.getAttribute("type") != null && polygonElement.getAttribute("type").compareTo("custom") == 0) {
                                            isCustom = true;
                                        }
                                        points = (points = polygonElement.getAttribute("points")) == null || points.length() == 0 ? "" : (isCustom ? "U;" + points : "F;" + points);
                                        points = points.replaceAll(" ", ";");
                                        points = points.replaceAll(",", "#");
                                        RelativePolygon polygon = new RelativePolygon(points, 10000, 10000);
                                        layerWrapper.getRelativePolygons().addElement(polygon);
                                        if (isCustom) {
                                            try {
                                                HIRuntime.getManager().addProjectPolygon(polygon.getModel());
                                            }
                                            catch (HIWebServiceException ex) {
                                                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                        }
                                        ++p;
                                    }
                                    NodeList rectElements = svgElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "rect");
                                    int p2 = 0;
                                    while (p2 < rectElements.getLength()) {
                                        Element rectElement = (Element)rectElements.item(p2);
                                        int x = (int)(Float.parseFloat(rectElement.getAttribute("x")) * 10000.0f);
                                        int y = (int)(Float.parseFloat(rectElement.getAttribute("y")) * 10000.0f);
                                        int width = (int)(Float.parseFloat(rectElement.getAttribute("width")) * 10000.0f);
                                        int height = (int)(Float.parseFloat(rectElement.getAttribute("height")) * 10000.0f);
                                        RelativePolygon polygon = new RelativePolygon(RelativePolygon.HiPolygonTypes.HI_RECTANGLE, x, y, width, height, null, 10000, 10000);
                                        polygon.commitChangesToModel();
                                        layerWrapper.getRelativePolygons().addElement(polygon);
                                        ++p2;
                                    }
                                    layerWrapper.syncPolygonChanges();
                                    try {
                                        HIRuntime.getManager().updateLayerProperties(newLayer.getId(), red, green, blue, opacity, layerWrapper.getModel().getPolygons());
                                    }
                                    catch (HIWebServiceException ex) {
                                        Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                                ++a;
                            }
                            try {
                                HIRuntime.getManager().updateViewSortOrder(newView, layerSortOrder);
                            }
                            catch (HIWebServiceException ex) {
                                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    if (contentElement.getTagName().compareTo("inscription") == 0) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.31"));
                        HiInscription newInscription = null;
                        try {
                            newInscription = HIRuntime.getManager().createInscription(newObject);
                        }
                        catch (HIWebServiceException ex) {
                            Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.inscriptionMap.put(newInscription, contentElement);
                        this.inscriptionIDMap.put(contentElement.getAttribute("id"), newInscription);
                        sortOrder = String.valueOf(sortOrder) + "," + newInscription.getId();
                        if (sortOrder.startsWith(",")) {
                            sortOrder = sortOrder.substring(1);
                        }
                    }
                    if (contentElement.getTagName().compareTo("standardView") == 0) {
                        standardView = contentElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                        standardView = standardView.substring(standardView.lastIndexOf("/") + 1);
                    }
                }
                if (standardView != null && standardView.length() > 0 && !this.corruptViews.contains(standardView) && this.viewIDMap.get(standardView) != null) {
                    try {
                        HIRuntime.getManager().setDefaultView(newObject, (HiObjectContent)this.viewIDMap.get(standardView));
                    }
                    catch (HIWebServiceException ex) {
                        Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                ++i;
            }
            try {
                HIRuntime.getManager().updateObjectSortOrder(newObject, sortOrder);
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(PeTAL2Importer.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++counter;
        }
    }

    private void evaluateBinaries() {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.19"));
        for (Element viewElement : this.views) {
            if (viewElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "original").getLength() <= 0 || viewElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "img").getLength() <= 0) {
                this.corruptViews.add(viewElement.getAttribute("id"));
                continue;
            }
            Element origElement = (Element)viewElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "original").item(0);
            Element imgElement = (Element)viewElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "img").item(0);
            String pathToFile = String.valueOf(this.inputFile.getParent()) + "/" + imgElement.getAttribute("src");
            pathToFile = File.separator.compareTo("\\") == 0 ? pathToFile.replaceAll("/", "\\" + File.separator) : pathToFile.replaceAll("/", File.separator);
            File binFile = new File(pathToFile);
            if (binFile.exists() && binFile.canRead() && binFile.isFile()) continue;
            this.corruptViews.add(viewElement.getAttribute("id"));
        }
    }

    public void importXMLToProject() {
        HIRuntime.getGui().startIndicatingServiceActivity(true);
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.1"));
        this.importSuccessful = false;
        this.languages.clear();
        this.templates.clear();
        this.texts.clear();
        this.objects.clear();
        this.views.clear();
        this.inscriptions.clear();
        this.layers.clear();
        this.urls.clear();
        this.litas.clear();
        this.groups.clear();
        this.corruptViews.clear();
        this.textMap.clear();
        this.textIDMap.clear();
        this.urlMap.clear();
        this.urlIDMap.clear();
        this.litaMap.clear();
        this.litaIDMap.clear();
        this.groupMap.clear();
        this.groupIDMap.clear();
        this.objectMap.clear();
        this.objectIDMap.clear();
        this.viewMap.clear();
        this.viewIDMap.clear();
        this.inscriptionMap.clear();
        this.inscriptionIDMap.clear();
        this.layerMap.clear();
        this.layerIDMap.clear();
        new Thread(){

            @Override
            public void run() {
                try {
                    PeTAL2Importer.this.rootElement = PeTAL2Importer.this.xmlDocument.getDocumentElement();
                    PeTAL2Importer.this.importLanguages();
                    PeTAL2Importer.this.importProjectMetadata();
                    PeTAL2Importer.this.importTemplates();
                    PeTAL2Importer.this.importTexts();
                    PeTAL2Importer.this.importObjectsViewsInscriptionsLayers();
                    PeTAL2Importer.this.importURLs();
                    NodeList projElements = null;
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.17"));
                    projElements = PeTAL2Importer.this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "lita");
                    int i = 0;
                    while (i < projElements.getLength()) {
                        Element litaElement = (Element)projElements.item(i);
                        PeTAL2Importer.this.litas.add(litaElement);
                        ++i;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.18"));
                    projElements = PeTAL2Importer.this.rootElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "group");
                    i = 0;
                    while (i < projElements.getLength()) {
                        Object groupElement = (Element)projElements.item(i);
                        if (!groupElement.getAttribute("type").equalsIgnoreCase("import")) {
                            PeTAL2Importer.this.groups.add(groupElement);
                        }
                        ++i;
                    }
                    PeTAL2Importer.this.evaluateBinaries();
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.22"));
                    for (Element litaElement : PeTAL2Importer.this.litas) {
                        Object litaXML = PeTALExporter.serializeXMLElement(litaElement);
                        litaXML = litaXML == null || ((String)litaXML).length() == 0 || ((String)litaXML).indexOf("<lita") < 0 ? MetadataHelper.getDefaultLightTableXML() : ((String)litaXML).substring(((String)litaXML).indexOf("<lita"));
                        HiLightTable newLita = HIRuntime.getManager().createLightTable("-", (String)litaXML);
                        PeTAL2Importer.this.litaMap.put(newLita, litaElement);
                        PeTAL2Importer.this.litaIDMap.put(litaElement.getAttribute("id"), newLita);
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.23"));
                    String sortOrder = "";
                    for (Object groupElement : PeTAL2Importer.this.groups) {
                        HiGroup newGroup = HIRuntime.getManager().createGroup();
                        if (newGroup == null) continue;
                        PeTAL2Importer.this.groupMap.put(newGroup, groupElement);
                        PeTAL2Importer.this.groupIDMap.put(groupElement.getAttribute("id"), newGroup);
                        sortOrder = String.valueOf(sortOrder) + "," + newGroup.getId();
                        if (!sortOrder.startsWith(",")) continue;
                        sortOrder = sortOrder.substring(1);
                    }
                    HiPreference groupSortOrderPref = MetadataHelper.findPreference(HIRuntime.getManager().getProject(), "groupSortOrder");
                    groupSortOrderPref.setValue(sortOrder);
                    HIRuntime.getManager().updatePreference(groupSortOrderPref);
                    int counter = 1;
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.32"));
                    for (Element groupElement : PeTAL2Importer.this.groupMap.values()) {
                        long groupID = ((HiGroup)PeTAL2Importer.this.groupIDMap.get(groupElement.getAttribute("id"))).getId();
                        sortOrder = "";
                        NodeList memberElements = groupElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "member");
                        int i2 = 0;
                        while (i2 < memberElements.getLength()) {
                            Element memberElement = (Element)memberElements.item(i2);
                            long memberID = PeTAL2Importer.this.resolveNewID(memberElement.getAttributeNS("http://www.w3.org/1999/xlink", "href"));
                            if (memberID > 0L) {
                                HIRuntime.getManager().addToGroup(memberID, groupID);
                                sortOrder = String.valueOf(sortOrder) + "," + memberID;
                                if (sortOrder.startsWith(",")) {
                                    sortOrder = sortOrder.substring(1);
                                }
                            }
                            ++i2;
                        }
                        HIRuntime.getManager().updateGroupSortOrder(groupID, sortOrder);
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.33"));
                    for (Element layerElement : PeTAL2Importer.this.layerMap.values()) {
                        long newID;
                        long layerID = ((HiLayer)PeTAL2Importer.this.layerIDMap.get(layerElement.getAttribute("id"))).getId();
                        String href = layerElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                        if (href == null || href.length() <= 0 || (newID = PeTAL2Importer.this.resolveNewID(href)) <= 0L) continue;
                        HIRuntime.getManager().setLayerLink(layerID, newID);
                    }
                    counter = 1;
                    for (Element viewElement : PeTAL2Importer.this.viewMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.36")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTAL2Importer.this.viewMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiView view = (HiView)PeTAL2Importer.this.viewIDMap.get(viewElement.getAttribute("id"));
                        PeTAL2Importer.this.attachMetadataRecords(viewElement, view.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", "http://purl.org/dc/elements/1.1/", "source", "source", "http://www.hyperimage.eu/PeTAL/HIView/1.0", "annotation", "comment");
                        ++counter;
                    }
                    counter = 1;
                    for (Element inscriptionElement : PeTAL2Importer.this.inscriptionMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.37")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTAL2Importer.this.inscriptionMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiInscription inscription = (HiInscription)PeTAL2Importer.this.inscriptionIDMap.get(inscriptionElement.getAttribute("id"));
                        PeTAL2Importer.this.attachMetadataRecords(inscriptionElement, inscription.getMetadata(), null, null, null, null, null, null, "http://www.hyperimage.eu/PeTAL/HIView/1.0", "content", "content");
                        ++counter;
                    }
                    counter = 1;
                    for (Element layerElement : PeTAL2Importer.this.layerMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.38")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTAL2Importer.this.layerMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiLayer layer = (HiLayer)PeTAL2Importer.this.layerIDMap.get(layerElement.getAttribute("id"));
                        PeTAL2Importer.this.attachMetadataRecords(layerElement, layer.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://www.hyperimage.eu/PeTAL/HIView/1.0", "annotation", "comment");
                        ++counter;
                    }
                    counter = 1;
                    for (Element groupElement : PeTAL2Importer.this.groupMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.39")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTAL2Importer.this.groupMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiGroup group = (HiGroup)PeTAL2Importer.this.groupIDMap.get(groupElement.getAttribute("id"));
                        PeTAL2Importer.this.attachMetadataRecords(groupElement, group.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://www.hyperimage.eu/PeTAL/HIView/1.0", "annotation", "comment");
                        ++counter;
                    }
                    counter = 1;
                    for (Element litaElement : PeTAL2Importer.this.litaMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.40")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTAL2Importer.this.litaMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiLightTable lita = (HiLightTable)PeTAL2Importer.this.litaIDMap.get(litaElement.getAttribute("id"));
                        String litaXML = lita.getXml();
                        litaXML = litaXML.replaceAll("<lita id=\"X[0123456789]+\">", "<lita id=\"X" + lita.getId() + "\">");
                        String convertedXML = "";
                        int refCounter = 0;
                        String[] stringArray = litaXML.split("ref=\"");
                        int n = stringArray.length;
                        int memberID = 0;
                        while (memberID < n) {
                            String refString = stringArray[memberID];
                            if (refCounter > 0) {
                                convertedXML = String.valueOf(convertedXML) + "ref=\"";
                                String ref = refString.substring(0, refString.indexOf("\""));
                                if ((ref = PeTAL2Importer.this.resolveDisplayableNewID("petal://legacy/" + ref)) == null || ref.length() == 0) {
                                    ref = "invalid";
                                }
                                convertedXML = String.valueOf(convertedXML) + ref + refString.substring(refString.indexOf("\""));
                            } else {
                                convertedXML = String.valueOf(convertedXML) + refString;
                            }
                            ++refCounter;
                            ++memberID;
                        }
                        lita.setXml(convertedXML);
                        HIRuntime.getManager().updateLightTable(lita);
                        ++counter;
                    }
                    counter = 1;
                    for (Element objectElement : PeTAL2Importer.this.objectMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.41")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTAL2Importer.this.objectMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiObject object = (HiObject)PeTAL2Importer.this.objectIDMap.get(objectElement.getAttribute("id"));
                        NodeList descElements = objectElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                        int i3 = 0;
                        while (i3 < descElements.getLength()) {
                            HiFlexMetadataRecord record;
                            Element descElement = (Element)descElements.item(i3);
                            String lang = descElement.getAttribute("xml:lang");
                            if (PeTAL2Importer.this.checkLangInProject(lang) && (record = MetadataHelper.getDefaultMetadataRecord(object.getMetadata(), lang)) != null) {
                                for (HiFlexMetadataTemplate template : PeTAL2Importer.this.templates) {
                                    for (HiFlexMetadataSet set : template.getEntries()) {
                                        String content = "";
                                        content = !set.isRichText() ? PeTAL2Importer.this.getSingleLineTextContent(descElement, template.getNamespaceURI(), set.getTagname()) : PeTAL2Importer.this.getMultiLineTextContent(descElement, template.getNamespaceURI(), set.getTagname());
                                        if (content == null) continue;
                                        PeTAL2Importer.this._DBG(content);
                                        MetadataHelper.setValue(template.getNamespacePrefix(), set.getTagname(), content, record);
                                    }
                                }
                                HIRuntime.getManager().updateFlexMetadataRecord(record);
                            }
                            ++i3;
                        }
                        ++counter;
                    }
                    PeTAL2Importer.this.setStartRef();
                }
                catch (HIWebServiceException wse) {
                    wse.printStackTrace();
                    HIRuntime.getGui().reportError(wse, null);
                    PeTAL2Importer.this.abortWithError("");
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PeTAL2Importer.this.abortWithError(e.getMessage());
                    return;
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                PeTAL2Importer.this.importSuccessful = true;
                HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.43"), String.valueOf(Messages.getString("PeTALImporter.44")) + "\n" + Messages.getString("PeTALImporter.45"));
                if (PeTAL2Importer.this.litaMap.size() > 0) {
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.46"), String.valueOf(Messages.getString("PeTALImporter.47")) + "\n\n" + Messages.getString("PeTALImporter.48"));
                }
                for (String viewID : PeTAL2Importer.this.corruptViews) {
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.46"), String.valueOf(Messages.getString("PeTALImporter.49")) + " " + viewID + " " + Messages.getString("PeTALImporter.50") + "\n\n" + Messages.getString("PeTALImporter.51") + "\n" + Messages.getString("PeTALImporter.52"));
                }
                HIRuntime.getGui().triggerProjectUpdate();
            }
        }.start();
    }
}

