/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.xmlimportexport;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.HIRichTextFieldControl;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.model.HIRichText;
import org.hyperimage.client.model.HIRichTextChunk;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataName;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiPreference;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.hyperimage.client.xmlimportexport.PeTALExporter;
import org.hyperimage.client.xmlimportexport.XMLImporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PeTAL3Importer
extends XMLImporter {
    SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public PeTAL3Importer(File inputFile, Document xmlDocument) {
        this.xmlDocument = xmlDocument;
        this.inputFile = inputFile;
    }

    private String getUTCDateTime(long timestamp) {
        this.utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return this.utcFormat.format(new Date(timestamp));
    }

    private long parseTimestamp(String timestamp) {
        try {
            return this.utcFormat.parse(timestamp).getTime();
        }
        catch (ParseException ex) {
            Logger.getLogger(PeTAL3Importer.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    private String getSingleLineTextContent(Element element, String namespace, String tagName) {
        String temp;
        String textContent = "";
        if (element == null) {
            return textContent;
        }
        if (element.getElementsByTagNameNS(namespace, tagName).getLength() > 0 && (temp = element.getElementsByTagNameNS(namespace, tagName).item(0).getTextContent()) != null) {
            textContent = temp.trim();
        }
        return textContent;
    }

    private String getMultiLineTextContent(Element element, String namespace, String tagName) {
        String textContent = new HIRichText().getModel();
        if (element == null) {
            return textContent;
        }
        if (element.getElementsByTagNameNS(namespace, tagName).getLength() > 0) {
            textContent = this.convertRichTextXMLField((Element)element.getElementsByTagNameNS(namespace, tagName).item(0));
        }
        HIRichTextFieldControl control = new HIRichTextFieldControl("import");
        control.setText(textContent);
        textContent = control.getText();
        return textContent;
    }

    private String getTextNodeContent(Node textNode) {
        String textContent = "";
        textContent = textNode.getTextContent();
        textContent = textContent.replaceAll("[ ]*[\t\n]+[\t\n ]*\\z", "");
        textContent = textContent.replaceAll("[ ]*[\t\n]+[\t\n ]*", " ");
        return textContent;
    }

    private String getSubElementText(Element subElement) {
        String textContent = "";
        NodeList subNodes = subElement.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node subNode = subNodes.item(i);
            if (subNode.getNodeType() == 3) {
                textContent = String.valueOf(textContent) + this.getTextNodeContent(subNode);
            } else if (subNode.getNodeType() == 1 && ((Element)subNode).getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && ((Element)subNode).getLocalName().compareTo("br") == 0) {
                textContent = String.valueOf(textContent) + "\n";
            }
            ++i;
        }
        return textContent;
    }

    private String convertRichTextXMLField(Element richTextElement) {
        HIRichText hiText = new HIRichText();
        NodeList chunkNodes = richTextElement.getChildNodes();
        int i = 0;
        while (i < chunkNodes.getLength()) {
            String chunkText;
            Node chunkNode = chunkNodes.item(i);
            if (chunkNode.getNodeType() == 3) {
                chunkText = this.getTextNodeContent(chunkNode);
                boolean nextNode = i < chunkNodes.getLength() - 1;
                while (nextNode) {
                    nextNode = false;
                    if (chunkNodes.item(i + 1).getNodeType() == 1 && chunkNodes.item(i + 1).getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkNodes.item(i + 1).getLocalName().compareTo("br") == 0) {
                        chunkText = String.valueOf(chunkText) + "\n";
                        nextNode = true;
                        ++i;
                    } else if (chunkNodes.item(i + 1).getNodeType() == 3) {
                        chunkText = String.valueOf(chunkText) + this.getTextNodeContent(chunkNodes.item(i + 1));
                        nextNode = true;
                        ++i;
                    }
                    boolean bl = nextNode = nextNode && i < chunkNodes.getLength() - 1;
                }
                if (chunkText.length() > 0) {
                    hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                }
            } else if (chunkNode.getNodeType() == 1) {
                Element chunkElement = (Element)chunkNode;
                if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("b") == 0) {
                    chunkText = this.getSubElementText(chunkElement);
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.BOLD, chunkText);
                    }
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("i") == 0) {
                    chunkText = this.getSubElementText(chunkElement);
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.ITALIC, chunkText);
                    }
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("u") == 0) {
                    chunkText = this.getSubElementText(chunkElement);
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.UNDERLINE, chunkText);
                    }
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("sup") == 0) {
                    chunkText = this.getSubElementText(chunkElement);
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.SUPERSCRIPT, chunkText);
                    }
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("sub") == 0) {
                    chunkText = this.getSubElementText(chunkElement);
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.SUBSCRIPT, chunkText);
                    }
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("br") == 0) {
                    chunkText = "\n";
                    hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                } else if (chunkElement.getNamespaceURI().compareTo("http://hyperimage.ws/PeTAL/3.0") == 0 && chunkElement.getLocalName().compareTo("link") == 0) {
                    String href = chunkElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                    chunkText = "";
                    if (href != null && href.length() > 0) {
                        chunkText = this.getSubElementText(chunkElement);
                    }
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.LINK, chunkText, href);
                    }
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") != 0 || chunkElement.getLocalName().compareTo("br") != 0) {
                    String elementText = this.serializeElement(chunkElement);
                    if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0) {
                        elementText = elementText.replaceAll("<html:", "<").replaceAll("</html:", "</").replaceAll(" xmlns:html=\"http://www.w3.org/1999/xhtml\"", "");
                    }
                    hiText.addChunk(HIRichTextChunk.chunkTypes.LITERAL, elementText);
                }
            } else if (chunkNode.getNodeType() == 4) {
                hiText.addChunk(HIRichTextChunk.chunkTypes.LITERAL, chunkNode.getNodeValue());
            }
            ++i;
        }
        return hiText.getModel();
    }

    private void attachMetadataRecords(Element mdElement, List<HiFlexMetadataRecord> records, String nsURI1, String tagName1, String mdName1, String nsURI2, String tagName2, String mdName2, String nsURI3, String tagName3, String mdName3) throws HIWebServiceException {
        NodeList descElements = mdElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        this.attachMetadataRecords(descElements, records, nsURI1, tagName1, mdName1, nsURI2, tagName2, mdName2, nsURI3, tagName3, mdName3);
    }

    private void attachMetadataRecords(NodeList descElements, List<HiFlexMetadataRecord> records, String nsURI1, String tagName1, String mdName1, String nsURI2, String tagName2, String mdName2, String nsURI3, String tagName3, String mdName3) throws HIWebServiceException {
        int i = 0;
        while (i < descElements.getLength()) {
            Element descElement = (Element)descElements.item(i);
            String lang = descElement.getAttribute("xml:lang");
            if (this.checkLangInProject(lang)) {
                HiFlexMetadataRecord record;
                String tagContent1 = null;
                if (tagName1 != null) {
                    tagContent1 = this.getSingleLineTextContent(descElement, nsURI1, tagName1);
                }
                String tagContent2 = null;
                if (tagName2 != null) {
                    tagContent2 = this.getSingleLineTextContent(descElement, nsURI2, tagName2);
                }
                String tagContent3 = null;
                if (tagName3 != null) {
                    tagContent3 = this.getMultiLineTextContent(descElement, nsURI3, tagName3);
                }
                if ((record = MetadataHelper.getDefaultMetadataRecord(records, lang)) != null) {
                    if (mdName1 != null) {
                        MetadataHelper.setValue("HIBase", mdName1, tagContent1, record);
                    }
                    if (mdName2 != null) {
                        MetadataHelper.setValue("HIBase", mdName2, tagContent2, record);
                    }
                    if (mdName3 != null) {
                        MetadataHelper.setValue("HIBase", mdName3, tagContent3, record);
                    }
                }
                HIRuntime.getManager().updateFlexMetadataRecord(record);
            }
            ++i;
        }
    }

    private void importLanguages() throws HIWebServiceException {
        this.languages.clear();
        NodeList langElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "language");
        String defLang = null;
        int i = 0;
        while (i < langElements.getLength()) {
            Element langElement = (Element)langElements.item(i);
            this.languages.add(langElement.getTextContent().trim());
            if (langElement.getAttribute("default") != null && langElement.getAttribute("default").equalsIgnoreCase("true")) {
                defLang = langElement.getTextContent().trim();
            }
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.8"));
        for (String lang : this.languages) {
            if (this.checkLangInProject(lang)) continue;
            HIRuntime.getManager().addLanguageToProject(lang);
        }
        if (defLang != null) {
            HIRuntime.getManager().updateProjectDefaultLanguage(defLang);
        }
    }

    private void importProjectMetadata() throws HIWebServiceException {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.9"));
        if (this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "projectMetadata").getLength() > 0) {
            Element projMetadataElement = (Element)this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "projectMetadata").item(0);
            NodeList mdElements = projMetadataElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            int i = 0;
            while (i < mdElements.getLength()) {
                Element mdElement = (Element)mdElements.item(i);
                if (this.checkLangInProject((mdElement = (Element)mdElement.getElementsByTagNameNS("http://purl.org/dc/elements/1.1/", "title").item(0)).getAttribute("xml:lang"))) {
                    HIRuntime.getManager().updateProject(mdElement.getAttribute("xml:lang"), mdElement.getTextContent().trim());
                }
                ++i;
            }
        }
    }

    private void importTemplates() throws HIWebServiceException {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.10"));
        NodeList templateElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "template");
        int i = 0;
        while (i < templateElements.getLength()) {
            Element templateElement = (Element)templateElements.item(i);
            if (!templateElement.getAttribute("nsPrefix").equalsIgnoreCase("HIBase")) {
                HiFlexMetadataTemplate customTemplate;
                Element nameElement;
                int b;
                NodeList nameElements;
                if (!this.checkTemplateInProject(templateElement.getAttribute("nsPrefix"), templateElement.getAttribute("schema"))) {
                    HiFlexMetadataTemplate newTemplate = new HiFlexMetadataTemplate();
                    newTemplate.setNamespacePrefix(templateElement.getAttribute("nsPrefix"));
                    newTemplate.setNamespaceURI(templateElement.getAttribute("schema"));
                    newTemplate.setNamespaceURL(templateElement.getAttribute("schemaLocation"));
                    HiFlexMetadataSet newSet = null;
                    HiFlexMetadataName newName = null;
                    NodeList keyElements = templateElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "key");
                    int a = 0;
                    while (a < keyElements.getLength()) {
                        Element keyElement = (Element)keyElements.item(a);
                        newSet = new HiFlexMetadataSet();
                        newSet.setRichText(false);
                        if (keyElement.getAttribute("richText") != null && keyElement.getAttribute("richText").equalsIgnoreCase("true")) {
                            newSet.setRichText(true);
                        }
                        newSet.setTagname(keyElement.getAttribute("tagName"));
                        nameElements = keyElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "displayName");
                        b = 0;
                        while (b < nameElements.getLength()) {
                            nameElement = (Element)nameElements.item(b);
                            newName = new HiFlexMetadataName();
                            newName.setDisplayName(nameElement.getTextContent().trim());
                            newName.setLanguage(nameElement.getAttribute("xml:lang"));
                            newSet.getDisplayNames().add(newName);
                            ++b;
                        }
                        newTemplate.getEntries().add(newSet);
                        ++a;
                    }
                    HIRuntime.getManager().addTemplateToProject(newTemplate);
                } else if (templateElement.getAttribute("nsPrefix").compareTo("custom") == 0 && (customTemplate = MetadataHelper.getTemplateByNSPrefix("custom")) != null) {
                    NodeList keyElements = templateElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "key");
                    int a = 0;
                    while (a < keyElements.getLength()) {
                        Element keyElement = (Element)keyElements.item(a);
                        if (MetadataHelper.findTemplateEntryByTagName(keyElement.getAttribute("tagName"), customTemplate) == null) {
                            HiFlexMetadataSet newSet;
                            boolean richText = false;
                            if (keyElement.getAttribute("richText") != null && keyElement.getAttribute("richText").equalsIgnoreCase("true")) {
                                richText = true;
                            }
                            if ((newSet = HIRuntime.getManager().addSetToTemplate(customTemplate, keyElement.getAttribute("tagName"), richText)) != null) {
                                nameElements = keyElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "displayName");
                                b = 0;
                                while (b < nameElements.getLength()) {
                                    nameElement = (Element)nameElements.item(b);
                                    HIRuntime.getManager().createSetDisplayName(newSet, nameElement.getAttribute("xml:lang"), nameElement.getTextContent().trim());
                                    ++b;
                                }
                            }
                        }
                        ++a;
                    }
                }
            }
            ++i;
        }
    }

    private void importGroups() throws HIWebServiceException {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.23"));
        this.groups.clear();
        this.xmlImportGroup = null;
        HiPreference groupSortOrderPref = MetadataHelper.findPreference(HIRuntime.getManager().getProject(), "groupSortOrder");
        String sortOrder = "";
        if (groupSortOrderPref != null && groupSortOrderPref.getValue() != null) {
            sortOrder = groupSortOrderPref.getValue();
        }
        NodeList projElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "group");
        int i = 0;
        while (i < projElements.getLength()) {
            Element groupElement = (Element)projElements.item(i);
            if (!groupElement.getAttribute("type").equalsIgnoreCase("import") && !groupElement.getAttribute("type").equalsIgnoreCase("tag")) {
                this.groups.add(groupElement);
            } else if (groupElement.getAttribute("type").equalsIgnoreCase("import")) {
                this.xmlImportGroup = groupElement;
            }
            ++i;
        }
        for (Element groupElement : this.groups) {
            HiGroup group = null;
            try {
                HiBase base = HIRuntime.getManager().getBaseElement(groupElement.getAttribute("id"));
                if (base != null && base instanceof HiGroup) {
                    group = (HiGroup)base;
                }
            }
            catch (HIWebServiceException base) {
                // empty catch block
            }
            boolean isNewGroup = false;
            if (group == null) {
                group = HIRuntime.getManager().createGroup(groupElement.getAttribute("id"));
                isNewGroup = true;
                if (group != null && (sortOrder = String.valueOf(sortOrder) + "," + group.getId()).startsWith(",")) {
                    sortOrder = sortOrder.substring(1);
                }
            }
            long timestamp = this.parseTimestamp(groupElement.getAttribute("timestamp"));
            if (!isNewGroup && (group == null || group.getTimestamp() >= timestamp)) continue;
            this.attachMetadataRecords(groupElement, group.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://hyperimage.ws/PeTAL/HIBase/2.0", "annotation", "comment");
        }
        if (groupSortOrderPref != null) {
            groupSortOrderPref.setValue(sortOrder);
            HIRuntime.getManager().updatePreference(groupSortOrderPref);
        }
    }

    private void importTags() throws HIWebServiceException {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.importtags"));
        this.tags.clear();
        NodeList projElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "group");
        int i = 0;
        while (i < projElements.getLength()) {
            Element tagElement = (Element)projElements.item(i);
            if (tagElement.getAttribute("type").equalsIgnoreCase("tag")) {
                this.tags.add(tagElement);
            }
            ++i;
        }
        for (Element tagElement : this.tags) {
            HiGroup tag = null;
            try {
                HiBase base = HIRuntime.getManager().getBaseElement(tagElement.getAttribute("id"));
                if (base != null && base instanceof HiGroup) {
                    tag = (HiGroup)base;
                }
            }
            catch (HIWebServiceException base) {
                // empty catch block
            }
            boolean isNewTag = false;
            if (tag == null) {
                tag = HIRuntime.getManager().createTagGroup(tagElement.getAttribute("id"));
                isNewTag = true;
            }
            long timestamp = this.parseTimestamp(tagElement.getAttribute("timestamp"));
            if (!isNewTag && (tag == null || tag.getTimestamp() >= timestamp)) continue;
            this.attachMetadataRecords(tagElement, tag.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://hyperimage.ws/PeTAL/HIBase/2.0", "annotation", "comment");
        }
    }

    private void importTexts() throws HIWebServiceException {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.11"));
        this.texts.clear();
        NodeList textElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "text");
        int counter = 1;
        int i = 0;
        while (i < textElements.getLength()) {
            Element textElement = (Element)textElements.item(i);
            this.texts.add(textElement);
            ++i;
        }
        for (Element textElement : this.texts) {
            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.34")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + this.texts.size() + ") " + Messages.getString("PeTALImporter.35"));
            HiText text = null;
            try {
                HiBase base = HIRuntime.getManager().getBaseElement(textElement.getAttribute("id"));
                if (base != null && base instanceof HiText) {
                    text = (HiText)base;
                }
            }
            catch (HIWebServiceException base) {
                // empty catch block
            }
            boolean isNewText = false;
            if (text == null) {
                text = HIRuntime.getManager().createText(textElement.getAttribute("id"));
                isNewText = true;
            }
            long timestamp = this.parseTimestamp(textElement.getAttribute("timestamp"));
            if (isNewText || text != null && text.getTimestamp() < timestamp) {
                this.attachMetadataRecords(textElement, text.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://hyperimage.ws/PeTAL/HIBase/2.0", "content", "content");
            }
            ++counter;
        }
    }

    private void importURLs() throws HIWebServiceException {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.16"));
        NodeList urlElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "url");
        this.urls.clear();
        int i = 0;
        while (i < urlElements.getLength()) {
            Element urlElement = (Element)urlElements.item(i);
            this.urls.add(urlElement);
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.21"));
        for (Element urlElement : this.urls) {
            Hiurl url = null;
            try {
                HiBase base = HIRuntime.getManager().getBaseElement(urlElement.getAttribute("id"));
                if (base != null && base instanceof Hiurl) {
                    url = (Hiurl)base;
                }
            }
            catch (HIWebServiceException base) {
                // empty catch block
            }
            String title = this.getSubElementText(urlElement);
            String lastAccess = "";
            if (urlElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "annotation").getLength() > 0 && (lastAccess = this.convertRichTextXMLField((Element)urlElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "annotation").item(0))) == null) {
                lastAccess = "";
            }
            boolean isNewURL = false;
            if (url == null) {
                url = HIRuntime.getManager().createURL(urlElement.getAttributeNS("http://www.w3.org/1999/xlink", "href"), title, lastAccess, urlElement.getAttribute("id"));
                isNewURL = true;
            }
            long timestamp = this.parseTimestamp(urlElement.getAttribute("timestamp"));
            if (!isNewURL && (url == null || url.getTimestamp() >= timestamp)) continue;
            url.setUrl(urlElement.getAttributeNS("http://www.w3.org/1999/xlink", "href"));
            url.setTitle(title);
            url.setLastAccess(lastAccess);
            HIRuntime.getManager().updateURL(url);
        }
    }

    private void stageObjectImport() {
        this.objects.clear();
        this.views.clear();
        this.inscriptions.clear();
        this.layers.clear();
        NodeList projElements = null;
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.12"));
        projElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "object");
        int i = 0;
        while (i < projElements.getLength()) {
            Element objectElement = (Element)projElements.item(i);
            this.objects.add(objectElement);
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.13"));
        projElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "view");
        i = 0;
        while (i < projElements.getLength()) {
            Element viewElement = (Element)projElements.item(i);
            this.views.add(viewElement);
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.14"));
        projElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "inscription");
        i = 0;
        while (i < projElements.getLength()) {
            Element inscriptionElement = (Element)projElements.item(i);
            this.inscriptions.add(inscriptionElement);
            ++i;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.15"));
        projElements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "layer");
        i = 0;
        while (i < projElements.getLength()) {
            Element layerElement = (Element)projElements.item(i);
            this.layers.add(layerElement);
            ++i;
        }
    }

    public boolean checkIfRemoteFileExists(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        try {
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setRequestMethod("HEAD");
            return httpConn.getResponseCode() == 200;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public RemoteFile getImageViaHTTP(String fileURL) {
        URL url;
        RemoteFile remoteFile = new RemoteFile();
        try {
            url = new URL(fileURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            remoteFile.data = null;
            return remoteFile;
        }
        try {
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                String filename = "unknown.jpg";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                String contentType = httpConn.getContentType();
                int contentLength = httpConn.getContentLength();
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        filename = disposition.substring(index + 10, disposition.length() - 1);
                    }
                } else {
                    filename = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
                }
                InputStream inputStream = httpConn.getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                int bytesRead = -1;
                byte[] buffer = new byte[2048];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                if (filename != null && filename.length() > 0) {
                    remoteFile.filename = filename;
                }
                remoteFile.data = outputStream.toByteArray();
                remoteFile.href = fileURL;
            } else {
                System.out.println("HTTP error code: " + responseCode);
                remoteFile.data = null;
            }
            httpConn.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
            remoteFile.data = null;
            return remoteFile;
        }
        return remoteFile;
    }

    private void evaluateBinaries() {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.19"));
        this.corruptViews.clear();
        for (Element viewElement : this.views) {
            if (viewElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "original").getLength() <= 0 || viewElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "img").getLength() <= 0) {
                this.corruptViews.add(viewElement.getAttribute("id"));
                continue;
            }
            Element origElement = (Element)viewElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "original").item(0);
            Element imgElement = (Element)viewElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "img").item(0);
            if (imgElement.getAttribute("src").startsWith("http://")) {
                if (this.checkIfRemoteFileExists(imgElement.getAttribute("src"))) continue;
                this.corruptViews.add(viewElement.getAttribute("id"));
                continue;
            }
            String pathToFile = String.valueOf(this.inputFile.getParent()) + "/" + imgElement.getAttribute("src");
            pathToFile = File.separator.compareTo("\\") == 0 ? pathToFile.replaceAll("/", "\\" + File.separator) : pathToFile.replaceAll("/", File.separator);
            File binFile = new File(pathToFile);
            if (binFile.exists() && binFile.canRead() && binFile.isFile()) continue;
            binFile = new File(String.valueOf(this.inputFile.getParent()) + "/data/img/" + viewElement.getAttribute("id") + ".jpg");
            System.out.println(binFile.getAbsolutePath());
            if (!(binFile.exists() && binFile.canRead() && binFile.isFile())) {
                this.corruptViews.add(viewElement.getAttribute("id"));
                continue;
            }
            System.out.println("ok");
        }
    }

    private void importObjectsViewsInscriptionsLayers() throws HIWebServiceException {
        this.stageObjectImport();
        this.evaluateBinaries();
        int counter = 1;
        for (Element objectElement : this.objects) {
            String sortOrder;
            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + " " + Messages.getString("PeTALImporter.25") + " " + this.objects.size() + " " + Messages.getString("PeTALImporter.26"));
            HiObject object = null;
            try {
                HiBase base = HIRuntime.getManager().getBaseElement(objectElement.getAttribute("id"));
                if (base != null && base instanceof HiObject) {
                    object = (HiObject)base;
                }
            }
            catch (HIWebServiceException base) {
                // empty catch block
            }
            boolean isNewObject = false;
            if (object == null) {
                object = HIRuntime.getManager().createObject(objectElement.getAttribute("id"));
                isNewObject = true;
            }
            long timestamp = this.parseTimestamp(objectElement.getAttribute("timestamp"));
            if (isNewObject || object != null && object.getTimestamp() < timestamp) {
                NodeList descElements = objectElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "metadata");
                int i = 0;
                while (i < descElements.getLength()) {
                    HiFlexMetadataRecord record;
                    String lang;
                    Element descElement = (Element)descElements.item(i);
                    boolean foundMetadata = false;
                    if (descElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description").getLength() > 0) {
                        descElement = (Element)descElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description").item(0);
                        foundMetadata = true;
                    }
                    if (this.checkLangInProject(lang = descElement.getAttribute("xml:lang")) && foundMetadata && (record = MetadataHelper.getDefaultMetadataRecord(object.getMetadata(), lang)) != null) {
                        for (HiFlexMetadataTemplate template : HIRuntime.getManager().getProject().getTemplates()) {
                            for (HiFlexMetadataSet set : template.getEntries()) {
                                String content = "";
                                String namespaceURI = template.getNamespaceURI();
                                if (namespaceURI == null || namespaceURI.length() == 0) {
                                    namespaceURI = "unknown";
                                }
                                if ((content = set.isRichText() ? this.getMultiLineTextContent(descElement, namespaceURI, set.getTagname()) : this.getSingleLineTextContent(descElement, namespaceURI, set.getTagname())) == null) continue;
                                this._DBG(content);
                                MetadataHelper.setValue(template.getNamespacePrefix(), set.getTagname(), content, record);
                            }
                        }
                        HIRuntime.getManager().updateFlexMetadataRecord(record);
                    }
                    ++i;
                }
            }
            NodeList contentElements = objectElement.getChildNodes();
            String defaultView = null;
            String string = sortOrder = object != null ? object.getSortOrder() : "";
            if (sortOrder == null) {
                sortOrder = "";
            }
            int i = 0;
            while (i < contentElements.getLength()) {
                if (contentElements.item(i).getNodeType() == 1) {
                    Element contentElement = (Element)contentElements.item(i);
                    if (contentElement.getTagName().compareTo("view") == 0 && !this.corruptViews.contains(contentElement.getAttribute("id"))) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.27"));
                        Element origElement = (Element)contentElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "original").item(0);
                        Element imgElement = (Element)contentElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "img").item(0);
                        boolean bytesRead = false;
                        byte[] data = null;
                        String filename = "unknown.jpg";
                        String repos = "[PeTAL 3.0 XML Import]";
                        if (imgElement.getAttribute("src").startsWith("http://")) {
                            RemoteFile remoteFile = this.getImageViaHTTP(imgElement.getAttribute("src"));
                            if (remoteFile != null && remoteFile.data != null) {
                                data = remoteFile.data;
                                repos = remoteFile.href;
                                filename = remoteFile.filename;
                                bytesRead = true;
                            }
                        } else {
                            String pathToFile = String.valueOf(this.inputFile.getParent()) + "/" + imgElement.getAttribute("src");
                            pathToFile = File.separator.compareTo("\\") == 0 ? pathToFile.replaceAll("/", "\\" + File.separator) : pathToFile.replaceAll("/", File.separator);
                            File binFile = new File(pathToFile);
                            try {
                                data = HIRuntime.getBytesFromFile(binFile);
                                bytesRead = true;
                                filename = origElement.getAttribute("filename");
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (!bytesRead || data == null) {
                                binFile = new File(String.valueOf(this.inputFile.getParent()) + "/data/img/" + contentElement.getAttribute("id") + ".jpg");
                                try {
                                    data = HIRuntime.getBytesFromFile(binFile);
                                    bytesRead = true;
                                    filename = origElement.getAttribute("filename");
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (bytesRead && data != null) {
                            String layerSortOrder;
                            HiView view = null;
                            try {
                                HiBase base = HIRuntime.getManager().getBaseElement(contentElement.getAttribute("id"));
                                if (base != null && base instanceof HiView) {
                                    view = (HiView)base;
                                }
                            }
                            catch (HIWebServiceException base) {
                                // empty catch block
                            }
                            boolean isNewView = false;
                            String pathToFile = String.valueOf(this.inputFile.getParent()) + "/" + imgElement.getAttribute("src");
                            if (!new File(pathToFile).exists()) {
                                pathToFile = String.valueOf(this.inputFile.getParent()) + "/data/img/" + contentElement.getAttribute("id") + ".jpg";
                            }
                            if (view == null) {
                                view = HIRuntime.getManager().createView(object.getId(), filename, repos, new File(pathToFile), contentElement.getAttribute("id"));
                                isNewView = true;
                            }
                            timestamp = this.parseTimestamp(contentElement.getAttribute("timestamp"));
                            if (isNewView || view != null && view.getTimestamp() < timestamp) {
                                Element rdfElement = null;
                                int cn = 0;
                                while (cn < contentElement.getChildNodes().getLength()) {
                                    Node child = contentElement.getChildNodes().item(cn);
                                    if (child.getNodeType() == 1 && child.getNamespaceURI().compareTo("http://www.w3.org/1999/02/22-rdf-syntax-ns#") == 0 && child.getLocalName().compareTo("RDF") == 0) {
                                        rdfElement = (Element)child;
                                    }
                                    ++cn;
                                }
                                if (rdfElement != null && rdfElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description").getLength() > 0) {
                                    this.attachMetadataRecords(rdfElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description"), view.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", "http://purl.org/dc/elements/1.1/", "source", "source", "http://hyperimage.ws/PeTAL/HIBase/2.0", "annotation", "comment");
                                }
                            }
                            if (!isNewView) {
                                HIRuntime.getManager().updateContentOwner(object, view);
                            }
                            data = null;
                            if (isNewView) {
                                sortOrder = String.valueOf(sortOrder) + "," + view.getId();
                            }
                            if (sortOrder.startsWith(",")) {
                                sortOrder = sortOrder.substring(1);
                            }
                            String string2 = layerSortOrder = view != null ? view.getSortOrder() : "";
                            if (layerSortOrder == null) {
                                layerSortOrder = "";
                            }
                            NodeList layerElements = contentElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "layer");
                            Vector<Element> sortedLayers = new Vector<Element>();
                            int a = 0;
                            while (a < layerElements.getLength()) {
                                sortedLayers.addElement((Element)layerElements.item(a));
                                ++a;
                            }
                            Collections.sort(sortedLayers, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    int order1 = 0;
                                    int order2 = 0;
                                    try {
                                        order1 = Integer.parseInt(((Element)o1).getAttribute("order"));
                                        order2 = Integer.parseInt(((Element)o2).getAttribute("order"));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    return order1 - order2;
                                }
                            });
                            a = 0;
                            while (a < sortedLayers.size()) {
                                HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.28") + " : " + Messages.getString("PeTALImporter.29") + " " + (a + 1) + " " + Messages.getString("PeTALImporter.25") + " " + layerElements.getLength() + " " + Messages.getString("PeTALImporter.26"));
                                Element layerElement = (Element)sortedLayers.get(a);
                                if (layerElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "g").getLength() > 0) {
                                    Element svgElement = (Element)layerElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "g").item(0);
                                    String colorString = svgElement.getAttribute("fill");
                                    float opacity = 1.0f;
                                    if (svgElement.getAttribute("opacity") != null) {
                                        try {
                                            opacity = Float.parseFloat(svgElement.getAttribute("opacity"));
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    Color color = Color.decode(colorString);
                                    int red = color.getRed();
                                    int green = color.getGreen();
                                    int blue = color.getBlue();
                                    HiBase layer = null;
                                    try {
                                        HiBase base = HIRuntime.getManager().getBaseElement(layerElement.getAttribute("id"));
                                        if (base != null && base instanceof HiLayer) {
                                            layer = (HiLayer)base;
                                        }
                                    }
                                    catch (HIWebServiceException base) {
                                        // empty catch block
                                    }
                                    boolean isNewLayer = false;
                                    if (layer == null) {
                                        layer = HIRuntime.getManager().createLayer(view, red, green, blue, opacity, layerElement.getAttribute("id"));
                                        isNewLayer = true;
                                    }
                                    if (isNewLayer) {
                                        layerSortOrder = String.valueOf(layerSortOrder) + "," + layer.getId();
                                    }
                                    this.layerIDMap.put(layer.getUUID(), layer);
                                    ((HiLayer)layer).setPolygons("");
                                    HILayer layerWrapper = new HILayer((HiLayer)layer, 100, 100);
                                    HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.28") + " : " + Messages.getString("PeTALImporter.29") + " " + (a + 1) + ": " + Messages.getString("PeTALImporter.30"));
                                    NodeList polygonElements = svgElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "polygon");
                                    int p = 0;
                                    while (p < polygonElements.getLength()) {
                                        String points;
                                        Element polygonElement = (Element)polygonElements.item(p);
                                        boolean isCustom = false;
                                        if (polygonElement.getAttribute("type") != null && polygonElement.getAttribute("type").compareTo("custom") == 0) {
                                            isCustom = true;
                                        }
                                        points = (points = polygonElement.getAttribute("points")) == null || points.length() == 0 ? "" : (isCustom ? "U;" + points : "F;" + points);
                                        points = points.replaceAll(" ", ";");
                                        points = points.replaceAll(",", "#");
                                        RelativePolygon polygon = new RelativePolygon(points, 10000, 10000);
                                        layerWrapper.getRelativePolygons().addElement(polygon);
                                        if (isCustom) {
                                            HIRuntime.getManager().addProjectPolygon(polygon.getModel());
                                        }
                                        ++p;
                                    }
                                    NodeList rectElements = svgElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "rect");
                                    int p2 = 0;
                                    while (p2 < rectElements.getLength()) {
                                        Element rectElement = (Element)rectElements.item(p2);
                                        int x = (int)(Float.parseFloat(rectElement.getAttribute("x")) * 10000.0f);
                                        int y = (int)(Float.parseFloat(rectElement.getAttribute("y")) * 10000.0f);
                                        int width = (int)(Float.parseFloat(rectElement.getAttribute("width")) * 10000.0f);
                                        int height = (int)(Float.parseFloat(rectElement.getAttribute("height")) * 10000.0f);
                                        RelativePolygon polygon = new RelativePolygon(RelativePolygon.HiPolygonTypes.HI_RECTANGLE, x, y, width, height, null, 10000, 10000);
                                        polygon.commitChangesToModel();
                                        layerWrapper.getRelativePolygons().addElement(polygon);
                                        ++p2;
                                    }
                                    NodeList pathElements = svgElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "path");
                                    int p3 = 0;
                                    while (p3 < pathElements.getLength()) {
                                        Element pathElement = (Element)pathElements.item(p3);
                                        String path = pathElement.getAttribute("d");
                                        if (path != null && path.length() > 0) {
                                            path = path.replaceAll("z", "");
                                            path = path.replaceAll("Z", "");
                                            String[] stringArray = path.split("M");
                                            int n = stringArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String points = stringArray[n2];
                                                if ((points = points.trim()).length() > 0) {
                                                    points = "F;" + points;
                                                    points = points.replaceAll(" ", ";");
                                                    points = points.replaceAll(",", "#");
                                                    RelativePolygon polygon = new RelativePolygon(points, 10000, 10000);
                                                    layerWrapper.getRelativePolygons().addElement(polygon);
                                                }
                                                ++n2;
                                            }
                                        }
                                        ++p3;
                                    }
                                    layerWrapper.syncPolygonChanges();
                                    timestamp = this.parseTimestamp(layerElement.getAttribute("timestamp"));
                                    if (isNewLayer || layer != null && layer.getTimestamp() < timestamp) {
                                        HIRuntime.getManager().updateLayerProperties(layer.getId(), red, green, blue, opacity, layerWrapper.getModel().getPolygons());
                                        this.attachMetadataRecords(layerElement, layer.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://hyperimage.ws/PeTAL/HIBase/2.0", "annotation", "comment");
                                    }
                                }
                                ++a;
                            }
                            if (layerSortOrder.startsWith(",")) {
                                layerSortOrder = layerSortOrder.substring(1);
                            }
                            HIRuntime.getManager().updateViewSortOrder(view, layerSortOrder);
                        }
                    }
                    if (contentElement.getTagName().compareTo("inscription") == 0) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.31"));
                        HiInscription inscription = null;
                        try {
                            HiBase base = HIRuntime.getManager().getBaseElement(contentElement.getAttribute("id"));
                            if (base != null && base instanceof HiInscription) {
                                inscription = (HiInscription)base;
                            }
                        }
                        catch (HIWebServiceException base) {
                            // empty catch block
                        }
                        boolean isNewInscription = false;
                        if (inscription == null) {
                            inscription = HIRuntime.getManager().createInscription(object, contentElement.getAttribute("id"));
                            isNewInscription = true;
                        }
                        timestamp = this.parseTimestamp(contentElement.getAttribute("timestamp"));
                        if (isNewInscription || inscription != null && inscription.getTimestamp() < timestamp) {
                            this.attachMetadataRecords(contentElement, inscription.getMetadata(), null, null, null, null, null, null, "http://hyperimage.ws/PeTAL/HIBase/2.0", "content", "content");
                        }
                        if (!isNewInscription) {
                            HIRuntime.getManager().updateContentOwner(object, inscription);
                        }
                        if (isNewInscription) {
                            sortOrder = String.valueOf(sortOrder) + "," + inscription.getId();
                        }
                        if (sortOrder.startsWith(",")) {
                            sortOrder = sortOrder.substring(1);
                        }
                    }
                    if (contentElement.getTagName().compareTo("defaultView") == 0) {
                        defaultView = contentElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                        defaultView = defaultView.substring(1);
                    }
                }
                if (defaultView != null && defaultView.length() > 0 && !this.corruptViews.contains(defaultView)) {
                    HiQuickInfo info = null;
                    try {
                        info = HIRuntime.getManager().getBaseQuickInfo(defaultView);
                    }
                    catch (HIWebServiceException hIWebServiceException) {
                        // empty catch block
                    }
                    if (info != null) {
                        HIRuntime.getManager().setDefaultView(object.getId(), info.getBaseID());
                    }
                }
                ++i;
            }
            HIRuntime.getManager().updateObjectSortOrder(object, sortOrder);
            ++counter;
        }
    }

    public void importLegacyLightTables() throws HIWebServiceException {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.22"));
        this.litas.clear();
        int counter = 1;
        NodeList litalements = this.rootElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "lita");
        int i = 0;
        while (i < litalements.getLength()) {
            Element litalement = (Element)litalements.item(i);
            this.litas.add(litalement);
            ++i;
        }
        for (Element litaElement : this.litas) {
            HiLightTable lita = null;
            try {
                HiBase base = HIRuntime.getManager().getBaseElement(litaElement.getAttribute("id"));
                if (base != null && base instanceof HiLightTable) {
                    lita = (HiLightTable)base;
                }
            }
            catch (HIWebServiceException base) {
                // empty catch block
            }
            String title = "-";
            NodeList titleElements = litaElement.getElementsByTagName("title");
            int i2 = 0;
            while (i2 < titleElements.getLength()) {
                Element titleElement = (Element)titleElements.item(i2);
                String lang = titleElement.getAttribute("xml:lang");
                if (lang.compareTo(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()) == 0 && ((title = titleElement.getTextContent()) == null || title.length() == 0)) {
                    title = "-";
                }
                ++i2;
            }
            String litaXML = PeTALExporter.serializeXMLElement(litaElement);
            litaXML = litaXML == null || litaXML.length() == 0 || litaXML.indexOf("<lita") < 0 ? MetadataHelper.getDefaultLightTableXML() : litaXML.substring(litaXML.indexOf("<lita"));
            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.40")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + this.litaMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
            if (litaXML == null) {
                litaXML = "";
            }
            boolean isNewLita = false;
            if (lita == null) {
                lita = HIRuntime.getManager().createLightTable(title, litaXML, litaElement.getAttribute("id"));
                isNewLita = true;
            }
            long timestamp = this.parseTimestamp(litaElement.getAttribute("timestamp"));
            if (isNewLita || lita != null && lita.getTimestamp() < timestamp) {
                lita.setXml(litaXML);
                HIRuntime.getManager().updateLightTable(lita);
            }
            ++counter;
        }
    }

    private void setStartRef() throws HIWebServiceException {
        this.startRef = this.xmlDocument.getDocumentElement().getAttribute("startRef");
        if (this.startRef == null || this.startRef.length() == 0) {
            return;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.42"));
        HiQuickInfo info = null;
        try {
            info = HIRuntime.getManager().getBaseQuickInfo(this.startRef);
        }
        catch (HIWebServiceException hIWebServiceException) {
            // empty catch block
        }
        if (info != null) {
            HIRuntime.getManager().updateProjectStartElement(info.getBaseID());
        }
    }

    public void importXMLToProject() {
        HIRuntime.getGui().startIndicatingServiceActivity(true);
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.1"));
        this.importSuccessful = false;
        new Thread(){

            @Override
            public void run() {
                try {
                    PeTAL3Importer.this.rootElement = PeTAL3Importer.this.xmlDocument.getDocumentElement();
                    PeTAL3Importer.this.importLanguages();
                    PeTAL3Importer.this.importProjectMetadata();
                    PeTAL3Importer.this.importTemplates();
                    PeTAL3Importer.this.importGroups();
                    PeTAL3Importer.this.importTags();
                    PeTAL3Importer.this.importTexts();
                    PeTAL3Importer.this.importURLs();
                    PeTAL3Importer.this.importObjectsViewsInscriptionsLayers();
                    PeTAL3Importer.this.importLegacyLightTables();
                    Object projElements = null;
                    boolean counter = true;
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.32"));
                    for (Element groupElement : PeTAL3Importer.this.groups) {
                        String sortOrder = "";
                        HiGroup group = (HiGroup)HIRuntime.getManager().getBaseElement(groupElement.getAttribute("id"));
                        if (group != null && group.getSortOrder() != null) {
                            sortOrder = group.getSortOrder();
                        }
                        List<HiQuickInfo> contents = HIRuntime.getManager().getGroupContents(group);
                        NodeList memberElements = groupElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "member");
                        int i = 0;
                        while (i < memberElements.getLength()) {
                            Element memberElement = (Element)memberElements.item(i);
                            String ref = memberElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                            if (ref != null) {
                                ref = ref.substring(1);
                            }
                            HiQuickInfo info2 = null;
                            try {
                                info2 = HIRuntime.getManager().getBaseQuickInfo(ref);
                            }
                            catch (HIWebServiceException e) {
                                e.printStackTrace();
                            }
                            boolean containsElement = false;
                            for (HiQuickInfo content : contents) {
                                if (content.getBaseID() != info2.getBaseID()) continue;
                                containsElement = true;
                            }
                            if (info2 != null && !containsElement) {
                                HIRuntime.getManager().addToGroup(info2.getBaseID(), group.getId());
                                sortOrder = String.valueOf(sortOrder) + "," + info2.getBaseID();
                                if (sortOrder.startsWith(",")) {
                                    sortOrder = sortOrder.substring(1);
                                }
                            }
                            ++i;
                        }
                        HIRuntime.getManager().updateGroupSortOrder(group.getId(), sortOrder);
                    }
                    projElements = null;
                    counter = true;
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.tagmembership"));
                    for (Element tagElement : PeTAL3Importer.this.tags) {
                        HiGroup tag = (HiGroup)HIRuntime.getManager().getBaseElement(tagElement.getAttribute("id"));
                        List<HiQuickInfo> contents = HIRuntime.getManager().getGroupContents(tag);
                        NodeList memberElements = tagElement.getElementsByTagNameNS("http://hyperimage.ws/PeTAL/3.0", "member");
                        int i = 0;
                        while (i < memberElements.getLength()) {
                            Element memberElement = (Element)memberElements.item(i);
                            String ref = memberElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                            if (ref != null) {
                                ref = ref.substring(1);
                            }
                            HiQuickInfo info = null;
                            try {
                                info = HIRuntime.getManager().getBaseQuickInfo(ref);
                            }
                            catch (HIWebServiceException info2) {
                                // empty catch block
                            }
                            boolean containsElement = false;
                            for (HiQuickInfo content : contents) {
                                if (content.getBaseID() != info.getBaseID()) continue;
                                containsElement = true;
                            }
                            if (info != null && !containsElement) {
                                HIRuntime.getManager().addToGroup(info.getBaseID(), tag.getId());
                            }
                            ++i;
                        }
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.33"));
                    for (Element layerElement : PeTAL3Importer.this.layers) {
                        HiLayer layer = (HiLayer)PeTAL3Importer.this.layerIDMap.get(layerElement.getAttribute("id"));
                        String href = layerElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                        if (href != null && href.length() > 0) {
                            href = href.substring(1);
                        }
                        if (layer == null || href == null || href.length() <= 0) continue;
                        HiQuickInfo info = null;
                        try {
                            info = HIRuntime.getManager().getBaseQuickInfo(href);
                        }
                        catch (HIWebServiceException hIWebServiceException) {
                            // empty catch block
                        }
                        if (info == null) continue;
                        HIRuntime.getManager().setLayerLink(layer.getId(), info.getBaseID());
                    }
                    PeTAL3Importer.this.setStartRef();
                }
                catch (HIWebServiceException wse) {
                    wse.printStackTrace();
                    HIRuntime.getGui().reportError(wse, null);
                    PeTAL3Importer.this.abortWithError("");
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PeTAL3Importer.this.abortWithError(e.getMessage());
                    return;
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                PeTAL3Importer.this.importSuccessful = true;
                HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.43"), String.valueOf(Messages.getString("PeTALImporter.44")) + "\n" + Messages.getString("PeTALImporter.45"));
                if (PeTAL3Importer.this.litaMap.size() > 0) {
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.46"), String.valueOf(Messages.getString("PeTALImporter.47")) + "\n\n" + Messages.getString("PeTALImporter.48"));
                }
                for (String viewID : PeTAL3Importer.this.corruptViews) {
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.46"), String.valueOf(Messages.getString("PeTALImporter.49")) + " " + viewID + " " + Messages.getString("PeTALImporter.50") + "\n\n" + Messages.getString("PeTALImporter.51") + "\n" + Messages.getString("PeTALImporter.52"));
                }
                HIRuntime.getGui().triggerProjectUpdate();
            }
        }.start();
    }

    class RemoteFile {
        public byte[] data = null;
        public String filename = "unknown.jpg";
        public String href = "[Remote Repository]";

        RemoteFile() {
        }
    }
}

