/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.xmlimportexport;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.model.HIRichText;
import org.hyperimage.client.model.HIRichTextChunk;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataName;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLanguage;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiProject;
import org.hyperimage.client.ws.HiProjectMetadata;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PeTALExporter {
    public static Vector<HiView> projectViews = new Vector();

    public static Document getProjectToPeTALXML(HiProject hiProject) {
        Element mdElement;
        String serverURL;
        DocumentBuilder xmlDocumentBuilder;
        Document petalXML = null;
        Vector<Element> groupNodes = new Vector<Element>();
        HashMap<Long, Element> textNodes = new HashMap<Long, Element>();
        HashMap<Long, Element> objectNodes = new HashMap<Long, Element>();
        HashMap<Long, Element> litaNodes = new HashMap<Long, Element>();
        HashMap<Long, Element> urlNodes = new HashMap<Long, Element>();
        projectViews.removeAllElements();
        try {
            xmlDocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return petalXML;
        }
        petalXML = xmlDocumentBuilder.newDocument();
        Element project = petalXML.createElement("petal");
        project.setAttribute("xmlns", "http://www.hyperimage.eu/PeTAL/2.0");
        project.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        project.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
        project.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        project.setAttribute("xmlns:html", "http://www.w3.org/1999/xhtml");
        project.setAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        project.setAttribute("xsi:schemaLocation", "http://www.hyperimage.eu/PeTAL/2.0 http://hyperimage.cms.hu-berlin.de/2.0/schema/PeTAL_schema_2.0.xsd");
        project.setAttribute("version", "2.0");
        boolean dcSchemaFound = false;
        for (HiFlexMetadataTemplate template : hiProject.getTemplates()) {
            String nsURI = template.getNamespaceURI();
            if (nsURI == null || nsURI.length() == 0) {
                nsURI = "unknown";
            }
            if (template.getNamespacePrefix().compareTo("HIClassic") == 0) {
                nsURI = "http://www.hyperimage.eu/PeTAL/HIClassic/1.0";
            }
            project.setAttribute("xmlns:" + template.getNamespacePrefix(), nsURI);
            if (template.getNamespacePrefix().compareTo("dc") != 0 || template.getNamespaceURI().compareTo("http://purl.org/dc/elements/1.1/") != 0) continue;
            dcSchemaFound = true;
        }
        if (!dcSchemaFound) {
            project.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        }
        if (hiProject == null) {
            return petalXML;
        }
        project.setAttribute("id", "P" + hiProject.getId());
        String startRef = "";
        if (hiProject.getStartObjectInfo() != null) {
            startRef = MetadataHelper.getDisplayableID(hiProject.getStartObjectInfo(), true);
        }
        if (!(serverURL = HIRuntime.getManager().getServerURL()).endsWith("/")) {
            serverURL = String.valueOf(serverURL) + "/";
        }
        serverURL = serverURL.replaceAll("http://", "petal://");
        serverURL = serverURL.replaceAll("https://", "petals://");
        project.setAttribute("startRef", String.valueOf(serverURL) + "P" + HIRuntime.getManager().getProject().getId() + "/" + startRef);
        petalXML.appendChild(project);
        for (HiLanguage lang : hiProject.getLanguages()) {
            Element tempLanguage = petalXML.createElement("language");
            if (lang.getId() == hiProject.getDefaultLanguage().getId()) {
                tempLanguage.setAttribute("standard", "true");
            }
            tempLanguage.appendChild(petalXML.createTextNode(lang.getLanguageId()));
            project.appendChild(tempLanguage);
        }
        Element projMetadataElement = petalXML.createElement("projectMetadata");
        project.appendChild(projMetadataElement);
        Element RDFElement = petalXML.createElement("rdf:RDF");
        projMetadataElement.appendChild(RDFElement);
        for (HiProjectMetadata record : hiProject.getMetadata()) {
            Element RDFDescriptionElement = petalXML.createElement("rdf:Description");
            RDFDescriptionElement.setAttribute("xml:lang", record.getLanguageID());
            RDFDescriptionElement.setAttribute("rdf:about", MetadataHelper.getProjectFullyQualifiedURI());
            RDFElement.appendChild(RDFDescriptionElement);
            mdElement = petalXML.createElement("dc:title");
            mdElement.setAttribute("xml:lang", record.getLanguageID());
            mdElement.appendChild(petalXML.createTextNode(PeTALExporter.validateUTF8(record.getTitle())));
            RDFDescriptionElement.appendChild(mdElement);
        }
        for (HiFlexMetadataTemplate template : hiProject.getTemplates()) {
            if (template.getNamespacePrefix().compareTo("HIBase") == 0) continue;
            Element tempTemplate = petalXML.createElement("template");
            tempTemplate.setAttribute("id", "T_" + template.getId() + "_" + template.getNamespacePrefix());
            tempTemplate.setAttribute("nsPrefix", template.getNamespacePrefix());
            tempTemplate.setAttribute("schema", template.getNamespaceURI());
            if (template.getNamespacePrefix().compareTo("HIClassic") == 0) {
                tempTemplate.setAttribute("schema", "http://www.hyperimage.eu/PeTAL/HIClassic/1.0");
            }
            if (template.getNamespaceURL().length() > 0) {
                tempTemplate.setAttribute("schemaLocation", template.getNamespaceURL());
            }
            for (HiFlexMetadataSet set : template.getEntries()) {
                Element tempSet = petalXML.createElement("key");
                tempSet.setAttribute("tagName", set.getTagname());
                if (set.isRichText()) {
                    tempSet.setAttribute("richText", "true");
                }
                for (HiFlexMetadataName name : set.getDisplayNames()) {
                    Element tempDisplayName = petalXML.createElement("displayName");
                    tempDisplayName.setAttribute("xml:lang", name.getLanguage());
                    tempDisplayName.appendChild(petalXML.createTextNode(name.getDisplayName()));
                    tempSet.appendChild(tempDisplayName);
                }
                tempTemplate.appendChild(tempSet);
            }
            project.appendChild(tempTemplate);
        }
        try {
            List<HiGroup> groups = HIRuntime.getManager().getGroups();
            groups.add(0, HIRuntime.getManager().getImportGroup());
            float percentage = 100.0f / (float)(groups.size() - 1);
            float progress = 0.0f;
            int groupIndex = 0;
            while (groupIndex < groups.size()) {
                HiGroup group = groups.get(groupIndex);
                Element tempGroup = petalXML.createElement("group");
                tempGroup.setAttribute("id", "G" + group.getId());
                if (group.getType() == GroupTypes.HIGROUP_IMPORT) {
                    tempGroup.setAttribute("type", "import");
                } else if (group.getType() == GroupTypes.HIGROUP_REGULAR) {
                    tempGroup.setAttribute("type", "regular");
                } else {
                    tempGroup.setAttribute("type", "trash");
                }
                RDFElement = petalXML.createElement("rdf:RDF");
                tempGroup.appendChild(RDFElement);
                for (HiFlexMetadataRecord record : group.getMetadata()) {
                    Element RDFDescriptionElement = petalXML.createElement("rdf:Description");
                    RDFDescriptionElement.setAttribute("rdf:about", MetadataHelper.getBaseIDQualifiedURI(group));
                    RDFDescriptionElement.setAttribute("xml:lang", record.getLanguage());
                    RDFElement.appendChild(RDFDescriptionElement);
                    mdElement = PeTALExporter.getSingleLineBaseElementNode("title", "dc:title", "HIBase", record, petalXML);
                    mdElement.removeAttribute("xml:lang");
                    RDFDescriptionElement.appendChild(mdElement);
                    mdElement = PeTALExporter.getMultiLineBaseElementNode("comment", "HIBase:annotation", "HIBase", record, petalXML);
                    mdElement.removeAttribute("xml:lang");
                    RDFDescriptionElement.appendChild(mdElement);
                }
                List<HiQuickInfo> contents = HIRuntime.getManager().getGroupContents(group);
                PeTALExporter.sortContents(contents, group.getSortOrder());
                float contentPercentage = 0.0f;
                if (contents.size() > 0) {
                    contentPercentage = 1.0f / (float)contents.size();
                }
                int contentIndex = 0;
                while (contentIndex < contents.size()) {
                    HiQuickInfo content = contents.get(contentIndex);
                    float updatedProgress = percentage * (float)groupIndex + percentage * (contentPercentage * (float)contentIndex);
                    if ((int)updatedProgress != (int)progress) {
                        progress = updatedProgress;
                        HIRuntime.getGui().setProgress((int)progress);
                    }
                    Element tempContent = petalXML.createElement("member");
                    tempContent.setAttribute("xlink:type", "simple");
                    tempContent.setAttribute("xlink:href", MetadataHelper.getBaseIDQualifiedURI(content));
                    tempGroup.appendChild(tempContent);
                    if (content.getContentType() == HiBaseTypes.HI_OBJECT && !objectNodes.containsKey(content.getBaseID())) {
                        objectNodes.put(content.getBaseID(), PeTALExporter.getObjectElement((HiObject)HIRuntime.getManager().getBaseElement(content.getBaseID()), hiProject, petalXML));
                    }
                    if (content.getContentType() == HiBaseTypes.HI_TEXT && !textNodes.containsKey(content.getBaseID())) {
                        textNodes.put(content.getBaseID(), PeTALExporter.getTextElement((HiText)HIRuntime.getManager().getBaseElement(content.getBaseID()), petalXML));
                    }
                    if (content.getContentType() == HiBaseTypes.HIURL && !urlNodes.containsKey(content.getBaseID())) {
                        urlNodes.put(content.getBaseID(), PeTALExporter.getURLElement((Hiurl)HIRuntime.getManager().getBaseElement(content.getBaseID()), petalXML));
                    }
                    if (content.getContentType() == HiBaseTypes.HI_LIGHT_TABLE && !litaNodes.containsKey(content.getBaseID())) {
                        litaNodes.put(content.getBaseID(), PeTALExporter.getLightTableElement((HiLightTable)HIRuntime.getManager().getBaseElement(content.getBaseID()), petalXML));
                    }
                    ++contentIndex;
                }
                groupNodes.addElement(tempGroup);
                ++groupIndex;
            }
            for (Long key : textNodes.keySet()) {
                project.appendChild((Node)textNodes.get(key));
            }
            for (Long key : objectNodes.keySet()) {
                project.appendChild((Node)objectNodes.get(key));
            }
            for (Long key : litaNodes.keySet()) {
                project.appendChild((Node)litaNodes.get(key));
            }
            for (Long key : urlNodes.keySet()) {
                project.appendChild((Node)urlNodes.get(key));
            }
            for (Element group : groupNodes) {
                project.appendChild(group);
            }
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, null);
            return petalXML;
        }
        HIRuntime.getGui().setProgress(-1);
        return petalXML;
    }

    public static String validateUTF8(String input) {
        return input;
    }

    private static void sortContents(List<HiQuickInfo> contents, String sortOrder) {
        if (contents == null) {
            return;
        }
        int index = 0;
        String[] stringArray = sortOrder.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long contentID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < contents.size()) {
                    if (contents.get(i).getBaseID() == contentID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiQuickInfo content = contents.get(contentIndex);
                        contents.remove(contentIndex);
                        contents.add(index, content);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static void sortLayers(List<HiLayer> layers, String sortOrder) {
        int index = 0;
        String[] stringArray = sortOrder.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long layerID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < layers.size()) {
                    if (layers.get(i).getId() == layerID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiLayer layer = layers.get(contentIndex);
                        layers.remove(contentIndex);
                        layers.add(index, layer);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static void sortObjectContent(List<HiObjectContent> contents, String sortOrder) {
        int index = 0;
        String[] stringArray = sortOrder.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long contentID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < contents.size()) {
                    if (contents.get(i).getId() == contentID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiObjectContent content = contents.get(contentIndex);
                        contents.remove(contentIndex);
                        contents.add(index, content);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static Element getLightTableElement(HiLightTable lightTable, Document creator) {
        Element lightTableElement = creator.createElement("lita");
        lightTableElement.setAttribute("id", "X" + lightTable.getId());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            factory.setNamespaceAware(false);
            builder = factory.newDocumentBuilder();
            if (builder != null) {
                builder.setErrorHandler(null);
            }
            builder.reset();
            ByteArrayInputStream input = new ByteArrayInputStream(MetadataHelper.convertToUTF8(lightTable.getXml()).getBytes());
            Document doc = builder.parse(input);
            lightTableElement = (Element)creator.adoptNode(doc.getElementsByTagName("lita").item(0));
            lightTableElement.setAttribute("id", "X" + lightTable.getId());
        }
        catch (ParserConfigurationException e) {
            return lightTableElement;
        }
        catch (SAXException e) {
            return lightTableElement;
        }
        catch (IOException e) {
            return lightTableElement;
        }
        return lightTableElement;
    }

    private static Element getURLElement(Hiurl url, Document creator) {
        Element urlElement = creator.createElement("url");
        urlElement.setAttribute("id", "U" + url.getId());
        urlElement.setAttribute("xlink:href", url.getUrl());
        urlElement.setAttribute("xlink:type", "simple");
        urlElement.setAttribute("xlink:title", PeTALExporter.validateUTF8(url.getTitle()));
        urlElement.appendChild(creator.createTextNode(PeTALExporter.validateUTF8(url.getTitle())));
        Element annotationElement = creator.createElement("annotation");
        PeTALExporter.serializeMultiLineField(url.getLastAccess(), annotationElement, creator);
        urlElement.appendChild(annotationElement);
        urlElement.removeAttribute("xml:lang");
        return urlElement;
    }

    private static Element getTextElement(HiText text, Document creator) {
        Element textElement = creator.createElement("text");
        textElement.setAttribute("id", "T" + text.getId());
        Element RDFElement = creator.createElement("rdf:RDF");
        textElement.appendChild(RDFElement);
        for (HiFlexMetadataRecord record : text.getMetadata()) {
            Element RDFDescriptionElement = creator.createElement("rdf:Description");
            RDFDescriptionElement.setAttribute("xml:lang", record.getLanguage());
            RDFDescriptionElement.setAttribute("rdf:about", MetadataHelper.getBaseIDQualifiedURI(text));
            RDFElement.appendChild(RDFDescriptionElement);
            Element mdElement = PeTALExporter.getSingleLineBaseElementNode("title", "dc:title", "HIBase", record, creator);
            mdElement.removeAttribute("xml:lang");
            RDFDescriptionElement.appendChild(mdElement);
            mdElement = PeTALExporter.getMultiLineBaseElementNode("content", "HIBase:content", "HIBase", record, creator);
            mdElement.removeAttribute("xml:lang");
            RDFDescriptionElement.appendChild(mdElement);
        }
        return textElement;
    }

    private static Element getObjectElement(HiObject object, HiProject project, Document creator) {
        Element objectElement = creator.createElement("object");
        if (object == null) {
            return objectElement;
        }
        objectElement.setAttribute("id", "O" + object.getId());
        if (object.getDefaultView() != null) {
            Element defViewElement = creator.createElement("standardView");
            defViewElement.setAttribute("xlink:type", "simple");
            defViewElement.setAttribute("xlink:href", MetadataHelper.getBaseIDQualifiedURI(object.getDefaultView()));
            objectElement.appendChild(defViewElement);
        }
        PeTALExporter.sortObjectContent(object.getViews(), object.getSortOrder());
        for (HiObjectContent content : object.getViews()) {
            if (content instanceof HiView) {
                objectElement.appendChild(PeTALExporter.getViewElement((HiView)content, creator));
                continue;
            }
            objectElement.appendChild(PeTALExporter.getInscriptionElement((HiInscription)content, creator));
        }
        for (HiFlexMetadataRecord record : object.getMetadata()) {
            Element metadataElement = creator.createElement("metadata");
            metadataElement.setAttribute("xml:lang", record.getLanguage());
            Element RDFElement = creator.createElement("rdf:RDF");
            metadataElement.appendChild(RDFElement);
            Element RDFDescriptionElement = creator.createElement("rdf:Description");
            RDFDescriptionElement.setAttribute("xml:lang", record.getLanguage());
            RDFDescriptionElement.setAttribute("rdf:about", MetadataHelper.getBaseIDQualifiedURI(object));
            RDFElement.appendChild(RDFDescriptionElement);
            for (HiFlexMetadataTemplate template : project.getTemplates()) {
                if (template.getNamespacePrefix().compareTo("HIBase") == 0) continue;
                for (HiFlexMetadataSet set : template.getEntries()) {
                    Element valueElement = set.isRichText() ? PeTALExporter.getMultiLineBaseElementNode(set.getTagname(), String.valueOf(template.getNamespacePrefix()) + ":" + set.getTagname(), template.getNamespacePrefix(), record, creator) : PeTALExporter.getSingleLineBaseElementNode(set.getTagname(), String.valueOf(template.getNamespacePrefix()) + ":" + set.getTagname(), template.getNamespacePrefix(), record, creator);
                    valueElement.removeAttribute("xml:lang");
                    RDFDescriptionElement.appendChild(valueElement);
                }
            }
            objectElement.appendChild(metadataElement);
        }
        return objectElement;
    }

    private static Element getInscriptionElement(HiInscription inscription, Document creator) {
        Element inscriptionElement = creator.createElement("inscription");
        inscriptionElement.setAttribute("id", "I" + inscription.getId());
        Element RDFElement = creator.createElement("rdf:RDF");
        inscriptionElement.appendChild(RDFElement);
        for (HiFlexMetadataRecord record : inscription.getMetadata()) {
            Element RDFDescriptionElement = creator.createElement("rdf:Description");
            RDFDescriptionElement.setAttribute("xml:lang", record.getLanguage());
            RDFDescriptionElement.setAttribute("rdf:about", MetadataHelper.getBaseIDQualifiedURI(inscription));
            RDFElement.appendChild(RDFDescriptionElement);
            Element mdElement = PeTALExporter.getMultiLineBaseElementNode("content", "HIBase:content", "HIBase", record, creator);
            mdElement.removeAttribute("xml:lang");
            RDFDescriptionElement.appendChild(mdElement);
        }
        return inscriptionElement;
    }

    private static Element getViewElement(HiView view, Document creator) {
        Element viewElement = creator.createElement("view");
        viewElement.setAttribute("id", "V" + view.getId());
        Element originalElement = creator.createElement("original");
        originalElement.setAttribute("filename", view.getFilename());
        originalElement.setAttribute("hash", view.getHash());
        viewElement.appendChild(originalElement);
        viewElement.appendChild(PeTALExporter.getImgElement(view.getWidth(), view.getHeight(), "img/V" + view.getId() + ".original", "pict", creator));
        Element RDFElement = creator.createElement("rdf:RDF");
        viewElement.appendChild(RDFElement);
        for (HiFlexMetadataRecord record : view.getMetadata()) {
            Element RDFDescriptionElement = creator.createElement("rdf:Description");
            RDFDescriptionElement.setAttribute("xml:lang", record.getLanguage());
            RDFDescriptionElement.setAttribute("rdf:about", MetadataHelper.getBaseIDQualifiedURI(view));
            RDFElement.appendChild(RDFDescriptionElement);
            Element mdElement = PeTALExporter.getSingleLineBaseElementNode("title", "dc:title", "HIBase", record, creator);
            mdElement.removeAttribute("xml:lang");
            RDFDescriptionElement.appendChild(mdElement);
            mdElement = PeTALExporter.getSingleLineBaseElementNode("source", "dc:source", "HIBase", record, creator);
            mdElement.removeAttribute("xml:lang");
            RDFDescriptionElement.appendChild(mdElement);
            mdElement = PeTALExporter.getMultiLineBaseElementNode("comment", "HIBase:annotation", "HIBase", record, creator);
            mdElement.removeAttribute("xml:lang");
            RDFDescriptionElement.appendChild(mdElement);
        }
        boolean isInStore = false;
        for (HiView storedView : projectViews) {
            if (storedView.getId() != view.getId()) continue;
            isInStore = true;
        }
        if (!isInStore) {
            projectViews.addElement(view);
        }
        PeTALExporter.sortLayers(view.getLayers(), view.getSortOrder());
        int zOrder = view.getLayers().size();
        while (zOrder >= 1) {
            HiLayer layer = view.getLayers().get(zOrder - 1);
            viewElement.appendChild(PeTALExporter.getLayerElement(layer, zOrder, creator));
            --zOrder;
        }
        return viewElement;
    }

    private static Node getLayerElement(HiLayer layer, int order, Document creator) {
        Element layerElement = creator.createElement("layer");
        layerElement.setAttribute("id", "L" + layer.getId());
        String color = "#";
        color = Integer.toHexString(layer.getRed()).length() < 2 ? String.valueOf(color) + "0" + Integer.toHexString(layer.getRed()) : String.valueOf(color) + Integer.toHexString(layer.getRed());
        color = Integer.toHexString(layer.getGreen()).length() < 2 ? String.valueOf(color) + "0" + Integer.toHexString(layer.getGreen()) : String.valueOf(color) + Integer.toHexString(layer.getGreen());
        color = Integer.toHexString(layer.getBlue()).length() < 2 ? String.valueOf(color) + "0" + Integer.toHexString(layer.getBlue()) : String.valueOf(color) + Integer.toHexString(layer.getBlue());
        if (layer.getLinkInfo() != null) {
            layerElement.setAttribute("xlink:type", "simple");
            layerElement.setAttribute("xlink:href", MetadataHelper.getBaseIDQualifiedURI(layer.getLinkInfo()));
        }
        layerElement.setAttribute("order", Integer.toString(order));
        Element RDFElement = creator.createElement("rdf:RDF");
        layerElement.appendChild(RDFElement);
        for (HiFlexMetadataRecord record : layer.getMetadata()) {
            Element RDFDescriptionElement = creator.createElement("rdf:Description");
            RDFDescriptionElement.setAttribute("rdf:about", MetadataHelper.getBaseIDQualifiedURI(layer));
            RDFDescriptionElement.setAttribute("xml:lang", record.getLanguage());
            RDFElement.appendChild(RDFDescriptionElement);
            Element mdElement = PeTALExporter.getSingleLineBaseElementNode("title", "dc:title", "HIBase", record, creator);
            mdElement.removeAttribute("xml:lang");
            RDFDescriptionElement.appendChild(mdElement);
            mdElement = PeTALExporter.getMultiLineBaseElementNode("comment", "HIBase:annotation", "HIBase", record, creator);
            mdElement.removeAttribute("xml:lang");
            RDFDescriptionElement.appendChild(mdElement);
        }
        Element svgElement = creator.createElement("svg:svg");
        svgElement.setAttribute("version", "1.1");
        svgElement.setAttribute("width", "100");
        svgElement.setAttribute("height", "100");
        Element gElement = creator.createElement("svg:g");
        svgElement.appendChild(gElement);
        gElement.setAttribute("transform", "scale(100)");
        gElement.setAttribute("stroke", "none");
        gElement.setAttribute("fill", color);
        gElement.setAttribute("opacity", Float.toString(layer.getOpacity()));
        gElement.setAttribute("fill-opacity", Float.toString(layer.getOpacity()));
        layerElement.appendChild(svgElement);
        HILayer wrapper = new HILayer(layer, 400, 400);
        for (RelativePolygon polygon : wrapper.getRelativePolygons()) {
            gElement.appendChild(PeTALExporter.getShapeElement(polygon, creator));
        }
        return layerElement;
    }

    private static Element getShapeElement(RelativePolygon polygon, Document creator) {
        Element shapeElement;
        if (polygon.getType() == RelativePolygon.HiPolygonTypes.HI_RECTANGLE) {
            shapeElement = creator.createElement("svg:rect");
            double x = polygon.getRelativePoint((int)0).x;
            double y = polygon.getRelativePoint((int)0).y;
            double width = x;
            double height = y;
            int i = 1;
            while (i < 4) {
                if (polygon.getRelativePoint((int)i).x < x) {
                    x = polygon.getRelativePoint((int)i).x;
                }
                if (polygon.getRelativePoint((int)i).y < y) {
                    y = polygon.getRelativePoint((int)i).y;
                }
                if (polygon.getRelativePoint((int)i).x > width) {
                    width = polygon.getRelativePoint((int)i).x;
                }
                if (polygon.getRelativePoint((int)i).y > height) {
                    height = polygon.getRelativePoint((int)i).y;
                }
                ++i;
            }
            shapeElement.setAttribute("x", Double.toString(x));
            shapeElement.setAttribute("y", Double.toString(y));
            shapeElement.setAttribute("width", Double.toString(width -= x));
            shapeElement.setAttribute("height", Double.toString(height -= y));
        } else {
            String points;
            shapeElement = creator.createElement("svg:polygon");
            if (polygon.getType() == RelativePolygon.HiPolygonTypes.HI_USERDESIGN) {
                shapeElement.setAttribute("type", "custom");
            }
            if ((points = polygon.getModel()).length() > 2) {
                points = points.substring(2);
            }
            points = points.replaceAll("#", ",");
            points = points.replaceAll(";", " ");
            shapeElement.setAttribute("points", points);
        }
        return shapeElement;
    }

    private static Element getImgElement(int width, int height, String src, String use, Document creator) {
        Element imgElement = creator.createElement("img");
        imgElement.setAttribute("width", Integer.toString(width));
        imgElement.setAttribute("height", Integer.toString(height));
        imgElement.setAttribute("src", src);
        imgElement.setAttribute("use", use);
        return imgElement;
    }

    private static List<Element> getSingleLineBaseElementNodes(String key, String elementTitle, String template, List<HiFlexMetadataRecord> records, Document creator) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (records == null) {
            return elements;
        }
        for (HiFlexMetadataRecord record : records) {
            elements.add(PeTALExporter.getSingleLineBaseElementNode(key, elementTitle, template, record, creator));
        }
        return elements;
    }

    private static Element getSingleLineBaseElementNode(String key, String elementTitle, String template, HiFlexMetadataRecord record, Document creator) {
        Element tempElement = creator.createElement(elementTitle);
        tempElement.setAttribute("xml:lang", record.getLanguage());
        tempElement.appendChild(creator.createTextNode(PeTALExporter.validateUTF8(MetadataHelper.findValue(template, key, record))));
        return tempElement;
    }

    private static Vector<String> breakdownLines(String lines) {
        Vector<String> cutLines = new Vector<String>();
        do {
            String line;
            if (lines.indexOf("\n") < 0) {
                line = lines;
                continue;
            }
            line = lines.substring(0, lines.indexOf("\n"));
            lines = lines.substring(lines.indexOf("\n") + 1);
            cutLines.addElement(line);
        } while (lines.indexOf("\n") >= 0);
        cutLines.addElement(lines);
        return cutLines;
    }

    private static void serializeMultiLineField(String model, Element multiLineElement, Document creator) {
        HIRichText text = new HIRichText(model);
        HIRichTextChunk.chunkTypes chunkState = null;
        Element chunkNode = null;
        if (text.getChunks().size() == 0) {
            return;
        }
        if (text.getChunks().size() == 1 && text.getChunks().get(0).getValue().length() == 0) {
            return;
        }
        chunkNode = multiLineElement;
        for (HIRichTextChunk chunk : text.getChunks()) {
            if (chunk.getChunkType() != HIRichTextChunk.chunkTypes.LINK) {
                if (chunkState != chunk.getChunkType()) {
                    if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.REGULAR) {
                        chunkNode = multiLineElement;
                    } else {
                        String tag = null;
                        if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.BOLD) {
                            tag = "html:b";
                        }
                        if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.ITALIC) {
                            tag = "html:i";
                        }
                        if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.UNDERLINE) {
                            tag = "html:u";
                        }
                        if (tag == null) {
                            chunkNode = multiLineElement;
                        } else {
                            chunkNode = creator.createElement(tag);
                            multiLineElement.appendChild(chunkNode);
                        }
                    }
                    chunkState = chunk.getChunkType();
                }
                Vector<String> lines = PeTALExporter.breakdownLines(chunk.getValue());
                int i = 0;
                while (i < lines.size()) {
                    String line = lines.get(i);
                    chunkNode.appendChild(creator.createTextNode(PeTALExporter.validateUTF8(line)));
                    if (i < lines.size() - 1) {
                        Element brElement = creator.createElement("html:br");
                        chunkNode.appendChild(brElement);
                    }
                    ++i;
                }
                continue;
            }
            Vector<String> lines = PeTALExporter.breakdownLines(chunk.getValue());
            int i = 0;
            while (i < lines.size()) {
                String line = lines.get(i);
                if (line.length() > 0) {
                    String serverURL = HIRuntime.getManager().getServerURL();
                    if (!serverURL.endsWith("/")) {
                        serverURL = String.valueOf(serverURL) + "/";
                    }
                    serverURL = serverURL.replaceAll("http://", "petal://");
                    serverURL = serverURL.replaceAll("https://", "petals://");
                    Element linkElement = creator.createElement("link");
                    linkElement.setAttribute("xlink:type", "simple");
                    linkElement.setAttribute("xlink:href", String.valueOf(serverURL) + "P" + HIRuntime.getManager().getProject().getId() + "/" + chunk.getRef());
                    linkElement.appendChild(creator.createTextNode(PeTALExporter.validateUTF8(line)));
                    chunkNode.appendChild(linkElement);
                }
                if (i < lines.size() - 1) {
                    Element brElement = creator.createElement("html:br");
                    chunkNode.appendChild(brElement);
                }
                ++i;
            }
        }
    }

    private static Element getMultiLineBaseElementNode(String key, String elementTitle, String template, HiFlexMetadataRecord record, Document creator) {
        Element tempElement = creator.createElement(elementTitle);
        tempElement.setAttribute("xml:lang", record.getLanguage());
        PeTALExporter.serializeMultiLineField(MetadataHelper.findValue(template, key, record), tempElement, creator);
        return tempElement;
    }

    private static List<Element> getMultiLineBaseElementNodes(String key, String elementTitle, String template, List<HiFlexMetadataRecord> records, Document creator) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (records == null) {
            return elements;
        }
        for (HiFlexMetadataRecord record : records) {
            elements.add(PeTALExporter.getMultiLineBaseElementNode(key, elementTitle, template, record, creator));
        }
        return elements;
    }

    public static String serializeXMLDocument(Document doc) {
        OutputFormat xmlFormat = new OutputFormat();
        xmlFormat.setEncoding("UTF-8");
        xmlFormat.setVersion("1.0");
        xmlFormat.setIndenting(true);
        xmlFormat.setIndent(4);
        xmlFormat.setPreserveEmptyAttributes(true);
        ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
        XMLSerializer x = new XMLSerializer(xmlStream, xmlFormat);
        x.setOutputFormat(xmlFormat);
        x.setOutputByteStream(xmlStream);
        try {
            x.serialize(doc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xmlStream.toString();
    }

    public static String serializeXMLElement(Element element) {
        OutputFormat xmlFormat = new OutputFormat();
        xmlFormat.setEncoding("UTF-8");
        xmlFormat.setVersion("1.0");
        xmlFormat.setIndenting(true);
        xmlFormat.setIndent(4);
        xmlFormat.setPreserveEmptyAttributes(true);
        ByteArrayOutputStream xmlStream = new ByteArrayOutputStream();
        XMLSerializer x = new XMLSerializer(xmlStream, xmlFormat);
        x.setOutputFormat(xmlFormat);
        x.setOutputByteStream(xmlStream);
        try {
            x.serialize(element);
        }
        catch (IOException e) {
            return "";
        }
        return xmlStream.toString();
    }

    public static void serializeXMLDocumentToFile(Document doc, File outputFile) {
        OutputFormat xmlFormat = new OutputFormat("XML", "UTF-8", true);
        xmlFormat.setIndenting(true);
        xmlFormat.setIndent(4);
        xmlFormat.setPreserveEmptyAttributes(true);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        XMLSerializer xmlSerializer = new XMLSerializer(fos, xmlFormat);
        try {
            xmlSerializer.asDOMSerializer().serialize(doc.getDocumentElement());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

