/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.xmlimportexport;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.HIRichTextFieldControl;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.model.HIRichText;
import org.hyperimage.client.model.HIRichTextChunk;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataName;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLanguage;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiPreference;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.hyperimage.client.xmlimportexport.PeTALExporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PeTALImporter {
    Document petalXML = null;
    File inputFile = null;
    String version = null;
    boolean importSuccessful = false;
    String startRef = "";
    Vector<String> languages = new Vector();
    Vector<String> brokenViews = new Vector();
    Vector<Element> texts = new Vector();
    Vector<Element> objects = new Vector();
    Vector<Element> views = new Vector();
    Vector<Element> inscriptions = new Vector();
    Vector<Element> layers = new Vector();
    Vector<Element> urls = new Vector();
    Vector<Element> litas = new Vector();
    Vector<Element> groups = new Vector();
    Vector<HiFlexMetadataTemplate> templates = new Vector();
    HashMap<HiText, Element> textMap = new HashMap();
    HashMap<String, HiText> textIDMap = new HashMap();
    HashMap<Hiurl, Element> urlMap = new HashMap();
    HashMap<String, Hiurl> urlIDMap = new HashMap();
    HashMap<HiLightTable, Element> litaMap = new HashMap();
    HashMap<String, HiLightTable> litaIDMap = new HashMap();
    HashMap<HiGroup, Element> groupMap = new HashMap();
    HashMap<String, HiGroup> groupIDMap = new HashMap();
    HashMap<HiObject, Element> objectMap = new HashMap();
    HashMap<String, HiObject> objectIDMap = new HashMap();
    HashMap<HiView, Element> viewMap = new HashMap();
    HashMap<String, HiView> viewIDMap = new HashMap();
    HashMap<HiInscription, Element> inscriptionMap = new HashMap();
    HashMap<String, HiInscription> inscriptionIDMap = new HashMap();
    HashMap<HiLayer, Element> layerMap = new HashMap();
    HashMap<String, HiLayer> layerIDMap = new HashMap();

    public String getPeTALVersion() {
        if (this.petalXML == null) {
            this.version = null;
        }
        return this.version;
    }

    public boolean wasImportSuccessful() {
        return this.importSuccessful;
    }

    private void abortWithError(String errorMessage) {
        HIRuntime.getGui().stopIndicatingServiceActivity();
        if (errorMessage == null) {
            errorMessage = "";
        }
        System.out.println("IMPORT ERROR!");
        System.out.println("--> " + errorMessage);
        if (errorMessage.length() == 0) {
            HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.2"), String.valueOf(Messages.getString("PeTALImporter.3")) + "\n\n" + Messages.getString("PeTALImporter.4"));
        } else {
            HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.2"), String.valueOf(Messages.getString("PeTALImporter.5")) + "\n" + Messages.getString("PeTALImporter.6") + " " + errorMessage + "\n\n" + Messages.getString("PeTALImporter.7"));
        }
        HIRuntime.getGui().triggerProjectUpdate();
    }

    private boolean checkLangInProject(String lang) {
        boolean langIsInProject = false;
        for (HiLanguage projLang : HIRuntime.getManager().getProject().getLanguages()) {
            if (!projLang.getLanguageId().equalsIgnoreCase(lang)) continue;
            langIsInProject = true;
        }
        return langIsInProject;
    }

    private String resolveDisplayableNewID(String oldURIID) {
        HiLayer layer;
        HiInscription inscription;
        HiView view;
        HiObject object;
        HiGroup group;
        HiLightTable lita;
        Hiurl url;
        HiText text;
        String newID = "";
        String oldID = oldURIID.substring(oldURIID.lastIndexOf("/") + 1);
        if (oldID.startsWith("T") && (text = this.textIDMap.get(oldID)) != null) {
            newID = "T" + text.getId();
        }
        if (oldID.startsWith("U") && (url = this.urlIDMap.get(oldID)) != null) {
            newID = "U" + url.getId();
        }
        if (oldID.startsWith("X") && (lita = this.litaIDMap.get(oldID)) != null) {
            newID = "X" + lita.getId();
        }
        if (oldID.startsWith("G") && (group = this.groupIDMap.get(oldID)) != null) {
            newID = "G" + group.getId();
        }
        if (oldID.startsWith("O") && (object = this.objectIDMap.get(oldID)) != null) {
            newID = "O" + object.getId();
        }
        if (oldID.startsWith("V") && (view = this.viewIDMap.get(oldID)) != null) {
            newID = "V" + view.getId();
        }
        if (oldID.startsWith("I") && (inscription = this.inscriptionIDMap.get(oldID)) != null) {
            newID = "I" + inscription.getId();
        }
        if (oldID.startsWith("L") && (layer = this.layerIDMap.get(oldID)) != null) {
            newID = "L" + layer.getId();
        }
        return newID;
    }

    private long resolveNewID(String oldURIID) {
        HiLayer layer;
        HiInscription inscription;
        HiView view;
        HiObject object;
        HiGroup group;
        HiLightTable lita;
        Hiurl url;
        HiText text;
        long newID = 0L;
        String oldID = oldURIID.substring(oldURIID.lastIndexOf("/") + 1);
        if (oldID.startsWith("T") && (text = this.textIDMap.get(oldID)) != null) {
            newID = text.getId();
        }
        if (oldID.startsWith("U") && (url = this.urlIDMap.get(oldID)) != null) {
            newID = url.getId();
        }
        if (oldID.startsWith("X") && (lita = this.litaIDMap.get(oldID)) != null) {
            newID = lita.getId();
        }
        if (oldID.startsWith("G") && (group = this.groupIDMap.get(oldID)) != null) {
            newID = group.getId();
        }
        if (oldID.startsWith("O") && (object = this.objectIDMap.get(oldID)) != null) {
            newID = object.getId();
        }
        if (oldID.startsWith("V") && (view = this.viewIDMap.get(oldID)) != null) {
            newID = view.getId();
        }
        if (oldID.startsWith("I") && (inscription = this.inscriptionIDMap.get(oldID)) != null) {
            newID = inscription.getId();
        }
        if (oldID.startsWith("L") && (layer = this.layerIDMap.get(oldID)) != null) {
            newID = layer.getId();
        }
        return newID;
    }

    private String getTextNodeContent(Node textNode) {
        String textContent = "";
        textContent = textNode.getTextContent();
        if ((textContent = textContent.replaceAll("[ ]*[\t\n]+[\t\n ]*\\z", "")).length() == 0) {
            textContent = " ";
        }
        textContent = textContent.replaceAll("[ ]*[\t\n]+[\t\n ]*", " ");
        return textContent;
    }

    private String getSubElementText(Element subElement) {
        String textContent = "";
        NodeList subNodes = subElement.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node subNode = subNodes.item(i);
            if (subNode.getNodeType() == 3) {
                textContent = String.valueOf(textContent) + this.getTextNodeContent(subNode);
            } else if (((Element)subNode).getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && ((Element)subNode).getLocalName().compareTo("br") == 0) {
                textContent = String.valueOf(textContent) + "\n";
            }
            ++i;
        }
        return textContent;
    }

    private void processSubNode(Element subElement, HIRichText hiText, HIRichTextChunk.chunkTypes chunkType) {
        String textContent = "";
        NodeList subNodes = subElement.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node subNode = subNodes.item(i);
            if (subNode.getNodeType() == 3) {
                if (i < subNodes.getLength() - 1 || subNode.getTextContent().replaceAll("[ \t\n]*", "").length() > 0) {
                    textContent = String.valueOf(textContent) + this.getTextNodeContent(subNode);
                }
            } else if (((Element)subNode).getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && ((Element)subNode).getLocalName().compareTo("br") == 0) {
                textContent = String.valueOf(textContent) + "\n";
            } else if (((Element)subNode).getNamespaceURI().compareTo("http://www.hyperimage.eu/PeTAL/2.0") == 0 && ((Element)subNode).getLocalName().compareTo("link") == 0) {
                if (textContent.length() > 0) {
                    hiText.addChunk(chunkType, textContent);
                }
                textContent = "";
                String href = ((Element)subNode).getAttributeNS("http://www.w3.org/1999/xlink", "href");
                if (href != null && href.length() > 0) {
                    href = this.resolveDisplayableNewID(href);
                    String subContent = this.getSubElementText((Element)subNode);
                    if (subContent.length() > 0) {
                        if (href.length() > 0) {
                            hiText.addChunk(HIRichTextChunk.chunkTypes.LINK, subContent, href);
                        } else {
                            hiText.addChunk(chunkType, subContent, href);
                        }
                    }
                }
            }
            ++i;
        }
        if (textContent.length() > 0) {
            hiText.addChunk(chunkType, textContent);
        }
    }

    private String convertRichTextXMLField(Element richTextElement) {
        String modelText = "";
        HIRichText hiText = new HIRichText();
        String chunkText = "";
        String chunkRef = "";
        NodeList chunkNodes = richTextElement.getChildNodes();
        int i = 0;
        while (i < chunkNodes.getLength()) {
            Node chunkNode = chunkNodes.item(i);
            if (chunkNode.getNodeType() == 3) {
                if (chunkNode.getTextContent().replaceAll("[ \t\n]*", "").length() == 0) {
                    if (i >= chunkNodes.getLength() - 1 || chunkNodes.item(i + 1).getNodeType() != 1 || ((Element)chunkNodes.item(i + 1)).getTagName().equalsIgnoreCase("html:br") || ((Element)chunkNodes.item(i + 1)).getTagName().equalsIgnoreCase("link")) {
                        chunkText = String.valueOf(chunkText) + this.getTextNodeContent(chunkNode);
                    }
                } else {
                    chunkText = String.valueOf(chunkText) + this.getTextNodeContent(chunkNode);
                }
            } else {
                Element chunkElement = (Element)chunkNode;
                if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("br") == 0) {
                    chunkText = String.valueOf(chunkText) + "\n";
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("b") == 0) {
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                    }
                    chunkText = "";
                    this.processSubNode(chunkElement, hiText, HIRichTextChunk.chunkTypes.BOLD);
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("i") == 0) {
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                    }
                    chunkText = "";
                    this.processSubNode(chunkElement, hiText, HIRichTextChunk.chunkTypes.ITALIC);
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.w3.org/1999/xhtml") == 0 && chunkElement.getLocalName().compareTo("u") == 0) {
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                    }
                    chunkText = "";
                    this.processSubNode(chunkElement, hiText, HIRichTextChunk.chunkTypes.UNDERLINE);
                } else if (chunkElement.getNamespaceURI().compareTo("http://www.hyperimage.eu/PeTAL/2.0") == 0 && chunkElement.getLocalName().compareTo("link") == 0) {
                    if (chunkText.length() > 0) {
                        hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
                    }
                    chunkText = "";
                    String href = chunkElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                    if (href != null && href.length() > 0) {
                        href = this.resolveDisplayableNewID(href);
                        String subContent = this.getSubElementText(chunkElement);
                        if (subContent.length() > 0) {
                            if (href.length() > 0) {
                                hiText.addChunk(HIRichTextChunk.chunkTypes.LINK, subContent, href);
                            } else {
                                hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, subContent, href);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (chunkText.length() > 0) {
            hiText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, chunkText);
        }
        modelText = hiText.getModel();
        return modelText;
    }

    private String getSingleLineTextContent(Element element, String namespace, String tagName) {
        String temp;
        String textContent = "";
        if (element == null) {
            return textContent;
        }
        if (element.getElementsByTagNameNS(namespace, tagName).getLength() > 0 && (temp = element.getElementsByTagNameNS(namespace, tagName).item(0).getTextContent()) != null) {
            textContent = temp.trim();
        }
        return textContent;
    }

    private String getMultiLineTextContent(Element element, String namespace, String tagName) {
        String textContent = new HIRichText().getModel();
        if (element == null) {
            return textContent;
        }
        if (element.getElementsByTagNameNS(namespace, tagName).getLength() > 0) {
            textContent = this.convertRichTextXMLField((Element)element.getElementsByTagNameNS(namespace, tagName).item(0));
        }
        HIRichTextFieldControl control = new HIRichTextFieldControl("import");
        control.setText(textContent);
        textContent = control.getText();
        return textContent;
    }

    public void attachMetadataRecords(Element mdElement, List<HiFlexMetadataRecord> records, String nsURI1, String tagName1, String mdName1, String nsURI2, String tagName2, String mdName2, String nsURI3, String tagName3, String mdName3) throws HIWebServiceException {
        NodeList descElements = mdElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        int i = 0;
        while (i < descElements.getLength()) {
            Element descElement = (Element)descElements.item(i);
            String lang = descElement.getAttribute("xml:lang");
            if (this.checkLangInProject(lang)) {
                HiFlexMetadataRecord record;
                String tagContent1 = null;
                if (tagName1 != null) {
                    tagContent1 = this.getSingleLineTextContent(descElement, nsURI1, tagName1);
                }
                String tagContent2 = null;
                if (tagName2 != null) {
                    tagContent2 = this.getSingleLineTextContent(descElement, nsURI2, tagName2);
                }
                String tagContent3 = null;
                if (tagName3 != null) {
                    tagContent3 = this.getMultiLineTextContent(descElement, nsURI3, tagName3);
                }
                if ((record = MetadataHelper.getDefaultMetadataRecord(records, lang)) != null) {
                    if (mdName1 != null) {
                        MetadataHelper.setValue("HIBase", mdName1, tagContent1, record);
                    }
                    if (mdName2 != null) {
                        MetadataHelper.setValue("HIBase", mdName2, tagContent2, record);
                    }
                    if (mdName3 != null) {
                        MetadataHelper.setValue("HIBase", mdName3, tagContent3, record);
                    }
                }
                HIRuntime.getManager().updateFlexMetadataRecord(record);
            }
            ++i;
        }
    }

    public void importXMLToProject() {
        HIRuntime.getGui().startIndicatingServiceActivity(true);
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.1"));
        this.importSuccessful = false;
        this.languages.removeAllElements();
        this.templates.removeAllElements();
        this.texts.removeAllElements();
        this.objects.removeAllElements();
        this.views.removeAllElements();
        this.inscriptions.removeAllElements();
        this.layers.removeAllElements();
        this.urls.removeAllElements();
        this.litas.removeAllElements();
        this.groups.removeAllElements();
        this.brokenViews.removeAllElements();
        this.textMap.clear();
        this.textIDMap.clear();
        this.urlMap.clear();
        this.urlIDMap.clear();
        this.litaMap.clear();
        this.litaIDMap.clear();
        this.groupMap.clear();
        this.groupIDMap.clear();
        this.objectMap.clear();
        this.objectIDMap.clear();
        this.viewMap.clear();
        this.viewIDMap.clear();
        this.inscriptionMap.clear();
        this.inscriptionIDMap.clear();
        this.layerMap.clear();
        this.layerIDMap.clear();
        new Thread(){

            @Override
            public void run() {
                try {
                    Element petalElement = PeTALImporter.this.petalXML.getDocumentElement();
                    PeTALImporter.this.languages.removeAllElements();
                    NodeList langElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "language");
                    String defLang = null;
                    int i = 0;
                    while (i < langElements.getLength()) {
                        Element langElement = (Element)langElements.item(i);
                        PeTALImporter.this.languages.addElement(langElement.getTextContent().trim());
                        if (langElement.getAttribute("standard") != null && langElement.getAttribute("standard").equalsIgnoreCase("true")) {
                            defLang = langElement.getTextContent().trim();
                        }
                        ++i;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.8"));
                    for (String lang : PeTALImporter.this.languages) {
                        if (PeTALImporter.this.checkLangInProject(lang)) continue;
                        HIRuntime.getManager().addLanguageToProject(lang);
                    }
                    HIRuntime.getManager().updateProjectDefaultLanguage(defLang);
                    Vector<String> unusedLangs = new Vector<String>();
                    for (HiLanguage projLang : HIRuntime.getManager().getProject().getLanguages()) {
                        boolean langIsInProject = false;
                        for (String string : PeTALImporter.this.languages) {
                            if (!string.equalsIgnoreCase(projLang.getLanguageId())) continue;
                            langIsInProject = true;
                        }
                        if (langIsInProject) continue;
                        unusedLangs.addElement(projLang.getLanguageId());
                    }
                    for (String unusedLang : unusedLangs) {
                        HIRuntime.getManager().removeLanguageFromProject(unusedLang);
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.9"));
                    if (petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "projectMetadata").getLength() > 0) {
                        Element projMetadataElement = (Element)petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "projectMetadata").item(0);
                        NodeList mdElements = projMetadataElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                        int i2 = 0;
                        while (i2 < mdElements.getLength()) {
                            Element element2 = (Element)mdElements.item(i2);
                            element2 = (Element)element2.getElementsByTagNameNS("http://purl.org/dc/elements/1.1/", "title").item(0);
                            if (PeTALImporter.this.checkLangInProject(element2.getAttribute("xml:lang"))) {
                                HIRuntime.getManager().updateProject(element2.getAttribute("xml:lang"), element2.getTextContent().trim());
                            }
                            ++i2;
                        }
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.10"));
                    NodeList templateElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "template");
                    int i3 = 0;
                    while (i3 < templateElements.getLength()) {
                        Element templateElement = (Element)templateElements.item(i3);
                        if (!templateElement.getAttribute("nsPrefix").equalsIgnoreCase("HIBase")) {
                            boolean bl;
                            boolean bl2 = false;
                            for (HiFlexMetadataTemplate projTemplate : HIRuntime.getManager().getProject().getTemplates()) {
                                if (!projTemplate.getNamespacePrefix().equalsIgnoreCase(templateElement.getAttribute("nsPrefix")) && !projTemplate.getNamespaceURI().equalsIgnoreCase(templateElement.getAttribute("schema"))) continue;
                                PeTALImporter.this.templates.add(projTemplate);
                                bl = true;
                            }
                            if (!bl) {
                                HiFlexMetadataTemplate newTemplate = new HiFlexMetadataTemplate();
                                newTemplate.setNamespacePrefix(templateElement.getAttribute("nsPrefix"));
                                newTemplate.setNamespaceURI(templateElement.getAttribute("schema"));
                                newTemplate.setNamespaceURL(templateElement.getAttribute("schemaLocation"));
                                HiFlexMetadataSet newSet = null;
                                HiFlexMetadataName newName = null;
                                NodeList keyElements = templateElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "key");
                                int a = 0;
                                while (a < keyElements.getLength()) {
                                    Element keyElement = (Element)keyElements.item(a);
                                    newSet = new HiFlexMetadataSet();
                                    newSet.setRichText(false);
                                    if (keyElement.getAttribute("richText") != null && keyElement.getAttribute("richText").equalsIgnoreCase("true")) {
                                        newSet.setRichText(true);
                                    }
                                    newSet.setTagname(keyElement.getAttribute("tagName"));
                                    NodeList nameElements = keyElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "displayName");
                                    int b = 0;
                                    while (b < nameElements.getLength()) {
                                        Element nameElement = (Element)nameElements.item(b);
                                        newName = new HiFlexMetadataName();
                                        newName.setDisplayName(nameElement.getTextContent().trim());
                                        newName.setLanguage(nameElement.getAttribute("xml:lang"));
                                        newSet.getDisplayNames().add(newName);
                                        ++b;
                                    }
                                    newTemplate.getEntries().add(newSet);
                                    ++a;
                                }
                                if (HIRuntime.getManager().addTemplateToProject(newTemplate)) {
                                    PeTALImporter.this.templates.add(newTemplate);
                                }
                            }
                        }
                        ++i3;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.11"));
                    NodeList projElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "text");
                    int i4 = 0;
                    while (i4 < projElements.getLength()) {
                        Element element = (Element)projElements.item(i4);
                        PeTALImporter.this.texts.addElement(element);
                        ++i4;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.12"));
                    projElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "object");
                    int i2 = 0;
                    while (i2 < projElements.getLength()) {
                        Element element = (Element)projElements.item(i2);
                        PeTALImporter.this.objects.addElement(element);
                        ++i2;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.13"));
                    projElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "view");
                    i2 = 0;
                    while (i2 < projElements.getLength()) {
                        Element element = (Element)projElements.item(i2);
                        PeTALImporter.this.views.addElement(element);
                        ++i2;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.14"));
                    projElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "inscription");
                    i2 = 0;
                    while (i2 < projElements.getLength()) {
                        Element element = (Element)projElements.item(i2);
                        PeTALImporter.this.inscriptions.addElement(element);
                        ++i2;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.15"));
                    projElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "layer");
                    i2 = 0;
                    while (i2 < projElements.getLength()) {
                        Element element = (Element)projElements.item(i2);
                        PeTALImporter.this.layers.addElement(element);
                        ++i2;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.16"));
                    projElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "url");
                    i2 = 0;
                    while (i2 < projElements.getLength()) {
                        Element element = (Element)projElements.item(i2);
                        PeTALImporter.this.urls.addElement(element);
                        ++i2;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.17"));
                    projElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "lita");
                    i2 = 0;
                    while (i2 < projElements.getLength()) {
                        Element element = (Element)projElements.item(i2);
                        PeTALImporter.this.litas.addElement(element);
                        ++i2;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.18"));
                    projElements = petalElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "group");
                    i2 = 0;
                    while (i2 < projElements.getLength()) {
                        Element element = (Element)projElements.item(i2);
                        if (!element.getAttribute("type").equalsIgnoreCase("import") && !element.getAttribute("type").equalsIgnoreCase("tag")) {
                            PeTALImporter.this.groups.addElement(element);
                        }
                        ++i2;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.19"));
                    for (Element viewElement : PeTALImporter.this.views) {
                        if (viewElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "original").getLength() <= 0 || viewElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "img").getLength() <= 0) {
                            PeTALImporter.this.brokenViews.addElement(viewElement.getAttribute("id"));
                            continue;
                        }
                        Element origElement = (Element)viewElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "original").item(0);
                        Element imgElement = (Element)viewElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "img").item(0);
                        String pathToFile = String.valueOf(PeTALImporter.this.inputFile.getParent()) + "/" + imgElement.getAttribute("src");
                        pathToFile = File.separator.compareTo("\\") == 0 ? pathToFile.replaceAll("/", "\\" + File.separator) : pathToFile.replaceAll("/", File.separator);
                        File binFile = new File(pathToFile);
                        if (binFile.exists() && binFile.canRead() && binFile.isFile()) continue;
                        PeTALImporter.this.brokenViews.addElement(viewElement.getAttribute("id"));
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.20"));
                    for (Element textElement : PeTALImporter.this.texts) {
                        HiText newText = HIRuntime.getManager().createText();
                        PeTALImporter.this.textMap.put(newText, textElement);
                        PeTALImporter.this.textIDMap.put(textElement.getAttribute("id"), newText);
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.21"));
                    for (Element urlElement : PeTALImporter.this.urls) {
                        Hiurl newURL = HIRuntime.getManager().createURL(urlElement.getAttributeNS("http://www.w3.org/1999/xlink", "href"), urlElement.getAttributeNS("http://www.w3.org/1999/xlink", "title"), "");
                        PeTALImporter.this.urlMap.put(newURL, urlElement);
                        PeTALImporter.this.urlIDMap.put(urlElement.getAttribute("id"), newURL);
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.22"));
                    for (Element litaElement : PeTALImporter.this.litas) {
                        Object litaXML = PeTALExporter.serializeXMLElement(litaElement);
                        litaXML = litaXML == null || ((String)litaXML).length() == 0 || ((String)litaXML).indexOf("<lita") < 0 ? MetadataHelper.getDefaultLightTableXML() : ((String)litaXML).substring(((String)litaXML).indexOf("<lita"));
                        HiLightTable newLita = HIRuntime.getManager().createLightTable("-", (String)litaXML);
                        PeTALImporter.this.litaMap.put(newLita, litaElement);
                        PeTALImporter.this.litaIDMap.put(litaElement.getAttribute("id"), newLita);
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.23"));
                    String sortOrder = "";
                    for (Element element : PeTALImporter.this.groups) {
                        HiGroup newGroup = HIRuntime.getManager().createGroup();
                        if (newGroup == null) continue;
                        PeTALImporter.this.groupMap.put(newGroup, element);
                        PeTALImporter.this.groupIDMap.put(element.getAttribute("id"), newGroup);
                        sortOrder = String.valueOf(sortOrder) + "," + newGroup.getId();
                        if (!sortOrder.startsWith(",")) continue;
                        sortOrder = sortOrder.substring(1);
                    }
                    HiPreference hiPreference = MetadataHelper.findPreference(HIRuntime.getManager().getProject(), "groupSortOrder");
                    hiPreference.setValue(sortOrder);
                    HIRuntime.getManager().updatePreference(hiPreference);
                    int counter = 1;
                    for (Element objectElement : PeTALImporter.this.objects) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTALImporter.this.objects.size() + " " + Messages.getString("PeTALImporter.26"));
                        HiObject newObject = HIRuntime.getManager().createObject();
                        PeTALImporter.this.objectMap.put(newObject, objectElement);
                        PeTALImporter.this.objectIDMap.put(objectElement.getAttribute("id"), newObject);
                        NodeList contentElements = objectElement.getChildNodes();
                        String standardView = null;
                        sortOrder = "";
                        int i5 = 0;
                        while (i5 < contentElements.getLength()) {
                            if (contentElements.item(i5).getNodeType() == 1) {
                                Element contentElement = (Element)contentElements.item(i5);
                                if (contentElement.getTagName().compareTo("view") == 0 && !PeTALImporter.this.brokenViews.contains(contentElement.getAttribute("id"))) {
                                    HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.27"));
                                    Element origElement = (Element)contentElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "original").item(0);
                                    Element imgElement = (Element)contentElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "img").item(0);
                                    String pathToFile = String.valueOf(PeTALImporter.this.inputFile.getParent()) + "/" + imgElement.getAttribute("src");
                                    pathToFile = File.separator.compareTo("\\") == 0 ? pathToFile.replaceAll("/", "\\" + File.separator) : pathToFile.replaceAll("/", File.separator);
                                    File binFile = new File(pathToFile);
                                    boolean bytesRead = false;
                                    byte[] data = null;
                                    try {
                                        data = HIRuntime.getBytesFromFile(binFile);
                                        bytesRead = true;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    if (bytesRead && data != null) {
                                        HiView newView = HIRuntime.getManager().createView(newObject.getId(), origElement.getAttribute("filename"), "[PeTAL 2.0 XML Import]", binFile, UUID.randomUUID().toString());
                                        PeTALImporter.this.viewMap.put(newView, contentElement);
                                        PeTALImporter.this.viewIDMap.put(contentElement.getAttribute("id"), newView);
                                        data = null;
                                        sortOrder = String.valueOf(sortOrder) + "," + newView.getId();
                                        if (sortOrder.startsWith(",")) {
                                            sortOrder = sortOrder.substring(1);
                                        }
                                        String layerSortOrder = "";
                                        NodeList layerElements = contentElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "layer");
                                        int a = 0;
                                        while (a < layerElements.getLength()) {
                                            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.28") + " : " + Messages.getString("PeTALImporter.29") + " " + (a + 1) + " " + Messages.getString("PeTALImporter.25") + " " + layerElements.getLength() + " " + Messages.getString("PeTALImporter.26"));
                                            Element layerElement = (Element)layerElements.item(a);
                                            if (layerElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "g").getLength() > 0) {
                                                Element svgElement = (Element)layerElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "g").item(0);
                                                String colorString = svgElement.getAttribute("fill");
                                                float opacity = 1.0f;
                                                if (svgElement.getAttribute("opacity") != null) {
                                                    try {
                                                        opacity = Float.parseFloat(svgElement.getAttribute("opacity"));
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        // empty catch block
                                                    }
                                                }
                                                Color color = Color.decode(colorString);
                                                int red = color.getRed();
                                                int green = color.getGreen();
                                                int blue = color.getBlue();
                                                HiLayer newLayer = HIRuntime.getManager().createLayer(newView, red, green, blue, opacity);
                                                PeTALImporter.this.layerMap.put(newLayer, layerElement);
                                                PeTALImporter.this.layerIDMap.put(layerElement.getAttribute("id"), newLayer);
                                                layerSortOrder = String.valueOf(layerSortOrder) + "," + newLayer.getId();
                                                if (layerSortOrder.startsWith(",")) {
                                                    layerSortOrder = layerSortOrder.substring(1);
                                                }
                                                HILayer layerWrapper = new HILayer(newLayer, 100, 100);
                                                HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.28") + " : " + Messages.getString("PeTALImporter.29") + " " + (a + 1) + ": " + Messages.getString("PeTALImporter.30"));
                                                NodeList polygonElements = svgElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "polygon");
                                                int p = 0;
                                                while (p < polygonElements.getLength()) {
                                                    String points;
                                                    Element polygonElement = (Element)polygonElements.item(p);
                                                    boolean isCustom = false;
                                                    if (polygonElement.getAttribute("type") != null && polygonElement.getAttribute("type").compareTo("custom") == 0) {
                                                        isCustom = true;
                                                    }
                                                    points = (points = polygonElement.getAttribute("points")) == null || points.length() == 0 ? "" : (isCustom ? "U;" + points : "F;" + points);
                                                    points = points.replaceAll(" ", ";");
                                                    points = points.replaceAll(",", "#");
                                                    RelativePolygon polygon = new RelativePolygon(points, 10000, 10000);
                                                    layerWrapper.getRelativePolygons().addElement(polygon);
                                                    if (isCustom) {
                                                        HIRuntime.getManager().addProjectPolygon(polygon.getModel());
                                                    }
                                                    ++p;
                                                }
                                                NodeList rectElements = svgElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "rect");
                                                int p2 = 0;
                                                while (p2 < rectElements.getLength()) {
                                                    Element rectElement = (Element)rectElements.item(p2);
                                                    int x = (int)(Float.parseFloat(rectElement.getAttribute("x")) * 10000.0f);
                                                    int y = (int)(Float.parseFloat(rectElement.getAttribute("y")) * 10000.0f);
                                                    int width = (int)(Float.parseFloat(rectElement.getAttribute("width")) * 10000.0f);
                                                    int height = (int)(Float.parseFloat(rectElement.getAttribute("height")) * 10000.0f);
                                                    RelativePolygon polygon = new RelativePolygon(RelativePolygon.HiPolygonTypes.HI_RECTANGLE, x, y, width, height, null, 10000, 10000);
                                                    polygon.commitChangesToModel();
                                                    layerWrapper.getRelativePolygons().addElement(polygon);
                                                    ++p2;
                                                }
                                                layerWrapper.syncPolygonChanges();
                                                HIRuntime.getManager().updateLayerProperties(newLayer.getId(), red, green, blue, opacity, layerWrapper.getModel().getPolygons());
                                            }
                                            ++a;
                                        }
                                        HIRuntime.getManager().updateViewSortOrder(newView, layerSortOrder);
                                    }
                                }
                                if (contentElement.getTagName().compareTo("inscription") == 0) {
                                    HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.31"));
                                    HiInscription newInscription = HIRuntime.getManager().createInscription(newObject);
                                    PeTALImporter.this.inscriptionMap.put(newInscription, contentElement);
                                    PeTALImporter.this.inscriptionIDMap.put(contentElement.getAttribute("id"), newInscription);
                                    sortOrder = String.valueOf(sortOrder) + "," + newInscription.getId();
                                    if (sortOrder.startsWith(",")) {
                                        sortOrder = sortOrder.substring(1);
                                    }
                                }
                                if (contentElement.getTagName().compareTo("standardView") == 0) {
                                    standardView = contentElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                                    standardView = standardView.substring(standardView.lastIndexOf("/") + 1);
                                }
                            }
                            if (standardView != null && standardView.length() > 0 && !PeTALImporter.this.brokenViews.contains(standardView) && PeTALImporter.this.viewIDMap.get(standardView) != null) {
                                HIRuntime.getManager().setDefaultView(newObject, PeTALImporter.this.viewIDMap.get(standardView));
                            }
                            ++i5;
                        }
                        HIRuntime.getManager().updateObjectSortOrder(newObject, sortOrder);
                        ++counter;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.32"));
                    for (Element groupElement : PeTALImporter.this.groupMap.values()) {
                        long groupID = PeTALImporter.this.groupIDMap.get(groupElement.getAttribute("id")).getId();
                        sortOrder = "";
                        NodeList memberElements = groupElement.getElementsByTagNameNS("http://www.hyperimage.eu/PeTAL/2.0", "member");
                        int i6 = 0;
                        while (i6 < memberElements.getLength()) {
                            Element memberElement = (Element)memberElements.item(i6);
                            long memberID = PeTALImporter.this.resolveNewID(memberElement.getAttributeNS("http://www.w3.org/1999/xlink", "href"));
                            if (memberID > 0L) {
                                HIRuntime.getManager().addToGroup(memberID, groupID);
                                sortOrder = String.valueOf(sortOrder) + "," + memberID;
                                if (sortOrder.startsWith(",")) {
                                    sortOrder = sortOrder.substring(1);
                                }
                            }
                            ++i6;
                        }
                        HIRuntime.getManager().updateGroupSortOrder(groupID, sortOrder);
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.33"));
                    for (Element layerElement : PeTALImporter.this.layerMap.values()) {
                        long newID;
                        long layerID = PeTALImporter.this.layerIDMap.get(layerElement.getAttribute("id")).getId();
                        String href = layerElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                        if (href == null || href.length() <= 0 || (newID = PeTALImporter.this.resolveNewID(href)) <= 0L) continue;
                        HIRuntime.getManager().setLayerLink(layerID, newID);
                    }
                    counter = 1;
                    for (Element textElement : PeTALImporter.this.textMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.34")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTALImporter.this.textMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiText text = PeTALImporter.this.textIDMap.get(textElement.getAttribute("id"));
                        PeTALImporter.this.attachMetadataRecords(textElement, text.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://www.hyperimage.eu/PeTAL/HIView/1.0", "content", "content");
                        ++counter;
                    }
                    counter = 1;
                    for (Element viewElement : PeTALImporter.this.viewMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.36")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTALImporter.this.viewMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiView view = PeTALImporter.this.viewIDMap.get(viewElement.getAttribute("id"));
                        PeTALImporter.this.attachMetadataRecords(viewElement, view.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", "http://purl.org/dc/elements/1.1/", "source", "source", "http://www.hyperimage.eu/PeTAL/HIView/1.0", "annotation", "comment");
                        ++counter;
                    }
                    counter = 1;
                    for (Element inscriptionElement : PeTALImporter.this.inscriptionMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.37")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTALImporter.this.inscriptionMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiInscription inscription = PeTALImporter.this.inscriptionIDMap.get(inscriptionElement.getAttribute("id"));
                        PeTALImporter.this.attachMetadataRecords(inscriptionElement, inscription.getMetadata(), null, null, null, null, null, null, "http://www.hyperimage.eu/PeTAL/HIView/1.0", "content", "content");
                        ++counter;
                    }
                    counter = 1;
                    for (Element layerElement : PeTALImporter.this.layerMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.38")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTALImporter.this.layerMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiLayer layer = PeTALImporter.this.layerIDMap.get(layerElement.getAttribute("id"));
                        PeTALImporter.this.attachMetadataRecords(layerElement, layer.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://www.hyperimage.eu/PeTAL/HIView/1.0", "annotation", "comment");
                        ++counter;
                    }
                    counter = 1;
                    for (Element groupElement : PeTALImporter.this.groupMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.39")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTALImporter.this.groupMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiGroup group = PeTALImporter.this.groupIDMap.get(groupElement.getAttribute("id"));
                        PeTALImporter.this.attachMetadataRecords(groupElement, group.getMetadata(), "http://purl.org/dc/elements/1.1/", "title", "title", null, null, null, "http://www.hyperimage.eu/PeTAL/HIView/1.0", "annotation", "comment");
                        ++counter;
                    }
                    counter = 1;
                    for (Element litaElement : PeTALImporter.this.litaMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.40")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTALImporter.this.litaMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiLightTable lita = PeTALImporter.this.litaIDMap.get(litaElement.getAttribute("id"));
                        String litaXML = lita.getXml();
                        litaXML = litaXML.replaceAll("<lita id=\"X[0123456789]+\">", "<lita id=\"X" + lita.getId() + "\">");
                        String convertedXML = "";
                        int refCounter = 0;
                        String[] stringArray = litaXML.split("ref=\"");
                        int imgElement = stringArray.length;
                        int memberID = 0;
                        while (memberID < imgElement) {
                            String refString = stringArray[memberID];
                            if (refCounter > 0) {
                                convertedXML = String.valueOf(convertedXML) + "ref=\"";
                                String ref = refString.substring(0, refString.indexOf("\""));
                                if ((ref = PeTALImporter.this.resolveDisplayableNewID("petal://legacy/" + ref)) == null || ref.length() == 0) {
                                    ref = "invalid";
                                }
                                convertedXML = String.valueOf(convertedXML) + ref + refString.substring(refString.indexOf("\""));
                            } else {
                                convertedXML = String.valueOf(convertedXML) + refString;
                            }
                            ++refCounter;
                            ++memberID;
                        }
                        lita.setXml(convertedXML);
                        HIRuntime.getManager().updateLightTable(lita);
                        ++counter;
                    }
                    counter = 1;
                    for (Element objectElement : PeTALImporter.this.objectMap.values()) {
                        HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.41")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + PeTALImporter.this.objectMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
                        HiObject object = PeTALImporter.this.objectIDMap.get(objectElement.getAttribute("id"));
                        NodeList descElements = objectElement.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                        int i7 = 0;
                        while (i7 < descElements.getLength()) {
                            HiFlexMetadataRecord record;
                            Element descElement = (Element)descElements.item(i7);
                            String lang = descElement.getAttribute("xml:lang");
                            if (PeTALImporter.this.checkLangInProject(lang) && (record = MetadataHelper.getDefaultMetadataRecord(object.getMetadata(), lang)) != null) {
                                for (HiFlexMetadataTemplate template : PeTALImporter.this.templates) {
                                    for (HiFlexMetadataSet set : template.getEntries()) {
                                        String content = "";
                                        content = !set.isRichText() ? PeTALImporter.this.getSingleLineTextContent(descElement, template.getNamespaceURI(), set.getTagname()) : PeTALImporter.this.getMultiLineTextContent(descElement, template.getNamespaceURI(), set.getTagname());
                                        if (content == null) continue;
                                        MetadataHelper.setValue(template.getNamespacePrefix(), set.getTagname(), content, record);
                                    }
                                }
                                HIRuntime.getManager().updateFlexMetadataRecord(record);
                            }
                            ++i7;
                        }
                        ++counter;
                    }
                    HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.42"));
                    long newStartRef = PeTALImporter.this.resolveNewID(PeTALImporter.this.startRef);
                    if (newStartRef > 0L) {
                        HIRuntime.getManager().updateProjectStartElement(newStartRef);
                    }
                }
                catch (HIWebServiceException wse) {
                    wse.printStackTrace();
                    HIRuntime.getGui().reportError(wse, null);
                    PeTALImporter.this.abortWithError("");
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PeTALImporter.this.abortWithError(e.getMessage());
                    return;
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                PeTALImporter.this.importSuccessful = true;
                HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.43"), String.valueOf(Messages.getString("PeTALImporter.44")) + "\n" + Messages.getString("PeTALImporter.45"));
                if (PeTALImporter.this.litaMap.size() > 0) {
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.46"), String.valueOf(Messages.getString("PeTALImporter.47")) + "\n\n" + Messages.getString("PeTALImporter.48"));
                }
                for (String viewID : PeTALImporter.this.brokenViews) {
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.46"), String.valueOf(Messages.getString("PeTALImporter.49")) + " " + viewID + " " + Messages.getString("PeTALImporter.50") + "\n\n" + Messages.getString("PeTALImporter.51") + "\n" + Messages.getString("PeTALImporter.52"));
                }
                HIRuntime.getGui().triggerProjectUpdate();
            }
        }.start();
    }

    public boolean loadAndValidatePeTAL(File inputFile) {
        block9: {
            block8: {
                this.inputFile = inputFile;
                this.importSuccessful = false;
                this.startRef = "";
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.petalXML = builder.parse(inputFile);
                if (this.petalXML.getDocumentElement().getTagName().compareTo("petal") == 0) break block8;
                this.petalXML = null;
                return false;
            }
            this.version = this.petalXML.getDocumentElement().getAttribute("version");
            if (this.version != null && this.version.length() != 0) break block9;
            this.petalXML = null;
            return false;
        }
        try {
            this.startRef = this.petalXML.getDocumentElement().getAttribute("startRef");
            if (this.startRef == null || this.startRef.length() == 0) {
                this.petalXML = null;
                return false;
            }
            return true;
        }
        catch (SAXParseException spe) {
            this.petalXML = null;
            spe.printStackTrace();
            return false;
        }
        catch (SAXException sxe) {
            this.petalXML = null;
            sxe.printStackTrace();
            return false;
        }
        catch (ParserConfigurationException pce) {
            this.petalXML = null;
            pce.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            this.petalXML = null;
            ioe.printStackTrace();
            return false;
        }
    }
}

