/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.xmlimportexport;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.xmlimportexport.XMLImporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class VRACore4HeidelbergImporter
extends XMLImporter {
    List<String[]> valueList = new ArrayList<String[]>();
    public static final String IMAGERETRIEVALSERVICE = "http://kjc-sv016.kjc.uni-heidelberg.de:8080/exist/apps/tamboti/modules/display/image-view.xql?uuid=";
    public static final String IMAGERETRIEVALSERVICE_FREIZOHEIDELBERGCOLLECTION_PREFIX = "http://iiif.cph.freizo.org/image/";
    public static final String IMAGERETRIEVALSERVICE_FREIZOIIIFSERVICE_PREFIX = "http://iiif.freizo.org/china_posters/";
    public static final String IMAGERETRIEVALSERVICE_IIIF_SUFFIX = "/full/!1000,1000/0/native";
    public static final String FREIZOHEIDELBERGCOLLECTION_ID = "freizo-heidelberg-collection";
    public static final String FREIZOIIIFSERVICE_ID = "freizo-iiif-service";
    public static final String TAMBOTI_REPOS = "[Tamboti Import]";
    public static final String IMAGE_URL_FROM_ID_SERVICE = "http://kjc-sv016.kjc.uni-heidelberg.de:8080/exist/apps/tamboti/modules/display/HI-get-image.xq?uuid=";

    public VRACore4HeidelbergImporter(File inputFile, Document xmlDocument) {
        this.xmlDocument = xmlDocument;
        this.xmlDocument.normalize();
        this.inputFile = inputFile;
    }

    public void importXMLToProject() {
        HIRuntime.getGui().startIndicatingServiceActivity(true);
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.1"));
        this.importSuccessful = false;
        this.languages.clear();
        this.templates.clear();
        this.objects.clear();
        this.views.clear();
        this.corruptViews.clear();
        this.objectMap.clear();
        this.objectIDMap.clear();
        this.viewMap.clear();
        this.viewIDMap.clear();
        new Thread(){

            @Override
            public void run() {
                try {
                    VRACore4HeidelbergImporter.this.rootElement = VRACore4HeidelbergImporter.this.xmlDocument.getDocumentElement();
                    VRACore4HeidelbergImporter.this._DBG("Root element: " + VRACore4HeidelbergImporter.this.rootElement.getTagName(), 3);
                    VRACore4HeidelbergImporter.this.importLanguages();
                    VRACore4HeidelbergImporter.this.setVRACore4HdlbgTemplate();
                    VRACore4HeidelbergImporter.this.stageObjectImport();
                    VRACore4HeidelbergImporter.this.importObjects();
                    VRACore4HeidelbergImporter.this.stageViewImport();
                    VRACore4HeidelbergImporter.this.importViews();
                }
                catch (HIWebServiceException wse) {
                    Logger.getLogger(VRACore4HeidelbergImporter.class.getName()).log(Level.SEVERE, null, wse);
                    HIRuntime.getGui().reportError(wse, null);
                    VRACore4HeidelbergImporter.this.abortWithError(wse.toString());
                    return;
                }
                catch (Exception e) {
                    Logger.getLogger(VRACore4HeidelbergImporter.class.getName()).log(Level.SEVERE, null, e);
                    VRACore4HeidelbergImporter.this.abortWithError(e.toString());
                    return;
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                VRACore4HeidelbergImporter.this.importSuccessful = true;
                HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.43"), String.valueOf(Messages.getString("PeTALImporter.44")) + "\n" + Messages.getString("PeTALImporter.45"));
                for (String viewID : VRACore4HeidelbergImporter.this.corruptViews) {
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.46"), String.valueOf(Messages.getString("PeTALImporter.49")) + " " + viewID + " " + Messages.getString("PeTALImporter.50") + "\n\n" + Messages.getString("PeTALImporter.51") + "\n" + Messages.getString("PeTALImporter.52"));
                }
                HIRuntime.getGui().triggerProjectUpdate();
            }
        }.start();
    }

    private void stageObjectImport() throws HIWebServiceException {
        NodeList workElements = this.rootElement.getElementsByTagNameNS("http://www.vraweb.org/vracore4.htm", "work");
        if (workElements == null) {
            return;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.12"));
        int i = 0;
        while (i < workElements.getLength()) {
            this._DBG(workElements.item(i).getLocalName());
            Element objectElement = (Element)workElements.item(i);
            this.objects.add(objectElement);
            this._DBG("added work to list of objects.");
            ++i;
        }
        int counter = 1;
        for (Element workElement : this.objects) {
            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + " " + Messages.getString("PeTALImporter.25") + " " + this.objects.size() + " " + Messages.getString("PeTALImporter.26"));
            String strUUID = workElement.getAttribute("id");
            if (strUUID.startsWith("w_")) {
                strUUID = strUUID.substring(2);
            }
            HiObject newObjectWithUUID = null;
            try {
                HiBase base = HIRuntime.getManager().getBaseElement(strUUID);
                if (base != null && base instanceof HiObject) {
                    newObjectWithUUID = (HiObject)base;
                }
            }
            catch (HIWebServiceException hIWebServiceException) {
                // empty catch block
            }
            if (newObjectWithUUID == null) {
                newObjectWithUUID = HIRuntime.getManager().createObject(strUUID);
            }
            this.objectMap.put(newObjectWithUUID, workElement);
            this.objectIDMap.put(strUUID, newObjectWithUUID);
            this._DBG("work id: " + workElement.getAttribute("id"));
            this._DBG("UUID: " + strUUID, 2);
            ++counter;
        }
    }

    private void stageViewImport() throws HIWebServiceException {
        NodeList imageElements = this.rootElement.getElementsByTagNameNS("http://www.vraweb.org/vracore4.htm", "image");
        if (imageElements.getLength() == 0) {
            this._DBG("No images to import!");
            return;
        }
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.13"));
        int i = 0;
        while (i < imageElements.getLength()) {
            Element viewElement = (Element)imageElements.item(i);
            this.views.add(viewElement);
            this._DBG("added image to list of views.");
            ++i;
        }
        int counter = 1;
        for (Element imageElement : this.views) {
            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.24")) + " " + counter + ": " + Messages.getString("PeTALImporter.27"));
            String strUUIDWithPrefix = imageElement.getAttribute("id");
            String strUUID = "";
            String workUUIDWithPrefix = "";
            if (strUUIDWithPrefix.startsWith("i_")) {
                strUUID = strUUIDWithPrefix.substring(2);
            }
            String strFilename = String.valueOf(strUUIDWithPrefix) + ".jpg";
            this._DBG("filename: " + strFilename);
            String strID = imageElement.getAttribute("id");
            this._DBG("image.id: " + strID);
            URL urlImage = this.generateImageURLfromID(strID);
            this._DBG("URL: " + urlImage.toString());
            File fileImage = this.getImage(urlImage, strFilename);
            NodeList imageRelationSetElements = imageElement.getElementsByTagNameNS("http://www.vraweb.org/vracore4.htm", "relationSet");
            if (imageRelationSetElements != null) {
                int i2 = 0;
                while (i2 < imageRelationSetElements.getLength()) {
                    NodeList listChildrenOfRelationSet;
                    Node nodeRelationSet = imageRelationSetElements.item(i2);
                    if (nodeRelationSet instanceof Element && nodeRelationSet.getNodeName().equals("relationSet") && (listChildrenOfRelationSet = nodeRelationSet.getChildNodes()) != null) {
                        int j = 0;
                        while (j < listChildrenOfRelationSet.getLength()) {
                            Node nodeRelationSetChild = listChildrenOfRelationSet.item(j);
                            if (nodeRelationSetChild instanceof Element && nodeRelationSetChild.hasAttributes() && nodeRelationSetChild.getNodeName().equals("relation")) {
                                Element elementRelation = (Element)nodeRelationSetChild;
                                workUUIDWithPrefix = elementRelation.getAttribute("relids");
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
            }
            HiObject workForThisImage = (HiObject)this.objectIDMap.get(workUUIDWithPrefix.substring(2));
            byte[] arrayImageData = null;
            try {
                arrayImageData = Files.readAllBytes(fileImage.toPath());
            }
            catch (IOException ex) {
                Logger.getLogger(VRACore4HeidelbergImporter.class.getName()).log(Level.SEVERE, null, ex);
            }
            HiView newViewWithUUID = null;
            try {
                HiBase base = HIRuntime.getManager().getBaseElement(strUUID);
                if (base != null && base instanceof HiView) {
                    newViewWithUUID = (HiView)base;
                }
            }
            catch (HIWebServiceException hIWebServiceException) {
                // empty catch block
            }
            if (newViewWithUUID == null) {
                newViewWithUUID = HIRuntime.getManager().createView(workForThisImage, strFilename, TAMBOTI_REPOS, arrayImageData, strUUID);
            }
            this.viewMap.put(newViewWithUUID, imageElement);
            this.viewIDMap.put(strUUID, newViewWithUUID);
            arrayImageData = null;
            ++counter;
        }
    }

    private URL generateImageURLfromHREF(String strHREF) {
        URL urlImage = null;
        String strImageID = "";
        int nLastFwdSlashIdx = 0;
        try {
            if (strHREF.startsWith(FREIZOHEIDELBERGCOLLECTION_ID)) {
                nLastFwdSlashIdx = strHREF.lastIndexOf("/");
                strImageID = strHREF.substring(nLastFwdSlashIdx + 1);
                this._DBG("ImageID from HREF(freizo-heidelberg-collection): " + strImageID);
                urlImage = new URL(IMAGERETRIEVALSERVICE_FREIZOHEIDELBERGCOLLECTION_PREFIX + strImageID + IMAGERETRIEVALSERVICE_IIIF_SUFFIX);
            } else if (strHREF.startsWith(FREIZOIIIFSERVICE_ID)) {
                nLastFwdSlashIdx = strHREF.lastIndexOf("/");
                strImageID = strHREF.substring(nLastFwdSlashIdx + 1);
                this._DBG("ImageID from HREF(freizo-iiif-service): " + strImageID);
                urlImage = new URL(IMAGERETRIEVALSERVICE_FREIZOIIIFSERVICE_PREFIX + strImageID + IMAGERETRIEVALSERVICE_IIIF_SUFFIX);
            } else {
                urlImage = new URL(IMAGERETRIEVALSERVICE + strHREF);
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(VRACore4HeidelbergImporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return urlImage;
    }

    private URL generateImageURLfromID(String strID) {
        String strImageURL;
        URL urlImage;
        block20: {
            urlImage = null;
            InputStream is = null;
            strImageURL = "";
            try {
                URL urlQuery = new URL(IMAGE_URL_FROM_ID_SERVICE + strID);
                is = urlQuery.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                strImageURL = br.readLine();
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                try {
                    if (is != null) {
                        is.close();
                    }
                    break block20;
                }
                catch (IOException iOException) {}
                break block20;
            }
            catch (IOException ioe) {
                try {
                    ioe.printStackTrace();
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this._DBG("URL via image ID: " + strID);
            urlImage = new URL(strImageURL);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(VRACore4HeidelbergImporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return urlImage;
    }

    private void importViews() throws HIWebServiceException {
        int counter = 1;
        for (Element viewElement : this.viewMap.values()) {
            HiFlexMetadataRecord record;
            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.36")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + this.viewMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
            String strUUID = viewElement.getAttribute("id").substring(2);
            HiView view = (HiView)this.viewIDMap.get(strUUID);
            this._DBG("viewElement: " + viewElement.getTagName());
            String key = viewElement.getTagName();
            String lang = "en";
            if (this.checkLangInProject(lang) && (record = MetadataHelper.getDefaultMetadataRecord(view.getMetadata(), lang)) != null) {
                String content = this.getContentFromElements(key, viewElement);
                if (content != null) {
                    this._DBG("content: " + content);
                    MetadataHelper.setValue("HIBase", "title", this.getTitleFromImageElement(viewElement), record);
                    MetadataHelper.setValue("HIBase", "source", this.getSourceFromImageElement(viewElement), record);
                    MetadataHelper.setValue("HIBase", "comment", content, record);
                }
                HIRuntime.getManager().updateFlexMetadataRecord(record);
            }
            ++counter;
        }
    }

    private String getTitleFromImageElement(Element imageElement) {
        String strImageTitle = "";
        NodeList imageTitleSetElements = imageElement.getElementsByTagNameNS("http://www.vraweb.org/vracore4.htm", "titleSet");
        if (imageTitleSetElements != null) {
            int i = 0;
            while (i < imageTitleSetElements.getLength()) {
                NodeList listChildrenOfTitleSet;
                Node nodeTitleSet = imageTitleSetElements.item(i);
                if (nodeTitleSet instanceof Element && nodeTitleSet.getNodeName().equals("titleSet") && (listChildrenOfTitleSet = nodeTitleSet.getChildNodes()) != null) {
                    int j = 0;
                    while (j < listChildrenOfTitleSet.getLength()) {
                        Node nodeTitleSetChild = listChildrenOfTitleSet.item(j);
                        if (nodeTitleSetChild instanceof Element && nodeTitleSetChild.getNodeName().equals("title")) {
                            strImageTitle = nodeTitleSetChild.getTextContent();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return strImageTitle;
    }

    private String getSourceFromImageElement(Element imageElement) {
        String strImageSource = "";
        NodeList imageRightsSetElements = imageElement.getElementsByTagNameNS("http://www.vraweb.org/vracore4.htm", "rightsSet");
        if (imageRightsSetElements != null) {
            int i = 0;
            while (i < imageRightsSetElements.getLength()) {
                NodeList listChildrenOfRightsSet;
                Node nodeRightsSet = imageRightsSetElements.item(i);
                if (nodeRightsSet instanceof Element && nodeRightsSet.getNodeName().equals("rightsSet") && (listChildrenOfRightsSet = nodeRightsSet.getChildNodes()) != null) {
                    int j = 0;
                    while (j < listChildrenOfRightsSet.getLength()) {
                        Node nodeRightsSetChild = listChildrenOfRightsSet.item(j);
                        if (nodeRightsSetChild instanceof Element && nodeRightsSetChild.getNodeName().equals("notes")) {
                            strImageSource = nodeRightsSetChild.getTextContent();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return strImageSource;
    }

    private void importObjects() throws HIWebServiceException {
        int counter = 1;
        for (Element objectElement : this.objectMap.values()) {
            HiFlexMetadataRecord record;
            HIRuntime.getGui().setMessage(String.valueOf(Messages.getString("PeTALImporter.41")) + " (" + counter + " " + Messages.getString("PeTALImporter.25") + " " + this.objectMap.values().size() + ") " + Messages.getString("PeTALImporter.35"));
            String strUUID = objectElement.getAttribute("id").substring(2);
            HiObject object = (HiObject)this.objectIDMap.get(strUUID);
            this._DBG("objectElement: " + objectElement.getTagName());
            String lang = "en";
            if (this.checkLangInProject(lang) && (record = MetadataHelper.getDefaultMetadataRecord(object.getMetadata(), lang)) != null) {
                String content = this.getContentFromElements("work", objectElement);
                if (content != null) {
                    this._DBG("content: " + content);
                    MetadataHelper.setValue("vra4hdlbg", "work", this.splitVRACore4Fields("work", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "agent", this.splitVRACore4Fields("agent", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "culturalContext", this.splitVRACore4Fields("culturalContext", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "date", this.splitVRACore4Fields("date", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "description", this.splitVRACore4Fields("description", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "location", this.splitVRACore4Fields("location", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "material", this.splitVRACore4Fields("material", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "measurements", this.splitVRACore4Fields("measurements", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "relation", this.splitVRACore4Fields("relation", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "rights", this.splitVRACore4Fields("rights", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "source", this.splitVRACore4Fields("source", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "stateEdition", this.splitVRACore4Fields("stateEdition", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "stylePeriod", this.splitVRACore4Fields("stylePeriod", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "subject", this.splitVRACore4Fields("subject", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "technique", this.splitVRACore4Fields("technique", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "textref", this.splitVRACore4Fields("textref", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "title", this.splitVRACore4Fields("title", content), record);
                    MetadataHelper.setValue("vra4hdlbg", "worktype", this.splitVRACore4Fields("worktype", content), record);
                }
                HIRuntime.getManager().updateFlexMetadataRecord(record);
            }
            ++counter;
        }
    }

    private String splitVRACore4Fields(String key, String fields) {
        String content = "";
        String[] stringArray = fields.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (key.equalsIgnoreCase("work")) {
                if (field.startsWith("{#}bold{#}work.refid{#}regular{#}")) {
                    content = String.valueOf(content) + "{#}bold{#}" + field.substring(15) + "\n";
                }
                if (field.startsWith("{#}bold{#}work.source{#}regular{#}")) {
                    content = String.valueOf(content) + "{#}bold{#}" + field.substring(15) + "\n";
                }
            } else {
                if (field.startsWith("{#}bold{#}work." + key + "Set." + key + ".")) {
                    content = String.valueOf(content) + "{#}bold{#}" + field.substring(20 + 2 * key.length()) + "\n";
                } else if (field.startsWith("{#}bold{#}work." + key + "Set." + key)) {
                    content = String.valueOf(content) + "{#}regular{#}" + field.substring(34 + 2 * key.length()) + "\n";
                }
                if (field.startsWith("{#}bold{#}work." + key + "Set.notes")) {
                    content = String.valueOf(content) + "{#}bold{#}" + field.substring(19 + key.length()) + "\n";
                }
            }
            ++n2;
        }
        return content;
    }

    private String getContentFromElements(String key, Element contentRootElement) {
        String contentString = "";
        String tagString = contentRootElement.getTagName();
        NodeList children = contentRootElement.getChildNodes();
        String nextTag = "";
        if (contentRootElement.hasAttributes()) {
            NamedNodeMap attributes = contentRootElement.getAttributes();
            int j = 0;
            while (j < attributes.getLength()) {
                Node attribute = attributes.item(j);
                String tagAttrPath = String.valueOf(contentRootElement.getTagName()) + "." + attribute.getNodeName();
                String attrValue = attribute.getNodeValue();
                this.valueList.add(new String[]{tagAttrPath, attrValue});
                ++j;
            }
        }
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element && children.item(i).getTextContent().trim().length() > 0) {
                nextTag = String.valueOf(tagString) + "." + children.item(i).getNodeName();
                this.processChildNode(children.item(i).getChildNodes(), nextTag);
                if (children.item(i).hasAttributes()) {
                    NamedNodeMap attributes = children.item(i).getAttributes();
                    int j = 0;
                    while (j < attributes.getLength()) {
                        Node attribute = attributes.item(j);
                        tagString = String.valueOf(tagString) + attribute.getNodeName() + ": " + attribute.getNodeValue() + "\n";
                        ++j;
                    }
                }
            }
            this._DBG("Ignoring node <" + children.item(i).getNodeName() + "> with value '" + children.item(i).getNodeValue() + "'.", 3);
            ++i;
        }
        for (String[] val : this.valueList) {
            contentString = String.valueOf(contentString) + "{#}bold{#}" + val[0] + "{#}regular{#}: " + val[1] + "\n";
        }
        this.valueList.clear();
        return contentString;
    }

    private void processChildNode(NodeList listOfNodes, String tags) {
        int i = 0;
        while (i < listOfNodes.getLength()) {
            if (listOfNodes.item(i) instanceof Element) {
                String tagPath = String.valueOf(tags) + "." + listOfNodes.item(i).getNodeName();
                if (listOfNodes.item(i).hasAttributes()) {
                    NamedNodeMap attributes = listOfNodes.item(i).getAttributes();
                    int j = 0;
                    while (j < attributes.getLength()) {
                        Node attribute = attributes.item(j);
                        String tagAttrPath = String.valueOf(tags) + "." + listOfNodes.item(i).getNodeName() + "." + attribute.getNodeName();
                        String attrValue = attribute.getNodeValue();
                        this.valueList.add(new String[]{tagAttrPath, attrValue});
                        ++j;
                    }
                }
                if (listOfNodes.item(i).getChildNodes().getLength() >= 1) {
                    this.processChildNode(listOfNodes.item(i).getChildNodes(), tagPath);
                }
            } else if (listOfNodes.item(i) instanceof Text && listOfNodes.getLength() == 1) {
                String value = listOfNodes.item(i).getNodeValue();
                this.valueList.add(new String[]{tags, value});
            }
            ++i;
        }
    }

    private void importLanguages() {
        this.languages.clear();
        this.languages.add("en");
        String defLang = "en";
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.8"));
        for (String lang : this.languages) {
            if (this.checkLangInProject(lang)) continue;
            try {
                HIRuntime.getManager().addLanguageToProject(lang);
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(VRACore4HeidelbergImporter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            HIRuntime.getManager().updateProjectDefaultLanguage(defLang);
        }
        catch (HIWebServiceException ex) {
            Logger.getLogger(VRACore4HeidelbergImporter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setVRACore4HdlbgTemplate() {
        HIRuntime.getGui().setMessage(Messages.getString("PeTALImporter.vraTemplate"));
        boolean templateIsInProject = false;
        for (HiFlexMetadataTemplate projTemplate : HIRuntime.getManager().getProject().getTemplates()) {
            if (!projTemplate.getNamespacePrefix().equalsIgnoreCase("vra4hdlbg") && !projTemplate.getNamespaceURI().equalsIgnoreCase("http://www.vraweb.org/vracore4.htm")) continue;
            this.templates.add(projTemplate);
            templateIsInProject = true;
        }
        if (!templateIsInProject) {
            HiFlexMetadataTemplate hdlbgTemplate = MetadataHelper.getVRACore4HdlbgExtTemplateBlueprint();
            try {
                if (HIRuntime.getManager().addTemplateToProject(hdlbgTemplate)) {
                    this.templates.add(hdlbgTemplate);
                }
            }
            catch (HIWebServiceException ex) {
                Logger.getLogger(VRACore4HeidelbergImporter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

