/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.xmlimportexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLanguage;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLImporter
implements ErrorHandler {
    protected static final boolean DEBUG = false;
    protected static final String DBGIND = ">>>>";
    private String strNamespace = "";
    protected static final String XHTML_XMLNS = "http://www.w3.org/1999/xhtml";
    protected static final String XLINK_XMLNS = "http://www.w3.org/1999/xlink";
    protected static final String RDF_XMLNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected static final String DC_1_1_XMLNS = "http://purl.org/dc/elements/1.1/";
    protected static final String HIBASE_XMLNS = "http://www.hyperimage.eu/PeTAL/HIView/1.0";
    protected static final String HIBASE_2_0_XMLNS = "http://hyperimage.ws/PeTAL/HIBase/2.0";
    protected static final String SVG_XMLNS = "http://www.w3.org/2000/svg";
    protected static final String PeTAL_2_0_XMLNS = "http://www.hyperimage.eu/PeTAL/2.0";
    protected static final String PeTAL_3_0_XMLNS = "http://hyperimage.ws/PeTAL/3.0";
    public static final String VRA_4_XMLNS = "http://www.vraweb.org/vracore4.htm";
    public static final String VRA_4_HDLBG_XMLNS = "http://www.vraweb.org/vracore4.htm";
    public static final String VRA_4_HDLBG_NSPREFIX = "vra4hdlbg";
    public static final String IMPORT_STAGING_DIR = "tmp_ImportStagingDirectory";
    private XMLFormat xmlFormat = null;
    Document xmlDocument = null;
    boolean isValidXML = true;
    File inputFile = null;
    boolean importSuccessful = false;
    String startRef = "";
    Element rootElement = null;
    ArrayList<String> languages = new ArrayList();
    ArrayList<String> corruptViews = new ArrayList();
    ArrayList<Element> texts = new ArrayList();
    ArrayList<Element> objects = new ArrayList();
    ArrayList<Element> views = new ArrayList();
    ArrayList<Element> inscriptions = new ArrayList();
    ArrayList<Element> layers = new ArrayList();
    ArrayList<Element> urls = new ArrayList();
    ArrayList<Element> litas = new ArrayList();
    ArrayList<Element> groups = new ArrayList();
    ArrayList<Element> tags = new ArrayList();
    Element xmlImportGroup;
    ArrayList<HiFlexMetadataTemplate> templates = new ArrayList();
    HashMap<HiText, Element> textMap = new HashMap();
    HashMap<String, HiText> textIDMap = new HashMap();
    HashMap<Hiurl, Element> urlMap = new HashMap();
    HashMap<String, Hiurl> urlIDMap = new HashMap();
    HashMap<HiLightTable, Element> litaMap = new HashMap();
    HashMap<String, HiLightTable> litaIDMap = new HashMap();
    HashMap<HiGroup, Element> groupMap = new HashMap();
    HashMap<String, HiGroup> groupIDMap = new HashMap();
    HashMap<HiObject, Element> objectMap = new HashMap();
    HashMap<String, HiObject> objectIDMap = new HashMap();
    HashMap<HiView, Element> viewMap = new HashMap();
    HashMap<String, HiView> viewIDMap = new HashMap();
    HashMap<HiInscription, Element> inscriptionMap = new HashMap();
    HashMap<String, HiInscription> inscriptionIDMap = new HashMap();
    HashMap<HiLayer, Element> layerMap = new HashMap();
    HashMap<String, HiLayer> layerIDMap = new HashMap();

    public boolean wasImportSuccessful() {
        return this.importSuccessful;
    }

    public String serializeElement(Element element) {
        DOMImplementationLS lsImpl = (DOMImplementationLS)element.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = lsImpl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        return serializer.writeToString(element);
    }

    protected void abortWithError(String errorMessage) {
        HIRuntime.getGui().stopIndicatingServiceActivity();
        if (errorMessage == null) {
            errorMessage = "";
        }
        System.out.println("IMPORT ERROR!");
        System.out.println("--> " + errorMessage);
        if (errorMessage.length() == 0) {
            HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.2"), String.valueOf(Messages.getString("PeTALImporter.3")) + "\n\n" + Messages.getString("PeTALImporter.4"));
        } else {
            HIRuntime.getGui().displayInfoDialog(Messages.getString("PeTALImporter.2"), String.valueOf(Messages.getString("PeTALImporter.5")) + "\n" + Messages.getString("PeTALImporter.6") + " " + errorMessage + "\n\n" + Messages.getString("PeTALImporter.7"));
        }
        HIRuntime.getGui().triggerProjectUpdate();
    }

    protected boolean checkLangInProject(String lang) {
        boolean langIsInProject = false;
        for (HiLanguage projLang : HIRuntime.getManager().getProject().getLanguages()) {
            if (!projLang.getLanguageId().equalsIgnoreCase(lang)) continue;
            langIsInProject = true;
        }
        return langIsInProject;
    }

    protected boolean checkTemplateInProject(String nsPrefix, String schema) {
        boolean templateIsInProject = false;
        for (HiFlexMetadataTemplate projTemplate : HIRuntime.getManager().getProject().getTemplates()) {
            if (nsPrefix != null && projTemplate.getNamespacePrefix().equalsIgnoreCase(nsPrefix)) {
                templateIsInProject = true;
            }
            if (schema == null || !projTemplate.getNamespaceURI().equalsIgnoreCase(schema)) continue;
            templateIsInProject = true;
        }
        return templateIsInProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadAndValidateXMLFile(File inputFile) {
        this.inputFile = inputFile;
        this.importSuccessful = false;
        this.startRef = "";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.xmlDocument = builder.parse(inputFile);
            this.isValidXML = true;
            switch (this.strNamespace = this.xmlDocument.getDocumentElement().getAttribute("xmlns")) {
                case "http://hyperimage.ws/PeTAL/3.0": {
                    this.xmlFormat = XMLFormat.PETAL_3_0_XML;
                    Schema schema = sf.newSchema(this.getClass().getResource("/resources/schema/PeTAL_schema_3.0.xsd"));
                    factory.setSchema(schema);
                    builder = factory.newDocumentBuilder();
                    builder.setErrorHandler(this);
                    this.xmlDocument = builder.parse(inputFile);
                    if (this.isValidXML) return true;
                    return false;
                }
                case "http://www.hyperimage.eu/PeTAL/2.0": {
                    this.xmlFormat = XMLFormat.PETAL_2_0_XML;
                    return true;
                }
                case "http://www.vraweb.org/vracore4.htm": {
                    this.xmlFormat = XMLFormat.VRA_4_HDLBG_XML;
                    return true;
                }
            }
            if (this.processTambotiExport()) {
                this.xmlFormat = XMLFormat.TAMBOTI;
                return true;
            }
            this.xmlFormat = XMLFormat.UNRECOGNISED;
            return true;
        }
        catch (SAXParseException spe) {
            this.xmlDocument = null;
            spe.printStackTrace();
            return false;
        }
        catch (SAXException sxe) {
            this.xmlDocument = null;
            sxe.printStackTrace();
            return false;
        }
        catch (ParserConfigurationException pce) {
            this.xmlDocument = null;
            pce.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            this.xmlDocument = null;
            ioe.printStackTrace();
            return false;
        }
    }

    private boolean processTambotiExport() {
        Element rootElement = this.xmlDocument.getDocumentElement();
        return rootElement.getNodeName().equals("my-list-export");
    }

    public boolean isPeTAL2_0() {
        return this.xmlFormat != null && this.xmlFormat.equals((Object)XMLFormat.PETAL_2_0_XML);
    }

    public boolean isPeTAL3_0() {
        return this.xmlFormat != null && this.xmlFormat.equals((Object)XMLFormat.PETAL_3_0_XML);
    }

    public boolean isVRA4() {
        return this.xmlFormat != null && this.xmlFormat.equals((Object)XMLFormat.VRA_4_XML);
    }

    public boolean isVRA4Hdlbg() {
        return this.xmlFormat != null && this.xmlFormat.equals((Object)XMLFormat.VRA_4_HDLBG_XML);
    }

    public boolean isTamboti() {
        return this.xmlFormat != null && this.xmlFormat.equals((Object)XMLFormat.TAMBOTI);
    }

    protected File getImage(Element imageElement) {
        File retFile = null;
        String strSrc = imageElement.getAttribute("src");
        this._DBG("Retrieving from " + strSrc);
        if (strSrc.startsWith("img")) {
            String pathToFile = String.valueOf(this.inputFile.getParent()) + "/" + imageElement.getAttribute("src");
            pathToFile = File.separator.compareTo("\\") == 0 ? pathToFile.replaceAll("/", "\\" + File.separator) : pathToFile.replaceAll("/", File.separator);
            retFile = new File(pathToFile);
        } else if (strSrc.startsWith("http")) {
            String fileName = this.getFileNameFromURL(strSrc);
            this._DBG("Filename: " + fileName);
            retFile = new File("tmp_import/" + fileName);
            try {
                int length;
                URL urlImage = new URL(strSrc);
                InputStream is = urlImage.openStream();
                FileOutputStream os = new FileOutputStream(retFile);
                byte[] b = new byte[2048];
                while ((length = is.read(b)) != -1) {
                    ((OutputStream)os).write(b, 0, length);
                }
                is.close();
                ((OutputStream)os).close();
            }
            catch (IOException ioe) {
                Logger.getLogger(XMLImporter.class.getName()).log(Level.SEVERE, "Error retrieving remote image.", ioe);
            }
        }
        return retFile;
    }

    protected File getImage(URL urlImage, String strName) {
        File fileImage = this.instantiateFileInImportStagingDirectory(strName);
        if (!Files.exists(fileImage.toPath(), new LinkOption[0])) {
            try {
                FileOutputStream os;
                Throwable throwable = null;
                Object var6_6 = null;
                try (InputStream is = urlImage.openStream();){
                    int length;
                    os = new FileOutputStream(fileImage);
                    byte[] b = new byte[2048];
                    while ((length = is.read(b)) != -1) {
                        ((OutputStream)os).write(b, 0, length);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ((OutputStream)os).close();
            }
            catch (IOException ioe) {
                Logger.getLogger(XMLImporter.class.getName()).log(Level.SEVERE, "Error retrieving remote image.", ioe);
            }
        }
        return fileImage;
    }

    private File instantiateFileInImportStagingDirectory(String strFilename) {
        File dirImport = new File(IMPORT_STAGING_DIR);
        if (!Files.exists(dirImport.toPath(), new LinkOption[0])) {
            this._DBG("Creating dir tmp_ImportStagingDirectory for import \u2026", 3);
            try {
                dirImport.mkdir();
            }
            catch (SecurityException se) {
                Logger.getLogger(XMLImporter.class.getName()).log(Level.SEVERE, "Error creating dir for import.", se);
            }
        }
        this._DBG("Saving file to tmp_ImportStagingDirectory" + File.separator + strFilename);
        return new File(IMPORT_STAGING_DIR + File.separator + strFilename);
    }

    private String getFileNameFromURL(String strURL) {
        return strURL.substring(strURL.lastIndexOf(47) + 1, strURL.length());
    }

    public Document getXMLDocument() {
        return this.xmlDocument;
    }

    protected void _DBG(String strDebugMessage) {
        this._DBG(strDebugMessage, 1);
    }

    protected void _DBG(String strDebugMessage, int nLevel) {
        String strIndents = "";
        int i = 0;
        while (i < nLevel) {
            strIndents = String.valueOf(strIndents) + DBGIND;
            ++i;
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.isValidXML = false;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.isValidXML = false;
    }

    public static enum XMLFormat {
        PETAL_2_0_XML,
        PETAL_3_0_XML,
        VRA_4_XML,
        VRA_4_HDLBG_XML,
        TAMBOTI,
        UNRECOGNISED;

    }
}

